// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/*
** ******************* GREEN CONTEXTS **********************
*/

/**
 * \defgroup CUDA_GREEN_CONTEXTS Green Contexts
 *
 * ___MANBRIEF___ Driver level API for creation and manipulation of green contexts
 * (___CURRENT_FILE___) ___ENDMANBRIEF___
 *
 * This section describes the APIs for creation and manipulation of green contexts in the CUDA
 * driver. Green contexts are a lightweight alternative to traditional contexts, with the ability
 * to pass in a set of resources that they should be initialized with. This allows the developer to
 * represent distinct spatial partitions of the GPU, provision resources for them, and target them
 * via the same programming model that CUDA exposes (streams, kernel launches, etc.).
 *
 * There are 4 main steps to using these new set of APIs.
 * - (1) Start with an initial set of resources, for example via ::cuDeviceGetDevResource. Only SM type is supported today.
 * - (2) Partition this set of resources by providing them as input to a partition API, for example: ::cuDevSmResourceSplitByCount.
 * - (3) Finalize the specification of resources by creating a descriptor via ::cuDevResourceGenerateDesc.
 * - (4) Provision the resources and create a green context via ::cuGreenCtxCreate.
 *
 * For \p CU_DEV_RESOURCE_TYPE_SM, the partitions created have minimum SM count requirements, often rounding up and aligning the
 * minCount provided to ::cuDevSmResourceSplitByCount. The following is a guideline for each architecture
 * and may be subject to change:
 * - On Compute Architecture 6.X: The minimum count is 1 SM.
 * - On Compute Architecture 7.X: The minimum count is 2 SMs and must be a multiple of 2.
 * - On Compute Architecture 8.X: The minimum count is 4 SMs and must be a multiple of 2.
 * - On Compute Architecture 9.0+: The minimum count is 8 SMs and must be a multiple of 8.
 *
 * In the future, flags can be provided to tradeoff functional and performance characteristics versus finer grained SM partitions.
 *
 * Even if the green contexts have disjoint SM partitions, it is not guaranteed that the kernels launched
 * in them will run concurrently or have forward progress guarantees. This is due to other resources (like HW connections,
 * see ::CUDA_DEVICE_MAX_CONNECTIONS) that could cause a dependency. Additionally, in certain scenarios,
 * it is possible for the workload to run on more SMs than was provisioned (but never less).
 * The following are two scenarios which can exhibit this behavior:
 * - On Volta+ MPS: When \p CUDA_MPS_ACTIVE_THREAD_PERCENTAGE is used,
 * the set of SMs that are used for running kernels can be scaled up to the value of SMs used for the MPS client.
 * - On Compute Architecture 9.x: When a module with dynamic parallelism (CDP) is loaded, all future
 * kernels running under green contexts may use and share an additional set of 2 SMs.
 *
 * \{
 */

/**
 * \typedef struct CUdevResourceDesc_st* CUdevResourceDesc;
 * An opaque descriptor handle. The descriptor encapsulates multiple created and configured resources.
 * Created via ::cuDevResourceGenerateDesc
 */
@Opaque @Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUdevResourceDesc_st extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public CUdevResourceDesc_st() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUdevResourceDesc_st(Pointer p) { super(p); }
}
