// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Optional annotation for edges in a CUDA graph. Note, all edges implicitly have annotations and
 * default to a zero-initialized value if not specified. A zero-initialized struct indicates a
 * standard full serialization of two nodes with memory visibility.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUgraphEdgeData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUgraphEdgeData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUgraphEdgeData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUgraphEdgeData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUgraphEdgeData position(long position) {
        return (CUgraphEdgeData)super.position(position);
    }
    @Override public CUgraphEdgeData getPointer(long i) {
        return new CUgraphEdgeData((Pointer)this).offsetAddress(i);
    }

    /** This indicates when the dependency is triggered from the upstream
                                      node on the edge. The meaning is specfic to the node type. A value
                                      of 0 in all cases means full completion of the upstream node, with
                                      memory visibility to the downstream node or portion thereof
                                      (indicated by \c to_port).
                                      <br>
                                      Only kernel nodes define non-zero ports. A kernel node
                                      can use the following output port types:
                                      ::CU_GRAPH_KERNEL_NODE_PORT_DEFAULT, ::CU_GRAPH_KERNEL_NODE_PORT_PROGRAMMATIC,
                                      or ::CU_GRAPH_KERNEL_NODE_PORT_LAUNCH_ORDER. */
    public native @Cast("unsigned char") byte from_port(); public native CUgraphEdgeData from_port(byte setter);
    /** This indicates what portion of the downstream node is dependent on
                                    the upstream node or portion thereof (indicated by \c from_port). The
                                    meaning is specific to the node type. A value of 0 in all cases means
                                    the entirety of the downstream node is dependent on the upstream work.
                                    <br>
                                    Currently no node types define non-zero ports. Accordingly, this field
                                    must be set to zero. */
    public native @Cast("unsigned char") byte to_port(); public native CUgraphEdgeData to_port(byte setter);
    /** This should be populated with a value from ::CUgraphDependencyType. (It
                                 is typed as char due to compiler-specific layout of bitfields.) See
                                 ::CUgraphDependencyType. */
    public native @Cast("unsigned char") byte type(); public native CUgraphEdgeData type(byte setter);
    /** These bytes are unused and must be zeroed. This ensures
                                        compatibility if additional fields are added in the future. */
    public native @Cast("unsigned char") byte reserved(int i); public native CUgraphEdgeData reserved(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer reserved();
}
