// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Graph node parameters.  See ::cuGraphAddNode.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUgraphNodeParams extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUgraphNodeParams() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUgraphNodeParams(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUgraphNodeParams(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUgraphNodeParams position(long position) {
        return (CUgraphNodeParams)super.position(position);
    }
    @Override public CUgraphNodeParams getPointer(long i) {
        return new CUgraphNodeParams((Pointer)this).offsetAddress(i);
    }

    /** Type of the node */
    public native @Cast("CUgraphNodeType") int type(); public native CUgraphNodeParams type(int setter);
    /** Reserved. Must be zero. */
    public native int reserved0(int i); public native CUgraphNodeParams reserved0(int i, int setter);
    @MemberGetter public native IntPointer reserved0();
        /** Padding. Unused bytes must be zero. */
        public native long reserved1(int i); public native CUgraphNodeParams reserved1(int i, long setter);
        @MemberGetter public native LongPointer reserved1();
        /** Kernel node parameters. */
        public native @ByRef CUDA_KERNEL_NODE_PARAMS_v3 kernel(); public native CUgraphNodeParams kernel(CUDA_KERNEL_NODE_PARAMS_v3 setter);
        /** Memcpy node parameters. */
        public native @ByRef CUDA_MEMCPY_NODE_PARAMS memcpy(); public native CUgraphNodeParams memcpy(CUDA_MEMCPY_NODE_PARAMS setter);
        /** Memset node parameters. */
        public native @ByRef CUDA_MEMSET_NODE_PARAMS_v2 memset(); public native CUgraphNodeParams memset(CUDA_MEMSET_NODE_PARAMS_v2 setter);
        /** Host node parameters. */
        public native @ByRef CUDA_HOST_NODE_PARAMS_v2 host(); public native CUgraphNodeParams host(CUDA_HOST_NODE_PARAMS_v2 setter);
        /** Child graph node parameters. */
        public native @ByRef CUDA_CHILD_GRAPH_NODE_PARAMS graph(); public native CUgraphNodeParams graph(CUDA_CHILD_GRAPH_NODE_PARAMS setter);
        /** Event wait node parameters. */
        public native @ByRef CUDA_EVENT_WAIT_NODE_PARAMS eventWait(); public native CUgraphNodeParams eventWait(CUDA_EVENT_WAIT_NODE_PARAMS setter);
        /** Event record node parameters. */
        public native @ByRef CUDA_EVENT_RECORD_NODE_PARAMS eventRecord(); public native CUgraphNodeParams eventRecord(CUDA_EVENT_RECORD_NODE_PARAMS setter);
        /** External semaphore signal node parameters. */
        public native @ByRef CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 extSemSignal(); public native CUgraphNodeParams extSemSignal(CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_v2 setter);
        /** External semaphore wait node parameters. */
        public native @ByRef CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 extSemWait(); public native CUgraphNodeParams extSemWait(CUDA_EXT_SEM_WAIT_NODE_PARAMS_v2 setter);
        /** Memory allocation node parameters. */
        public native @ByRef CUDA_MEM_ALLOC_NODE_PARAMS_v2 alloc(); public native CUgraphNodeParams alloc(CUDA_MEM_ALLOC_NODE_PARAMS_v2 setter);
        /** Memory free node parameters. */
        public native @ByRef @Name("free") CUDA_MEM_FREE_NODE_PARAMS _free(); public native CUgraphNodeParams _free(CUDA_MEM_FREE_NODE_PARAMS setter);
        /** MemOp node parameters. */
        public native @ByRef CUDA_BATCH_MEM_OP_NODE_PARAMS_v2 memOp(); public native CUgraphNodeParams memOp(CUDA_BATCH_MEM_OP_NODE_PARAMS_v2 setter);
        /** Conditional node parameters. */
        public native @ByRef CUDA_CONDITIONAL_NODE_PARAMS conditional(); public native CUgraphNodeParams conditional(CUDA_CONDITIONAL_NODE_PARAMS setter);

    /** Reserved bytes. Must be zero. */
    public native long reserved2(); public native CUgraphNodeParams reserved2(long setter);
}
