// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Memory Synchronization Domain map
 *
 * See ::cudaLaunchMemSyncDomain.
 *
 * By default, kernels are launched in domain 0. Kernel launched with ::CU_LAUNCH_MEM_SYNC_DOMAIN_REMOTE will have a
 * different domain ID. User may also alter the domain ID with ::CUlaunchMemSyncDomainMap for a specific stream /
 * graph node / kernel launch. See ::CU_LAUNCH_ATTRIBUTE_MEM_SYNC_DOMAIN_MAP.
 *
 * Domain ID range is available through ::CU_DEVICE_ATTRIBUTE_MEM_SYNC_DOMAIN_COUNT.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUlaunchMemSyncDomainMap extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUlaunchMemSyncDomainMap() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUlaunchMemSyncDomainMap(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUlaunchMemSyncDomainMap(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUlaunchMemSyncDomainMap position(long position) {
        return (CUlaunchMemSyncDomainMap)super.position(position);
    }
    @Override public CUlaunchMemSyncDomainMap getPointer(long i) {
        return new CUlaunchMemSyncDomainMap((Pointer)this).offsetAddress(i);
    }

    /** The default domain ID to use for designated kernels */
    public native @Cast("unsigned char") byte default_(); public native CUlaunchMemSyncDomainMap default_(byte setter);
    /** The remote domain ID to use for designated kernels */
    public native @Cast("unsigned char") byte remote(); public native CUlaunchMemSyncDomainMap remote(byte setter);
}
