// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Launch attributes union; used as value field of ::cudaLaunchAttribute
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaLaunchAttributeValue extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaLaunchAttributeValue() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaLaunchAttributeValue(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaLaunchAttributeValue(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaLaunchAttributeValue position(long position) {
        return (cudaLaunchAttributeValue)super.position(position);
    }
    @Override public cudaLaunchAttributeValue getPointer(long i) {
        return new cudaLaunchAttributeValue((Pointer)this).offsetAddress(i);
    }

    public native @Cast("char") byte pad(int i); public native cudaLaunchAttributeValue pad(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer pad(); /* Pad to 64 bytes */
    /** Value of launch attribute ::cudaLaunchAttributeAccessPolicyWindow. */
    public native @ByRef cudaAccessPolicyWindow accessPolicyWindow(); public native cudaLaunchAttributeValue accessPolicyWindow(cudaAccessPolicyWindow setter);
    /** Value of launch attribute ::cudaLaunchAttributeCooperative. Nonzero indicates a cooperative
                            kernel (see ::cudaLaunchCooperativeKernel). */
    public native int cooperative(); public native cudaLaunchAttributeValue cooperative(int setter);
    /** Value of launch attribute
                                                      ::cudaLaunchAttributeSynchronizationPolicy. ::cudaSynchronizationPolicy
                                                      for work queued up in this stream. */
    public native @Cast("cudaSynchronizationPolicy") int syncPolicy(); public native cudaLaunchAttributeValue syncPolicy(int setter);
    /**
     * Value of launch attribute ::cudaLaunchAttributeClusterDimension that
     * represents the desired cluster dimensions for the kernel. Opaque type
     * with the following fields:
     *     - \p x - The X dimension of the cluster, in blocks. Must be a divisor
     *              of the grid X dimension.
     *     - \p y - The Y dimension of the cluster, in blocks. Must be a divisor
     *              of the grid Y dimension.
     *     - \p z - The Z dimension of the cluster, in blocks. Must be a divisor
     *              of the grid Z dimension.
     */
        @Name("clusterDim.x") public native @Cast("unsigned int") int clusterDim_x(); public native cudaLaunchAttributeValue clusterDim_x(int setter);
        @Name("clusterDim.y") public native @Cast("unsigned int") int clusterDim_y(); public native cudaLaunchAttributeValue clusterDim_y(int setter);
        @Name("clusterDim.z") public native @Cast("unsigned int") int clusterDim_z(); public native cudaLaunchAttributeValue clusterDim_z(int setter);
    /** Value of launch attribute
                                                                               ::cudaLaunchAttributeClusterSchedulingPolicyPreference. Cluster
                                                                               scheduling policy preference for the kernel. */
    public native @Cast("cudaClusterSchedulingPolicy") int clusterSchedulingPolicyPreference(); public native cudaLaunchAttributeValue clusterSchedulingPolicyPreference(int setter);
    /** Value of launch attribute
                                                       ::cudaLaunchAttributeProgrammaticStreamSerialization. */
    public native int programmaticStreamSerializationAllowed(); public native cudaLaunchAttributeValue programmaticStreamSerializationAllowed(int setter);

    /**
     * Value of launch attribute ::cudaLaunchAttributeProgrammaticEvent
     * with the following fields:
     *     - \p cudaEvent_t event - Event to fire when all blocks trigger it.
     *     - \p int flags;        - Event record flags, see ::cudaEventRecordWithFlags. Does not accept
     *                               ::cudaEventRecordExternal.
     *     - \p int triggerAtBlockStart - If this is set to non-0, each block launch will automatically trigger the event.
     */
        @Name("programmaticEvent.event") public native CUevent_st programmaticEvent_event(); public native cudaLaunchAttributeValue programmaticEvent_event(CUevent_st setter);
        @Name("programmaticEvent.flags") public native int programmaticEvent_flags(); public native cudaLaunchAttributeValue programmaticEvent_flags(int setter);
        @Name("programmaticEvent.triggerAtBlockStart") public native int programmaticEvent_triggerAtBlockStart(); public native cudaLaunchAttributeValue programmaticEvent_triggerAtBlockStart(int setter);
    /** Value of launch attribute ::cudaLaunchAttributePriority. Execution priority of the kernel. */
    public native int priority(); public native cudaLaunchAttributeValue priority(int setter);
    /** Value of launch attribute
                                                        ::cudaLaunchAttributeMemSyncDomainMap. See
                                                        ::cudaLaunchMemSyncDomainMap. */
    public native @ByRef cudaLaunchMemSyncDomainMap memSyncDomainMap(); public native cudaLaunchAttributeValue memSyncDomainMap(cudaLaunchMemSyncDomainMap setter);
    /** Value of launch attribute ::cudaLaunchAttributeMemSyncDomain. See
                                                        ::cudaLaunchMemSyncDomain. */
    public native @Cast("cudaLaunchMemSyncDomain") int memSyncDomain(); public native cudaLaunchAttributeValue memSyncDomain(int setter);
    /**
     * Value of launch attribute ::cudaLaunchAttributeLaunchCompletionEvent
     * with the following fields:
     *     - \p cudaEvent_t event - Event to fire when the last block launches.
     *     - \p int flags - Event record flags, see ::cudaEventRecordWithFlags. Does not accept
     *                   ::cudaEventRecordExternal.
     */
        @Name("launchCompletionEvent.event") public native CUevent_st launchCompletionEvent_event(); public native cudaLaunchAttributeValue launchCompletionEvent_event(CUevent_st setter);
        @Name("launchCompletionEvent.flags") public native int launchCompletionEvent_flags(); public native cudaLaunchAttributeValue launchCompletionEvent_flags(int setter);

    /**
     * Value of launch attribute ::cudaLaunchAttributeDeviceUpdatableKernelNode
     * with the following fields:
     *    - \p int deviceUpdatable - Whether or not the resulting kernel node should be device-updatable.
     *    - \p cudaGraphDeviceNode_t devNode - Returns a handle to pass to the various device-side update functions.
     */
        @Name("deviceUpdatableKernelNode.deviceUpdatable") public native int deviceUpdatableKernelNode_deviceUpdatable(); public native cudaLaunchAttributeValue deviceUpdatableKernelNode_deviceUpdatable(int setter);
        @Name("deviceUpdatableKernelNode.devNode") public native CUgraphDeviceUpdatableNode_st deviceUpdatableKernelNode_devNode(); public native cudaLaunchAttributeValue deviceUpdatableKernelNode_devNode(CUgraphDeviceUpdatableNode_st setter);
    /** Value of launch attribute ::cudaLaunchAttributePreferredSharedMemoryCarveout. */
    public native @Cast("unsigned int") int sharedMemCarveout(); public native cudaLaunchAttributeValue sharedMemCarveout(int setter);
}
