// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The base activity record.
 *
 * The activity API uses a CUpti_Activity as a generic representation
 * for any activity. The 'kind' field is used to determine the
 * specific activity kind, and from that the CUpti_Activity object can
 * be cast to the specific activity record type appropriate for that kind.
 *
 * Note that all activity record types are padded and aligned to
 * ensure that each member of the record is naturally aligned.
 *
 * @see CUpti_ActivityKind
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_Activity extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_Activity() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_Activity(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_Activity(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_Activity position(long position) {
        return (CUpti_Activity)super.position(position);
    }
    @Override public CUpti_Activity getPointer(long i) {
        return new CUpti_Activity((Pointer)this).offsetAddress(i);
    }

  /**
   * The kind of this activity.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_Activity kind(int setter);
}
