// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a context.
 *
 * This activity record represents information about a context
 * (CUPTI_ACTIVITY_KIND_CONTEXT).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityContext3 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityContext3() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityContext3(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityContext3(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityContext3 position(long position) {
        return (CUpti_ActivityContext3)super.position(position);
    }
    @Override public CUpti_ActivityContext3 getPointer(long i) {
        return new CUpti_ActivityContext3((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_CONTEXT.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityContext3 kind(int setter);

  /**
   * The context ID.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityContext3 contextId(int setter);

  /**
   * The device ID.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityContext3 deviceId(int setter);

  /**
   * The compute API kind. @see CUpti_ActivityComputeApiKind
   */
  public native @Cast("uint16_t") short computeApiKind(); public native CUpti_ActivityContext3 computeApiKind(short setter);

  /**
   * The ID for the NULL stream in this context
   */
  public native @Cast("uint16_t") short nullStreamId(); public native CUpti_ActivityContext3 nullStreamId(short setter);

  /**
   * The ID of the parent context. It would be 0 if
   * context does not have parent
   */
  public native @Cast("uint32_t") int parentContextId(); public native CUpti_ActivityContext3 parentContextId(int setter);

  /**
   * This field indicates whether the context is a green context
   */
  public native @Cast("uint8_t") byte isGreenContext(); public native CUpti_ActivityContext3 isGreenContext(byte setter);

  public native @Cast("uint8_t") byte padding(); public native CUpti_ActivityContext3 padding(byte setter);

  /**
   * Number of multiprocessors assigned to the green context
   * Invalid if the field 'isGreenContext' is 0
   */
  public native @Cast("uint16_t") short numMultiprocessors(); public native CUpti_ActivityContext3 numMultiprocessors(short setter);

  /**
   * This field indicates the CIG mode
   */
  public native @Cast("CUpti_ContextCigMode") int cigMode(); public native CUpti_ActivityContext3 cigMode(int setter);

  public native @Cast("uint32_t") int padding2(); public native CUpti_ActivityContext3 padding2(int setter);

}
