// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for CUDA event.
 *
 * This activity is used to track recorded events.
 * (CUPTI_ACTIVITY_KIND_CUDA_EVENT).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityCudaEvent extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityCudaEvent() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityCudaEvent(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityCudaEvent(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityCudaEvent position(long position) {
        return (CUpti_ActivityCudaEvent)super.position(position);
    }
    @Override public CUpti_ActivityCudaEvent getPointer(long i) {
        return new CUpti_ActivityCudaEvent((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_CUDA_EVENT.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityCudaEvent kind(int setter);

  /**
   * The correlation ID of the API to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityCudaEvent correlationId(int setter);

  /**
   * The ID of the context where the event was recorded.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityCudaEvent contextId(int setter);

  /**
   * The compute stream where the event was recorded.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityCudaEvent streamId(int setter);

  /**
   * A unique event ID to identify the event record.
   */
  public native @Cast("uint32_t") int eventId(); public native CUpti_ActivityCudaEvent eventId(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityCudaEvent pad(int setter);
}
