// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;



/**
 * \brief The activity record for trace of graph execution.
 *
 * This activity record represents execution for a graph without giving visibility
 * about the execution of its nodes. This is intended to reduce overheads in tracing
 * each node. The activity kind is CUPTI_ACTIVITY_KIND_GRAPH_TRACE
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityGraphTrace2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityGraphTrace2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityGraphTrace2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityGraphTrace2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityGraphTrace2 position(long position) {
        return (CUpti_ActivityGraphTrace2)super.position(position);
    }
    @Override public CUpti_ActivityGraphTrace2 getPointer(long i) {
        return new CUpti_ActivityGraphTrace2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_GRAPH_TRACE
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityGraphTrace2 kind(int setter);

  /**
   * The correlation ID of the graph launch. Each graph launch is
   * assigned a unique correlation ID that is identical to the
   * correlation ID in the driver API activity record that launched
   * the graph.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityGraphTrace2 correlationId(int setter);

  /**
   * The start timestamp for the graph execution, in ns. A value of 0
   * for both the start and end timestamps indicates that timestamp
   * information could not be collected for the graph.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityGraphTrace2 start(long setter);

  /**
   * The end timestamp for the graph execution, in ns. A value of 0
   * for both the start and end timestamps indicates that timestamp
   * information could not be collected for the graph.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityGraphTrace2 end(long setter);

  /**
   * The ID of the device where the first node of the graph is executed.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityGraphTrace2 deviceId(int setter);

  /**
   * The unique ID of the graph that is launched.
   */
  public native @Cast("uint32_t") int graphId(); public native CUpti_ActivityGraphTrace2 graphId(int setter);

  /**
   * The ID of the context where the first node of the graph is executed.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityGraphTrace2 contextId(int setter);

  /**
   * The ID of the stream where the graph is being launched.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityGraphTrace2 streamId(int setter);

  /**
   * This field is reserved for internal use
   */
  public native Pointer reserved(); public native CUpti_ActivityGraphTrace2 reserved(Pointer setter);

  /**
   * The ID of the device where last node of the graph is executed
   */
  public native @Cast("uint32_t") int endDeviceId(); public native CUpti_ActivityGraphTrace2 endDeviceId(int setter);

  /**
   * The ID of the context where the last node of the graph is executed.
   */
  public native @Cast("uint32_t") int endContextId(); public native CUpti_ActivityGraphTrace2 endContextId(int setter);
}
