// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for an instantaneous CUPTI metric.
 *
 * This activity record represents the collection of a CUPTI metric
 * value (CUPTI_ACTIVITY_KIND_METRIC) at a particular instance.
 * This activity record kind is not produced by the activity API but
 * is included for completeness and ease-of-use. Profiler frameworks built
 * on top of CUPTI that collect metric data may choose to use this type to
 * store the collected metric data.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityInstantaneousMetric extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityInstantaneousMetric() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityInstantaneousMetric(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityInstantaneousMetric(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityInstantaneousMetric position(long position) {
        return (CUpti_ActivityInstantaneousMetric)super.position(position);
    }
    @Override public CUpti_ActivityInstantaneousMetric getPointer(long i) {
        return new CUpti_ActivityInstantaneousMetric((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityInstantaneousMetric kind(int setter);

  /**
   * The metric ID.
   */
  public native @Cast("CUpti_MetricID") int id(); public native CUpti_ActivityInstantaneousMetric id(int setter);

  /**
   * The metric value.
   */
  public native @ByRef CUpti_MetricValue value(); public native CUpti_ActivityInstantaneousMetric value(CUpti_MetricValue setter);

  /**
   * The timestamp at which metric is sampled
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityInstantaneousMetric timestamp(long setter);

  /**
   * The device id
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityInstantaneousMetric deviceId(int setter);

  /**
   * The properties of this metric. @see CUpti_ActivityFlag
   */
  public native @Cast("uint8_t") byte flags(); public native CUpti_ActivityInstantaneousMetric flags(byte setter);

  /**
   * Undefined. reserved for internal use
   */
  public native @Cast("uint8_t") byte pad(int i); public native CUpti_ActivityInstantaneousMetric pad(int i, byte setter);
  @MemberGetter public native @Cast("uint8_t*") BytePointer pad();
}
