// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The instantaneous activity record for a CUPTI metric with instance
 * information.
 <p>
 * This activity record represents a CUPTI metric value
 * for a specific metric domain instance
 * (CUPTI_ACTIVITY_KIND_METRIC_INSTANCE) sampled at a particular time. This
 * activity record kind is not produced by the activity API but is included for
 * completeness and ease-of-use. Profiler frameworks built on top of
 * CUPTI that collect metric data may choose to use this type to store
 * the collected metric data. This activity record should be used when
 * metric domain instance information needs to be associated with the
 * metric.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityInstantaneousMetricInstance extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityInstantaneousMetricInstance() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityInstantaneousMetricInstance(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityInstantaneousMetricInstance(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityInstantaneousMetricInstance position(long position) {
        return (CUpti_ActivityInstantaneousMetricInstance)super.position(position);
    }
    @Override public CUpti_ActivityInstantaneousMetricInstance getPointer(long i) {
        return new CUpti_ActivityInstantaneousMetricInstance((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityInstantaneousMetricInstance kind(int setter);

  /**
   * The metric ID.
   */
  public native @Cast("CUpti_MetricID") int id(); public native CUpti_ActivityInstantaneousMetricInstance id(int setter);

  /**
   * The metric value.
   */
  public native @ByRef CUpti_MetricValue value(); public native CUpti_ActivityInstantaneousMetricInstance value(CUpti_MetricValue setter);

  /**
   * The timestamp at which metric is sampled
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityInstantaneousMetricInstance timestamp(long setter);

  /**
   * The device id
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityInstantaneousMetricInstance deviceId(int setter);

  /**
   * The properties of this metric. @see CUpti_ActivityFlag
   */
  public native @Cast("uint8_t") byte flags(); public native CUpti_ActivityInstantaneousMetricInstance flags(byte setter);

  /**
   * The metric domain instance
   */
  public native @Cast("uint8_t") byte instance(); public native CUpti_ActivityInstantaneousMetricInstance instance(byte setter);

  /**
   * Undefined. reserved for internal use
   */
  public native @Cast("uint8_t") byte pad(int i); public native CUpti_ActivityInstantaneousMetricInstance pad(int i, byte setter);
  @MemberGetter public native @Cast("uint8_t*") BytePointer pad();
}
