// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for kernel.
 *
 * This activity record represents a kernel execution
 * (CUPTI_ACTIVITY_KIND_KERNEL and
 * CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL)
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityKernel9 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityKernel9() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityKernel9(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityKernel9(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityKernel9 position(long position) {
        return (CUpti_ActivityKernel9)super.position(position);
    }
    @Override public CUpti_ActivityKernel9 getPointer(long i) {
        return new CUpti_ActivityKernel9((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_KERNEL or
   * CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityKernel9 kind(int setter);

  /**
   * For devices with compute capability 7.0+ cacheConfig values are not updated
   * in case field isSharedMemoryCarveoutRequested is set
   */
    @Name("cacheConfig.both") public native @Cast("uint8_t") byte cacheConfig_both(); public native CUpti_ActivityKernel9 cacheConfig_both(byte setter);
      /**
       * The cache configuration requested by the kernel. The value is one
       * of the CUfunc_cache enumeration values from cuda.h.
       */
      @Name("cacheConfig.config.requested") public native @Cast("uint8_t") @NoOffset byte cacheConfig_config_requested(); public native CUpti_ActivityKernel9 cacheConfig_config_requested(byte setter);

      /**
       * The cache configuration used for the kernel. The value is one of
       * the CUfunc_cache enumeration values from cuda.h.
       */
      @Name("cacheConfig.config.executed") public native @Cast("uint8_t") @NoOffset byte cacheConfig_config_executed(); public native CUpti_ActivityKernel9 cacheConfig_config_executed(byte setter);

  /**
   * The shared memory configuration used for the kernel. The value is one of
   * the CUsharedconfig enumeration values from cuda.h.
   */
  public native @Cast("uint8_t") byte sharedMemoryConfig(); public native CUpti_ActivityKernel9 sharedMemoryConfig(byte setter);

  /**
   * The number of registers required for each thread executing the
   * kernel.
   */
  public native @Cast("uint16_t") short registersPerThread(); public native CUpti_ActivityKernel9 registersPerThread(short setter);

  /**
   * The partitioned global caching requested for the kernel. Partitioned
   * global caching is required to enable caching on certain chips, such as
   * devices with compute capability 5.2.
   */
  public native @Cast("CUpti_ActivityPartitionedGlobalCacheConfig") int partitionedGlobalCacheRequested(); public native CUpti_ActivityKernel9 partitionedGlobalCacheRequested(int setter);

  /**
   * The partitioned global caching executed for the kernel. Partitioned
   * global caching is required to enable caching on certain chips, such as
   * devices with compute capability 5.2. Partitioned global caching can be
   * automatically disabled if the occupancy requirement of the launch cannot
   * support caching.
   */
  public native @Cast("CUpti_ActivityPartitionedGlobalCacheConfig") int partitionedGlobalCacheExecuted(); public native CUpti_ActivityKernel9 partitionedGlobalCacheExecuted(int setter);

  /**
   * The start timestamp for the kernel execution, in ns. A value of 0
   * for both the start and end timestamps indicates that timestamp
   * information could not be collected for the kernel.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityKernel9 start(long setter);

  /**
   * The end timestamp for the kernel execution, in ns. A value of 0
   * for both the start and end timestamps indicates that timestamp
   * information could not be collected for the kernel.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityKernel9 end(long setter);

  /**
   * The completed timestamp for the kernel execution, in ns.  It
   * represents the completion of all it's child kernels and the
   * kernel itself. A value of CUPTI_TIMESTAMP_UNKNOWN indicates that
   * the completion time is unknown.
   */
  public native @Cast("uint64_t") long completed(); public native CUpti_ActivityKernel9 completed(long setter);

  /**
   * The ID of the device where the kernel is executing.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityKernel9 deviceId(int setter);

  /**
   * The ID of the context where the kernel is executing.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityKernel9 contextId(int setter);

  /**
   * The ID of the stream where the kernel is executing.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityKernel9 streamId(int setter);

  /**
   * The X-dimension grid size for the kernel.
   */
  public native int gridX(); public native CUpti_ActivityKernel9 gridX(int setter);

  /**
   * The Y-dimension grid size for the kernel.
   */
  public native int gridY(); public native CUpti_ActivityKernel9 gridY(int setter);

  /**
   * The Z-dimension grid size for the kernel.
   */
  public native int gridZ(); public native CUpti_ActivityKernel9 gridZ(int setter);

  /**
   * The X-dimension block size for the kernel.
   */
  public native int blockX(); public native CUpti_ActivityKernel9 blockX(int setter);

  /**
   * The Y-dimension block size for the kernel.
   */
  public native int blockY(); public native CUpti_ActivityKernel9 blockY(int setter);

  /**
   * The Z-dimension grid size for the kernel.
   */
  public native int blockZ(); public native CUpti_ActivityKernel9 blockZ(int setter);

  /**
   * The static shared memory allocated for the kernel, in bytes.
   */
  public native int staticSharedMemory(); public native CUpti_ActivityKernel9 staticSharedMemory(int setter);

  /**
   * The dynamic shared memory reserved for the kernel, in bytes.
   */
  public native int dynamicSharedMemory(); public native CUpti_ActivityKernel9 dynamicSharedMemory(int setter);

  /**
   * The amount of local memory reserved for each thread, in bytes.
   */
  public native @Cast("uint32_t") int localMemoryPerThread(); public native CUpti_ActivityKernel9 localMemoryPerThread(int setter);

  /**
   * The total amount of local memory reserved for the kernel, in
   * bytes (deprecated in CUDA 11.8).
   * Refer field localMemoryTotal_v2
   */
  public native @Cast("uint32_t") int localMemoryTotal(); public native CUpti_ActivityKernel9 localMemoryTotal(int setter);

  /**
   * The correlation ID of the kernel. Each kernel execution is
   * assigned a unique correlation ID that is identical to the
   * correlation ID in the driver or runtime API activity record that
   * launched the kernel.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityKernel9 correlationId(int setter);

  /**
   * The grid ID of the kernel. Each kernel is assigned a unique
   * grid ID at runtime.
   */
  public native @Cast("int64_t") long gridId(); public native CUpti_ActivityKernel9 gridId(long setter);

  /**
   * The name of the kernel. This name is shared across all activity
   * records representing the same kernel, and so should not be
   * modified.
   */
  public native @Cast("const char*") BytePointer name(); public native CUpti_ActivityKernel9 name(BytePointer setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native Pointer reserved0(); public native CUpti_ActivityKernel9 reserved0(Pointer setter);

  /**
   * The timestamp when the kernel is queued up in the command buffer, in ns.
   * A value of CUPTI_TIMESTAMP_UNKNOWN indicates that the queued time
   * could not be collected for the kernel. This timestamp is not collected
   * by default. Use API \ref cuptiActivityEnableLatencyTimestamps() to
   * enable collection.
   *
   * Command buffer is a buffer written by CUDA driver to send commands
   * like kernel launch, memory copy etc to the GPU. All launches of CUDA
   * kernels are asynchronous with respect to the host, the host requests
   * the launch by writing commands into the command buffer, then returns
   * without checking the GPU's progress.
   */
  public native @Cast("uint64_t") long queued(); public native CUpti_ActivityKernel9 queued(long setter);

  /**
   * The timestamp when the command buffer containing the kernel launch
   * is submitted to the GPU, in ns. A value of CUPTI_TIMESTAMP_UNKNOWN
   * indicates that the submitted time could not be collected for the kernel.
   * This timestamp is not collected by default. Use API \ref
   * cuptiActivityEnableLatencyTimestamps() to enable collection.
   */
  public native @Cast("uint64_t") long submitted(); public native CUpti_ActivityKernel9 submitted(long setter);

  /**
   * The indicates if the kernel was executed via a regular launch or via a
   * single/multi device cooperative launch. @see CUpti_ActivityLaunchType
   */
  public native @Cast("uint8_t") byte launchType(); public native CUpti_ActivityKernel9 launchType(byte setter);

  /**
   * This indicates if CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT was
   * updated for the kernel launch
   */
  public native @Cast("uint8_t") byte isSharedMemoryCarveoutRequested(); public native CUpti_ActivityKernel9 isSharedMemoryCarveoutRequested(byte setter);

  /**
   * Shared memory carveout value requested for the function in percentage of
   * the total resource. The value will be updated only if field
   * isSharedMemoryCarveoutRequested is set.
   */
  public native @Cast("uint8_t") byte sharedMemoryCarveoutRequested(); public native CUpti_ActivityKernel9 sharedMemoryCarveoutRequested(byte setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint8_t") byte padding(); public native CUpti_ActivityKernel9 padding(byte setter);

 /**
  * Shared memory size set by the driver.
  */
  public native @Cast("uint32_t") int sharedMemoryExecuted(); public native CUpti_ActivityKernel9 sharedMemoryExecuted(int setter);

  /**
   * The unique ID of the graph node that launched this kernel through graph launch APIs.
   * This field will be 0 if the kernel is not launched through graph launch APIs.
   */
  public native @Cast("uint64_t") long graphNodeId(); public native CUpti_ActivityKernel9 graphNodeId(long setter);

  /**
   * The shared memory limit config for the kernel. This field shows whether user has opted for a
   * higher per block limit of dynamic shared memory.
   */
  public native @Cast("CUpti_FuncShmemLimitConfig") int shmemLimitConfig(); public native CUpti_ActivityKernel9 shmemLimitConfig(int setter);

  /**
   * The unique ID of the graph that launched this kernel through graph launch APIs.
   * This field will be 0 if the kernel is not launched through graph launch APIs.
   */
  public native @Cast("uint32_t") int graphId(); public native CUpti_ActivityKernel9 graphId(int setter);

  /**
   * The pointer to the access policy window. The structure CUaccessPolicyWindow is
   * defined in cuda.h.
   */
  public native @Cast("CUaccessPolicyWindow*") CUaccessPolicyWindow_v1 pAccessPolicyWindow(); public native CUpti_ActivityKernel9 pAccessPolicyWindow(CUaccessPolicyWindow_v1 setter);

  /**
   * The ID of the HW channel on which the kernel is launched.
   */
  public native @Cast("uint32_t") int channelID(); public native CUpti_ActivityKernel9 channelID(int setter);

  /**
   * The type of the channel
   */
  public native @Cast("CUpti_ChannelType") int channelType(); public native CUpti_ActivityKernel9 channelType(int setter);

  /**
   * The X-dimension cluster size for the kernel.
   * Field is valid for devices with compute capability 9.0 and higher
   */
  public native @Cast("uint32_t") int clusterX(); public native CUpti_ActivityKernel9 clusterX(int setter);

  /**
   * The Y-dimension cluster size for the kernel.
   * Field is valid for devices with compute capability 9.0 and higher
   */
  public native @Cast("uint32_t") int clusterY(); public native CUpti_ActivityKernel9 clusterY(int setter);

  /**
   * The Z-dimension cluster size for the kernel.
   * Field is valid for devices with compute capability 9.0 and higher
   */
  public native @Cast("uint32_t") int clusterZ(); public native CUpti_ActivityKernel9 clusterZ(int setter);

  /**
   * The cluster scheduling policy for the kernel. Refer CUclusterSchedulingPolicy
   * Field is valid for devices with compute capability 9.0 and higher
   */
  public native @Cast("uint32_t") int clusterSchedulingPolicy(); public native CUpti_ActivityKernel9 clusterSchedulingPolicy(int setter);

  /**
   * The total amount of local memory reserved for the kernel, in
   * bytes.
   */
  public native @Cast("uint64_t") long localMemoryTotal_v2(); public native CUpti_ActivityKernel9 localMemoryTotal_v2(long setter);

  /**
   * The maximum cluster size for the kernel
   */
  public native @Cast("uint32_t") int maxPotentialClusterSize(); public native CUpti_ActivityKernel9 maxPotentialClusterSize(int setter);

  /**
   * The maximum clusters that could co-exist on the target device for the kernel
   */
  public native @Cast("uint32_t") int maxActiveClusters(); public native CUpti_ActivityKernel9 maxActiveClusters(int setter);
}
