// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record providing detailed information for a marker.
 *
 * User must enable CUPTI_ACTIVITY_KIND_MARKER as well
 * to get records for marker data.
 * The marker data contains color, payload, and category.
 * (CUPTI_ACTIVITY_KIND_MARKER_DATA).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMarkerData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMarkerData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMarkerData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMarkerData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMarkerData position(long position) {
        return (CUpti_ActivityMarkerData)super.position(position);
    }
    @Override public CUpti_ActivityMarkerData getPointer(long i) {
        return new CUpti_ActivityMarkerData((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be
   * CUPTI_ACTIVITY_KIND_MARKER_DATA.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMarkerData kind(int setter);

  /**
   * The flags associated with the marker. @see CUpti_ActivityFlag
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityMarkerData flags(int setter);

  /**
   * The marker ID.
   */
  public native @Cast("uint32_t") int id(); public native CUpti_ActivityMarkerData id(int setter);

  /**
   * Defines the payload format for the value associated with the marker.
   */
  public native @Cast("CUpti_MetricValueKind") int payloadKind(); public native CUpti_ActivityMarkerData payloadKind(int setter);

  /**
   * The payload value.
   */
  public native @ByRef CUpti_MetricValue payload(); public native CUpti_ActivityMarkerData payload(CUpti_MetricValue setter);

  /**
   * The color for the marker.
   */
  public native @Cast("uint32_t") int color(); public native CUpti_ActivityMarkerData color(int setter);

  /**
   * The category for the marker.
   */
  public native @Cast("uint32_t") int category(); public native CUpti_ActivityMarkerData category(int setter);

}
