// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for memory.
 *
 * This activity record represents a memory allocation and free operation
 * (CUPTI_ACTIVITY_KIND_MEMORY2).
 * This activity record provides separate records for memory allocation and
 * memory release operations.
 * This allows to correlate the corresponding driver and runtime API
 * activity record with the memory operation.
 *
 * Note: This activity record is an upgrade over \ref CUpti_ActivityMemory
 * enabled using the kind \ref CUPTI_ACTIVITY_KIND_MEMORY.
 * \ref CUpti_ActivityMemory provides a single record for the memory
 * allocation and memory release operations.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMemory4 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMemory4() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMemory4(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMemory4(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMemory4 position(long position) {
        return (CUpti_ActivityMemory4)super.position(position);
    }
    @Override public CUpti_ActivityMemory4 getPointer(long i) {
        return new CUpti_ActivityMemory4((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MEMORY2
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMemory4 kind(int setter);

  /**
   * The memory operation requested by the user, \ref CUpti_ActivityMemoryOperationType.
   */
  public native @Cast("CUpti_ActivityMemoryOperationType") int memoryOperationType(); public native CUpti_ActivityMemory4 memoryOperationType(int setter);

  /**
   * The memory kind requested by the user, \ref CUpti_ActivityMemoryKind.
   */
  public native @Cast("CUpti_ActivityMemoryKind") int memoryKind(); public native CUpti_ActivityMemory4 memoryKind(int setter);

  /**
   * The correlation ID of the memory operation. Each memory operation is
   * assigned a unique correlation ID that is identical to the
   * correlation ID in the driver and runtime API activity record that
   * launched the memory operation.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMemory4 correlationId(int setter);

  /**
   * The virtual address of the allocation.
   */
  public native @Cast("uint64_t") @Name("address") long _address(); public native CUpti_ActivityMemory4 _address(long setter);

  /**
   * The number of bytes of memory allocated.
   */
  public native @Cast("uint64_t") long bytes(); public native CUpti_ActivityMemory4 bytes(long setter);

  /**
   * The start timestamp for the memory operation, in ns.
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityMemory4 timestamp(long setter);

  /**
   * The program counter of the memory operation.
   */
  public native @Cast("uint64_t") long PC(); public native CUpti_ActivityMemory4 PC(long setter);

  /**
   * The ID of the process to which this record belongs to.
   */
  public native @Cast("uint32_t") int processId(); public native CUpti_ActivityMemory4 processId(int setter);

  /**
   * The ID of the device where the memory operation is taking place.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityMemory4 deviceId(int setter);

  /**
   * The ID of the context. If context is NULL, \p contextId is set to CUPTI_INVALID_CONTEXT_ID.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityMemory4 contextId(int setter);

  /**
   * The ID of the stream. If memory operation is not async, \p streamId is set to CUPTI_INVALID_STREAM_ID.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityMemory4 streamId(int setter);

  /**
   * Variable name. This name is shared across all activity
   * records representing the same symbol, and so should not be
   * modified.
   */
  public native @Cast("const char*") BytePointer name(); public native CUpti_ActivityMemory4 name(BytePointer setter);

  /**
   * \p isAsync is set if memory operation happens through async memory APIs.
   */
  public native @Cast("uint32_t") int isAsync(); public native CUpti_ActivityMemory4 isAsync(int setter);

// #ifdef CUPTILP64
  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad1(); public native CUpti_ActivityMemory4 pad1(int setter);
// #endif

  /**
   * The memory pool configuration used for the memory operations.
   */
    /**
     * The type of the memory pool, \ref CUpti_ActivityMemoryPoolType
     */
    @Name("memoryPoolConfig.memoryPoolType") public native @Cast("CUpti_ActivityMemoryPoolType") int memoryPoolConfig_memoryPoolType(); public native CUpti_ActivityMemory4 memoryPoolConfig_memoryPoolType(int setter);

// #ifdef CUPTILP64
    /**
     * Undefined. Reserved for internal use.
     */
    @Name("memoryPoolConfig.pad2") public native @Cast("uint32_t") int memoryPoolConfig_pad2(); public native CUpti_ActivityMemory4 memoryPoolConfig_pad2(int setter);
// #endif

    /**
     * The base address of the memory pool.
     */
    @Name("memoryPoolConfig.address") public native @Cast("uint64_t") long memoryPoolConfig_address(); public native CUpti_ActivityMemory4 memoryPoolConfig_address(long setter);

    /**
     * The release threshold of the memory pool in bytes. \p releaseThreshold is
     * valid for CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
     */
    @Name("memoryPoolConfig.releaseThreshold") public native @Cast("uint64_t") long memoryPoolConfig_releaseThreshold(); public native CUpti_ActivityMemory4 memoryPoolConfig_releaseThreshold(long setter);

    /**
     * The size of memory pool in bytes and the processId of the memory pools
     * \p size is valid if \p memoryPoolType is
     * CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
     * \p processId is valid if \p memoryPoolType is
     * CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED, \ref CUpti_ActivityMemoryPoolType
     */
      @Name("memoryPoolConfig.pool.size") public native @Cast("uint64_t") long memoryPoolConfig_pool_size(); public native CUpti_ActivityMemory4 memoryPoolConfig_pool_size(long setter);
      @Name("memoryPoolConfig.pool.processId") public native @Cast("uint64_t") long memoryPoolConfig_pool_processId(); public native CUpti_ActivityMemory4 memoryPoolConfig_pool_processId(long setter);

    /**
     * The utilized size of the memory pool. \p utilizedSize is
     * valid for CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
     */
    @Name("memoryPoolConfig.utilizedSize") public native @Cast("uint64_t") long memoryPoolConfig_utilizedSize(); public native CUpti_ActivityMemory4 memoryPoolConfig_utilizedSize(long setter);

    /**
     * The shared object or binary that the memory allocation request comes from.
     */
    public native @Cast("const char*") BytePointer source(); public native CUpti_ActivityMemory4 source(BytePointer setter);
}
