// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for memory pool.
 *
 * This activity record represents a memory pool creation, destruction and
 * trimming (CUPTI_ACTIVITY_KIND_MEMORY_POOL).
 * This activity record provides separate records for memory pool creation,
 * destruction and trimming operations.
 * This allows to correlate the corresponding driver and runtime API
 * activity record with the memory pool operation.
 *
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMemoryPool2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMemoryPool2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMemoryPool2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMemoryPool2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMemoryPool2 position(long position) {
        return (CUpti_ActivityMemoryPool2)super.position(position);
    }
    @Override public CUpti_ActivityMemoryPool2 getPointer(long i) {
        return new CUpti_ActivityMemoryPool2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MEMORY_POOL
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMemoryPool2 kind(int setter);

  /**
   * The memory operation requested by the user, \ref CUpti_ActivityMemoryPoolOperationType.
   */
  public native @Cast("CUpti_ActivityMemoryPoolOperationType") int memoryPoolOperationType(); public native CUpti_ActivityMemoryPool2 memoryPoolOperationType(int setter);

  /**
   * The type of the memory pool, \ref CUpti_ActivityMemoryPoolType
   */
  public native @Cast("CUpti_ActivityMemoryPoolType") int memoryPoolType(); public native CUpti_ActivityMemoryPool2 memoryPoolType(int setter);

  /**
   * The correlation ID of the memory pool operation. Each memory pool
   * operation is assigned a unique correlation ID that is identical to the
   * correlation ID in the driver and runtime API activity record that
   * launched the memory operation.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMemoryPool2 correlationId(int setter);

  /**
   * The ID of the process to which this record belongs to.
   */
  public native @Cast("uint32_t") int processId(); public native CUpti_ActivityMemoryPool2 processId(int setter);

  /**
   * The ID of the device where the memory pool is created.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityMemoryPool2 deviceId(int setter);

  /**
   * The minimum bytes to keep of the memory pool. \p minBytesToKeep is
   * valid for CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED,
   * \ref CUpti_ActivityMemoryPoolOperationType
   */
  public native @Cast("size_t") long minBytesToKeep(); public native CUpti_ActivityMemoryPool2 minBytesToKeep(long setter);

// #ifndef CUPTILP64
// #endif

  /**
   * The virtual address of the allocation.
   */
  public native @Cast("uint64_t") @Name("address") long _address(); public native CUpti_ActivityMemoryPool2 _address(long setter);

  /**
   * The size of the memory pool operation in bytes. \p size is
   * valid for CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
   */
  public native @Cast("uint64_t") long size(); public native CUpti_ActivityMemoryPool2 size(long setter);

  /**
   * The release threshold of the memory pool. \p releaseThreshold is
   * valid for CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
   */
  public native @Cast("uint64_t") long releaseThreshold(); public native CUpti_ActivityMemoryPool2 releaseThreshold(long setter);

  /**
   * The start timestamp for the memory operation, in ns.
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityMemoryPool2 timestamp(long setter);

  /**
   * The utilized size of the memory pool. \p utilizedSize is
   * valid for CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL, \ref CUpti_ActivityMemoryPoolType.
   */
  public native @Cast("uint64_t") long utilizedSize(); public native CUpti_ActivityMemoryPool2 utilizedSize(long setter);
}
