// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for memset.
 *
 * This activity record represents a memory set operation
 * (CUPTI_ACTIVITY_KIND_MEMSET).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMemset4 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMemset4() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMemset4(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMemset4(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMemset4 position(long position) {
        return (CUpti_ActivityMemset4)super.position(position);
    }
    @Override public CUpti_ActivityMemset4 getPointer(long i) {
        return new CUpti_ActivityMemset4((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MEMSET.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMemset4 kind(int setter);

  /**
   * The value being assigned to memory by the memory set.
   */
  public native @Cast("uint32_t") int value(); public native CUpti_ActivityMemset4 value(int setter);

  /**
   * The number of bytes being set by the memory set.
   */
  public native @Cast("uint64_t") long bytes(); public native CUpti_ActivityMemset4 bytes(long setter);

  /**
   * The start timestamp for the memory set, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the memory set.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityMemset4 start(long setter);

  /**
   * The end timestamp for the memory set, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the memory set.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityMemset4 end(long setter);

  /**
   * The ID of the device where the memory set is occurring.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityMemset4 deviceId(int setter);

  /**
   * The ID of the context where the memory set is occurring.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityMemset4 contextId(int setter);

  /**
   * The ID of the stream where the memory set is occurring.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityMemset4 streamId(int setter);

  /**
   * The correlation ID of the memory set. Each memory set is assigned
   * a unique correlation ID that is identical to the correlation ID
   * in the driver API activity record that launched the memory set.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMemset4 correlationId(int setter);

  /**
   * The flags associated with the memset. @see CUpti_ActivityFlag
   */
  public native @Cast("uint16_t") short flags(); public native CUpti_ActivityMemset4 flags(short setter);

  /**
   * The memory kind of the memory set @see CUpti_ActivityMemoryKind
   */
  public native @Cast("uint16_t") short memoryKind(); public native CUpti_ActivityMemset4 memoryKind(short setter);

// #ifdef CUPTILP64
  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityMemset4 pad(int setter);
// #endif

  /**
   * Undefined. Reserved for internal use.
   */
  public native Pointer reserved0(); public native CUpti_ActivityMemset4 reserved0(Pointer setter);

  /**
   * The unique ID of the graph node that executed this memset through graph launch.
   * This field will be 0 if the memset is not executed through graph launch.
   */
  public native @Cast("uint64_t") long graphNodeId(); public native CUpti_ActivityMemset4 graphNodeId(long setter);

  /**
   * The unique ID of the graph that executed this memset through graph launch.
   * This field will be 0 if the memset is not executed through graph launch.
   */
  public native @Cast("uint32_t") int graphId(); public native CUpti_ActivityMemset4 graphId(int setter);

  /**
   * The ID of the HW channel on which the memory set is occurring.
   */
  public native @Cast("uint32_t") int channelID(); public native CUpti_ActivityMemset4 channelID(int setter);

  /**
   * The type of the channel
   */
  public native @Cast("CUpti_ChannelType") int channelType(); public native CUpti_ActivityMemset4 channelType(int setter);

  /**
   *  Undefined. Reserved for internal use
   */
  public native @Cast("uint32_t") int pad2(); public native CUpti_ActivityMemset4 pad2(int setter);
}
