// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a CUDA module.
 *
 * This activity record represents a CUDA module
 * (CUPTI_ACTIVITY_KIND_MODULE). This activity record kind is not
 * produced by the activity API but is included for completeness and
 * ease-of-use. Profile frameworks built on top of CUPTI that collect
 * module data from the module callback may choose to use this type to
 * store the collected module data.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityModule extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityModule() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityModule(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityModule(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityModule position(long position) {
        return (CUpti_ActivityModule)super.position(position);
    }
    @Override public CUpti_ActivityModule getPointer(long i) {
        return new CUpti_ActivityModule((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MODULE.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityModule kind(int setter);

  /**
   * The ID of the context where the module is loaded.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityModule contextId(int setter);

  /**
   * The module ID.
   */
  public native @Cast("uint32_t") int id(); public native CUpti_ActivityModule id(int setter);

  /**
   * The cubin size.
   */
  public native @Cast("uint32_t") int cubinSize(); public native CUpti_ActivityModule cubinSize(int setter);

// #ifndef CUPTILP64
// #endif

  /**
   * The pointer to cubin.
   */
  public native @Const Pointer cubin(); public native CUpti_ActivityModule cubin(Pointer setter);
}
