// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for PC sampling.
 *
 * This activity records information obtained by sampling PC
 * (CUPTI_ACTIVITY_KIND_PC_SAMPLING).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityPCSampling3 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityPCSampling3() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityPCSampling3(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityPCSampling3(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityPCSampling3 position(long position) {
        return (CUpti_ActivityPCSampling3)super.position(position);
    }
    @Override public CUpti_ActivityPCSampling3 getPointer(long i) {
        return new CUpti_ActivityPCSampling3((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_PC_SAMPLING.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityPCSampling3 kind(int setter);

  /**
   * The properties of this instruction.
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityPCSampling3 flags(int setter);

  /**
   * The ID for source locator.
   */
  public native @Cast("uint32_t") int sourceLocatorId(); public native CUpti_ActivityPCSampling3 sourceLocatorId(int setter);

  /**
   * The correlation ID of the kernel to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityPCSampling3 correlationId(int setter);

  /**
  * Correlation ID with global/device function name
  */
  public native @Cast("uint32_t") int functionId(); public native CUpti_ActivityPCSampling3 functionId(int setter);

  /**
   * Number of times the PC was sampled with the stallReason in the record.
   * These samples indicate that no instruction was issued in that cycle from
   * the warp scheduler from where the warp was sampled.
   * Field is valid for devices with compute capability 6.0 and higher
   */
  public native @Cast("uint32_t") int latencySamples(); public native CUpti_ActivityPCSampling3 latencySamples(int setter);

  /**
   * Number of times the PC was sampled with the stallReason in the record.
   * The same PC can be sampled with different stall reasons. The count includes
   * latencySamples.
   */
  public native @Cast("uint32_t") int samples(); public native CUpti_ActivityPCSampling3 samples(int setter);

  /**
   * Current stall reason. Includes one of the reasons from
   * \ref CUpti_ActivityPCSamplingStallReason
   */
  public native @Cast("CUpti_ActivityPCSamplingStallReason") int stallReason(); public native CUpti_ActivityPCSampling3 stallReason(int setter);

  /**
   * The pc offset for the instruction.
   */
  public native @Cast("uint64_t") long pcOffset(); public native CUpti_ActivityPCSampling3 pcOffset(long setter);
}
