// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for synchronization management.
 *
 * This activity is used to track various CUDA synchronization APIs.
 * (CUPTI_ACTIVITY_KIND_SYNCHRONIZATION).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivitySynchronization extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivitySynchronization() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivitySynchronization(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivitySynchronization(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivitySynchronization position(long position) {
        return (CUpti_ActivitySynchronization)super.position(position);
    }
    @Override public CUpti_ActivitySynchronization getPointer(long i) {
        return new CUpti_ActivitySynchronization((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_SYNCHRONIZATION.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivitySynchronization kind(int setter);

  /**
   * The type of record.
   */
  public native @Cast("CUpti_ActivitySynchronizationType") int type(); public native CUpti_ActivitySynchronization type(int setter);

  /**
   * The start timestamp for the function, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the function.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivitySynchronization start(long setter);

  /**
   * The end timestamp for the function, in ns. A value of 0 for both
   * the start and end timestamps indicates that timestamp information
   * could not be collected for the function.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivitySynchronization end(long setter);

  /**
   * The correlation ID of the API to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivitySynchronization correlationId(int setter);

  /**
   * The ID of the context for which the synchronization API is called.
   * In case of context synchronization API it is the context id for which the API is called.
   * In case of stream/event synchronization it is the ID of the context where the stream/event was created.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivitySynchronization contextId(int setter);

  /**
   * The compute stream for which the synchronization API is called.
   * A CUPTI_SYNCHRONIZATION_INVALID_VALUE value indicate the field is not applicable for this record.
   * Not valid for cuCtxSynchronize, cuEventSynchronize.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivitySynchronization streamId(int setter);

  /**
   * The event ID for which the synchronization API is called.
   * A CUPTI_SYNCHRONIZATION_INVALID_VALUE value indicate the field is not applicable for this record.
   * Not valid for cuCtxSynchronize, cuStreamSynchronize.
   */
  public native @Cast("uint32_t") int cudaEventId(); public native CUpti_ActivitySynchronization cudaEventId(int setter);
}
