// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Function type for callback used by CUPTI to return a buffer
 * of activity records.
 *
 * This callback function returns to the CUPTI client a buffer
 * containing activity records.  The buffer contains \p validSize
 * bytes of activity records which should be read using
 * cuptiActivityGetNextRecord. The number of dropped records can be
 * read using cuptiActivityGetNumDroppedRecords. After this call CUPTI
 * relinquished ownership of the buffer and will not use it
 * anymore. The client may return the buffer to CUPTI using the
 * CUpti_BuffersCallbackRequestFunc callback.
 * Note: CUDA 6.0 onwards, all buffers returned by this callback are
 * global buffers i.e. there is no context/stream specific buffer.
 * User needs to parse the global buffer to extract the context/stream
 * specific activity records.
 *
 * @param context The context this buffer is associated with. If NULL, the
 * buffer is associated with the global activities. This field is deprecated
 * as of CUDA 6.0 and will always be NULL.
 * @param streamId The stream id this buffer is associated with.
 * This field is deprecated as of CUDA 6.0 and will always be NULL.
 * @param buffer The activity record buffer.
 * @param size The total size of the buffer in bytes as set in
 * CUpti_BuffersCallbackRequestFunc.
 * @param validSize The number of valid bytes in the buffer.
 */
@Convention("CUPTIAPI") @Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_BuffersCallbackCompleteFunc extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    CUpti_BuffersCallbackCompleteFunc(Pointer p) { super(p); }
    protected CUpti_BuffersCallbackCompleteFunc() { allocate(); }
    private native void allocate();
    public native void call(
    CUctx_st context,
    @Cast("uint32_t") int streamId,
    @Cast("uint8_t*") BytePointer buffer,
    @Cast("size_t") long size,
    @Cast("size_t") long validSize);
}
