// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;



/**
 * \brief A set of event groups.
 *
 * A set of event groups. When returned by \ref
 * cuptiEventGroupSetsCreate and \ref cuptiMetricCreateEventGroupSets
 * a set indicates that event groups that can be enabled at the same
 * time (i.e. all the events in the set can be collected
 * simultaneously).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_EventGroupSet extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_EventGroupSet() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_EventGroupSet(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_EventGroupSet(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_EventGroupSet position(long position) {
        return (CUpti_EventGroupSet)super.position(position);
    }
    @Override public CUpti_EventGroupSet getPointer(long i) {
        return new CUpti_EventGroupSet((Pointer)this).offsetAddress(i);
    }

  /**
   * The number of event groups in the set.
   */
  public native @Cast("uint32_t") int numEventGroups(); public native CUpti_EventGroupSet numEventGroups(int setter);
  /**
   * An array of \p numEventGroups event groups.
   */
  public native @ByPtrPtr CUpti_EventGroup eventGroups(); public native CUpti_EventGroupSet eventGroups(CUpti_EventGroup setter);
}
