// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief A metric value.
 *
 * Metric values can be one of several different kinds. Corresponding
 * to each kind is a member of the CUpti_MetricValue union. The metric
 * value returned by \ref cuptiMetricGetValue should be accessed using
 * the appropriate member of that union based on its value kind.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_MetricValue extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_MetricValue() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_MetricValue(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_MetricValue(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_MetricValue position(long position) {
        return (CUpti_MetricValue)super.position(position);
    }
    @Override public CUpti_MetricValue getPointer(long i) {
        return new CUpti_MetricValue((Pointer)this).offsetAddress(i);
    }

  /*
   * Value for CUPTI_METRIC_VALUE_KIND_DOUBLE.
   */
  public native double metricValueDouble(); public native CUpti_MetricValue metricValueDouble(double setter);
  /*
   * Value for CUPTI_METRIC_VALUE_KIND_UINT64.
   */
  public native @Cast("uint64_t") long metricValueUint64(); public native CUpti_MetricValue metricValueUint64(long setter);
  /*
   * Value for CUPTI_METRIC_VALUE_KIND_INT64.
   */
  public native @Cast("int64_t") long metricValueInt64(); public native CUpti_MetricValue metricValueInt64(long setter);
  /*
   * Value for CUPTI_METRIC_VALUE_KIND_PERCENT. For example, 57.5% is
   * represented by the value 57.5.
   */
  public native double metricValuePercent(); public native CUpti_MetricValue metricValuePercent(double setter);
  /*
   * Value for CUPTI_METRIC_VALUE_KIND_THROUGHPUT.  The unit for
   * throughput values is bytes/second.
   */
  public native @Cast("uint64_t") long metricValueThroughput(); public native CUpti_MetricValue metricValueThroughput(long setter);
  /*
   * Value for CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL.
   */
  public native @Cast("CUpti_MetricValueUtilizationLevel") int metricValueUtilizationLevel(); public native CUpti_MetricValue metricValueUtilizationLevel(int setter);
}
