// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;



/**
 * \brief Module data passed into a resource callback function.
 *
 * CUDA module data passed into a resource callback function as the \p cbdata
 * argument to \ref CUpti_CallbackFunc. The \p cbdata will be this
 * type for \p domain equal to CUPTI_CB_DOMAIN_RESOURCE. The module
 * data is valid only within the invocation of the callback function
 * that is passed the data. If you need to retain some data for use
 * outside of the callback, you must make a copy of that data.
 */

@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ModuleResourceData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ModuleResourceData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ModuleResourceData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ModuleResourceData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ModuleResourceData position(long position) {
        return (CUpti_ModuleResourceData)super.position(position);
    }
    @Override public CUpti_ModuleResourceData getPointer(long i) {
        return new CUpti_ModuleResourceData((Pointer)this).offsetAddress(i);
    }

  /**
   * Identifier to associate with the CUDA module.
   */
    public native @Cast("uint32_t") int moduleId(); public native CUpti_ModuleResourceData moduleId(int setter);

  /**
   * The size of the cubin.
   */
    public native @Cast("size_t") long cubinSize(); public native CUpti_ModuleResourceData cubinSize(long setter);

  /**
   * Pointer to the associated cubin.
   */
    public native @Cast("const char*") BytePointer pCubin(); public native CUpti_ModuleResourceData pCubin(BytePointer setter);
}
