// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Data passed into a State callback function.
 *
 * Data passed into a State callback function as the \p cbdata argument
 * to \ref CUpti_CallbackFunc. The \p cbdata will be this type for \p
 * domain equal to CUPTI_CB_DOMAIN_STATE and callback Ids belonging to CUpti_CallbackIdState. 
 * Unless otherwise noted, the callback data is valid only within the invocation of the callback
 * function that is passed the data. If you need to retain some data
 * for use outside of the callback, you must make a copy of that data.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_StateData extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_StateData() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_StateData(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_StateData(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_StateData position(long position) {
        return (CUpti_StateData)super.position(position);
    }
    @Override public CUpti_StateData getPointer(long i) {
        return new CUpti_StateData((Pointer)this).offsetAddress(i);
    }

    /**
     * Data passed along with the callback Ids 
     * Enum CUpti_CallbackIdState used to denote callback ids
     */
      /**
       * Error code
       */
      @Name("notification.result") public native @Cast("CUptiResult") int notification_result(); public native CUpti_StateData notification_result(int setter);
      /**
       * String containing more details. It can be NULL.
       */
      @Name("notification.message") public native @Cast("const char*") BytePointer notification_message(); public native CUpti_StateData notification_message(BytePointer setter);
}
