// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cupti.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class cupti extends org.bytedeco.cuda.presets.cupti {
    static { Loader.load(); }

// Parsed from cupti_result.h

/*
 * Copyright 2010-2021 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(_CUPTI_RESULT_H_)
// #define _CUPTI_RESULT_H_

// #ifndef CUPTIAPI
// #ifdef _WIN32
// #define CUPTIAPI __stdcall
// #else
// #define CUPTIAPI
// #endif
// #endif

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/**
 * \defgroup CUPTI_RESULT_API CUPTI Result Codes
 * Error and result codes returned by CUPTI functions.
 * \{
 */

/**
 * \brief CUPTI result codes.
 *
 * Error and result codes returned by CUPTI functions.
 */
/** enum CUptiResult */
public static final int
    /**
     * No error.
     */
    CUPTI_SUCCESS                                       = 0,
    /**
     * One or more of the parameters is invalid.
     */
    CUPTI_ERROR_INVALID_PARAMETER                       = 1,
    /**
     * The device does not correspond to a valid CUDA device.
     */
    CUPTI_ERROR_INVALID_DEVICE                          = 2,
    /**
     * The context is NULL or not valid.
     */
    CUPTI_ERROR_INVALID_CONTEXT                         = 3,
    /**
     * The event domain id is invalid.
     */
    CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID                 = 4,
    /**
     * The event id is invalid.
     */
    CUPTI_ERROR_INVALID_EVENT_ID                        = 5,
    /**
     * The event name is invalid.
     */
    CUPTI_ERROR_INVALID_EVENT_NAME                      = 6,
    /**
     * The current operation cannot be performed due to dependency on
     * other factors.
     */
    CUPTI_ERROR_INVALID_OPERATION                       = 7,
    /**
     * Unable to allocate enough memory to perform the requested
     * operation.
     */
    CUPTI_ERROR_OUT_OF_MEMORY                           = 8,
    /**
     * An error occurred on the performance monitoring hardware.
     */
    CUPTI_ERROR_HARDWARE                                = 9,
    /**
     * The output buffer size is not sufficient to return all
     * requested data.
     */
    CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT           = 10,
    /**
     * API is not implemented.
     */
    CUPTI_ERROR_API_NOT_IMPLEMENTED                     = 11,
    /**
     * The maximum limit is reached.
     */
    CUPTI_ERROR_MAX_LIMIT_REACHED                       = 12,
    /**
     * The object is not yet ready to perform the requested operation.
     */
    CUPTI_ERROR_NOT_READY                               = 13,
    /**
     * The current operation is not compatible with the current state
     * of the object
     */
    CUPTI_ERROR_NOT_COMPATIBLE                          = 14,
    /**
     * CUPTI is unable to initialize its connection to the CUDA
     * driver.
     */
    CUPTI_ERROR_NOT_INITIALIZED                         = 15,
    /**
     * The metric id is invalid.
     */
    CUPTI_ERROR_INVALID_METRIC_ID                        = 16,
    /**
     * The metric name is invalid.
     */
    CUPTI_ERROR_INVALID_METRIC_NAME                      = 17,
    /**
     * The queue is empty.
     */
    CUPTI_ERROR_QUEUE_EMPTY                              = 18,
    /**
     * Invalid handle (internal?).
     */
    CUPTI_ERROR_INVALID_HANDLE                           = 19,
    /**
     * Invalid stream.
     */
    CUPTI_ERROR_INVALID_STREAM                           = 20,
    /**
     * Invalid kind.
     */
    CUPTI_ERROR_INVALID_KIND                             = 21,
    /**
     * Invalid event value.
     */
    CUPTI_ERROR_INVALID_EVENT_VALUE                      = 22,
    /**
     * CUPTI is disabled due to conflicts with other enabled profilers
     */
    CUPTI_ERROR_DISABLED                                 = 23,
    /**
     * Invalid module.
     */
    CUPTI_ERROR_INVALID_MODULE                           = 24,
    /**
     * Invalid metric value.
     */
    CUPTI_ERROR_INVALID_METRIC_VALUE                     = 25,
    /**
     * The performance monitoring hardware is in use by other client.
     */
    CUPTI_ERROR_HARDWARE_BUSY                            = 26,
    /**
     * The attempted operation is not supported on the current
     * system or device.
     */
    CUPTI_ERROR_NOT_SUPPORTED                            = 27,
    /**
     * Unified memory profiling is not supported on the system.
     * Potential reason could be unsupported OS or architecture.
     */
    CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED               = 28,
    /**
     * Unified memory profiling is not supported on the device
     */
    CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_DEVICE     = 29,
    /**
     * Unified memory profiling is not supported on a multi-GPU
     * configuration without P2P support between any pair of devices
     */
    CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_NON_P2P_DEVICES = 30,
    /**
     * Unified memory profiling is not supported under the
     * Multi-Process Service (MPS) environment. CUDA 7.5 removes this
     * restriction.
     */
    CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_WITH_MPS      = 31,
    /**
     * In CUDA 9.0, devices with compute capability 7.0 don't
     * support CDP tracing
     */
    CUPTI_ERROR_CDP_TRACING_NOT_SUPPORTED                = 32,
    /**
     * Profiling on virtualized GPU is not supported.
     */
    CUPTI_ERROR_VIRTUALIZED_DEVICE_NOT_SUPPORTED         = 33,
    /**
     * Profiling results might be incorrect for CUDA applications
     * compiled with nvcc version older than 9.0 for devices with
     * compute capability 6.0 and 6.1.
     * Profiling session will continue and CUPTI will notify it using this error code.
     * User is advised to recompile the application code with nvcc version 9.0 or later.
     * Ignore this warning if code is already compiled with the recommended nvcc version.
     */
    CUPTI_ERROR_CUDA_COMPILER_NOT_COMPATIBLE             = 34,
    /**
     * User doesn't have sufficient privileges which are required to
     * start the profiling session.
     * One possible reason for this may be that the NVIDIA driver or your system
     * administrator may have restricted access to the NVIDIA GPU performance counters.
     * To learn how to resolve this issue and find more information, please visit
     * https://developer.nvidia.com/CUPTI_ERROR_INSUFFICIENT_PRIVILEGES
     */
    CUPTI_ERROR_INSUFFICIENT_PRIVILEGES                  = 35,
    /**
     * Legacy CUPTI Profiling API i.e. event API from the header cupti_events.h and
     * metric API from the header cupti_metrics.h are not compatible with the
     * Profiling API in the header cupti_profiler_target.h and Perfworks metrics API
     * in the headers nvperf_host.h and nvperf_target.h.
     */
    CUPTI_ERROR_OLD_PROFILER_API_INITIALIZED             = 36,
    /**
     * Missing definition of the OpenACC API routine in the linked OpenACC library.
     *
     * One possible reason is that OpenACC library is linked statically in the
     * user application, which might not have the definition of all the OpenACC
     * API routines needed for the OpenACC profiling, as compiler might ignore
     * definitions for the functions not used in the application. This issue
     * can be mitigated by linking the OpenACC library dynamically.
     */
    CUPTI_ERROR_OPENACC_UNDEFINED_ROUTINE                = 37,
    /**
     * Legacy CUPTI Profiling API i.e. event API from the header cupti_events.h and
     * metric API from the header cupti_metrics.h are not supported on devices with
     * compute capability 7.5 and higher (i.e. Turing and later GPU architectures).
     * These API will be deprecated in a future CUDA release. These are replaced by
     * Profiling API in the header cupti_profiler_target.h and Perfworks metrics API
     * in the headers nvperf_host.h and nvperf_target.h.
     */
    CUPTI_ERROR_LEGACY_PROFILER_NOT_SUPPORTED            = 38,
    /**
     * CUPTI doesn't allow multiple callback subscribers. Only a single subscriber
     * can be registered at a time.
     * Same error code is used when application is launched using NVIDIA tools
     * like nvprof, Visual Profiler, Nsight Systems, Nsight Compute, cuda-gdb and
     * cuda-memcheck.
     */
    CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED       = 39,
    /**
     * Profiling on virtualized GPU is not allowed by hypervisor.
     */
    CUPTI_ERROR_VIRTUALIZED_DEVICE_INSUFFICIENT_PRIVILEGES = 40,
    /**
     * Profiling and tracing are not allowed when confidential computing mode
     * is enabled.
     */
    CUPTI_ERROR_CONFIDENTIAL_COMPUTING_NOT_SUPPORTED = 41,
    /**
     * CUPTI does not support NVIDIA Crypto Mining Processors (CMP).
     * For more information, please visit https://developer.nvidia.com/ERR_NVCMPGPU
    */
    CUPTI_ERROR_CMP_DEVICE_NOT_SUPPORTED = 42,
    /**
     * An unknown internal error has occurred.
     */
    CUPTI_ERROR_UNKNOWN                                  = 999,
    CUPTI_ERROR_FORCE_INT                                = 0x7fffffff;

/**
 * \brief Get the descriptive string for a CUptiResult.
 *
 * Return the descriptive string for a CUptiResult in \p *str.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param result The result to get the string for
 * @param str Returns the string
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p str is NULL or \p
 * result is not a valid CUptiResult
 */
public static native @Cast("CUptiResult") int cuptiGetResultString(@Cast("CUptiResult") int result, @Cast("const char**") PointerPointer str);
public static native @Cast("CUptiResult") int cuptiGetResultString(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr BytePointer str);
public static native @Cast("CUptiResult") int cuptiGetResultString(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr ByteBuffer str);
public static native @Cast("CUptiResult") int cuptiGetResultString(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr byte[] str);

/**
 * \brief Get the descriptive message corresponding to error codes returned
 * by CUPTI.
 * 
 * Return the descriptive error message for a CUptiResult in \p *str.
 * \note \b Thread-safety: this function is thread safe.
 * 
 * @param result The result to get the descriptive error message for
 * @param str Returns the error message string
 * 
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p str is NULL or \p
 * result is not a valid CUptiResult
 * 
 */

public static native @Cast("CUptiResult") int cuptiGetErrorMessage(@Cast("CUptiResult") int result, @Cast("const char**") PointerPointer str);
public static native @Cast("CUptiResult") int cuptiGetErrorMessage(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr BytePointer str);
public static native @Cast("CUptiResult") int cuptiGetErrorMessage(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr ByteBuffer str);
public static native @Cast("CUptiResult") int cuptiGetErrorMessage(@Cast("CUptiResult") int result, @Cast("const char**") @ByPtrPtr byte[] str);

/** \} */ /* END CUPTI_RESULT_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// #endif /*_CUPTI_RESULT_H_*/




// Parsed from cupti_version.h

/*
 * Copyright 2010-2024 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(_CUPTI_VERSION_H_)
// #define _CUPTI_VERSION_H_

// #include <cuda_stdint.h>
// #include <cupti_result.h>

// #ifndef CUPTIAPI
// #ifdef _WIN32
// #define CUPTIAPI __stdcall
// #else
// #define CUPTIAPI
// #endif
// #endif

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/**
 * \defgroup CUPTI_VERSION_API CUPTI Version
 * Function and macro to determine the CUPTI version.
 * \{
 */

/**
 * \brief The API version for this implementation of CUPTI.
 *
 * The API version for this implementation of CUPTI. This define along
 * with \ref cuptiGetVersion can be used to dynamically detect if the
 * version of CUPTI compiled against matches the version of the loaded
 * CUPTI library.
 *
 * v1 : CUDAToolsSDK 4.0
 * v2 : CUDAToolsSDK 4.1
 * v3 : CUDA Toolkit 5.0
 * v4 : CUDA Toolkit 5.5
 * v5 : CUDA Toolkit 6.0
 * v6 : CUDA Toolkit 6.5
 * v7 : CUDA Toolkit 6.5(with sm_52 support)
 * v8 : CUDA Toolkit 7.0
 * v9 : CUDA Toolkit 8.0
 * v10 : CUDA Toolkit 9.0
 * v11 : CUDA Toolkit 9.1
 * v12 : CUDA Toolkit 10.0, 10.1 and 10.2
 * v13 : CUDA Toolkit 11.0
 * v14 : CUDA Toolkit 11.1
 * v15 : CUDA Toolkit 11.2, 11.3 and 11.4
 * v16 : CUDA Toolkit 11.5
 * v17 : CUDA Toolkit 11.6
 * v18 : CUDA Toolkit 11.8
 * v19 : CUDA Toolkit 12.0
 * v20 : CUDA Toolkit 12.2
 * v21 : CUDA Toolkit 12.3
 * v22 : CUDA Toolkit 12.4
 * v23 : CUDA Toolkit 12.5
 * v24 : CUDA Toolkit 12.6
 */
public static final int CUPTI_API_VERSION = 24;

/**
 * \brief Get the CUPTI API version.
 *
 * Return the API version in \p *version.
 *
 * @param version Returns the version
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p version is NULL
 * @see CUPTI_API_VERSION
 */
public static native @Cast("CUptiResult") int cuptiGetVersion(@Cast("uint32_t*") IntPointer version);
public static native @Cast("CUptiResult") int cuptiGetVersion(@Cast("uint32_t*") IntBuffer version);
public static native @Cast("CUptiResult") int cuptiGetVersion(@Cast("uint32_t*") int[] version);

/** \} */ /* END CUPTI_VERSION_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// #endif /*_CUPTI_VERSION_H_*/


// Parsed from cupti_activity.h

/*
 * Copyright 2011-2024 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(_CUPTI_ACTIVITY_H_)
// #define _CUPTI_ACTIVITY_H_

/**
 * Deprecated APIs and structures have been moved to the
 * header :doc: {@code cupti_activity_deprecated.h}, which is included at
 * the bottom of this file. Header cupti_activity.h contains
 * only the latest version of APIs and structures.
 */

// #include <cuda.h>
// #include <cupti_callbacks.h>
// #include <cupti_events.h>
// #include <cupti_metrics.h>
// #include <cupti_result.h>

// #if defined(CUPTI_DIRECTIVE_SUPPORT)
// #include <Openacc/cupti_openacc.h>
// #include <Openmp/cupti_openmp.h>
// #endif

// #include <cupti_common.h>

public static final int CUPTI_UNIFIED_MEMORY_CPU_DEVICE_ID = ((int) 0xFFFFFFFF);
public static final int CUPTI_INVALID_CONTEXT_ID = ((int) 0xFFFFFFFF);
public static final int CUPTI_INVALID_STREAM_ID = ((int) 0xFFFFFFFF);
public static final int CUPTI_INVALID_CHANNEL_ID = ((int) 0xFFFFFFFF);

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

public static final int invalidNumaId = ((int) 0xFFFFFFFF);

/**
 * \defgroup CUPTI_ACTIVITY_API CUPTI Activity API
 * Functions, types, and enums that implement the CUPTI Activity API.
 * \{
 */

/**
 * \brief The kinds of activity records.
 *
 * Each activity record kind represents information about a GPU or an
 * activity occurring on a CPU or GPU. Each kind is associated with a
 * activity record structure that holds the information associated
 * with the kind.
 * @see CUpti_Activity
 * @see CUpti_ActivityAPI
 * @see CUpti_ActivityContext
 * @see CUpti_ActivityContext2
 * @see CUpti_ActivityContext3
 * @see CUpti_ActivityDevice
 * @see CUpti_ActivityDevice2
 * @see CUpti_ActivityDevice3
 * @see CUpti_ActivityDevice4
 * @see CUpti_ActivityDeviceAttribute
 * @see CUpti_ActivityEvent
 * @see CUpti_ActivityEventInstance
 * @see CUpti_ActivityKernel
 * @see CUpti_ActivityKernel2
 * @see CUpti_ActivityKernel3
 * @see CUpti_ActivityKernel4
 * @see CUpti_ActivityKernel5
 * @see CUpti_ActivityKernel6
 * @see CUpti_ActivityKernel7
 * @see CUpti_ActivityKernel8
 * @see CUpti_ActivityKernel9
 * @see CUpti_ActivityCdpKernel
 * @see CUpti_ActivityPreemption
 * @see CUpti_ActivityMemcpy
 * @see CUpti_ActivityMemcpy3
 * @see CUpti_ActivityMemcpy4
 * @see CUpti_ActivityMemcpy5
 * @see CUpti_ActivityMemcpyPtoP
 * @see CUpti_ActivityMemcpyPtoP2
 * @see CUpti_ActivityMemcpyPtoP3
 * @see CUpti_ActivityMemcpyPtoP4
 * @see CUpti_ActivityMemset
 * @see CUpti_ActivityMemset2
 * @see CUpti_ActivityMemset3
 * @see CUpti_ActivityMemset4
 * @see CUpti_ActivityMemory
 * @see CUpti_ActivityMemory2
 * @see CUpti_ActivityMemory3
 * @see CUpti_ActivityMemory4
 * @see CUpti_ActivityMemoryPool
 * @see CUpti_ActivityMemoryPool2
 * @see CUpti_ActivityMetric
 * @see CUpti_ActivityMetricInstance
 * @see CUpti_ActivityName
 * @see CUpti_ActivityMarker
 * @see CUpti_ActivityMarker2
 * @see CUpti_ActivityMarkerData
 * @see CUpti_ActivitySourceLocator
 * @see CUpti_ActivityGlobalAccess
 * @see CUpti_ActivityGlobalAccess2
 * @see CUpti_ActivityGlobalAccess3
 * @see CUpti_ActivityBranch
 * @see CUpti_ActivityBranch2
 * @see CUpti_ActivityOverhead3
 * @see CUpti_ActivityEnvironment
 * @see CUpti_ActivityInstructionExecution
 * @see CUpti_ActivityUnifiedMemoryCounter
 * @see CUpti_ActivityFunction
 * @see CUpti_ActivityModule
 * @see CUpti_ActivitySharedAccess
 * @see CUpti_ActivityPCSampling
 * @see CUpti_ActivityPCSampling2
 * @see CUpti_ActivityPCSampling3
 * @see CUpti_ActivityPCSamplingRecordInfo
 * @see CUpti_ActivityCudaEvent
 * @see CUpti_ActivityStream
 * @see CUpti_ActivitySynchronization
 * @see CUpti_ActivityInstructionCorrelation
 * @see CUpti_ActivityExternalCorrelation
 * @see CUpti_ActivityUnifiedMemoryCounter2
 * @see CUpti_ActivityOpenAccData
 * @see CUpti_ActivityOpenAccLaunch
 * @see CUpti_ActivityOpenAccOther
 * @see CUpti_ActivityOpenMp
 * @see CUpti_ActivityNvLink
 * @see CUpti_ActivityNvLink2
 * @see CUpti_ActivityNvLink3
 * @see CUpti_ActivityNvLink4
 * @see CUpti_ActivityPcie
 * @see CUpti_ActivityConfidentialComputeRotation
 */

/** enum CUpti_ActivityKind */
public static final int
  /**
   * The activity record is invalid.
   */
  CUPTI_ACTIVITY_KIND_INVALID  = 0,

  /**
   * A host<->host, host<->device, or device<->device memory copy. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityMemcpy5.
   */
  CUPTI_ACTIVITY_KIND_MEMCPY   = 1,

  /**
   * A memory set executing on the GPU. The corresponding activity
   * record structure is \ref CUpti_ActivityMemset4.
   */
  CUPTI_ACTIVITY_KIND_MEMSET   = 2,

  /**
   * A kernel executing on the GPU. This activity kind may significantly change
   * the overall performance characteristics of the application because all
   * kernel executions are serialized on the GPU. Other activity kind for kernel
   * CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL doesn't break kernel concurrency.
   * The corresponding activity record structure is \ref CUpti_ActivityKernel9.
   */
  CUPTI_ACTIVITY_KIND_KERNEL   = 3,

  /**
   * A CUDA driver API function execution. The corresponding activity
   * record structure is \ref CUpti_ActivityAPI.
   */
  CUPTI_ACTIVITY_KIND_DRIVER   = 4,

  /**
   * A CUDA runtime API function execution. The corresponding activity
   * record structure is \ref CUpti_ActivityAPI.
   */
  CUPTI_ACTIVITY_KIND_RUNTIME  = 5,

  /**
   * An event value. The corresponding activity record structure is
   * \ref CUpti_ActivityEvent.
   */
  CUPTI_ACTIVITY_KIND_EVENT    = 6,

  /**
   * A metric value. The corresponding activity record structure is
   * \ref CUpti_ActivityMetric.
   */
  CUPTI_ACTIVITY_KIND_METRIC   = 7,

  /**
   * Information about a device. The corresponding activity record
   * structure is \ref CUpti_ActivityDevice5.
   */
  CUPTI_ACTIVITY_KIND_DEVICE   = 8,

  /**
   * Information about a context. The corresponding activity record
   * structure is \ref CUpti_ActivityContext3.
   */
  CUPTI_ACTIVITY_KIND_CONTEXT  = 9,

  /**
   * A kernel executing on the GPU. This activity kind doesn't break
   * kernel concurrency. The corresponding activity record structure
   * is \ref CUpti_ActivityKernel9.
   */
  CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL = 10,

  /**
   * Resource naming done via NVTX APIs for thread, device, context, etc.
   * The corresponding activity record structure is \ref CUpti_ActivityName.
   */
  CUPTI_ACTIVITY_KIND_NAME     = 11,

  /**
   * Instantaneous, start, or end NVTX marker. The corresponding activity
   * record structure is \ref CUpti_ActivityMarker2.
   */
  CUPTI_ACTIVITY_KIND_MARKER = 12,

  /**
   * Extended, optional, data about a marker. User must enable
   * CUPTI_ACTIVITY_KIND_MARKER as well to get records for marker data.
   * The corresponding activity record structure is \ref CUpti_ActivityMarkerData.
   */
  CUPTI_ACTIVITY_KIND_MARKER_DATA = 13,

  /**
   * Source information about source level result. The corresponding
   * activity record structure is \ref CUpti_ActivitySourceLocator.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR = 14,

  /**
   * Results for source-level global access. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityGlobalAccess3.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS = 15,

  /**
   * Results for source-level branch. The corresponding
   * activity record structure is \ref CUpti_ActivityBranch2.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_BRANCH = 16,

  /**
   * Overhead activity records. The
   * corresponding activity record structure is
   * \ref CUpti_ActivityOverhead3.
   */
  CUPTI_ACTIVITY_KIND_OVERHEAD = 17,

  /**
   * A CDP (CUDA Dynamic Parallel) kernel executing on the GPU. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityCdpKernel.  This activity can not be directly
   * enabled or disabled. It is enabled and disabled through
   * concurrent kernel activity i.e. _CONCURRENT_KERNEL.
   */
  CUPTI_ACTIVITY_KIND_CDP_KERNEL = 18,
  /**
   * Preemption activity record indicating a preemption of a CDP (CUDA
   * Dynamic Parallel) kernel executing on the GPU. The corresponding
   * activity record structure is \ref CUpti_ActivityPreemption.
   */
  CUPTI_ACTIVITY_KIND_PREEMPTION = 19,

  /**
   * Environment activity records indicating power, clock, thermal,
   * etc. levels of the GPU. The corresponding activity record
   * structure is \ref CUpti_ActivityEnvironment.
   */
  CUPTI_ACTIVITY_KIND_ENVIRONMENT = 20,

  /**
   * An event value associated with a specific event domain
   * instance. The corresponding activity record structure is \ref
   * CUpti_ActivityEventInstance.
   */
  CUPTI_ACTIVITY_KIND_EVENT_INSTANCE = 21,

  /**
   * A peer to peer memory copy. The corresponding activity record
   * structure is \ref CUpti_ActivityMemcpyPtoP4.
   */
  CUPTI_ACTIVITY_KIND_MEMCPY2 = 22,

  /**
   * A metric value associated with a specific metric domain
   * instance. The corresponding activity record structure is \ref
   * CUpti_ActivityMetricInstance.
   */
  CUPTI_ACTIVITY_KIND_METRIC_INSTANCE = 23,

  /**
   * Results for source-level instruction execution.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstructionExecution.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION = 24,

  /**
   * Unified Memory counter record. The corresponding activity
   * record structure is \ref CUpti_ActivityUnifiedMemoryCounter2.
   */
  CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER = 25,

  /**
   * Device global/function record. The corresponding activity
   * record structure is \ref CUpti_ActivityFunction.
   */
  CUPTI_ACTIVITY_KIND_FUNCTION = 26,

  /**
   * CUDA Module record. The corresponding activity
   * record structure is \ref CUpti_ActivityModule.
   */
  CUPTI_ACTIVITY_KIND_MODULE = 27,

  /**
   * A device attribute value. The corresponding activity record
   * structure is \ref CUpti_ActivityDeviceAttribute.
   */
  CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE   = 28,

  /**
   * Results for source-level shared access. The
   * corresponding activity record structure is \ref
   * CUpti_ActivitySharedAccess.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_SHARED_ACCESS = 29,

  /**
   * Enable PC sampling for kernels. This will serialize
   * kernels. The corresponding activity record structure
   * is \ref CUpti_ActivityPCSampling3. In CUDA 12.5, this kind
   * is deprecated for Volta and later GPU architectures in favor
   * of PC Sampling APIs from the header cupti_pcsampling.h.
   */
  CUPTI_ACTIVITY_KIND_PC_SAMPLING = 30,

  /**
   * Summary information about PC sampling records. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityPCSamplingRecordInfo. In CUDA 12.5, this kind
   * is deprecated for Volta and later GPU architectures in favor
   * of PC Sampling APIs from the header cupti_pcsampling.h.
   */
  CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO = 31,

  /**
   * SASS/Source line-by-line correlation record.
   * This will generate sass/source correlation for functions that have source
   * level analysis or pc sampling results. The records will be generated only
   * when either of source level analysis or pc sampling activity is enabled.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstructionCorrelation.
   * In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures
   * in favor of SASS Metric APIs from the header cupti_sass_metrics.h.
   */
  CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION = 32,

  /**
   * OpenACC data events.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityOpenAccData.
   */
  CUPTI_ACTIVITY_KIND_OPENACC_DATA = 33,

  /**
   * OpenACC launch events.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityOpenAccLaunch.
   */
  CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH = 34,

  /**
   * OpenACC other events.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityOpenAccOther.
   */
  CUPTI_ACTIVITY_KIND_OPENACC_OTHER = 35,

  /**
   * Information about a CUDA event. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityCudaEvent.
   */
  CUPTI_ACTIVITY_KIND_CUDA_EVENT = 36,

  /**
   * Information about a CUDA stream. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityStream.
   */
  CUPTI_ACTIVITY_KIND_STREAM = 37,

  /**
   * Records for synchronization management. The
   * corresponding activity record structure is \ref
   * CUpti_ActivitySynchronization.
   */
  CUPTI_ACTIVITY_KIND_SYNCHRONIZATION = 38,

  /**
   * Records for correlation of different programming APIs. The
   * corresponding activity record structure is \ref
   * CUpti_ActivityExternalCorrelation.
   */
  CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION = 39,

  /**
   * NVLink information.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityNvLink4.
   */
  CUPTI_ACTIVITY_KIND_NVLINK = 40,

  /**
   * Instantaneous Event information.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstantaneousEvent.
   */
  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT = 41,

  /**
   * Instantaneous Event information for a specific event
   * domain instance.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstantaneousEventInstance
   */
  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE = 42,

  /**
   * Instantaneous Metric information
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstantaneousMetric.
   */
  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC = 43,

  /**
   * Instantaneous Metric information for a specific metric
   * domain instance.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityInstantaneousMetricInstance.
   */
  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE = 44,

  /**
   * Memory activity tracking allocation and freeing of the memory
   * The corresponding activity record structure is \ref
   * CUpti_ActivityMemory.
   */
  CUPTI_ACTIVITY_KIND_MEMORY = 45,

  /**
   * PCI devices information used for PCI topology.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityPcie.
   */
  CUPTI_ACTIVITY_KIND_PCIE = 46,

  /**
   * OpenMP parallel events.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityOpenMp.
   */
  CUPTI_ACTIVITY_KIND_OPENMP = 47,

  /**
   * A CUDA driver kernel launch occurring outside of any
   * public API function execution.  Tools can handle these
   * like records for driver API launch functions, although
   * the cbid field is not used here.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityAPI.
   */
  CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API = 48,

  /**
   * Memory activity tracking allocation and freeing of the memory
   * The corresponding activity record structure is \ref
   * CUpti_ActivityMemory4.
   */
  CUPTI_ACTIVITY_KIND_MEMORY2 = 49,

  /**
   * Memory pool activity tracking creation, destruction and
   * trimming of the memory pool.
   * The corresponding activity record structure is \ref
   * CUpti_ActivityMemoryPool2.
   */
  CUPTI_ACTIVITY_KIND_MEMORY_POOL = 50,

  /**
   * The corresponding activity record structure is
   * \ref CUpti_ActivityGraphTrace2.
   */
  CUPTI_ACTIVITY_KIND_GRAPH_TRACE = 51,

  /**
   * JIT operation tracking
   * The corresponding activity record structure is \ref
   * CUpti_ActivityJit.
   */
  CUPTI_ACTIVITY_KIND_JIT = 52,



  CUPTI_ACTIVITY_KIND_COUNT = 53,

  CUPTI_ACTIVITY_KIND_FORCE_INT     = 0x7fffffff;

/**
 * \brief The kinds of activity objects.
 * @see CUpti_ActivityObjectKindId
 */
/** enum CUpti_ActivityObjectKind */
public static final int
  /**
   * The object kind is not known.
   */
  CUPTI_ACTIVITY_OBJECT_UNKNOWN  = 0,

  /**
   * A process.
   */
  CUPTI_ACTIVITY_OBJECT_PROCESS  = 1,

  /**
   * A thread.
   */
  CUPTI_ACTIVITY_OBJECT_THREAD   = 2,

  /**
   * A device.
   */
  CUPTI_ACTIVITY_OBJECT_DEVICE   = 3,

  /**
   * A context.
   */
  CUPTI_ACTIVITY_OBJECT_CONTEXT  = 4,

  /**
   * A stream.
   */
  CUPTI_ACTIVITY_OBJECT_STREAM   = 5,

  CUPTI_ACTIVITY_OBJECT_FORCE_INT = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityObjectKindId.java


// Targeting ..\cupti\CUpti_ActivityOverheadCommandBufferFullData.java



/**
 * \brief The kinds of activity overhead.
 */
/** enum CUpti_ActivityOverheadKind */
public static final int
  /**
   * The overhead kind is not known.
   */
  CUPTI_ACTIVITY_OVERHEAD_UNKNOWN               = 0,

  /**
   * Compiler overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER       = 1,

  /**
   * Activity buffer flush overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH               = 1<<16,

  /**
   * CUPTI instrumentation overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION            = 2<<16,

  /**
   * CUPTI resource creation and destruction overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE                   = 3<<16,

  /**
   * CUDA Runtime triggered module loading overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING = 4<<16,

  /**
   * Lazy function loading overhead.
   */
  CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING            = 5<<16,

  /**
   * Overhead due to lack of command buffer space.
   * Refer CUpti_ActivityOverheadCommandBufferFullData for more details.
   */
  CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL              = 6<<16,
  
  /**
   * Overhead due to activity buffer request.
   */
  CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST          = 7<<16,

  CUPTI_ACTIVITY_OVERHEAD_FORCE_INT             = 0x7fffffff;

/**
 * \brief The kind of a compute API.
 */
/** enum CUpti_ActivityComputeApiKind */
public static final int
  /**
   * The compute API is not known.
   */
  CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN    = 0,

  /**
   * The compute APIs are for CUDA.
   */
  CUPTI_ACTIVITY_COMPUTE_API_CUDA       = 1,

  /**
   * The compute APIs are for CUDA running
   * in MPS (Multi-Process Service) environment.
   */
  CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS   = 2,

  CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT  = 0x7fffffff;

/**
 * \brief Flags associated with activity records.
 *
 * Activity record flags. Flags can be combined by bitwise OR to
 * associated multiple flags with an activity record. Each flag is
 * specific to a certain activity kind, as noted below.
 */
/** enum CUpti_ActivityFlag */
public static final int
  /**
   * Indicates the activity record has no flags.
   */
  CUPTI_ACTIVITY_FLAG_NONE          = 0,

  /**
   * Indicates the activity represents a device that supports
   * concurrent kernel execution. Valid for
   * CUPTI_ACTIVITY_KIND_DEVICE.
   */
  CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS  = 1 << 0,

  /**
   * Indicates if the activity represents a CUdevice_attribute value
   * or a CUpti_DeviceAttribute value. Valid for
   * CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE.
   */
  CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE  = 1 << 0,

  /**
   * Indicates the activity represents an asynchronous memcpy
   * operation. Valid for CUPTI_ACTIVITY_KIND_MEMCPY.
   */
  CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC  = 1 << 0,

  /**
   * Indicates the activity represents an instantaneous marker. Valid
   * for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS  = 1 << 0,

  /**
   * Indicates the activity represents a region start marker. Valid
   * for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_START  = 1 << 1,

  /**
   * Indicates the activity represents a region end marker. Valid for
   * CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_END  = 1 << 2,

  /**
   * Indicates the activity represents an attempt to acquire a user
   * defined synchronization object.
   * Valid for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE = 1 << 3,

  /**
   * Indicates the activity represents success in acquiring the
   * user defined synchronization object.
   * Valid for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS = 1 << 4,

  /**
   * Indicates the activity represents failure in acquiring the
   * user defined synchronization object.
   * Valid for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED = 1 << 5,

  /**
   * Indicates the activity represents releasing a reservation on
   * user defined synchronization object.
   * Valid for CUPTI_ACTIVITY_KIND_MARKER.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE = 1 << 6,

  /**
   * Indicates the activity represents a marker that does not specify
   * a color. Valid for CUPTI_ACTIVITY_KIND_MARKER_DATA.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE  = 1 << 0,

  /**
   * Indicates the activity represents a marker that specifies a color
   * in alpha-red-green-blue format. Valid for
   * CUPTI_ACTIVITY_KIND_MARKER_DATA.
   */
  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB  = 1 << 1,

  /**
   * The number of bytes requested by each thread
   * Valid for CUpti_ActivityGlobalAccess3.
   */
  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK  = 0xFF << 0,

  /**
   * If bit in this flag is set, the access was load, else it is a
   * store access. Valid for CUpti_ActivityGlobalAccess3.
   */
  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD       = 1 << 8,

  /**
   * If this bit in flag is set, the load access was cached else it is
   * uncached. Valid for CUpti_ActivityGlobalAccess3.
   */
  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED     = 1 << 9,

  /**
   * If this bit in flag is set, the metric value overflowed. Valid
   * for CUpti_ActivityMetric and CUpti_ActivityMetricInstance.
   */
  CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED     = 1 << 0,

  /**
   * If this bit in flag is set, the metric value couldn't be
   * calculated. This occurs when a value(s) required to calculate the
   * metric is missing.  Valid for CUpti_ActivityMetric and
   * CUpti_ActivityMetricInstance.
   */
  CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID  = 1 << 1,

  /**
   * If this bit in flag is set, the source level metric value couldn't be
   * calculated. This occurs when a value(s) required to calculate the
   * source level metric cannot be evaluated.
   * Valid for CUpti_ActivityInstructionExecution.
   */
  CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID  = 1 << 0,

  /**
   * The mask for the instruction class, \ref CUpti_ActivityInstructionClass
   * Valid for CUpti_ActivityInstructionExecution and
   * CUpti_ActivityInstructionCorrelation
   */
  CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK    = 0xFF << 1,

  /**
   * When calling cuptiActivityFlushAll, this flag
   * can be set to force CUPTI to flush all records in the buffer, whether
   * finished or not
   */
  CUPTI_ACTIVITY_FLAG_FLUSH_FORCED = 1 << 0,

  /**
   * The number of bytes requested by each thread
   * Valid for CUpti_ActivitySharedAccess.
   */
  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK  = 0xFF << 0,

  /**
   * If bit in this flag is set, the access was load, else it is a
   * store access.  Valid for CUpti_ActivitySharedAccess.
   */
  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD       = 1 << 8,

  /**
   * Indicates the activity represents an asynchronous memset
   * operation. Valid for CUPTI_ACTIVITY_KIND_MEMSET.
   */
  CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC  = 1 << 0,

  /**
   * Indicates the activity represents thrashing in CPU.
   * Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING in
   * CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER
   */
  CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU = 1 << 0,

  /**
   * Indicates the activity represents page throttling in CPU.
   * Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING in
   * CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER
   */
  CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU = 1 << 0,

  CUPTI_ACTIVITY_FLAG_FORCE_INT = 0x7fffffff;

/**
 * \brief The stall reason for PC sampling activity.
 */
/** enum CUpti_ActivityPCSamplingStallReason */
public static final int
  /**
   * Invalid reason
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID      = 0,

  /**
   * No stall, instruction is selected for issue
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE         = 1,

  /**
   * Warp is blocked because next instruction is not yet available,
   * because of instruction cache miss, or because of branching effects
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH   = 2,

  /**
   * Instruction is waiting on an arithmetic dependency
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY   = 3,

  /**
   * Warp is blocked because it is waiting for a memory access to complete.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY   = 4,

  /**
   * Texture sub-system is fully utilized or has too many outstanding requests.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE   = 5,

  /**
   * Warp is blocked as it is waiting at __syncthreads() or at memory barrier.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC   = 6,

  /**
   * Warp is blocked waiting for __constant__ memory and immediate memory access to complete.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY   = 7,

  /**
   * Compute operation cannot be performed due to the required resources not
   * being available.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY   = 8,

  /**
   * Warp is blocked because there are too many pending memory operations.
   * In Kepler architecture it often indicates high number of memory replays.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE   = 9,

  /**
   * Warp was ready to issue, but some other warp issued instead.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED   = 10,

  /**
   * Miscellaneous reasons
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER   = 11,

  /**
   * Sleeping.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING   = 12,

  CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT  = 0x7fffffff;

/**
 * \brief Sampling period for PC sampling method
 *
 * Sampling period can be set using \ref cuptiActivityConfigurePCSampling
 */
/** enum CUpti_ActivityPCSamplingPeriod */
public static final int
  /**
   * The PC sampling period is not set.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID = 0,

  /**
   * Minimum sampling period available on the device.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN = 1,

  /**
   * Sampling period in lower range.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW = 2,

  /**
   * Medium sampling period.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID = 3,

  /**
   * Sampling period in higher range.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH = 4,

  /**
   * Maximum sampling period available on the device.
   */
  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX = 5,

  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT = 0x7fffffff;

/**
 * \brief The kind of a memory copy, indicating the source and
 * destination targets of the copy.
 *
 * Each kind represents the source and destination targets of a memory
 * copy. Targets are host, device, and array.
 */
/** enum CUpti_ActivityMemcpyKind */
public static final int
  /**
   * The memory copy kind is not known.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN = 0,

  /**
   * A host to device memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_HTOD    = 1,

  /**
   * A device to host memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_DTOH    = 2,

  /**
   * A host to device array memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_HTOA    = 3,

  /**
   * A device array to host memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_ATOH    = 4,

  /**
   * A device array to device array memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_ATOA    = 5,

  /**
   * A device array to device memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_ATOD    = 6,

  /**
   * A device to device array memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_DTOA    = 7,

  /**
   * A device to device memory copy on the same device.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_DTOD    = 8,

  /**
   * A host to host memory copy.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_HTOH    = 9,

  /**
   * A peer to peer memory copy across different devices.
   */
  CUPTI_ACTIVITY_MEMCPY_KIND_PTOP    = 10,

  CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT = 0x7fffffff;

/**
 * \brief The kinds of memory accessed by a memory operation/copy.
 *
 * Each kind represents the type of the memory
 * accessed by a memory operation/copy.
 */
/** enum CUpti_ActivityMemoryKind */
public static final int
  /**
   * The memory kind is unknown.
   */
  CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN            = 0,

  /**
   * The memory is pageable.
   */
  CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE           = 1,

  /**
   * The memory is pinned.
   */
  CUPTI_ACTIVITY_MEMORY_KIND_PINNED             = 2,

  /**
   * The memory is on the device.
   */
  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE             = 3,

  /**
   * The memory is an array.
   */
  CUPTI_ACTIVITY_MEMORY_KIND_ARRAY              = 4,

  /**
   * The memory is managed
   */
  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED            = 5,

  /**
   * The memory is device static
   */
  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC      = 6,

  /**
   * The memory is managed static
   */
  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC     = 7,

  CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT          = 0x7fffffff;

/**
 * \brief The kind of a preemption activity.
 */
/** enum CUpti_ActivityPreemptionKind */
public static final int
  /**
   * The preemption kind is not known.
   */
  CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN    = 0,

  /**
   * Preemption to save CDP block.
   */
  CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE       = 1,

  /**
   * Preemption to restore CDP block.
   */
  CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE    = 2,

  CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT  = 0x7fffffff;

/**
 * \brief The kind of environment data. Used to indicate what type of
 * data is being reported by an environment activity record.
 */
/** enum CUpti_ActivityEnvironmentKind */
public static final int
  /**
   * Unknown data.
   */
  CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN = 0,

  /**
   * The environment data is related to speed.
   */
  CUPTI_ACTIVITY_ENVIRONMENT_SPEED = 1,

  /**
   * The environment data is related to temperature.
   */
  CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE = 2,

  /**
   * The environment data is related to power.
   */
  CUPTI_ACTIVITY_ENVIRONMENT_POWER = 3,

  /**
   * The environment data is related to cooling.
   */
  CUPTI_ACTIVITY_ENVIRONMENT_COOLING = 4,

  CUPTI_ACTIVITY_ENVIRONMENT_COUNT = 5,

  CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT    = 0x7fffffff;

/**
 * \brief Reasons for clock throttling.
 *
 * The possible reasons that a clock can be throttled. There can be
 * more than one reason that a clock is being throttled so these types
 * can be combined by bitwise OR.  These are used in the
 * clocksThrottleReason field in the Environment Activity Record.
 */
/** enum CUpti_EnvironmentClocksThrottleReason */
public static final int
  /**
   * Nothing is running on the GPU and the clocks are dropping to idle
   * state.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE              = 0x00000001,

  /**
   * The GPU clocks are limited by a user specified limit.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS   = 0x00000002,

  /**
   * A software power scaling algorithm is reducing the clocks below
   * requested clocks.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP          = 0x00000004,

  /**
   * Hardware slowdown to reduce the clock by a factor of two or more
   * is engaged.  This is an indicator of one of the following: 1)
   * Temperature is too high, 2) External power brake assertion is
   * being triggered (e.g. by the system power supply), 3) Change in
   * power state.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN           = 0x00000008,

  /**
   * Some unspecified factor is reducing the clocks.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN               = 0x80000000,

  /**
   * Throttle reason is not supported for this GPU.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED           = 0x40000000,

  /**
   * No clock throttling.
   */
  CUPTI_CLOCKS_THROTTLE_REASON_NONE                  = 0x00000000,

  CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT             = 0x7fffffff;

/**
 * \brief Scope of the unified memory counter (deprecated in CUDA 7.0)
 */
/** enum CUpti_ActivityUnifiedMemoryCounterScope */
public static final int
  /**
   * The unified memory counter scope is not known.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN = 0,

  /**
   * Collect unified memory counter for single process on one device
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE = 1,

  /**
   * Collect unified memory counter for single process across all devices
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES = 2,

  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT = 3,

  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT = 0x7fffffff;

/**
 * \brief Kind of the Unified Memory counter
 *
 * Many activities are associated with Unified Memory mechanism; among them
 * are transfers from host to device, device to host, page fault at
 * host side.
 */
/** enum CUpti_ActivityUnifiedMemoryCounterKind */
public static final int
  /**
   * The unified memory counter kind is not known.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN = 0,

  /**
   * Number of bytes transferred from host to device
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD = 1,

  /**
   * Number of bytes transferred from device to host
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH = 2,

  /**
   * Number of CPU page faults, this is only supported on 64 bit
   * Linux and Mac platforms
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT = 3,

  /**
   * Number of GPU page faults, this is only supported on devices with
   * compute capability 6.0 and higher and 64 bit Linux platforms
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT = 4,

  /**
   * Thrashing occurs when data is frequently accessed by
   * multiple processors and has to be constantly migrated around
   * to achieve data locality. In this case the overhead of migration
   * may exceed the benefits of locality.
   * This is only supported on 64 bit Linux platforms.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING = 5,

  /**
   * Throttling is a prevention technique used by the driver to avoid
   * further thrashing. Here, the driver doesn't service the fault for
   * one of the contending processors for a specific period of time,
   * so that the other processor can run at full-speed.
   * This is only supported on 64 bit Linux platforms.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING = 6,

  /**
   * In case throttling does not help, the driver tries to pin the memory
   * to a processor for a specific period of time. One of the contending
   * processors will have slow  access to the memory, while the other will
   * have fast access.
   * This is only supported on 64 bit Linux platforms.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP = 7,

  /**
   * Number of bytes transferred from one device to another device.
   * This is only supported on 64 bit Linux platforms.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD = 8,

  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT = 9,

  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT = 0x7fffffff;

/**
 * \brief Memory access type for unified memory page faults
 *
 * This is valid for \ref CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT
 * and \ref CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT
 */
/** enum CUpti_ActivityUnifiedMemoryAccessType */
public static final int
  /**
   * The unified memory access type is not known
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN = 0,

  /**
   * The page fault was triggered by read memory instruction
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ = 1,

  /**
   * The page fault was triggered by write memory instruction
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE = 2,

  /**
   * The page fault was triggered by atomic memory instruction
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC = 3,

  /**
   * The page fault was triggered by memory prefetch operation
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH = 4;

/**
 * \brief Migration cause of the Unified Memory counter
 *
 * This is valid for \ref CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD and
 * \ref CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH
 */
/** enum CUpti_ActivityUnifiedMemoryMigrationCause */
public static final int
  /**
   * The unified memory migration cause is not known
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN = 0,

  /**
   * The unified memory migrated due to an explicit call from
   * the user e.g. cudaMemPrefetchAsync
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER = 1,

  /**
   * The unified memory migrated to guarantee data coherence
   * e.g. CPU/GPU faults on Pascal+ and kernel launch on pre-Pascal GPUs
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE = 2,

  /**
   * The unified memory was speculatively migrated by the UVM driver
   * before being accessed by the destination processor to improve
   * performance
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH = 3,

  /**
   * The unified memory migrated to the CPU because it was evicted to make
   * room for another block of memory on the GPU
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION = 4,

  /**
    * The unified memory migrated to another processor because of access counter
    * notifications. Only frequently accessed pages are migrated between CPU and GPU, or
    * between peer GPUs.
    */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS = 5;

/**
 * \brief Remote memory map cause of the Unified Memory counter
 *
 * This is valid for \ref CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP
 */
/** enum CUpti_ActivityUnifiedMemoryRemoteMapCause */
public static final int
  /**
   * The cause of mapping to remote memory was unknown
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN = 0,

  /**
   * Mapping to remote memory was added to maintain data coherence.
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE = 1,

  /**
   * Mapping to remote memory was added to prevent further thrashing
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING = 2,

  /**
   * Mapping to remote memory was added to enforce the hints
   * specified by the programmer or by performance heuristics of the
   * UVM driver
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY = 3,

  /**
   * Mapping to remote memory was added because there is no more
   * memory available on the processor and eviction was not
   * possible
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY = 4,

  /**
   * Mapping to remote memory was added after the memory was
   * evicted to make room for another block of memory on the GPU
   */
  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION = 5;

/**
 * \brief SASS instruction classification.
 *
 * The sass instruction are broadly divided into different class. Each enum represents a classification.
 */
/** enum CUpti_ActivityInstructionClass */
public static final int
  /**
   * The instruction class is not known.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN = 0,

  /**
   * Represents a 32 bit floating point operation.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32 = 1,

  /**
   * Represents a 64 bit floating point operation.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64 = 2,

  /**
   * Represents an integer operation.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER = 3,

  /**
   * Represents a bit conversion operation.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION = 4,

  /**
   * Represents a control flow instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW = 5,

  /**
   * Represents a global load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL = 6,

  /**
   * Represents a shared load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED = 7,

  /**
   * Represents a local load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL = 8,

  /**
   * Represents a generic load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC = 9,

  /**
   * Represents a surface load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE = 10,

  /**
   * Represents a constant load instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT = 11,

  /**
   * Represents a texture load-store instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE = 12,

  /**
   * Represents a global atomic instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC = 13,

  /**
   * Represents a shared atomic instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC = 14,

  /**
   * Represents a surface atomic instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC = 15,

  /**
   * Represents a inter-thread communication instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION = 16,

  /**
   * Represents a barrier instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER = 17,

  /**
   * Represents some miscellaneous instructions which do not fit in the above classification.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS = 18,

  /**
   * Represents a 16 bit floating point operation.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16 = 19,

  /**
   * Represents uniform instruction.
   */
  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM = 20,

  CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT     = 0x7fffffff;

/**
 * \brief Partitioned global caching option
 */
/** enum CUpti_ActivityPartitionedGlobalCacheConfig */
public static final int
  /**
   * Partitioned global cache config unknown.
   */
  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN       = 0,

  /**
   * Partitioned global cache not supported.
   */
  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED = 1,

  /**
   * Partitioned global cache config off.
   */
  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF           = 2,

  /**
   * Partitioned global cache config on.
   */
  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON            = 3,

  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT     = 0x7fffffff;

/**
 * \brief Synchronization type.
 *
 * The types of synchronization to be used with CUpti_ActivitySynchronization.
 */

/** enum CUpti_ActivitySynchronizationType */
public static final int
  /**
   * Unknown data.
   */
  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN             = 0,

  /**
   * Event synchronize API.
   */
  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE   = 1,

  /**
   * Stream wait event API.
   */
  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT   = 2,

  /**
   * Stream synchronize API.
   */
  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE  = 3,

  /**
   * Context synchronize API.
   */
  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE = 4,

  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT           = 0x7fffffff;

/**
 * \brief stream type.
 *
 * The types of stream to be used with CUpti_ActivityStream.
 */

/** enum CUpti_ActivityStreamFlag */
public static final int
  /**
   * Unknown data.
   */
  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN      = 0,

  /**
   * Default stream.
   */
  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT      = 1,

  /**
   * Non-blocking stream.
   */
  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING = 2,

  /**
   * Null stream.
   */
  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL         = 3,

  /**
   * Stream create Mask
   */
  CUPTI_ACTIVITY_STREAM_CREATE_MASK              = 0xFFFF,

  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT    = 0x7fffffff;

/**
* \brief Link flags.
*
* Describes link properties, to be used with CUpti_ActivityNvLink.
*/

/** enum CUpti_LinkFlag */
public static final int
  /**
   * The flag is invalid.
   */
  CUPTI_LINK_FLAG_INVALID        = 0,

  /**
  * Is peer to peer access supported by this link.
  */
  CUPTI_LINK_FLAG_PEER_ACCESS    = (1 << 1),

  /**
  * Is system memory access supported by this link.
  */
  CUPTI_LINK_FLAG_SYSMEM_ACCESS  = (1 << 2),

  /**
  * Is peer atomic access supported by this link.
  */
  CUPTI_LINK_FLAG_PEER_ATOMICS   = (1 << 3),

  /**
  * Is system memory atomic access supported by this link.
  */
  CUPTI_LINK_FLAG_SYSMEM_ATOMICS = (1 << 4),

  CUPTI_LINK_FLAG_FORCE_INT = 0x7fffffff;

/**
* \brief Memory operation types.
*
* Describes the type of memory operation, to be used with CUpti_ActivityMemory4.
*/

/** enum CUpti_ActivityMemoryOperationType */
public static final int
  /**
   * The operation is invalid.
   */
  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID   = 0,

  /**
  * Memory is allocated.
  */
  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION = 1,

  /**
  * Memory is released.
  */
  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE    = 2,

  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT  = 0x7fffffff;

/**
* \brief Memory pool types.
*
* Describes the type of memory pool, to be used with CUpti_ActivityMemory4.
*/

/** enum CUpti_ActivityMemoryPoolType */
public static final int
  /**
   * The operation is invalid.
   */
  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID   = 0,

  /**
  * Memory pool is local to the process.
  */
  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL     = 1,

  /**
  * Memory pool is imported by the process.
  */
  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED  = 2,

  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT = 0x7fffffff;

/**
* \brief Memory pool operation types.
*
* Describes the type of memory pool operation, to be used with CUpti_ActivityMemoryPool2.
*/

/** enum CUpti_ActivityMemoryPoolOperationType */
public static final int
  /**
   * The operation is invalid.
   */
  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID   = 0,

  /**
  * Memory pool is created.
  */
  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED   = 1,

  /**
  * Memory pool is destroyed.
  */
  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED = 2,

  /**
  * Memory pool is trimmed.
  */
  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED   = 3,

  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT = 0x7fffffff;

/** enum CUpti_ChannelType */
public static final int
  CUPTI_CHANNEL_TYPE_INVALID      = 0,

  /**
   * Channel is used for standard work launch and tracking
   */
  CUPTI_CHANNEL_TYPE_COMPUTE      = 1,

  /**
   * Channel is used by an asynchronous copy engine
   * For confidential compute configurations, work launch and
   * completion are done using the copy engines.
   */
  CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY = 2,

  CUPTI_CHANNEL_TYPE_FORCE_INT = 0x7fffffff;

/**
* \brief CIG (CUDA in Graphics) Modes.
*
* Describes the CIG modes associated with the CUDA context.
*/

/** enum CUpti_ContextCigMode */
public static final int
  /**
   * Regular (non-CIG) mode
   */
  CUPTI_CONTEXT_CIG_MODE_NONE         = 0,
  /**
   * CIG mode
   */
  CUPTI_CONTEXT_CIG_MODE_CIG          = 1,
  /**
   * CIG fallback mode
   */
  CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK = 2,

  CUPTI_CONTEXT_CIG_MODE_FORCE_INT    = 0x7fffffff;

/**
 * The source-locator ID that indicates an unknown source
 * location. There is not an actual CUpti_ActivitySourceLocator object
 * corresponding to this value.
 */
public static final int CUPTI_SOURCE_LOCATOR_ID_UNKNOWN = 0;

/**
 * An invalid function index ID.
 */
public static final int CUPTI_FUNCTION_INDEX_ID_INVALID = 0;

/**
 * An invalid/unknown correlation ID. A correlation ID of this value
 * indicates that there is no correlation for the activity record.
 */
public static final int CUPTI_CORRELATION_ID_UNKNOWN = 0;

/**
 * An invalid/unknown grid ID.
 */
public static final long CUPTI_GRID_ID_UNKNOWN = 0L;

/**
 * An invalid/unknown timestamp for a start, end, queued, submitted,
 * or completed time.
 */
public static final long CUPTI_TIMESTAMP_UNKNOWN = 0L;

/**
 * An invalid/unknown value.
 */
public static final int CUPTI_SYNCHRONIZATION_INVALID_VALUE = -1;

/**
 * An invalid/unknown process id.
 */
public static final int CUPTI_AUTO_BOOST_INVALID_CLIENT_PID = 0;

/**
 * Invalid/unknown NVLink port number.
*/
public static final int CUPTI_NVLINK_INVALID_PORT = -1;

/**
 * Maximum NVLink port numbers.
*/
public static final int CUPTI_MAX_NVLINK_PORTS = 32;
// Targeting ..\cupti\CUpti_ActivityUnifiedMemoryCounterConfig.java


// Targeting ..\cupti\CUpti_ActivityAutoBoostState.java


// Targeting ..\cupti\CUpti_ActivityPCSamplingConfig.java


// Targeting ..\cupti\CUpti_Activity.java


// Targeting ..\cupti\CUpti_ActivityMemcpy5.java


// Targeting ..\cupti\CUpti_ActivityMemcpyPtoP4.java


// Targeting ..\cupti\CUpti_ActivityMemset4.java


// Targeting ..\cupti\CUpti_ActivityMemory.java


// Targeting ..\cupti\CUpti_ActivityMemory4.java


// Targeting ..\cupti\CUpti_ActivityMemoryPool2.java



/**
 * \brief The type of the CUDA kernel launch.
 */
/** enum CUpti_ActivityLaunchType */
public static final int
  /**
  * The kernel was launched via a regular kernel call
  */
  CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR = 0,

  /**
  * The kernel was launched via API \ref cudaLaunchCooperativeKernel() or
  * \ref cuLaunchCooperativeKernel()
  */
  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE = 1,

  /**
  * The kernel was launched via API \ref cudaLaunchCooperativeKernelMultiDevice() or
  * \ref cuLaunchCooperativeKernelMultiDevice()
  */
  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE = 2,

  /**
  * The kernel was launched as a CBL commandlist
  */
  CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST = 3;

/**
 * \brief The shared memory limit per block config for a kernel
 * This should be used to set 'cudaOccFuncShmemConfig' field in occupancy calculator API
 */
/** enum CUpti_FuncShmemLimitConfig */
public static final int
    /** The shared memory limit config is default
     */
    CUPTI_FUNC_SHMEM_LIMIT_DEFAULT              = 0x00,

    /** User has opted for a higher dynamic shared memory limit using function attribute
     * 'cudaFuncAttributeMaxDynamicSharedMemorySize' for runtime API or
     * CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES for driver API
     */
    CUPTI_FUNC_SHMEM_LIMIT_OPTIN                = 0x01,

    CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT            = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityKernel9.java


// Targeting ..\cupti\CUpti_ActivityCdpKernel.java


// Targeting ..\cupti\CUpti_ActivityPreemption.java


// Targeting ..\cupti\CUpti_ActivityAPI.java


// Targeting ..\cupti\CUpti_ActivityEvent.java


// Targeting ..\cupti\CUpti_ActivityEventInstance.java


// Targeting ..\cupti\CUpti_ActivityMetric.java


// Targeting ..\cupti\CUpti_ActivityMetricInstance.java


// Targeting ..\cupti\CUpti_ActivitySourceLocator.java


// Targeting ..\cupti\CUpti_ActivityGlobalAccess3.java


// Targeting ..\cupti\CUpti_ActivityBranch2.java


// Targeting ..\cupti\CUpti_ActivityDevice5.java


// Targeting ..\cupti\CUpti_ActivityDeviceAttribute.java


// Targeting ..\cupti\CUpti_ActivityContext3.java


// Targeting ..\cupti\CUpti_ActivityName.java


// Targeting ..\cupti\CUpti_ActivityMarker2.java


// Targeting ..\cupti\CUpti_ActivityMarkerData.java


// Targeting ..\cupti\CUpti_ActivityOverhead3.java


// Targeting ..\cupti\CUpti_ActivityEnvironment.java


// Targeting ..\cupti\CUpti_ActivityInstructionExecution.java


// Targeting ..\cupti\CUpti_ActivityPCSampling3.java


// Targeting ..\cupti\CUpti_ActivityPCSamplingRecordInfo.java


// Targeting ..\cupti\CUpti_ActivityUnifiedMemoryCounter2.java


// Targeting ..\cupti\CUpti_ActivityFunction.java


// Targeting ..\cupti\CUpti_ActivityModule.java


// Targeting ..\cupti\CUpti_ActivitySharedAccess.java


// Targeting ..\cupti\CUpti_ActivityCudaEvent.java


// Targeting ..\cupti\CUpti_ActivityStream.java


// Targeting ..\cupti\CUpti_ActivitySynchronization.java


// Targeting ..\cupti\CUpti_ActivityInstructionCorrelation.java



/**
 * \brief The OpenAcc event kind for OpenAcc activity records.
 *
 * @see CUpti_ActivityKindOpenAcc
 */
/** enum CUpti_OpenAccEventKind */
public static final int
  CUPTI_OPENACC_EVENT_KIND_INVALID              = 0,
  CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT          = 1,
  CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN      = 2,
  CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN     = 3,
  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH       = 4,
  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD       = 5,
  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD     = 6,
  CUPTI_OPENACC_EVENT_KIND_WAIT                 = 7,
  CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT        = 8,
  CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT    = 9,
  CUPTI_OPENACC_EVENT_KIND_UPDATE               = 10,
  CUPTI_OPENACC_EVENT_KIND_ENTER_DATA           = 11,
  CUPTI_OPENACC_EVENT_KIND_EXIT_DATA            = 12,
  CUPTI_OPENACC_EVENT_KIND_CREATE               = 13,
  CUPTI_OPENACC_EVENT_KIND_DELETE               = 14,
  CUPTI_OPENACC_EVENT_KIND_ALLOC                = 15,
  CUPTI_OPENACC_EVENT_KIND_FREE                 = 16,
  CUPTI_OPENACC_EVENT_KIND_FORCE_INT            = 0x7fffffff;

/**
 * \brief The OpenAcc parent construct kind for OpenAcc activity records.
 */
/** enum CUpti_OpenAccConstructKind */
public static final int
  CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN          = 0,
  CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL         = 1,
  CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS          = 2,
  CUPTI_OPENACC_CONSTRUCT_KIND_LOOP             = 3,
  CUPTI_OPENACC_CONSTRUCT_KIND_DATA             = 4,
  CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA       = 5,
  CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA        = 6,
  CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA        = 7,
  CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC           = 8,
  CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE          = 9,
  CUPTI_OPENACC_CONSTRUCT_KIND_INIT             = 10,
  CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN         = 11,
  CUPTI_OPENACC_CONSTRUCT_KIND_SET              = 12,
  CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE           = 13,
  CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE          = 14,
  CUPTI_OPENACC_CONSTRUCT_KIND_WAIT             = 15,
  CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API      = 16,
  CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT        = 0x7fffffff;

/** enum CUpti_OpenMpEventKind */
public static final int
  CUPTI_OPENMP_EVENT_KIND_INVALID               = 0,
  CUPTI_OPENMP_EVENT_KIND_PARALLEL              = 1,
  CUPTI_OPENMP_EVENT_KIND_TASK                  = 2,
  CUPTI_OPENMP_EVENT_KIND_THREAD                = 3,
  CUPTI_OPENMP_EVENT_KIND_IDLE                  = 4,
  CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER          = 5,
  CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT         = 6,
  CUPTI_OPENMP_EVENT_KIND_FORCE_INT             = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityOpenAcc.java


// Targeting ..\cupti\CUpti_ActivityOpenAccData.java


// Targeting ..\cupti\CUpti_ActivityOpenAccLaunch.java


// Targeting ..\cupti\CUpti_ActivityOpenAccOther.java


// Targeting ..\cupti\CUpti_ActivityOpenMp.java



/**
 * \brief The kind of external APIs supported for correlation.
 *
 * Custom correlation kinds are reserved for usage in external tools.
 *
 * @see CUpti_ActivityExternalCorrelation
 */
/** enum CUpti_ExternalCorrelationKind */
public static final int
    CUPTI_EXTERNAL_CORRELATION_KIND_INVALID              = 0,

    /**
     * The external API is unknown to CUPTI
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN              = 1,

    /**
     * The external API is OpenACC
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC              = 2,

    /**
     * The external API is custom0
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0              = 3,

    /**
     * The external API is custom1
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1              = 4,

    /**
     * The external API is custom2
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2              = 5,

    /**
     * Add new kinds before this line
     */
    CUPTI_EXTERNAL_CORRELATION_KIND_SIZE = 6,

    CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT            = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityExternalCorrelation.java



/**
* \brief The device type for device connected to NVLink.
*/
/** enum CUpti_DevType */
public static final int
    CUPTI_DEV_TYPE_INVALID = 0,

    /**
    * The device type is GPU.
    */
    CUPTI_DEV_TYPE_GPU = 1,

    /**
    * The device type is NVLink processing unit in CPU.
    */
    CUPTI_DEV_TYPE_NPU = 2,

    CUPTI_DEV_TYPE_FORCE_INT = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityNvLink4.java



public static final int CUPTI_MAX_GPUS = 32;
/**
 * Field to differentiate whether PCIE Activity record
 * is of a GPU or a PCI Bridge
 */
/** enum CUpti_PcieDeviceType */
public static final int
    /**
     * PCIE GPU record
     */
    CUPTI_PCIE_DEVICE_TYPE_GPU       = 0,

    /**
     * PCIE Bridge record
     */
    CUPTI_PCIE_DEVICE_TYPE_BRIDGE    = 1,

    CUPTI_PCIE_DEVICE_TYPE_FORCE_INT = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityPcie.java



/**
 * \brief PCIE Generation.
 *
 * Enumeration of PCIE Generation for
 * pcie activity attribute pcieGeneration
 */
/** enum CUpti_PcieGen */
public static final int
  /**
  * PCIE Generation 1
  */
  CUPTI_PCIE_GEN_GEN1       = 1,

  /**
  * PCIE Generation 2
  */
  CUPTI_PCIE_GEN_GEN2       = 2,

  /**
  * PCIE Generation 3
  */
  CUPTI_PCIE_GEN_GEN3       = 3,

  /**
  * PCIE Generation 4
  */
  CUPTI_PCIE_GEN_GEN4       = 4,

  /**
  * PCIE Generation 5
  */
  CUPTI_PCIE_GEN_GEN5       = 5,

  CUPTI_PCIE_GEN_FORCE_INT  = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityInstantaneousEvent.java


// Targeting ..\cupti\CUpti_ActivityInstantaneousEventInstance.java


// Targeting ..\cupti\CUpti_ActivityInstantaneousMetric.java


// Targeting ..\cupti\CUpti_ActivityInstantaneousMetricInstance.java



/**
 * \brief The types of JIT entry.
 *
 * To be used in CUpti_ActivityJit.
 */
/** enum CUpti_ActivityJitEntryType */
public static final int
  CUPTI_ACTIVITY_JIT_ENTRY_INVALID = 0,

  /**
  * PTX to CUBIN.
  */
  CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN = 1,

  /**
  * NVVM-IR to PTX
  */
  CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX = 2,

  CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT = 0x7fffffff;

/**
 * \brief The types of JIT compilation operations.
 *
 * To be used in CUpti_ActivityJit.
 */

/** enum CUpti_ActivityJitOperationType */
public static final int
  CUPTI_ACTIVITY_JIT_OPERATION_INVALID = 0,
  /**
  * Loaded from the compute cache.
  */
  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD = 1,

  /**
  * Stored in the compute cache.
  */
  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE = 2,

  /**
  * JIT compilation.
  */
  CUPTI_ACTIVITY_JIT_OPERATION_COMPILE = 3,

  CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT = 0x7fffffff;
// Targeting ..\cupti\CUpti_ActivityJit2.java


// Targeting ..\cupti\CUpti_ActivityGraphTrace2.java



/** enum CUpti_ActivityAttribute */
public static final int
    /**
     * The device memory size (in bytes) reserved for storing profiling data for concurrent
     * kernels (activity kind \ref CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL), memcopies and memsets
     * for each buffer on a context. The value is a size_t.
     *
     * There is a limit on how many device buffers can be allocated per context. User
     * can query and set this limit using the attribute
     * \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT.
     * CUPTI doesn't pre-allocate all the buffers, it pre-allocates only those many
     * buffers as set by the attribute \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE.
     * When all of the data in a buffer is consumed, it is added in the reuse pool, and
     * CUPTI picks a buffer from this pool when a new buffer is needed. Thus memory
     * footprint does not scale with the kernel count. Applications with the high density
     * of kernels, memcopies and memsets might result in having CUPTI to allocate more device buffers.
     * CUPTI allocates another buffer only when it runs out of the buffers in the
     * reuse pool.
     *
     * Since buffer allocation happens in the main application thread, this might result
     * in stalls in the critical path. CUPTI pre-allocates 3 buffers of the same size to
     * mitigate this issue. User can query and set the pre-allocation limit using the
     * attribute \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE.
     *
     * Having larger buffer size leaves less device memory for the application.
     * Having smaller buffer size increases the risk of dropping timestamps for
     * records if too many kernels or memcopies or memsets are launched at one time.
     *
     * This value only applies to new buffer allocations. Set this value before initializing
     * CUDA or before creating a context to ensure it is considered for the following allocations.
     *
     * The default value is 3200000 (~3MB) which can accommodate profiling data
     * up to 100,000 kernels, memcopies and memsets combined.
     *
     * Note: Starting with the CUDA 12.0 Update 1 release, CUPTI allocates profiling buffer in the
     * device memory by default as this might help in improving the performance of the
     * tracing run. Refer to the description of the attribute
     * \ref CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED for more details.
     * Size of the memory and maximum number of pools are still controlled by the attributes
     * \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE and \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT.
     *
     * Note: The actual amount of device memory per buffer reserved by CUPTI might be larger.
     */
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE                      = 0,

    /**
     * The device memory size (in bytes) reserved for storing profiling
     * data for CDP operations for each buffer on a context. The
     * value is a size_t.
     *
     * Having larger buffer size means less flush operations but
     * consumes more device memory. This value only applies to new
     * allocations.
     *
     * Set this value before initializing CUDA or before creating a
     * context to ensure it is considered for the following allocations.
     *
     * The default value is 8388608 (8MB).
     *
     * Note: The actual amount of device memory per context reserved by
     * CUPTI might be larger.
     */
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP          = 1,

    /**
     * The maximum number of device memory buffers per context. The value is a size_t.
     *
     * For an application with high rate of kernel launches, memcopies and memsets having a bigger pool
     * limit helps in timestamp collection for all these activities at the expense of a larger memory footprint.
     * Refer to the description of the attribute \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE
     * for more details.
     *
     * Setting this value will not modify the number of memory buffers
     * currently stored.
     *
     * Set this value before initializing CUDA to ensure the limit is
     * not exceeded.
     *
     * The default value is 250.
     */
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT                = 2,

    /**
     * This attribute is not supported starting with CUDA 12.3
     * CUPTI no longer uses profiling semaphore pool to store profiling data.
     *
     * There is a limit on how many semaphore pools can be allocated per context. User
     * can query and set this limit using the attribute
     * \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT.
     * CUPTI doesn't pre-allocate all the semaphore pools, it pre-allocates only those many
     * semaphore pools as set by the attribute \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE.
     * When all of the data in a semaphore pool is consumed, it is added in the reuse pool, and
     * CUPTI picks a semaphore pool from the reuse pool when a new semaphore pool is needed. Thus memory
     * footprint does not scale with the kernel count. Applications with the high density
     * of kernels might result in having CUPTI to allocate more semaphore pools.
     * CUPTI allocates another semaphore pool only when it runs out of the semaphore pools in the
     * reuse pool.
     *
     * Since semaphore pool allocation happens in the main application thread, this might result
     * in stalls in the critical path. CUPTI pre-allocates 3 semaphore pools of the same size to
     * mitigate this issue. User can query and set the pre-allocation limit using the
     * attribute \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE.
     *
     * Having larger semaphore pool size leaves less device memory for the application.
     * Having smaller semaphore pool size increases the risk of dropping timestamps for
     * kernel records if too many kernels are issued/launched at one time.
     *
     * This value only applies to new semaphore pool allocations. Set this value before initializing
     * CUDA or before creating a context to ensure it is considered for the following allocations.
     *
     * The default value is 25000 which can accommodate profiling data for upto 25,000 kernels.
     *
     */
    CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE           = 3,

    /**
     * This attribute is not supported starting with CUDA 12.3
     * CUPTI no longer uses profiling semaphore pool to store profiling data.
     *
     * The maximum number of profiling semaphore pools per context. The value is a size_t.
     *
     * Refer to the description of the attribute \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE
     * for more details.
     *
     * Set this value before initializing CUDA to ensure the limit is not exceeded.
     *
     * The default value is 250.
     */
    CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT          = 4,

    /**
     * The flag to indicate whether user should provide activity buffer of zero value.
     * The value is a uint8_t.
     *
     * If the value of this attribute is non-zero, user should provide
     * a zero value buffer in the \ref CUpti_BuffersCallbackRequestFunc.
     * If the user does not provide a zero value buffer after setting this to non-zero,
     * the activity buffer may contain some uninitialized values when CUPTI returns it in
     * \ref CUpti_BuffersCallbackCompleteFunc
     *
     * If the value of this attribute is zero, CUPTI will initialize the user buffer
     * received in the \ref CUpti_BuffersCallbackRequestFunc to zero before filling it.
     * If the user sets this to zero, a few stalls may appear in critical path because CUPTI
     * will zero out the buffer in the main thread.
     * Set this value before returning from \ref CUpti_BuffersCallbackRequestFunc to
     * ensure it is considered for all the subsequent user buffers.
     *
     * The default value is 0.
     */
    CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER              = 5,

    /**
     * Number of device buffers to pre-allocate for a context during the initialization phase.
     * The value is a size_t.
     *
     * Refer to the description of the attribute \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE
     * for details.
     *
     * This value must be less than the maximum number of device buffers set using
     * the attribute \ref CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT
     *
     * Set this value before initializing CUDA or before creating a context to ensure it
     * is considered by the CUPTI.
     *
     * The default value is set to 3 to ping pong between these buffers (if possible).
     */
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE        = 6,

    /**
     * This attribute is not supported starting with CUDA 12.3
     * CUPTI no longer uses profiling semaphore pool to store profiling data.
     *
     * Number of profiling semaphore pools to pre-allocate for a context during the
     * initialization phase. The value is a size_t.
     *
     * Refer to the description of the attribute \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE
     * for details.
     *
     * This value must be less than the maximum number of profiling semaphore pools set
     * using the attribute \ref CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT
     *
     * Set this value before initializing CUDA or before creating a context to ensure it
     * is considered by the CUPTI.
     *
     * The default value is set to 3 to ping pong between these pools (if possible).
     */
    CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE  = 7,

    /**
     * Allocate page-locked (pinned) host memory for storing profiling data for concurrent
     * kernels, memcopies and memsets for each buffer on a context. The value is a uint8_t.
     *
     * Starting with the CUDA 11.2 release, CUPTI allocates profiling buffer in the pinned host
     * memory by default as this might help in improving the performance of the tracing run.
     * Allocating excessive amounts of pinned memory may degrade system performance, since it
     * reduces the amount of memory available to the system for paging. For this reason user
     * might want to change the location from pinned host memory to device memory by setting
     * value of this attribute to 0.
     *
     * Using page-locked (pinned) host memory buffers is not supported on confidential computing
     * devices. On setting this attribute to 1, CUPTI will return CUPTI_ERROR_NOT_SUPPORTED.
     *
     * The default value is 1.
     */
    CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED         = 8,

    /**
     * Request activity buffers per-thread to store CUPTI activity records
     * in the activity buffer on per-thread basis. The value is a uint8_t.
     *
     * The attribute should be set before registering the buffer callbacks using
     * cuptiActivityRegisterCallbacks API and before any of the CUPTI activity kinds are enabled.
     * This makes sure that all the records are stored in activity buffers allocated per-thread.
     * Changing this attribute in the middle of the profiling session will result in undefined behavior.
     *
     * The default value is 0.
     */
    CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER = 9,



    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT                 = 0x7fffffff;

/**
 * \brief Thread-Id types.
 *
 * CUPTI uses different methods to obtain the thread-id depending on the
 * support and the underlying platform. This enum documents these methods
 * for each type. APIs \ref cuptiSetThreadIdType and \ref cuptiGetThreadIdType
 * can be used to set and get the thread-id type.
 */
/** enum CUpti_ActivityThreadIdType */
public static final int
    /**
     * Default type
     * Windows uses API GetCurrentThreadId()
     * Linux/Mac/Android/QNX use POSIX pthread API pthread_self()
     */
    CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT       = 0,

    /**
     * This type is based on the system API available on the underlying platform
     * and thread-id obtained is supposed to be unique for the process lifetime.
     * Windows uses API GetCurrentThreadId()
     * Linux uses syscall SYS_gettid
     * Mac uses syscall SYS_thread_selfid
     * Android/QNX use gettid()
     */
    CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM        = 1,

    /**
     * Add new enums before this field.
     */
    CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE          = 2,

    CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT     = 0x7fffffff;

/**
 * \brief Get the CUPTI timestamp.
 *
 * Returns a timestamp normalized to correspond with the start and end
 * timestamps reported in the CUPTI activity records. The timestamp is
 * reported in nanoseconds.
 *
 * @param timestamp Returns the CUPTI timestamp
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p timestamp is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetTimestamp(@Cast("uint64_t*") LongPointer timestamp);
public static native @Cast("CUptiResult") int cuptiGetTimestamp(@Cast("uint64_t*") LongBuffer timestamp);
public static native @Cast("CUptiResult") int cuptiGetTimestamp(@Cast("uint64_t*") long[] timestamp);

/**
 * \brief Get the ID of a context.
 *
 * Get the ID of a context.
 *
 * @param context The context
 * @param contextId Returns a process-unique ID for the context
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_CONTEXT The context is NULL or not valid.
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p contextId is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetContextId(CUctx_st context, @Cast("uint32_t*") IntPointer contextId);
public static native @Cast("CUptiResult") int cuptiGetContextId(CUctx_st context, @Cast("uint32_t*") IntBuffer contextId);
public static native @Cast("CUptiResult") int cuptiGetContextId(CUctx_st context, @Cast("uint32_t*") int[] contextId);

/**
 * \brief Get the ID of a stream.
 *
 * Get the ID of a stream. The stream ID is unique within a context
 * (i.e. all streams within a context will have unique stream
 * IDs).
 *
 * @param context If non-NULL then the stream is checked to ensure
 * that it belongs to this context. Typically this parameter should be
 * null.
 * @param stream The stream
 * @param streamId Returns a context-unique ID for the stream
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_STREAM if unable to get stream ID, or
 * if \p context is non-NULL and \p stream does not belong to the
 * context
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p streamId is NULL
 *
 * **DEPRECATED** This method is deprecated as of CUDA 8.0.
 * Use method cuptiGetStreamIdEx instead.
 */
public static native @Cast("CUptiResult") int cuptiGetStreamId(CUctx_st context, CUstream_st stream, @Cast("uint32_t*") IntPointer streamId);
public static native @Cast("CUptiResult") int cuptiGetStreamId(CUctx_st context, CUstream_st stream, @Cast("uint32_t*") IntBuffer streamId);
public static native @Cast("CUptiResult") int cuptiGetStreamId(CUctx_st context, CUstream_st stream, @Cast("uint32_t*") int[] streamId);

/**
* \brief Get the ID of a stream.
*
* Get the ID of a stream. The stream ID is unique within a context
* (i.e. all streams within a context will have unique stream
* IDs).
*
* @param context If non-NULL then the stream is checked to ensure
* that it belongs to this context. Typically this parameter should be
* null.
* @param stream The stream
* @param perThreadStream Flag to indicate if program is compiled for per-thread streams
* @param streamId Returns a context-unique ID for the stream
*
* \retval CUPTI_SUCCESS
* \retval CUPTI_ERROR_NOT_INITIALIZED
* \retval CUPTI_ERROR_INVALID_STREAM if unable to get stream ID, or
* if \p context is non-NULL and \p stream does not belong to the
* context
* \retval CUPTI_ERROR_INVALID_PARAMETER if \p streamId is NULL
*/
public static native @Cast("CUptiResult") int cuptiGetStreamIdEx(CUctx_st context, CUstream_st stream, @Cast("uint8_t") byte perThreadStream, @Cast("uint32_t*") IntPointer streamId);
public static native @Cast("CUptiResult") int cuptiGetStreamIdEx(CUctx_st context, CUstream_st stream, @Cast("uint8_t") byte perThreadStream, @Cast("uint32_t*") IntBuffer streamId);
public static native @Cast("CUptiResult") int cuptiGetStreamIdEx(CUctx_st context, CUstream_st stream, @Cast("uint8_t") byte perThreadStream, @Cast("uint32_t*") int[] streamId);

/**
 * \brief Get the ID of a device
 *
 * If \p context is NULL, returns the ID of the device that contains
 * the currently active context. If \p context is non-NULL, returns
 * the ID of the device which contains that context. Operates in a
 * similar manner to cudaGetDevice() or cuCtxGetDevice() but may be
 * called from within callback functions.
 *
 * @param context The context, or NULL to indicate the current context.
 * @param deviceId Returns the ID of the device that is current for
 * the calling thread.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE if unable to get device ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p deviceId is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetDeviceId(CUctx_st context, @Cast("uint32_t*") IntPointer deviceId);
public static native @Cast("CUptiResult") int cuptiGetDeviceId(CUctx_st context, @Cast("uint32_t*") IntBuffer deviceId);
public static native @Cast("CUptiResult") int cuptiGetDeviceId(CUctx_st context, @Cast("uint32_t*") int[] deviceId);

/**
 * \brief Get the unique ID of a graph node
 *
 * Returns the unique ID of the CUDA graph node.
 *
 * @param node The graph node.
 * @param nodeId Returns the unique ID of the node
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p node is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetGraphNodeId(CUgraphNode_st node, @Cast("uint64_t*") LongPointer nodeId);
public static native @Cast("CUptiResult") int cuptiGetGraphNodeId(CUgraphNode_st node, @Cast("uint64_t*") LongBuffer nodeId);
public static native @Cast("CUptiResult") int cuptiGetGraphNodeId(CUgraphNode_st node, @Cast("uint64_t*") long[] nodeId);

/**
 * \brief Get the unique ID of graph
 *
 * Returns the unique ID of CUDA graph.
 *
 * @param graph The graph.
 * @param pId Returns the unique ID of the graph
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p graph is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetGraphId(CUgraph_st graph, @Cast("uint32_t*") IntPointer pId);
public static native @Cast("CUptiResult") int cuptiGetGraphId(CUgraph_st graph, @Cast("uint32_t*") IntBuffer pId);
public static native @Cast("CUptiResult") int cuptiGetGraphId(CUgraph_st graph, @Cast("uint32_t*") int[] pId);

/**
 * \brief Get the unique ID of executable graph
 *
 * Returns the unique ID of executable CUDA graph.
 *
 * @param graphExec The executable graph.
 * @param pId Returns the unique ID of the executable graph
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p graph is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetGraphExecId(CUgraphExec_st graphExec, @Cast("uint32_t*") IntPointer pId);
public static native @Cast("CUptiResult") int cuptiGetGraphExecId(CUgraphExec_st graphExec, @Cast("uint32_t*") IntBuffer pId);
public static native @Cast("CUptiResult") int cuptiGetGraphExecId(CUgraphExec_st graphExec, @Cast("uint32_t*") int[] pId);

/**
 * \brief Enable collection of a specific kind of activity record.
 *
 * Enable collection of a specific kind of activity record. Multiple
 * kinds can be enabled by calling this function multiple times. By
 * default all activity kinds are disabled for collection.
 *
 * @param kind The kind of activity record to collect
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if the activity kind cannot be enabled
 * \retval CUPTI_ERROR_INVALID_KIND if the activity kind is not supported
 */
public static native @Cast("CUptiResult") int cuptiActivityEnable(@Cast("CUpti_ActivityKind") int kind);

/**
 * \brief Enable collection of a specific kind of activity record. For certain activity kinds
 * it dumps existing records.
 *
 * In general, the behavior of this API is similar to the API \ref cuptiActivityEnable i.e. it
 * enables the collection of a specific kind of activity record.
 * Additionally, this API can help in dumping the records for activities which happened in
 * the past before enabling the corresponding activity kind.
 * The API allows to get records for the current resource allocations done in CUDA
 * For CUPTI_ACTIVITY_KIND_DEVICE, existing device records are dumped
 * For CUPTI_ACTIVITY_KIND_CONTEXT, existing context records are dumped
 * For CUPTI_ACTIVITY_KIND_STREAM, existing stream records are dumped
 * For CUPTI_ACTIVITY_KIND_ NVLINK, existing NVLINK records are dumped
 * For CUPTI_ACTIVITY_KIND_PCIE, existing PCIE records are dumped
 * For other activities, the behavior is similar to the API \ref cuptiActivityEnable
 *
 * Device records are emitted in CUPTI on CUDA driver initialization. Those records
 * can only be retrieved by the user if CUPTI is attached before CUDA initialization.
 * Context and stream records are emitted on context and stream creation.
 * The use case of the API is to provide the records for CUDA resources
 * (contexts/streams/devices) that are currently active if user late attaches CUPTI.
 *
 * Before calling this function, the user must register buffer callbacks
 * to get the activity records by calling \ref cuptiActivityRegisterCallbacks.
 * If the user does not register the buffers and calls API \ref cuptiActivityEnableAndDump,
 * then CUPTI will enable the activity kind but not provide any records for that
 * activity kind.
 *
 * @param kind The kind of activity record to collect
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_UNKNOWN if buffer is not initialized.
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if the activity kind cannot be enabled
 * \retval CUPTI_ERROR_INVALID_KIND if the activity kind is not supported
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableAndDump(@Cast("CUpti_ActivityKind") int kind);

/**
 * \brief Disable collection of a specific kind of activity record.
 *
 * Disable collection of a specific kind of activity record. Multiple
 * kinds can be disabled by calling this function multiple times. By
 * default all activity kinds are disabled for collection.
 *
 * @param kind The kind of activity record to stop collecting
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_KIND if the activity kind is not supported
 */
public static native @Cast("CUptiResult") int cuptiActivityDisable(@Cast("CUpti_ActivityKind") int kind);

/**
 * \brief Enable collection of a specific kind of activity record for
 * a context.
 *
 * Enable collection of a specific kind of activity record for a
 * context.  This setting done by this API will supersede the global
 * settings for activity records enabled by \ref cuptiActivityEnable.
 * Multiple kinds can be enabled by calling this function multiple
 * times.
 *
 * @param context The context for which activity is to be enabled
 * @param kind The kind of activity record to collect
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if the activity kind cannot be enabled
 * \retval CUPTI_ERROR_INVALID_KIND if the activity kind is not supported
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableContext(CUctx_st context, @Cast("CUpti_ActivityKind") int kind);

/**
 * \brief Disable collection of a specific kind of activity record for
 * a context.
 *
 * Disable collection of a specific kind of activity record for a context.
 * This setting done by this API will supersede the global settings
 * for activity records.
 * Multiple kinds can be enabled by calling this function multiple times.
 *
 * @param context The context for which activity is to be disabled
 * @param kind The kind of activity record to stop collecting
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_KIND if the activity kind is not supported
 */
public static native @Cast("CUptiResult") int cuptiActivityDisableContext(CUctx_st context, @Cast("CUpti_ActivityKind") int kind);

/**
 * \brief Get the number of activity records that were dropped of
 * insufficient buffer space.
 *
 * Get the number of records that were dropped because of insufficient
 * buffer space.  The dropped count includes records that could not be
 * recorded because CUPTI did not have activity buffer space available
 * for the record (because the CUpti_BuffersCallbackRequestFunc
 * callback did not return an empty buffer of sufficient size) and
 * also CDP records that could not be record because the device-size
 * buffer was full (size is controlled by the
 * CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP attribute). The dropped
 * count maintained for the queue is reset to zero when this function
 * is called.
 *
 * @param context The context, or NULL to get dropped count from global queue
 * @param streamId The stream ID
 * @param dropped The number of records that were dropped since the last call
 * to this function.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p dropped is NULL
 */
public static native @Cast("CUptiResult") int cuptiActivityGetNumDroppedRecords(CUctx_st context, @Cast("uint32_t") int streamId,
                                                       @Cast("size_t*") SizeTPointer dropped);

/**
 * \brief Iterate over the activity records in a buffer.
 *
 * This is a helper function to iterate over the activity records in a
 * buffer. A buffer of activity records is typically obtained by
 * receiving a CUpti_BuffersCallbackCompleteFunc callback. Stop iterating
 * the buffer when an error occurs.
 *
 * An example of typical usage:
 * <pre>{@code
 * CUpti_Activity *record = NULL;
 * CUptiResult status = CUPTI_SUCCESS;
 *   do {
 *      status = cuptiActivityGetNextRecord(buffer, validSize, &record);
 *      if(status == CUPTI_SUCCESS) {
 *           // Use record here...
 *      }
 *      else if (status == CUPTI_ERROR_MAX_LIMIT_REACHED)
 *          break;
 *      else if (status == CUPTI_ERROR_INVALID_KIND)
 *          break;
 *      else {
 *          goto Error;
 *      }
 *    } while (1);
 * }</pre>
 *
 * @param buffer The buffer containing activity records
 * @param record Inputs the previous record returned by
 * cuptiActivityGetNextRecord and returns the next activity record
 * from the buffer. If input value is NULL, returns the first activity
 * record in the buffer. Records of certain kinds like CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL
 * may contain invalid (0) timestamps, indicating that no timing information could
 * be collected for lack of device memory.
 * @param validBufferSizeBytes The number of valid bytes in the buffer.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_MAX_LIMIT_REACHED if no more records in the buffer
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p buffer is NULL.
 * \retval CUPTI_ERROR_INVALID_KIND if activity record is either incomplete or invalid
 */
public static native @Cast("CUptiResult") int cuptiActivityGetNextRecord(@Cast("uint8_t*") BytePointer buffer, @Cast("size_t") long validBufferSizeBytes,
                                                @Cast("CUpti_Activity**") PointerPointer record);
public static native @Cast("CUptiResult") int cuptiActivityGetNextRecord(@Cast("uint8_t*") BytePointer buffer, @Cast("size_t") long validBufferSizeBytes,
                                                @ByPtrPtr CUpti_Activity record);
public static native @Cast("CUptiResult") int cuptiActivityGetNextRecord(@Cast("uint8_t*") ByteBuffer buffer, @Cast("size_t") long validBufferSizeBytes,
                                                @ByPtrPtr CUpti_Activity record);
public static native @Cast("CUptiResult") int cuptiActivityGetNextRecord(@Cast("uint8_t*") byte[] buffer, @Cast("size_t") long validBufferSizeBytes,
                                                @ByPtrPtr CUpti_Activity record);
// Targeting ..\cupti\CUpti_BuffersCallbackRequestFunc.java


// Targeting ..\cupti\CUpti_BuffersCallbackCompleteFunc.java



/**
 * \brief Registers callback functions with CUPTI for activity buffer
 * handling.
 *
 * This function registers two callback functions to be used in asynchronous
 * buffer handling. If registered, activity record buffers are handled using
 * asynchronous requested/completed callbacks from CUPTI.
 *
 * Registering these callbacks prevents the client from using CUPTI's
 * blocking enqueue/dequeue functions.
 *
 * @param funcBufferRequested callback which is invoked when an empty
 * buffer is requested by CUPTI
 * @param funcBufferCompleted callback which is invoked when a buffer
 * containing activity records is available from CUPTI
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if either \p
 * funcBufferRequested or \p funcBufferCompleted is NULL
 */
public static native @Cast("CUptiResult") int cuptiActivityRegisterCallbacks(CUpti_BuffersCallbackRequestFunc funcBufferRequested,
        CUpti_BuffersCallbackCompleteFunc funcBufferCompleted);

/**
 * \brief Wait for all activity records to be delivered via the
 * completion callback.
 *
 * This function does not return until all activity records associated
 * with the specified context/stream are returned to the CUPTI client
 * using the callback registered in cuptiActivityRegisterCallbacks. To
 * ensure that all activity records are complete, the requested
 * stream(s), if any, are synchronized.
 *
 * If \p context is NULL, the global activity records (i.e. those not
 * associated with a particular stream) are flushed (in this case no
 * streams are synchronized).  If \p context is a valid CUcontext and
 * \p streamId is 0, the buffers of all streams of this context are
 * flushed.  Otherwise, the buffers of the specified stream in this
 * context is flushed.
 *
 * Before calling this function, the buffer handling callback api
 * must be activated by calling cuptiActivityRegisterCallbacks.
 *
 * @param context A valid CUcontext or NULL.
 * @param streamId The stream ID.
 * @param flag The flag can be set to indicate a forced flush. See CUpti_ActivityFlag
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_CUPTI_ERROR_INVALID_OPERATION if not preceded
 * by a successful call to cuptiActivityRegisterCallbacks
 * \retval CUPTI_ERROR_UNKNOWN an internal error occurred
 *
 * **DEPRECATED** This method is deprecated
 * CONTEXT and STREAMID will be ignored. Use cuptiActivityFlushAll
 * to flush all data.
 */
public static native @Cast("CUptiResult") int cuptiActivityFlush(CUctx_st context, @Cast("uint32_t") int streamId, @Cast("uint32_t") int flag);

/**
 * \brief Request to deliver activity records via the buffer completion callback.
 *
 * This function returns the activity records associated with all contexts/streams
 * (and the global buffers not associated with any stream) to the CUPTI client
 * using the callback registered in cuptiActivityRegisterCallbacks.
 *
 * This is a blocking call but it doesn't issue any CUDA synchronization calls
 * implicitly thus it's not guaranteed that all activities are completed on the
 * underlying devices. Activity record is considered as completed if it has all
 * the information filled up including the timestamps if any. It is the client's
 * responsibility to issue necessary CUDA synchronization calls before calling
 * this function if all activity records with complete information are expected
 * to be delivered.
 *
 * Behavior of the function based on the input flag:
 * (-) ::For default flush i.e. when flag is set as 0, it returns all the
 * activity buffers which have all the activity records completed, buffers need not
 * to be full though. It doesn't return buffers which have one or more incomplete
 * records. Default flush can be done at a regular interval in a separate thread.
 * (-) ::For forced flush i.e. when flag CUPTI_ACTIVITY_FLAG_FLUSH_FORCED is passed
 * to the function, it returns all the activity buffers including the ones which have
 * one or more incomplete activity records. It's suggested for clients to do the
 * force flush before the termination of the profiling session to allow remaining
 * buffers to be delivered. In general, it can be done in the at-exit handler.
 *
 * Before calling this function, the buffer handling callback api must be activated
 * by calling cuptiActivityRegisterCallbacks.
 *
 * @param flag The flag can be set to indicate a forced flush. See CUpti_ActivityFlag
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_OPERATION if not preceded by a
 * successful call to cuptiActivityRegisterCallbacks
 * \retval CUPTI_ERROR_UNKNOWN an internal error occurred
 *
 * @see cuptiActivityFlushPeriod
 */
public static native @Cast("CUptiResult") int cuptiActivityFlushAll(@Cast("uint32_t") int flag);

/**
 * \brief Read an activity API attribute.
 *
 * Read an activity API attribute and return it in \p *value.
 *
 * @param attr The attribute to read
 * @param valueSize Size of buffer pointed by the value, and
 * returns the number of bytes written to \p value
 * @param value Returns the value of the attribute
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value is NULL, or
 * if \p attr is not an activity attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT Indicates that
 * the \p value buffer is too small to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiActivityGetAttribute(@Cast("CUpti_ActivityAttribute") int attr,
        @Cast("size_t*") SizeTPointer valueSize, Pointer value);

/**
 * \brief Write an activity API attribute.
 *
 * Write an activity API attribute.
 *
 * @param attr The attribute to write
 * @param valueSize The size, in bytes, of the value
 * @param value The attribute value to write
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value is NULL, or
 * if \p attr is not an activity attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT Indicates that
 * the \p value buffer is too small to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiActivitySetAttribute(@Cast("CUpti_ActivityAttribute") int attr,
        @Cast("size_t*") SizeTPointer valueSize, Pointer value);


/**
 * \brief Set Unified Memory Counter configuration.
 *
 * @param config A pointer to \ref CUpti_ActivityUnifiedMemoryCounterConfig structures
 * containing Unified Memory counter configuration.
 * @param count Number of Unified Memory counter configuration structures
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p config is NULL or
 * any parameter in the \p config structures is not a valid value
 * \retval CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED One potential reason is that
 * platform (OS/arch) does not support the unified memory counters
 * \retval CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_DEVICE Indicates that the device
 * does not support the unified memory counters
 * \retval CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_NON_P2P_DEVICES Indicates that
 * multi-GPU configuration without P2P support between any pair of devices
 * does not support the unified memory counters
 */
public static native @Cast("CUptiResult") int cuptiActivityConfigureUnifiedMemoryCounter(CUpti_ActivityUnifiedMemoryCounterConfig config, @Cast("uint32_t") int count);

/**
 * \brief Get auto boost state
 *
 * The profiling results can be inconsistent in case auto boost is enabled.
 * CUPTI tries to disable auto boost while profiling. It can fail to disable in
 * cases where user does not have the permissions or CUDA_AUTO_BOOST env
 * variable is set. The function can be used to query whether auto boost is
 * enabled.
 *
 * @param context A valid CUcontext.
 * @param state A pointer to \ref CUpti_ActivityAutoBoostState structure which
 * contains the current state and the id of the process that has requested the
 * current state
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p CUcontext or \p state is NULL
 * \retval CUPTI_ERROR_NOT_SUPPORTED Indicates that the device does not support auto boost
 * \retval CUPTI_ERROR_UNKNOWN an internal error occurred
 */
public static native @Cast("CUptiResult") int cuptiGetAutoBoostState(CUctx_st context, CUpti_ActivityAutoBoostState state);

/**
 * \brief Set PC sampling configuration.
 *
 * For Pascal and older GPU architectures this API must be called before enabling
 * activity kind CUPTI_ACTIVITY_KIND_PC_SAMPLING. There is no such requirement
 * for Volta and newer GPU architectures.
 *
 * For Volta and newer GPU architectures if this API is called in the middle of
 * execution, PC sampling configuration will be updated for subsequent kernel launches.
 *
 * @param ctx The context
 * @param config A pointer to \ref CUpti_ActivityPCSamplingConfig structure
 * containing PC sampling configuration.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_OPERATION if this api is called while
 * some valid event collection method is set.
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p config is NULL or
 * any parameter in the \p config structures is not a valid value
 * \retval CUPTI_ERROR_NOT_SUPPORTED Indicates that the system/device
 * does not support the unified memory counters
 */
public static native @Cast("CUptiResult") int cuptiActivityConfigurePCSampling(CUctx_st ctx, CUpti_ActivityPCSamplingConfig config);

/**
 * \brief Returns the last error from a cupti call or callback
 *
 * Returns the last error that has been produced by any of the cupti api calls
 * or the callback in the same host thread and resets it to CUPTI_SUCCESS.
 */
public static native @Cast("CUptiResult") int cuptiGetLastError();

/**
 * \brief Set the thread-id type
 *
 * CUPTI uses the method corresponding to set type to generate the thread-id.
 * See enum \ref CUpti_ActivityThreadIdType for the list of methods.
 * Activity records having thread-id field contain the same value.
 * Thread id type must not be changed during the profiling session to
 * avoid thread-id value mismatch across activity records.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_SUPPORTED if \p type is not supported on the platform
 */
public static native @Cast("CUptiResult") int cuptiSetThreadIdType(@Cast("CUpti_ActivityThreadIdType") int type);

/**
 * \brief Get the thread-id type
 *
 * Returns the thread-id type used in CUPTI
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p type is NULL
  */
public static native @Cast("CUptiResult") int cuptiGetThreadIdType(@Cast("CUpti_ActivityThreadIdType*") IntPointer type);
public static native @Cast("CUptiResult") int cuptiGetThreadIdType(@Cast("CUpti_ActivityThreadIdType*") IntBuffer type);
public static native @Cast("CUptiResult") int cuptiGetThreadIdType(@Cast("CUpti_ActivityThreadIdType*") int[] type);

/**
* \brief Check support for a compute capability
*
* This function is used to check the support for a device based on
* it's compute capability. It sets the \p support when the compute
* capability is supported by the current version of CUPTI, and clears
* it otherwise. This version of CUPTI might not support all GPUs sharing
* the same compute capability. It is suggested to use API \ref
* cuptiDeviceSupported which provides correct information.
*
* @param major The major revision number of the compute capability
* @param minor The minor revision number of the compute capability
* @param support Pointer to an integer to return the support status
*
* \retval CUPTI_SUCCESS
* \retval CUPTI_ERROR_INVALID_PARAMETER if \p support is NULL
*
* @see ::cuptiDeviceSupported
*/
public static native @Cast("CUptiResult") int cuptiComputeCapabilitySupported(int major, int minor, IntPointer support);
public static native @Cast("CUptiResult") int cuptiComputeCapabilitySupported(int major, int minor, IntBuffer support);
public static native @Cast("CUptiResult") int cuptiComputeCapabilitySupported(int major, int minor, int[] support);

/**
* \brief Check support for a compute device
*
* This function is used to check the support for a compute device.
* It sets the \p support when the device is supported by the current
* version of CUPTI, and clears it otherwise.
*
* @param dev The device handle returned by CUDA Driver API cuDeviceGet
* @param support Pointer to an integer to return the support status
*
* \retval CUPTI_SUCCESS
* \retval CUPTI_ERROR_INVALID_PARAMETER if \p support is NULL
* \retval CUPTI_ERROR_INVALID_DEVICE if \p dev is not a valid device
*
* @see ::cuptiComputeCapabilitySupported
*/
public static native @Cast("CUptiResult") int cuptiDeviceSupported(@Cast("CUdevice") int dev, IntPointer support);
public static native @Cast("CUptiResult") int cuptiDeviceSupported(@Cast("CUdevice") int dev, IntBuffer support);
public static native @Cast("CUptiResult") int cuptiDeviceSupported(@Cast("CUdevice") int dev, int[] support);

/**
 * This indicates the virtualization mode in which CUDA device is running
 */
/** enum CUpti_DeviceVirtualizationMode */
public static final int
  /**
   * No virtualization mode is associated with the device
   * i.e. it's a baremetal GPU
   */
  CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE = 0,
  /**
   * The device is associated with the pass-through GPU.
   * In this mode, an entire physical GPU is directly assigned
   * to one virtual machine (VM).
   */
  CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH = 1,
  /**
   * The device is associated with the virtual GPU (vGPU).
   * In this mode multiple virtual machines (VMs) have simultaneous,
   * direct access to a single physical GPU.
   */
  CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU = 2,

  CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT = 0x7fffffff;

/**
 * \brief Query the virtualization mode of the device
 *
 * This function is used to query the virtualization mode of the CUDA device.
 *
 * @param dev The device handle returned by CUDA Driver API cuDeviceGet
 * @param mode Pointer to an CUpti_DeviceVirtualizationMode to return the virtualization mode
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_DEVICE if \p dev is not a valid device
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p mode is NULL
 *
 */
public static native @Cast("CUptiResult") int cuptiDeviceVirtualizationMode(@Cast("CUdevice") int dev, @Cast("CUpti_DeviceVirtualizationMode*") IntPointer mode);
public static native @Cast("CUptiResult") int cuptiDeviceVirtualizationMode(@Cast("CUdevice") int dev, @Cast("CUpti_DeviceVirtualizationMode*") IntBuffer mode);
public static native @Cast("CUptiResult") int cuptiDeviceVirtualizationMode(@Cast("CUdevice") int dev, @Cast("CUpti_DeviceVirtualizationMode*") int[] mode);

/**
 * \brief Detach CUPTI from the running process
 *
 * This API detaches the CUPTI from the running process. It destroys and cleans up all the
 * resources associated with CUPTI in the current process. After CUPTI detaches from the process,
 * the process will keep on running with no CUPTI attached to it.
 * For safe operation of the API, it is recommended this API is invoked from the exit callsite
 * of any of the CUDA Driver or Runtime API. Otherwise CUPTI client needs to make sure that
 * required CUDA synchronization and CUPTI activity buffer flush is done before calling the API.
 * Sample code showing the usage of the API in the cupti callback handler code:
 * <pre>{@code
  void CUPTIAPI
  cuptiCallbackHandler(void *userdata, CUpti_CallbackDomain domain,
      CUpti_CallbackId cbid, void *cbdata)
  {
    const CUpti_CallbackData *cbInfo = (CUpti_CallbackData *)cbdata;

    // Take this code path when CUPTI detach is requested
    if (detachCupti) {
      switch(domain)
      {
        case CUPTI_CB_DOMAIN_RUNTIME_API:
        case CUPTI_CB_DOMAIN_DRIVER_API:
          if (cbInfo->callbackSite == CUPTI_API_EXIT) {
              // call the CUPTI detach API
              cuptiFinalize();
          }
          break;
        default:
          break;
      }
    }
  }
 }</pre>
 */
public static native @Cast("CUptiResult") int cuptiFinalize();

/**
 * \brief Push an external correlation id for the calling thread
 *
 * This function notifies CUPTI that the calling thread is entering an external API region.
 * When a CUPTI activity API record is created while within an external API region and
 * CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION is enabled, the activity API record will
 * be preceded by a CUpti_ActivityExternalCorrelation record for each \ref CUpti_ExternalCorrelationKind.
 *
 * @param kind The kind of external API activities should be correlated with.
 * @param id External correlation id.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER The external API kind is invalid
 */
public static native @Cast("CUptiResult") int cuptiActivityPushExternalCorrelationId(@Cast("CUpti_ExternalCorrelationKind") int kind, @Cast("uint64_t") long id);

/**
 * \brief Pop an external correlation id for the calling thread
 *
 * This function notifies CUPTI that the calling thread is leaving an external API region.
 *
 * @param kind The kind of external API activities should be correlated with.
 * @param lastId If the function returns successful, contains the last external correlation id for this \p kind, can be NULL.
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER The external API kind is invalid.
 * \retval CUPTI_ERROR_QUEUE_EMPTY No external id is currently associated with \p kind.
 */
public static native @Cast("CUptiResult") int cuptiActivityPopExternalCorrelationId(@Cast("CUpti_ExternalCorrelationKind") int kind, @Cast("uint64_t*") LongPointer lastId);
public static native @Cast("CUptiResult") int cuptiActivityPopExternalCorrelationId(@Cast("CUpti_ExternalCorrelationKind") int kind, @Cast("uint64_t*") LongBuffer lastId);
public static native @Cast("CUptiResult") int cuptiActivityPopExternalCorrelationId(@Cast("CUpti_ExternalCorrelationKind") int kind, @Cast("uint64_t*") long[] lastId);

/**
 * \brief Controls the collection of queued and submitted timestamps for kernels.
 *
 * This API is used to control the collection of queued and submitted timestamps
 * for kernels whose records are provided through the struct \ref CUpti_ActivityKernel9.
 * Default value is 0, i.e. these timestamps are not collected. This API needs
 * to be called before initialization of CUDA and this setting should not be
 * changed during the profiling session.
 *
 * @param enable is a boolean, denoting whether these timestamps should be
 * collected
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableLatencyTimestamps(@Cast("uint8_t") byte enable);

/**
 * \brief Sets the flush period for the worker thread
 *
 * CUPTI creates a worker thread to minimize the perturbance for the application created
 * threads. CUPTI offloads certain operations from the application threads to the worker
 * thread, this includes synchronization of profiling resources between host and device,
 * delivery of the activity buffers to the client using the callback registered in
 * cuptiActivityRegisterCallbacks. For performance reasons, CUPTI wakes up the worker
 * thread based on certain heuristics.
 *
 * This API is used to control the flush period of the worker thread. This setting will
 * override the CUPTI heuristics. Setting time to zero disables the periodic flush and
 * restores the default behavior.
 *
 * Periodic flush can return only those activity buffers which are full and have all the
 * activity records completed.
 *
 * It's allowed to use the API \ref cuptiActivityFlushAll to flush the data on-demand, even
 * when client sets the periodic flush.
 *
 * @param time flush period in milliseconds (ms)
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 *
 * @see cuptiActivityFlushAll
 */
public static native @Cast("CUptiResult") int cuptiActivityFlushPeriod(@Cast("uint32_t") int time);

/**
 * \brief Controls the collection of launch attributes for kernels.
 *
 * This API is used to control the collection of launch attributes for kernels whose
 * records are provided through the struct \ref CUpti_ActivityKernel9.
 * Default value is 0, i.e. these attributes are not collected.
 *
 * @param enable is a boolean denoting whether these launch attributes should be collected
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableLaunchAttributes(@Cast("uint8_t") byte enable);
// Targeting ..\cupti\CUpti_TimestampCallbackFunc.java



/**
 * \brief Registers callback function with CUPTI for providing timestamp.
 *
 * This function registers a callback function to obtain timestamp of user's
 * choice instead of using CUPTI provided timestamp.
 * By default CUPTI uses different methods, based on the underlying platform,
 * to retrieve the timestamp
 * Linux and Android use clock_gettime(CLOCK_REALTIME, ..)
 * Windows uses QueryPerformanceCounter()
 * Mac uses mach_absolute_time()
 * QNX uses ClockCycles()
 * Timestamps retrieved using these methods are converted to nanosecond if needed
 * before usage.
 *
 * The registration of timestamp callback should be done before any of the CUPTI
 * activity kinds are enabled to make sure that all the records report the timestamp using
 * the callback function registered through cuptiActivityRegisterTimestampCallback API.
 *
 * Changing the timestamp callback function in CUPTI through
 * cuptiActivityRegisterTimestampCallback API in the middle of the profiling
 * session can cause records generated prior to the change to report
 * timestamps through previous timestamp method.
 *
 * @param funcTimestamp callback which is invoked when a timestamp is
 * needed by CUPTI
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p funcTimestamp is NULL
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 */
public static native @Cast("CUptiResult") int cuptiActivityRegisterTimestampCallback(CUpti_TimestampCallbackFunc funcTimestamp);

/**
 * \brief Controls the collection of records for device launched graphs.
 *
 * This API is used to control the collection of records for device launched graphs.
 * Default value is 0, i.e. these records are not collected. This API needs
 * to be called before initialization of CUDA and this setting should not be
 * changed during the profiling session.
 *
 * @param enable is a boolean, denoting whether these records should be
 * collected
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableDeviceGraph(@Cast("uint8_t") byte enable);

/**
 * \brief Controls the collection of activity records for specific CUDA Driver APIs.
 *
 * Activity kind CUPTI_ACTIVITY_KIND_DRIVER controls the collection of either all
 * CUDA Driver APIs or none. API cuptiActivityEnableDriverApi can be used for fine-grained
 * control, it allows enabling/disabling tracing of a specific set of CUDA Driver APIs.
 * To disable collection of a small set of CUDA Driver APIs, user can
 * first enable the collection of all Driver APIs using the activity kind
 * CUPTI_ACTIVITY_KIND_DRIVER and call this API to disable specific Driver APIs.
 * And to enable the collection of a small set of CUDA Driver APIs, user can
 * call this API without using the activity kind CUPTI_ACTIVITY_KIND_DRIVER.
 *
 * Note: Activity kind CUPTI_ACTIVITY_KIND_DRIVER overrides the settings done by this API
 * if it is called after the API.
 *
 * @param cbid callback id of the CUDA Driver API. This can be found in the header cupti_driver_cbid.h.
 * @param enable is a boolean, denoting whether to enable or disable the collection
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableDriverApi(@Cast("CUpti_CallbackId") int cbid, @Cast("uint8_t") byte enable);

/**
 * \brief Controls the collection of activity records for specific CUDA Runtime APIs.
 *
 * Activity kind CUPTI_ACTIVITY_KIND_RUNTIME controls the collection of either all
 * CUDA Runtime APIs or none. API cuptiActivityEnableRuntimeApi can be used for fine-grained
 * control, it allows enabling/disabling tracing of a specific set of CUDA Runtime APIs.
 * To disable collection of a small set of CUDA Runtime APIs, user can
 * first enable the collection of all Runtime APIs using the activity kind
 * CUPTI_ACTIVITY_KIND_RUNTIME and call this API to disable specific Runtime APIs.
 * And to enable the collection of a small set of CUDA Runtime APIs, user can
 * call this API without using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME.
 *
 * Note: Activity kind CUPTI_ACTIVITY_KIND_RUNTIME overrides the settings done by this API
 * if it is called after the API.
 *
 * @param cbid callback id of the CUDA Runtime API. This can be found in the header cupti_runtime_cbid.h.
 * @param enable is a boolean, denoting whether to enable or disable the collection
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 */
public static native @Cast("CUptiResult") int cuptiActivityEnableRuntimeApi(@Cast("CUpti_CallbackId") int cbid, @Cast("uint8_t") byte enable);



/** \} */ /* END CUPTI_ACTIVITY_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// Including deprecated structures of CUPTI_ACTIVITY_API
// #include "cupti_activity_deprecated.h"

// #endif /*_CUPTI_ACTIVITY_H_*/


// Parsed from cupti_callbacks.h

/*
 * Copyright 2010-2023 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(__CUPTI_CALLBACKS_H__)
// #define __CUPTI_CALLBACKS_H__

// #include <cuda.h>
// #include <builtin_types.h>
// #include <string.h>
// #include <cuda_stdint.h>
// #include <cupti_result.h>

// #ifndef CUPTIAPI
// #ifdef _WIN32
// #define CUPTIAPI __stdcall
// #else
// #define CUPTIAPI
// #endif
// #endif

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/**
 * \defgroup CUPTI_CALLBACK_API CUPTI Callback API
 * Functions, types, and enums that implement the CUPTI Callback API.
 * \{
 */

/**
 * \brief Specifies the point in an API call that a callback is issued.
 *
 * Specifies the point in an API call that a callback is issued. This
 * value is communicated to the callback function via \ref
 * CUpti_CallbackData::callbackSite.
 */
/** enum CUpti_ApiCallbackSite */
public static final int
  /**
   * The callback is at the entry of the API call.
   */
  CUPTI_API_ENTER                 = 0,
  /**
   * The callback is at the exit of the API call.
   */
  CUPTI_API_EXIT                  = 1,
  CUPTI_API_CBSITE_FORCE_INT     = 0x7fffffff;

/**
 * \brief Callback domains.
 *
 * Callback domains. Each domain represents callback points for a
 * group of related API functions or CUDA driver activity.
 */
/** enum CUpti_CallbackDomain */
public static final int
  /**
   * Invalid domain.
   */
  CUPTI_CB_DOMAIN_INVALID           = 0,
  /**
   * Domain containing callback points for all driver API functions.
   */
  CUPTI_CB_DOMAIN_DRIVER_API        = 1,
  /**
   * Domain containing callback points for all runtime API
   * functions.
   */
  CUPTI_CB_DOMAIN_RUNTIME_API       = 2,
  /**
   * Domain containing callback points for CUDA resource tracking.
   */
  CUPTI_CB_DOMAIN_RESOURCE          = 3,
  /**
   * Domain containing callback points for CUDA synchronization.
   */
  CUPTI_CB_DOMAIN_SYNCHRONIZE       = 4,
  /**
   * Domain containing callback points for NVTX API functions.
   */
  CUPTI_CB_DOMAIN_NVTX              = 5,
  /**
   * Domain containing callback points for various states.
   */
  CUPTI_CB_DOMAIN_STATE             = 6,

  CUPTI_CB_DOMAIN_SIZE = 7,

  CUPTI_CB_DOMAIN_FORCE_INT         = 0x7fffffff;

/**
 * \brief Callback IDs for resource domain.
 *
 * Callback IDs for resource domain, CUPTI_CB_DOMAIN_RESOURCE.  This
 * value is communicated to the callback function via the \p cbid
 * parameter.
 */
/** enum CUpti_CallbackIdResource */
public static final int
  /**
   * Invalid resource callback ID.
   */
  CUPTI_CBID_RESOURCE_INVALID                               = 0,
  /**
   * A new context has been created.
   */
  CUPTI_CBID_RESOURCE_CONTEXT_CREATED                       = 1,
  /**
   * A context is about to be destroyed.
   */
  CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING              = 2,
  /**
   * A new stream has been created.
   */
  CUPTI_CBID_RESOURCE_STREAM_CREATED                        = 3,
  /**
   * A stream is about to be destroyed.
   */
  CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING               = 4,
  /**
   * The driver has finished initializing.
   */
  CUPTI_CBID_RESOURCE_CU_INIT_FINISHED                      = 5,
  /**
   * A module has been loaded.
   */
  CUPTI_CBID_RESOURCE_MODULE_LOADED                         = 6,
  /**
   * A module is about to be unloaded.
   */
  CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING                = 7,
  /**
   * The current module which is being profiled.
   */
  CUPTI_CBID_RESOURCE_MODULE_PROFILED                       = 8,
  /**
   * CUDA graph has been created.
   */
  CUPTI_CBID_RESOURCE_GRAPH_CREATED                         = 9,
  /**
   * CUDA graph is about to be destroyed.
   */
  CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING                = 10,
  /**
   * CUDA graph is cloned.
   */
  CUPTI_CBID_RESOURCE_GRAPH_CLONED                          = 11,
  /**
   * CUDA graph node is about to be created
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING             = 12,
  /**
   * CUDA graph node is created.
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED                     = 13,
  /**
   * CUDA graph node is about to be destroyed.
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING            = 14,
  /**
   * Dependency on a CUDA graph node is created.
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED          = 15,
  /**
   * Dependency on a CUDA graph node is destroyed.
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING = 16,
  /**
   * An executable CUDA graph is about to be created.
   */
  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING             = 17,
  /**
   * An executable CUDA graph is created.
   */
  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED                     = 18,
  /**
   * An executable CUDA graph is about to be destroyed.
   */
  CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING            = 19,
  /**
   * CUDA graph node is cloned.
   */
  CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED                      = 20,
  /**
   * CUDA stream attribute is changed.
   */
  CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED              = 21,

  CUPTI_CBID_RESOURCE_SIZE = 22,
  CUPTI_CBID_RESOURCE_FORCE_INT                   = 0x7fffffff;

/**
 * \brief Callback IDs for synchronization domain.
 *
 * Callback IDs for synchronization domain,
 * CUPTI_CB_DOMAIN_SYNCHRONIZE.  This value is communicated to the
 * callback function via the \p cbid parameter.
 */
/** enum CUpti_CallbackIdSync */
public static final int
  /**
   * Invalid synchronize callback ID.
   */
  CUPTI_CBID_SYNCHRONIZE_INVALID                  = 0,
  /**
   * Stream synchronization has completed for the stream.
   */
  CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED      = 1,
  /**
   * Context synchronization has completed for the context.
   */
  CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED     = 2,
  CUPTI_CBID_SYNCHRONIZE_SIZE = 3,
  CUPTI_CBID_SYNCHRONIZE_FORCE_INT                = 0x7fffffff;


/**
 * \brief Callback IDs for state domain.
 *
 * Callback IDs for state domain,
 * CUPTI_CB_DOMAIN_STATE. This value is communicated to the
 * callback function via the \p cbid parameter.
 */
/** enum CUpti_CallbackIdState */
public static final int
  /**
   * Invalid state callback ID.
   */
  CUPTI_CBID_STATE_INVALID                        = 0,
  /**
   * Notification of fatal errors - high impact, non-recoverable
   * When encountered, CUPTI automatically invokes cuptiFinalize()
   * User can control behavior of the application in future from 
   * receiving this callback - such as continuing without profiling, or
   * terminating the whole application.
   */
  CUPTI_CBID_STATE_FATAL_ERROR                    = 1,
  /**
   * Notification of non fatal errors - high impact, but recoverable
   * This notification is not issued in the current release.
   */
  CUPTI_CBID_STATE_ERROR                          = 2,
  /**
   * Notification of warnings - low impact, recoverable
   * This notification is not issued in the current release.
   */
  CUPTI_CBID_STATE_WARNING                        = 3,

  CUPTI_CBID_STATE_SIZE = 4,
  CUPTI_CBID_STATE_FORCE_INT         = 0x7fffffff;
// Targeting ..\cupti\CUpti_CallbackData.java


// Targeting ..\cupti\CUpti_ResourceData.java


// Targeting ..\cupti\CUpti_ModuleResourceData.java


// Targeting ..\cupti\CUpti_GraphData.java


// Targeting ..\cupti\CUpti_SynchronizeData.java


// Targeting ..\cupti\CUpti_NvtxData.java


// Targeting ..\cupti\CUpti_StreamAttrData.java


// Targeting ..\cupti\CUpti_StateData.java



/**
 * \brief An ID for a driver API, runtime API, resource or
 * synchronization callback.
 *
 * An ID for a driver API, runtime API, resource or synchronization
 * callback. Within a driver API callback this should be interpreted
 * as a CUpti_driver_api_trace_cbid value (these values are defined in
 * cupti_driver_cbid.h). Within a runtime API callback this should be
 * interpreted as a CUpti_runtime_api_trace_cbid value (these values
 * are defined in cupti_runtime_cbid.h). Within a resource API
 * callback this should be interpreted as a \ref
 * CUpti_CallbackIdResource value. Within a synchronize API callback
 * this should be interpreted as a \ref CUpti_CallbackIdSync value.
 */
// Targeting ..\cupti\CUpti_CallbackFunc.java


// Targeting ..\cupti\CUpti_Subscriber_st.java



/**
 * \brief Pointer to an array of callback domains.
 */

/**
 * \brief Get the available callback domains.
 *
 * Returns in \p *domainTable an array of size \p *domainCount of all
 * the available callback domains.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param domainCount Returns number of callback domains
 * @param domainTable Returns pointer to array of available callback domains
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialize CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p domainCount or \p domainTable are NULL
 */
public static native @Cast("CUptiResult") int cuptiSupportedDomains(@Cast("size_t*") SizeTPointer domainCount,
                                           @Cast("CUpti_DomainTable*") IntPointer domainTable);
public static native @Cast("CUptiResult") int cuptiSupportedDomains(@Cast("size_t*") SizeTPointer domainCount,
                                           @Cast("CUpti_DomainTable*") IntBuffer domainTable);
public static native @Cast("CUptiResult") int cuptiSupportedDomains(@Cast("size_t*") SizeTPointer domainCount,
                                           @Cast("CUpti_DomainTable*") int[] domainTable);

/**
 * \brief Initialize a callback subscriber with a callback function
 * and user data.
 *
 * Initializes a callback subscriber with a callback function and
 * (optionally) a pointer to user data. The returned subscriber handle
 * can be used to enable and disable the callback for specific domains
 * and callback IDs.
 * \note Only a single subscriber can be registered at a time. To ensure
 * that no other CUPTI client interrupts the profiling session, it's the
 * responsibility of all the CUPTI clients to call this function before
 * starting the profling session. In case profiling session is already
 * started by another CUPTI client, this function returns the error code
 * CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED.
 * Note that this function returns the same error when application is
 * launched using NVIDIA tools like nvprof, Visual Profiler, Nsight Systems,
 * Nsight Compute, cuda-gdb and cuda-memcheck.
 * \note This function does not enable any callbacks.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param subscriber Returns handle to initialize subscriber
 * @param callback The callback function
 * @param userdata A pointer to user data. This data will be passed to
 * the callback function via the \p userdata parameter.
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialize CUPTI
 * \retval CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED if there is already a CUPTI subscriber
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p subscriber is NULL
 */
public static native @Cast("CUptiResult") int cuptiSubscribe(@ByPtrPtr CUpti_Subscriber_st subscriber,
                                    CUpti_CallbackFunc callback,
                                    Pointer userdata);

/**
 * \brief Unregister a callback subscriber.
 *
 * Removes a callback subscriber so that no future callbacks will be
 * issued to that subscriber.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param subscriber Handle to the initialize subscriber
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialized CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p subscriber is NULL or not initialized
 */
public static native @Cast("CUptiResult") int cuptiUnsubscribe(@ByPtr CUpti_Subscriber_st subscriber);

/**
 * \brief Get the current enabled/disabled state of a callback for a specific
 * domain and function ID.
 *
 * Returns non-zero in \p *enable if the callback for a domain and
 * callback ID is enabled, and zero if not enabled.
 *
 * \note \b Thread-safety: a subscriber must serialize access to
 * cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and
 * cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub,
 * d, c) and cuptiEnableCallback(sub, d, c) are called concurrently,
 * the results are undefined.
 *
 * @param enable Returns non-zero if callback enabled, zero if not enabled
 * @param subscriber Handle to the initialize subscriber
 * @param domain The domain of the callback
 * @param cbid The ID of the callback
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialized CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p enabled is NULL, or if \p
 * subscriber, \p domain or \p cbid is invalid.
 */
public static native @Cast("CUptiResult") int cuptiGetCallbackState(@Cast("uint32_t*") IntPointer enable,
                                           @ByPtr CUpti_Subscriber_st subscriber,
                                           @Cast("CUpti_CallbackDomain") int domain,
                                           @Cast("CUpti_CallbackId") int cbid);
public static native @Cast("CUptiResult") int cuptiGetCallbackState(@Cast("uint32_t*") IntBuffer enable,
                                           @ByPtr CUpti_Subscriber_st subscriber,
                                           @Cast("CUpti_CallbackDomain") int domain,
                                           @Cast("CUpti_CallbackId") int cbid);
public static native @Cast("CUptiResult") int cuptiGetCallbackState(@Cast("uint32_t*") int[] enable,
                                           @ByPtr CUpti_Subscriber_st subscriber,
                                           @Cast("CUpti_CallbackDomain") int domain,
                                           @Cast("CUpti_CallbackId") int cbid);

/**
 * \brief Enable or disabled callbacks for a specific domain and
 * callback ID.
 *
 * Enable or disabled callbacks for a subscriber for a specific domain
 * and callback ID.
 *
 * \note \b Thread-safety: a subscriber must serialize access to
 * cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and
 * cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub,
 * d, c) and cuptiEnableCallback(sub, d, c) are called concurrently,
 * the results are undefined.
 *
 * @param enable New enable state for the callback. Zero disables the
 * callback, non-zero enables the callback.
 * @param subscriber - Handle to callback subscription
 * @param domain The domain of the callback
 * @param cbid The ID of the callback
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialized CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p subscriber, \p domain or \p
 * cbid is invalid.
 */
public static native @Cast("CUptiResult") int cuptiEnableCallback(@Cast("uint32_t") int enable,
                                         @ByPtr CUpti_Subscriber_st subscriber,
                                         @Cast("CUpti_CallbackDomain") int domain,
                                         @Cast("CUpti_CallbackId") int cbid);

/**
 * \brief Enable or disabled all callbacks for a specific domain.
 *
 * Enable or disabled all callbacks for a specific domain.
 *
 * \note \b Thread-safety: a subscriber must serialize access to
 * cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and
 * cuptiEnableAllDomains. For example, if cuptiGetCallbackEnabled(sub,
 * d, *) and cuptiEnableDomain(sub, d) are called concurrently, the
 * results are undefined.
 *
 * @param enable New enable state for all callbacks in the
 * domain. Zero disables all callbacks, non-zero enables all
 * callbacks.
 * @param subscriber - Handle to callback subscription
 * @param domain The domain of the callback
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialized CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p subscriber or \p domain is invalid
 */
public static native @Cast("CUptiResult") int cuptiEnableDomain(@Cast("uint32_t") int enable,
                                       @ByPtr CUpti_Subscriber_st subscriber,
                                       @Cast("CUpti_CallbackDomain") int domain);

/**
 * \brief Enable or disable all callbacks in all domains.
 *
 * Enable or disable all callbacks in all domains.
 *
 * \note \b Thread-safety: a subscriber must serialize access to
 * cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and
 * cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub,
 * d, *) and cuptiEnableAllDomains(sub) are called concurrently, the
 * results are undefined.
 *
 * @param enable New enable state for all callbacks in all
 * domain. Zero disables all callbacks, non-zero enables all
 * callbacks.
 * @param subscriber - Handle to callback subscription
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_NOT_INITIALIZED if unable to initialized CUPTI
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p subscriber is invalid
 */
public static native @Cast("CUptiResult") int cuptiEnableAllDomains(@Cast("uint32_t") int enable,
                                           @ByPtr CUpti_Subscriber_st subscriber);

/**
 * \brief Get the name of a callback for a specific domain and callback ID.
 *
 * Returns a pointer to the name c_string in \p **name.
 *
 * \note \b Names are available only for the DRIVER and RUNTIME domains.
 *
 * @param domain The domain of the callback
 * @param cbid The ID of the callback
 * @param name Returns pointer to the name string on success, NULL otherwise
 *
 * \retval CUPTI_SUCCESS on success
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p name is NULL, or if
 * \p domain or \p cbid is invalid.
 */
public static native @Cast("CUptiResult") int cuptiGetCallbackName(@Cast("CUpti_CallbackDomain") int domain,
                                          @Cast("uint32_t") int cbid,
                                          @Cast("const char**") PointerPointer name);
public static native @Cast("CUptiResult") int cuptiGetCallbackName(@Cast("CUpti_CallbackDomain") int domain,
                                          @Cast("uint32_t") int cbid,
                                          @Cast("const char**") @ByPtrPtr BytePointer name);
public static native @Cast("CUptiResult") int cuptiGetCallbackName(@Cast("CUpti_CallbackDomain") int domain,
                                          @Cast("uint32_t") int cbid,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native @Cast("CUptiResult") int cuptiGetCallbackName(@Cast("CUpti_CallbackDomain") int domain,
                                          @Cast("uint32_t") int cbid,
                                          @Cast("const char**") @ByPtrPtr byte[] name);

/** \} */ /* END CUPTI_CALLBACK_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// #endif  // file guard



// Parsed from cupti_events.h

/*
 * Copyright 2010-2021 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(_CUPTI_EVENTS_H_)
// #define _CUPTI_EVENTS_H_

// #include <cuda.h>
// #include <string.h>
// #include <cuda_stdint.h>
// #include <cupti_result.h>

// #ifndef CUPTIAPI
// #ifdef _WIN32
// #define CUPTIAPI __stdcall
// #else
// #define CUPTIAPI
// #endif
// #endif

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/**
 * \defgroup CUPTI_EVENT_API CUPTI Event API
 * Functions, types, and enums that implement the CUPTI Event API.
 *
 * \note CUPTI event API from the header cupti_events.h are not supported on devices
 * with compute capability 7.5 and higher (i.e. Turing and later GPU architectures).
 * These API will be deprecated in a future CUDA release. These are replaced by
 * Profiling API in the header cupti_profiler_target.h and Perfworks metrics API
 * in the headers nvperf_host.h and nvperf_target.h which are supported on
 * devices with compute capability 7.0 and higher (i.e. Volta and later GPU
 * architectures).
 *
 * \{
 */

/**
 * \brief ID for an event.
 *
 * An event represents a countable activity, action, or occurrence on
 * the device.
 */

/**
 * \brief ID for an event domain.
 *
 * ID for an event domain. An event domain represents a group of
 * related events. A device may have multiple instances of a domain,
 * indicating that the device can simultaneously record multiple
 * instances of each event within that domain.
 */
// Targeting ..\cupti\CUpti_EventGroup.java



/**
 * \brief Device class.
 *
 * Enumeration of device classes for device attribute
 * CUPTI_DEVICE_ATTR_DEVICE_CLASS.
 */
/** enum CUpti_DeviceAttributeDeviceClass */
public static final int
  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA              = 0,
  CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO             = 1,
  CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE            = 2,
  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA              = 3;

/**
 * \brief Device attributes.
 *
 * CUPTI device attributes. These attributes can be read using \ref
 * cuptiDeviceGetAttribute.
 */
/** enum CUpti_DeviceAttribute */
public static final int
  /**
   * Number of event IDs for a device. Value is a uint32_t.
   */
  CUPTI_DEVICE_ATTR_MAX_EVENT_ID                            = 1,
  /**
   * Number of event domain IDs for a device. Value is a uint32_t.
   */
  CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID                     = 2,
  /**
   * Get global memory bandwidth in Kbytes/sec. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH                 = 3,
  /**
   * Get theoretical maximum number of instructions per cycle. Value
   * is a uint32_t.
   */
  CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE                   = 4,
  /**
   * Get theoretical maximum number of single precision instructions
   * that can be executed per second. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION = 5,
  /**
   * Get number of frame buffers for device.  Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS                       = 6,
  /**
   * Get PCIE link rate in Mega bits/sec for device. Return 0 if bus-type
   * is non-PCIE. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_PCIE_LINK_RATE                          = 7,
  /**
   * Get PCIE link width for device. Return 0 if bus-type
   * is non-PCIE. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH                         = 8,
  /**
   * Get PCIE generation for device. Return 0 if bus-type
   * is non-PCIE. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_PCIE_GEN                                = 9,
  /**
   * Get the class for the device. Value is a
   * CUpti_DeviceAttributeDeviceClass.
   */
  CUPTI_DEVICE_ATTR_DEVICE_CLASS                            = 10,
  /**
   * Get the peak single precision flop per cycle. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE                       = 11,
  /**
   * Get the peak double precision flop per cycle. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE                       = 12,
  /**
   * Get number of L2 units. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_MAX_L2_UNITS                           = 13,
  /**
   * Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_SHARED
   * preference. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED = 14,
  /**
   * Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_L1
   * preference. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1 = 15,
  /**
   * Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_EQUAL
   * preference. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL = 16,
  /**
   * Get the peak half precision flop per cycle. Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE                       = 17,
  /**
   * Check if Nvlink is connected to device. Returns 1, if at least one
   * Nvlink is connected to the device, returns 0 otherwise.
   * Value is a uint32_t.
   */
  CUPTI_DEVICE_ATTR_NVLINK_PRESENT                          = 18,
    /**
   * Check if Nvlink is present between GPU and CPU. Returns Bandwidth,
   * in Bytes/sec, if Nvlink is present, returns 0 otherwise.
   * Value is a uint64_t.
   */
  CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW                       = 19,
  /**
   * Check if NVSwitch is present in the underlying topology.
   * Returns 1, if present, returns 0 otherwise.
   * Value is a uint32_t.
   */
  CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT                        = 20,
  CUPTI_DEVICE_ATTR_FORCE_INT                               = 0x7fffffff;

/**
 * \brief Event domain attributes.
 *
 * Event domain attributes. Except where noted, all the attributes can
 * be read using either \ref cuptiDeviceGetEventDomainAttribute or
 * \ref cuptiEventDomainGetAttribute.
 */
/** enum CUpti_EventDomainAttribute */
public static final int
  /**
   * Event domain name. Value is a null terminated const c-string.
   */
  CUPTI_EVENT_DOMAIN_ATTR_NAME                 = 0,
  /**
   * Number of instances of the domain for which event counts will be
   * collected.  The domain may have additional instances that cannot
   * be profiled (see CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT).
   * Can be read only with \ref
   * cuptiDeviceGetEventDomainAttribute. Value is a uint32_t.
   */
  CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT       = 1,
  /**
   * Total number of instances of the domain, including instances that
   * cannot be profiled.  Use CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT
   * to get the number of instances that can be profiled. Can be read
   * only with \ref cuptiDeviceGetEventDomainAttribute. Value is a
   * uint32_t.
   */
  CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT = 3,
  /**
   * Collection method used for events contained in the event domain.
   * Value is a \ref CUpti_EventCollectionMethod.
   */
  CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD    = 4,

  CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT      = 0x7fffffff;

/**
 * \brief The collection method used for an event.
 *
 * The collection method indicates how an event is collected.
 */
/** enum CUpti_EventCollectionMethod */
public static final int
  /**
   * Event is collected using a hardware global performance monitor.
   */
  CUPTI_EVENT_COLLECTION_METHOD_PM                  = 0,
  /**
   * Event is collected using a hardware SM performance monitor.
   */
  CUPTI_EVENT_COLLECTION_METHOD_SM                  = 1,
  /**
   * Event is collected using software instrumentation.
   */
  CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED        = 2,
  /**
   * Event is collected using NvLink throughput counter method.
   */
  CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC           = 3,
  CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT           = 0x7fffffff;

/**
 * \brief Event group attributes.
 *
 * Event group attributes. These attributes can be read using \ref
 * cuptiEventGroupGetAttribute. Attributes marked [rw] can also be
 * written using \ref cuptiEventGroupSetAttribute.
 */
/** enum CUpti_EventGroupAttribute */
public static final int
  /**
   * The domain to which the event group is bound. This attribute is
   * set when the first event is added to the group.  Value is a
   * CUpti_EventDomainID.
   */
  CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID              = 0,
  /**
   * [rw] Profile all the instances of the domain for this
   * eventgroup. This feature can be used to get load balancing
   * across all instances of a domain. Value is an integer.
   */
  CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES = 1,
  /**
   * [rw] Reserved for user data.
   */
  CUPTI_EVENT_GROUP_ATTR_USER_DATA                    = 2,
  /**
   * Number of events in the group. Value is a uint32_t.
   */
  CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS                   = 3,
  /**
   * Enumerates events in the group. Value is a pointer to buffer of
   * size sizeof(CUpti_EventID) * num_of_events in the eventgroup.
   * num_of_events can be queried using
   * CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS.
   */
  CUPTI_EVENT_GROUP_ATTR_EVENTS                       = 4,
  /**
   * Number of instances of the domain bound to this event group that
   * will be counted.  Value is a uint32_t.
   */
  CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT               = 5,
  /**
   * Event group scope can be set to CUPTI_EVENT_PROFILING_SCOPE_DEVICE or
   * CUPTI_EVENT_PROFILING_SCOPE_CONTEXT for an eventGroup, before
   * adding any event.
   * Sets the scope of eventgroup as CUPTI_EVENT_PROFILING_SCOPE_DEVICE or
   * CUPTI_EVENT_PROFILING_SCOPE_CONTEXT when the scope of the events
   * that will be added is CUPTI_EVENT_PROFILING_SCOPE_BOTH.
   * If profiling scope of event is either
   * CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT
   * then setting this attribute will not affect the default scope.
   * It is not allowed to add events of different scope to same eventgroup.
   * Value is a uint32_t.
   */
  CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE               = 6,
  CUPTI_EVENT_GROUP_ATTR_FORCE_INT                     = 0x7fffffff;

/**
* \brief Profiling scope for event.
*
* Profiling scope of event indicates if the event can be collected at context
* scope or device scope or both i.e. it can be collected at any of context or
* device scope.
*/
/** enum CUpti_EventProfilingScope */
public static final int
  /**
   * Event is collected at context scope.
   */
  CUPTI_EVENT_PROFILING_SCOPE_CONTEXT                 = 0,
  /**
   * Event is collected at device scope.
   */
  CUPTI_EVENT_PROFILING_SCOPE_DEVICE                  = 1,
  /**
   * Event can be collected at device or context scope.
   * The scope can be set using \ref cuptiEventGroupSetAttribute API.
   */
  CUPTI_EVENT_PROFILING_SCOPE_BOTH                    = 2,
  CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT               = 0x7fffffff;

/**
 * \brief Event attributes.
 *
 * Event attributes. These attributes can be read using \ref
 * cuptiEventGetAttribute.
 */
/** enum CUpti_EventAttribute */
public static final int
  /**
   * Event name. Value is a null terminated const c-string.
   */
  CUPTI_EVENT_ATTR_NAME              = 0,
  /**
   * Short description of event. Value is a null terminated const
   * c-string.
   */
  CUPTI_EVENT_ATTR_SHORT_DESCRIPTION = 1,
  /**
   * Long description of event. Value is a null terminated const
   * c-string.
   */
  CUPTI_EVENT_ATTR_LONG_DESCRIPTION  = 2,
  /**
   * Category of event. Value is CUpti_EventCategory.
   */
  CUPTI_EVENT_ATTR_CATEGORY          = 3,
  /**
   * Profiling scope of the events. It can be either device or context or both.
   * Value is a \ref CUpti_EventProfilingScope.
   */
  CUPTI_EVENT_ATTR_PROFILING_SCOPE   = 5,

  CUPTI_EVENT_ATTR_FORCE_INT         = 0x7fffffff;

/**
 * \brief Event collection modes.
 *
 * The event collection mode determines the period over which the
 * events within the enabled event groups will be collected.
 */
/** enum CUpti_EventCollectionMode */
public static final int
  /**
   * Events are collected for the entire duration between the
   * cuptiEventGroupEnable and cuptiEventGroupDisable calls.
   * Event values are reset when the events are read.
   * For CUDA toolkit v6.0 and older this was the default mode.
   */
  CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS          = 0,
  /**
   * Events are collected only for the durations of kernel executions
   * that occur between the cuptiEventGroupEnable and
   * cuptiEventGroupDisable calls. Event collection begins when a
   * kernel execution begins, and stops when kernel execution
   * completes. Event values are reset to zero when each kernel
   * execution begins. If multiple kernel executions occur between the
   * cuptiEventGroupEnable and cuptiEventGroupDisable calls then the
   * event values must be read after each kernel launch if those
   * events need to be associated with the specific kernel launch.
   * Note that collection in this mode may significantly change the
   * overall performance characteristics of the application because
   * kernel executions that occur between the cuptiEventGroupEnable and
   * cuptiEventGroupDisable calls are serialized on the GPU.
   * This is the default mode from CUDA toolkit v6.5
   */
  CUPTI_EVENT_COLLECTION_MODE_KERNEL              = 1,
  CUPTI_EVENT_COLLECTION_MODE_FORCE_INT           = 0x7fffffff;

/**
 * \brief An event category.
 *
 * Each event is assigned to a category that represents the general
 * type of the event. A event's category is accessed using \ref
 * cuptiEventGetAttribute and the CUPTI_EVENT_ATTR_CATEGORY attribute.
 */
/** enum CUpti_EventCategory */
public static final int
  /**
   * An instruction related event.
   */
  CUPTI_EVENT_CATEGORY_INSTRUCTION     = 0,
  /**
   * A memory related event.
   */
  CUPTI_EVENT_CATEGORY_MEMORY          = 1,
  /**
   * A cache related event.
   */
  CUPTI_EVENT_CATEGORY_CACHE           = 2,
  /**
   * A profile-trigger event.
   */
  CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER = 3,
  /**
   * A system event.
   */
  CUPTI_EVENT_CATEGORY_SYSTEM  = 4,
  CUPTI_EVENT_CATEGORY_FORCE_INT       = 0x7fffffff;

/**
 * \brief The overflow value for a CUPTI event.
 *
 * The CUPTI event value that indicates an overflow.
 */
public static final long CUPTI_EVENT_OVERFLOW = ((long)0xFFFFFFFFFFFFFFFFL);

/**
 * \brief The value that indicates the event value is invalid
 */
public static final long CUPTI_EVENT_INVALID = ((long)0xFFFFFFFFFFFFFFFEL);

/**
 * \brief Flags for cuptiEventGroupReadEvent an
 * cuptiEventGroupReadAllEvents.
 *
 * Flags for \ref cuptiEventGroupReadEvent an \ref
 * cuptiEventGroupReadAllEvents.
 */
/** enum CUpti_ReadEventFlags */
public static final int
  /**
   * No flags.
   */
  CUPTI_EVENT_READ_FLAG_NONE          = 0,
  CUPTI_EVENT_READ_FLAG_FORCE_INT     = 0x7fffffff;
// Targeting ..\cupti\CUpti_EventGroupSet.java


// Targeting ..\cupti\CUpti_EventGroupSets.java



/**
 * \brief Set the event collection mode.
 *
 * Set the event collection mode for a \p context.  The \p mode
 * controls the event collection behavior of all events in event
 * groups created in the \p context. This API is invalid in kernel
 * replay mode.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param context The context
 * @param mode The event collection mode
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_CONTEXT
 * \retval CUPTI_ERROR_INVALID_OPERATION if called when replay mode is enabled
 * \retval CUPTI_ERROR_NOT_SUPPORTED if mode is not supported on the device
 */

public static native @Cast("CUptiResult") int cuptiSetEventCollectionMode(CUctx_st context,
                                                 @Cast("CUpti_EventCollectionMode") int mode);

/**
 * \brief Read a device attribute.
 *
 * Read a device attribute and return it in \p *value.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param device The CUDA device
 * @param attrib The attribute to read
 * @param valueSize Size of buffer pointed by the value, and
 * returns the number of bytes written to \p value
 * @param value Returns the value of the attribute
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not a device attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiDeviceGetAttribute(@Cast("CUdevice") int device,
                                             @Cast("CUpti_DeviceAttribute") int attrib,
                                             @Cast("size_t*") SizeTPointer valueSize,
                                             Pointer value);

/**
 * \brief Get the number of domains for a device.
 *
 * Returns the number of domains in \p numDomains for a device.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param device The CUDA device
 * @param numDomains Returns the number of domains
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numDomains is NULL
 */
public static native @Cast("CUptiResult") int cuptiDeviceGetNumEventDomains(@Cast("CUdevice") int device,
                                                   @Cast("uint32_t*") IntPointer numDomains);
public static native @Cast("CUptiResult") int cuptiDeviceGetNumEventDomains(@Cast("CUdevice") int device,
                                                   @Cast("uint32_t*") IntBuffer numDomains);
public static native @Cast("CUptiResult") int cuptiDeviceGetNumEventDomains(@Cast("CUdevice") int device,
                                                   @Cast("uint32_t*") int[] numDomains);

/**
 * \brief Get the event domains for a device.
 *
 * Returns the event domains IDs in \p domainArray for a device.  The
 * size of the \p domainArray buffer is given by \p
 * *arraySizeBytes. The size of the \p domainArray buffer must be at
 * least \p numdomains * sizeof(CUpti_EventDomainID) or else all
 * domains will not be returned. The value returned in \p
 * *arraySizeBytes contains the number of bytes returned in \p
 * domainArray.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param device The CUDA device
 * @param arraySizeBytes The size of \p domainArray in bytes, and
 * returns the number of bytes written to \p domainArray
 * @param domainArray Returns the IDs of the event domains for the device
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p arraySizeBytes or
 * \p domainArray are NULL
 */
public static native @Cast("CUptiResult") int cuptiDeviceEnumEventDomains(@Cast("CUdevice") int device,
                                                 @Cast("size_t*") SizeTPointer arraySizeBytes,
                                                 @Cast("CUpti_EventDomainID*") IntPointer domainArray);
public static native @Cast("CUptiResult") int cuptiDeviceEnumEventDomains(@Cast("CUdevice") int device,
                                                 @Cast("size_t*") SizeTPointer arraySizeBytes,
                                                 @Cast("CUpti_EventDomainID*") int[] domainArray);

/**
 * \brief Read an event domain attribute.
 *
 * Returns an event domain attribute in \p *value. The size of the \p
 * value buffer is given by \p *valueSize. The value returned in \p
 * *valueSize contains the number of bytes returned in \p value.
 *
 * If the attribute value is a c-string that is longer than \p
 * *valueSize, then only the first \p *valueSize characters will be
 * returned and there will be no terminating null byte.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param device The CUDA device
 * @param eventDomain ID of the event domain
 * @param attrib The event domain attribute to read
 * @param valueSize The size of the \p value buffer in bytes, and
 * returns the number of bytes written to \p value
 * @param value Returns the attribute's value
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not an event domain attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiDeviceGetEventDomainAttribute(@Cast("CUdevice") int device,
                                                        @Cast("CUpti_EventDomainID") int eventDomain,
                                                        @Cast("CUpti_EventDomainAttribute") int attrib,
                                                        @Cast("size_t*") SizeTPointer valueSize,
                                                        Pointer value);

/**
 * \brief Get the number of event domains available on any device.
 *
 * Returns the total number of event domains available on any
 * CUDA-capable device.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param numDomains Returns the number of domains
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numDomains is NULL
 */
public static native @Cast("CUptiResult") int cuptiGetNumEventDomains(@Cast("uint32_t*") IntPointer numDomains);
public static native @Cast("CUptiResult") int cuptiGetNumEventDomains(@Cast("uint32_t*") IntBuffer numDomains);
public static native @Cast("CUptiResult") int cuptiGetNumEventDomains(@Cast("uint32_t*") int[] numDomains);

/**
 * \brief Get the event domains available on any device.
 *
 * Returns all the event domains available on any CUDA-capable device.
 * Event domain IDs are returned in \p domainArray. The size of the \p
 * domainArray buffer is given by \p *arraySizeBytes. The size of the
 * \p domainArray buffer must be at least \p numDomains *
 * sizeof(CUpti_EventDomainID) or all domains will not be
 * returned. The value returned in \p *arraySizeBytes contains the
 * number of bytes returned in \p domainArray.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param arraySizeBytes The size of \p domainArray in bytes, and
 * returns the number of bytes written to \p domainArray
 * @param domainArray Returns all the event domains
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p arraySizeBytes or
 * \p domainArray are NULL
 */
public static native @Cast("CUptiResult") int cuptiEnumEventDomains(@Cast("size_t*") SizeTPointer arraySizeBytes,
                                           @Cast("CUpti_EventDomainID*") IntPointer domainArray);
public static native @Cast("CUptiResult") int cuptiEnumEventDomains(@Cast("size_t*") SizeTPointer arraySizeBytes,
                                           @Cast("CUpti_EventDomainID*") int[] domainArray);

/**
 * \brief Read an event domain attribute.
 *
 * Returns an event domain attribute in \p *value. The size of the \p
 * value buffer is given by \p *valueSize. The value returned in \p
 * *valueSize contains the number of bytes returned in \p value.
 *
 * If the attribute value is a c-string that is longer than \p
 * *valueSize, then only the first \p *valueSize characters will be
 * returned and there will be no terminating null byte.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventDomain ID of the event domain
 * @param attrib The event domain attribute to read
 * @param valueSize The size of the \p value buffer in bytes, and
 * returns the number of bytes written to \p value
 * @param value Returns the attribute's value
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not an event domain attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiEventDomainGetAttribute(@Cast("CUpti_EventDomainID") int eventDomain,
                                                  @Cast("CUpti_EventDomainAttribute") int attrib,
                                                  @Cast("size_t*") SizeTPointer valueSize,
                                                  Pointer value);

/**
 * \brief Get number of events in a domain.
 *
 * Returns the number of events in \p numEvents for a domain.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventDomain ID of the event domain
 * @param numEvents Returns the number of events in the domain
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numEvents is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventDomainGetNumEvents(@Cast("CUpti_EventDomainID") int eventDomain,
                                                  @Cast("uint32_t*") IntPointer numEvents);
public static native @Cast("CUptiResult") int cuptiEventDomainGetNumEvents(@Cast("CUpti_EventDomainID") int eventDomain,
                                                  @Cast("uint32_t*") IntBuffer numEvents);
public static native @Cast("CUptiResult") int cuptiEventDomainGetNumEvents(@Cast("CUpti_EventDomainID") int eventDomain,
                                                  @Cast("uint32_t*") int[] numEvents);

/**
 * \brief Get the events in a domain.
 *
 * Returns the event IDs in \p eventArray for a domain.  The size of
 * the \p eventArray buffer is given by \p *arraySizeBytes. The size
 * of the \p eventArray buffer must be at least \p numdomainevents *
 * sizeof(CUpti_EventID) or else all events will not be returned. The
 * value returned in \p *arraySizeBytes contains the number of bytes
 * returned in \p eventArray.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventDomain ID of the event domain
 * @param arraySizeBytes The size of \p eventArray in bytes, and
 * returns the number of bytes written to \p eventArray
 * @param eventArray Returns the IDs of the events in the domain
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p arraySizeBytes or \p
 * eventArray are NULL
 */
public static native @Cast("CUptiResult") int cuptiEventDomainEnumEvents(@Cast("CUpti_EventDomainID") int eventDomain,
                                                @Cast("size_t*") SizeTPointer arraySizeBytes,
                                                @Cast("CUpti_EventID*") IntPointer eventArray);
public static native @Cast("CUptiResult") int cuptiEventDomainEnumEvents(@Cast("CUpti_EventDomainID") int eventDomain,
                                                @Cast("size_t*") SizeTPointer arraySizeBytes,
                                                @Cast("CUpti_EventID*") int[] eventArray);

/**
 * \brief Get an event attribute.
 *
 * Returns an event attribute in \p *value. The size of the \p
 * value buffer is given by \p *valueSize. The value returned in \p
 * *valueSize contains the number of bytes returned in \p value.
 *
 * If the attribute value is a c-string that is longer than \p
 * *valueSize, then only the first \p *valueSize characters will be
 * returned and there will be no terminating null byte.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param event ID of the event
 * @param attrib The event attribute to read
 * @param valueSize The size of the \p value buffer in bytes, and
 * returns the number of bytes written to \p value
 * @param value Returns the attribute's value
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not an event attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiEventGetAttribute(@Cast("CUpti_EventID") int event,
                                            @Cast("CUpti_EventAttribute") int attrib,
                                            @Cast("size_t*") SizeTPointer valueSize,
                                            Pointer value);

/**
 * \brief Find an event by name.
 *
 * Find an event by name and return the event ID in \p *event.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param device The CUDA device
 * @param eventName The name of the event to find
 * @param event Returns the ID of the found event or undefined if
 * unable to find the event
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_EVENT_NAME if unable to find an event
 * with name \p eventName. In this case \p *event is undefined
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventName or \p event are NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGetIdFromName(@Cast("CUdevice") int device,
                                             @Cast("const char*") BytePointer eventName,
                                             @Cast("CUpti_EventID*") IntPointer event);
public static native @Cast("CUptiResult") int cuptiEventGetIdFromName(@Cast("CUdevice") int device,
                                             String eventName,
                                             @Cast("CUpti_EventID*") int[] event);

/**
 * \brief Create a new event group for a context.
 *
 * Creates a new event group for \p context and returns the new group
 * in \p *eventGroup.
 * \note \p flags are reserved for future use and should be set to zero.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param context The context for the event group
 * @param eventGroup Returns the new event group
 * @param flags Reserved - must be zero
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_CONTEXT
 * \retval CUPTI_ERROR_OUT_OF_MEMORY
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupCreate(CUctx_st context,
                                           @ByPtrPtr CUpti_EventGroup eventGroup,
                                           @Cast("uint32_t") int flags);

/**
 * \brief Destroy an event group.
 *
 * Destroy an \p eventGroup and free its resources. An event group
 * cannot be destroyed if it is enabled.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group to destroy
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_OPERATION if the event group is enabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupDestroy(CUpti_EventGroup eventGroup);

/**
 * \brief Read an event group attribute.
 *
 * Read an event group attribute and return it in \p *value.
 * \note \b Thread-safety: this function is thread safe but client
 * must guard against simultaneous destruction or modification of \p
 * eventGroup (for example, client must guard against simultaneous
 * calls to \ref cuptiEventGroupDestroy, \ref cuptiEventGroupAddEvent,
 * etc.), and must guard against simultaneous destruction of the
 * context in which \p eventGroup was created (for example, client
 * must guard against simultaneous calls to cudaDeviceReset,
 * cuCtxDestroy, etc.).
 *
 * @param eventGroup The event group
 * @param attrib The attribute to read
 * @param valueSize Size of buffer pointed by the value, and
 * returns the number of bytes written to \p value
 * @param value Returns the value of the attribute
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not an eventgroup attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiEventGroupGetAttribute(CUpti_EventGroup eventGroup,
                                                 @Cast("CUpti_EventGroupAttribute") int attrib,
                                                 @Cast("size_t*") SizeTPointer valueSize,
                                                 Pointer value);

/**
 * \brief Write an event group attribute.
 *
 * Write an event group attribute.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 * @param attrib The attribute to write
 * @param valueSize The size, in bytes, of the value
 * @param value The attribute value to write
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not an event group attribute, or if
 * \p attrib is not a writable attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT Indicates that
 * the \p value buffer is too small to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiEventGroupSetAttribute(CUpti_EventGroup eventGroup,
                                                 @Cast("CUpti_EventGroupAttribute") int attrib,
                                                 @Cast("size_t") long valueSize,
                                                 Pointer value);

/**
 * \brief Add an event to an event group.
 *
 * Add an event to an event group. The event add can fail for a number of reasons:
 * \li The event group is enabled
 * \li The event does not belong to the same event domain as the
 * events that are already in the event group
 * \li Device limitations on the events that can belong to the same group
 * \li The event group is full
 *
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 * @param event The event to add to the group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_ID
 * \retval CUPTI_ERROR_OUT_OF_MEMORY
 * \retval CUPTI_ERROR_INVALID_OPERATION if \p eventGroup is enabled
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if \p event belongs to a
 * different event domain than the events already in \p eventGroup, or
 * if a device limitation prevents \p event from being collected at
 * the same time as the events already in \p eventGroup
 * \retval CUPTI_ERROR_MAX_LIMIT_REACHED if \p eventGroup is full
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupAddEvent(CUpti_EventGroup eventGroup,
                                             @Cast("CUpti_EventID") int event);

/**
 * \brief Remove an event from an event group.
 *
 * Remove \p event from the an event group. The event cannot be
 * removed if the event group is enabled.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 * @param event The event to remove from the group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_ID
 * \retval CUPTI_ERROR_INVALID_OPERATION if \p eventGroup is enabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupRemoveEvent(CUpti_EventGroup eventGroup,
                                                @Cast("CUpti_EventID") int event);

/**
 * \brief Remove all events from an event group.
 *
 * Remove all events from an event group. Events cannot be removed if
 * the event group is enabled.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_OPERATION if \p eventGroup is enabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupRemoveAllEvents(CUpti_EventGroup eventGroup);

/**
 * \brief Zero all the event counts in an event group.
 *
 * Zero all the event counts in an event group.
 * \note \b Thread-safety: this function is thread safe but client
 * must guard against simultaneous destruction or modification of \p
 * eventGroup (for example, client must guard against simultaneous
 * calls to \ref cuptiEventGroupDestroy, \ref cuptiEventGroupAddEvent,
 * etc.), and must guard against simultaneous destruction of the
 * context in which \p eventGroup was created (for example, client
 * must guard against simultaneous calls to cudaDeviceReset,
 * cuCtxDestroy, etc.).
 *
 * @param eventGroup The event group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupResetAllEvents(CUpti_EventGroup eventGroup);

/**
 * \brief Enable an event group.
 *
 * Enable an event group. Enabling an event group zeros the value of
 * all the events in the group and then starts collection of those
 * events.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_NOT_READY if \p eventGroup does not contain any events
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if \p eventGroup cannot be
 * enabled due to other already enabled event groups
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 * \retval CUPTI_ERROR_HARDWARE_BUSY if another client is profiling
 * and hardware is busy
 */
public static native @Cast("CUptiResult") int cuptiEventGroupEnable(CUpti_EventGroup eventGroup);

/**
 * \brief Disable an event group.
 *
 * Disable an event group. Disabling an event group stops collection
 * of events contained in the group.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroup The event group
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupDisable(CUpti_EventGroup eventGroup);

/**
 * \brief Read the value for an event in an event group.
 *
 * Read the value for an event in an event group. The event value is
 * returned in the \p eventValueBuffer buffer. \p
 * eventValueBufferSizeBytes indicates the size of the \p
 * eventValueBuffer buffer. The buffer must be at least sizeof(uint64)
 * if ::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set
 * on the group containing the event.  The buffer must be at least
 * (sizeof(uint64) * number of domain instances) if
 * ::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the
 * group.
 *
 * If any instance of an event counter overflows, the value returned
 * for that event instance will be ::CUPTI_EVENT_OVERFLOW.
 *
 * The only allowed value for \p flags is ::CUPTI_EVENT_READ_FLAG_NONE.
 *
 * Reading an event from a disabled event group is not allowed. After
 * being read, an event's value is reset to zero.
 * \note \b Thread-safety: this function is thread safe but client
 * must guard against simultaneous destruction or modification of \p
 * eventGroup (for example, client must guard against simultaneous
 * calls to \ref cuptiEventGroupDestroy, \ref cuptiEventGroupAddEvent,
 * etc.), and must guard against simultaneous destruction of the
 * context in which \p eventGroup was created (for example, client
 * must guard against simultaneous calls to cudaDeviceReset,
 * cuCtxDestroy, etc.). If \ref cuptiEventGroupResetAllEvents is
 * called simultaneously with this function, then returned event
 * values are undefined.
 *
 * @param eventGroup The event group
 * @param flags Flags controlling the reading mode
 * @param event The event to read
 * @param eventValueBufferSizeBytes The size of \p eventValueBuffer
 * in bytes, and returns the number of bytes written to \p
 * eventValueBuffer
 * @param eventValueBuffer Returns the event value(s)
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_EVENT_ID
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_INVALID_OPERATION if \p eventGroup is disabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup, \p
 * eventValueBufferSizeBytes or \p eventValueBuffer is NULL
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT if size of \p eventValueBuffer
 * is not sufficient
 */
public static native @Cast("CUptiResult") int cuptiEventGroupReadEvent(CUpti_EventGroup eventGroup,
                                              @Cast("CUpti_ReadEventFlags") int flags,
                                              @Cast("CUpti_EventID") int event,
                                              @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                              @Cast("uint64_t*") LongPointer eventValueBuffer);
public static native @Cast("CUptiResult") int cuptiEventGroupReadEvent(CUpti_EventGroup eventGroup,
                                              @Cast("CUpti_ReadEventFlags") int flags,
                                              @Cast("CUpti_EventID") int event,
                                              @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                              @Cast("uint64_t*") LongBuffer eventValueBuffer);
public static native @Cast("CUptiResult") int cuptiEventGroupReadEvent(CUpti_EventGroup eventGroup,
                                              @Cast("CUpti_ReadEventFlags") int flags,
                                              @Cast("CUpti_EventID") int event,
                                              @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                              @Cast("uint64_t*") long[] eventValueBuffer);

/**
 * \brief Read the values for all the events in an event group.
 *
 * Read the values for all the events in an event group. The event
 * values are returned in the \p eventValueBuffer buffer. \p
 * eventValueBufferSizeBytes indicates the size of \p
 * eventValueBuffer.  The buffer must be at least (sizeof(uint64) *
 * number of events in group) if
 * ::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on
 * the group containing the events.  The buffer must be at least
 * (sizeof(uint64) * number of domain instances * number of events in
 * group) if ::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is
 * set on the group.
 *
 * The data format returned in \p eventValueBuffer is:
 *    - domain instance 0: event0 event1 ... eventN
 *    - domain instance 1: event0 event1 ... eventN
 *    - ...
 *    - domain instance M: event0 event1 ... eventN
 *
 * The event order in \p eventValueBuffer is returned in \p
 * eventIdArray. The size of \p eventIdArray is specified in \p
 * eventIdArraySizeBytes. The size should be at least
 * (sizeof(CUpti_EventID) * number of events in group).
 *
 * If any instance of any event counter overflows, the value returned
 * for that event instance will be ::CUPTI_EVENT_OVERFLOW.
 *
 * The only allowed value for \p flags is ::CUPTI_EVENT_READ_FLAG_NONE.
 *
 * Reading events from a disabled event group is not allowed. After
 * being read, an event's value is reset to zero.
 * \note \b Thread-safety: this function is thread safe but client
 * must guard against simultaneous destruction or modification of \p
 * eventGroup (for example, client must guard against simultaneous
 * calls to \ref cuptiEventGroupDestroy, \ref cuptiEventGroupAddEvent,
 * etc.), and must guard against simultaneous destruction of the
 * context in which \p eventGroup was created (for example, client
 * must guard against simultaneous calls to cudaDeviceReset,
 * cuCtxDestroy, etc.). If \ref cuptiEventGroupResetAllEvents is
 * called simultaneously with this function, then returned event
 * values are undefined.
 *
 * @param eventGroup The event group
 * @param flags Flags controlling the reading mode
 * @param eventValueBufferSizeBytes The size of \p eventValueBuffer in
 * bytes, and returns the number of bytes written to \p
 * eventValueBuffer
 * @param eventValueBuffer Returns the event values
 * @param eventIdArraySizeBytes The size of \p eventIdArray in bytes,
 * and returns the number of bytes written to \p eventIdArray
 * @param eventIdArray Returns the IDs of the events in the same order
 * as the values return in eventValueBuffer.
 * @param numEventIdsRead Returns the number of event IDs returned
 * in \p eventIdArray
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_INVALID_OPERATION if \p eventGroup is disabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroup, \p
 * eventValueBufferSizeBytes, \p eventValueBuffer, \p
 * eventIdArraySizeBytes, \p eventIdArray or \p numEventIdsRead is
 * NULL
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT if size of \p eventValueBuffer
 * or \p eventIdArray is not sufficient
 */
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") LongPointer eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") LongBuffer eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") int[] eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") long[] eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") LongPointer eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") int[] eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") LongBuffer eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);
public static native @Cast("CUptiResult") int cuptiEventGroupReadAllEvents(CUpti_EventGroup eventGroup,
                                                  @Cast("CUpti_ReadEventFlags") int flags,
                                                  @Cast("size_t*") SizeTPointer eventValueBufferSizeBytes,
                                                  @Cast("uint64_t*") long[] eventValueBuffer,
                                                  @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                                  @Cast("CUpti_EventID*") int[] eventIdArray,
                                                  @Cast("size_t*") SizeTPointer numEventIdsRead);

/**
 * \brief For a set of events, get the grouping that indicates the
 * number of passes and the event groups necessary to collect the
 * events.
 *
 * The number of events that can be collected simultaneously varies by
 * device and by the type of the events. When events can be collected
 * simultaneously, they may need to be grouped into multiple event
 * groups because they are from different event domains. This function
 * takes a set of events and determines how many passes are required
 * to collect all those events, and which events can be collected
 * simultaneously in each pass.
 *
 * The CUpti_EventGroupSets returned in \p eventGroupPasses indicates
 * how many passes are required to collect the events with the \p
 * numSets field. Within each event group set, the \p sets array
 * indicates the event groups that should be collected on each pass.
 * \note \b Thread-safety: this function is thread safe, but client
 * must guard against another thread simultaneously destroying \p
 * context.
 *
 * @param context The context for event collection
 * @param eventIdArraySizeBytes Size of \p eventIdArray in bytes
 * @param eventIdArray Array of event IDs that need to be grouped
 * @param eventGroupPasses Returns a CUpti_EventGroupSets object that
 * indicates the number of passes required to collect the events and
 * the events to collect on each pass
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_CONTEXT
 * \retval CUPTI_ERROR_INVALID_EVENT_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventIdArray or
 * \p eventGroupPasses is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupSetsCreate(CUctx_st context,
                                               @Cast("size_t") long eventIdArraySizeBytes,
                                               @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                               @Cast("CUpti_EventGroupSets**") PointerPointer eventGroupPasses);
public static native @Cast("CUptiResult") int cuptiEventGroupSetsCreate(CUctx_st context,
                                               @Cast("size_t") long eventIdArraySizeBytes,
                                               @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                               @ByPtrPtr CUpti_EventGroupSets eventGroupPasses);
public static native @Cast("CUptiResult") int cuptiEventGroupSetsCreate(CUctx_st context,
                                               @Cast("size_t") long eventIdArraySizeBytes,
                                               @Cast("CUpti_EventID*") int[] eventIdArray,
                                               @ByPtrPtr CUpti_EventGroupSets eventGroupPasses);

/**
 * \brief Destroy a event group sets object.
 *
 * Destroy a CUpti_EventGroupSets object.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroupSets The object to destroy
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_OPERATION if any of the event groups
 * contained in the sets is enabled
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroupSets is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupSetsDestroy(CUpti_EventGroupSets eventGroupSets);


/**
 * \brief Enable an event group set.
 *
 * Enable a set of event groups. Enabling a set of event groups zeros the value of
 * all the events in all the groups and then starts collection of those events.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param eventGroupSet The pointer to the event group set
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_NOT_READY if \p eventGroup does not contain any events
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if \p eventGroup cannot be
 * enabled due to other already enabled event groups
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroupSet is NULL
 * \retval CUPTI_ERROR_HARDWARE_BUSY if other client is profiling and hardware is
 * busy
 */
public static native @Cast("CUptiResult") int cuptiEventGroupSetEnable(CUpti_EventGroupSet eventGroupSet);

/**
 * \brief Disable an event group set.
 *
 * Disable a set of event groups. Disabling a set of event groups
 * stops collection of events contained in the groups.
 * \note \b Thread-safety: this function is thread safe.
 * \note \b If this call fails, some of the event groups in the set may be disabled
 * and other event groups may remain enabled.
 *
 * @param eventGroupSet The pointer to the event group set
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_HARDWARE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventGroupSet is NULL
 */
public static native @Cast("CUptiResult") int cuptiEventGroupSetDisable(CUpti_EventGroupSet eventGroupSet);

/**
 * \brief Enable kernel replay mode.
 *
 * Set profiling mode for the context to replay mode. In this mode,
 * any number of events can be collected in one run of the kernel. The
 * event collection mode will automatically switch to
 * CUPTI_EVENT_COLLECTION_MODE_KERNEL.  In this mode, \ref
 * cuptiSetEventCollectionMode will return
 * CUPTI_ERROR_INVALID_OPERATION.
 * \note \b Kernels might take longer to run if many events are enabled.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param context The context
 * \retval CUPTI_SUCCESS
 */
public static native @Cast("CUptiResult") int cuptiEnableKernelReplayMode(CUctx_st context);

/**
 * \brief Disable kernel replay mode.
 *
 * Set profiling mode for the context to non-replay (default)
 * mode. Event collection mode will be set to
 * CUPTI_EVENT_COLLECTION_MODE_KERNEL.  All previously enabled
 * event groups and event group sets will be disabled.
 * \note \b Thread-safety: this function is thread safe.
 *
 * @param context The context
 * \retval CUPTI_SUCCESS
 */
public static native @Cast("CUptiResult") int cuptiDisableKernelReplayMode(CUctx_st context);
// Targeting ..\cupti\CUpti_KernelReplayUpdateFunc.java



/**
 * \brief Subscribe to kernel replay updates.
 *
 * When subscribed, the function pointer passed in will be called each time a
 * kernel run is finished during kernel replay. Previously subscribed function
 * pointer will be replaced. Pass in NULL as the function pointer unsubscribes
 * the update.
 *
 * @param updateFunc The update function pointer
 * @param customData Pointer to any custom data
 * \retval CUPTI_SUCCESS
 */
public static native @Cast("CUptiResult") int cuptiKernelReplaySubscribeUpdate(CUpti_KernelReplayUpdateFunc updateFunc, Pointer customData);

/** \} */ /* END CUPTI_EVENT_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// #endif /*_CUPTI_EVENTS_H_*/




// Parsed from cupti_metrics.h

/*
 * Copyright 2011-2020   NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if !defined(_CUPTI_METRIC_H_)
// #define _CUPTI_METRIC_H_

// #include <cuda.h>
// #include <string.h>
// #include <cuda_stdint.h>
// #include <cupti_result.h>

// #ifndef CUPTIAPI
// #ifdef _WIN32
// #define CUPTIAPI __stdcall
// #else
// #define CUPTIAPI
// #endif
// #endif

// #if defined(__cplusplus)
// #endif

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/**
 * \defgroup CUPTI_METRIC_API CUPTI Metric API
 * Functions, types, and enums that implement the CUPTI Metric API.
 *
 * \note CUPTI metric API from the header cupti_metrics.h are not supported on devices
 * with compute capability 7.5 and higher (i.e. Turing and later GPU architectures).
 * These API will be deprecated in a future CUDA release. These are replaced by
 * Profiling API in the header cupti_profiler_target.h and Perfworks metrics API
 * in the headers nvperf_host.h and nvperf_target.h which are supported on
 * devices with compute capability 7.0 and higher (i.e. Volta and later GPU
 * architectures).
 *
 * \{
 */

/**
 * \brief ID for a metric.
 *
 * A metric provides a measure of some aspect of the device.
 */

/**
 * \brief A metric category.
 *
 * Each metric is assigned to a category that represents the general
 * type of the metric. A metric's category is accessed using \ref
 * cuptiMetricGetAttribute and the CUPTI_METRIC_ATTR_CATEGORY
 * attribute.
 */
/** enum CUpti_MetricCategory */
public static final int
  /**
   * A memory related metric.
   */
  CUPTI_METRIC_CATEGORY_MEMORY          = 0,
  /**
   * An instruction related metric.
   */
  CUPTI_METRIC_CATEGORY_INSTRUCTION     = 1,
  /**
   * A multiprocessor related metric.
   */
  CUPTI_METRIC_CATEGORY_MULTIPROCESSOR  = 2,
  /**
   * A cache related metric.
   */
  CUPTI_METRIC_CATEGORY_CACHE           = 3,
  /**
   * A texture related metric.
   */
  CUPTI_METRIC_CATEGORY_TEXTURE         = 4,
  /**
   *A Nvlink related metric.
   */
  CUPTI_METRIC_CATEGORY_NVLINK          = 5,
  /**
   *A PCIe related metric.
   */
  CUPTI_METRIC_CATEGORY_PCIE           = 6,
  CUPTI_METRIC_CATEGORY_FORCE_INT                         = 0x7fffffff;

/**
 * \brief A metric evaluation mode.
 *
 * A metric can be evaluated per hardware instance to know the load balancing
 * across instances of a domain or the metric can be evaluated in aggregate mode
 * when the events involved in metric evaluation are from different event
 * domains. It might be possible to evaluate some metrics in both
 * modes for convenience. A metric's evaluation mode is accessed using \ref
 * CUpti_MetricEvaluationMode and the CUPTI_METRIC_ATTR_EVALUATION_MODE
 * attribute.
 */
/** enum CUpti_MetricEvaluationMode */
public static final int
  /**
   * If this bit is set, the metric can be profiled for each instance of the
   * domain. The event values passed to \ref cuptiMetricGetValue can contain
   * values for one instance of the domain. And \ref cuptiMetricGetValue can
   * be called for each instance.
   */
  CUPTI_METRIC_EVALUATION_MODE_PER_INSTANCE         = 1,
  /**
   * If this bit is set, the metric can be profiled over all instances. The
   * event values passed to \ref cuptiMetricGetValue can be aggregated values
   * of events for all instances of the domain.
   */
  CUPTI_METRIC_EVALUATION_MODE_AGGREGATE            = 1 << 1,
  CUPTI_METRIC_EVALUATION_MODE_FORCE_INT            = 0x7fffffff;

/**
 * \brief Kinds of metric values.
 *
 * Metric values can be one of several different kinds. Corresponding
 * to each kind is a member of the CUpti_MetricValue union. The metric
 * value returned by \ref cuptiMetricGetValue should be accessed using
 * the appropriate member of that union based on its value kind.
 */
/** enum CUpti_MetricValueKind */
public static final int
  /**
   * The metric value is a 64-bit double.
   */
  CUPTI_METRIC_VALUE_KIND_DOUBLE            = 0,
  /**
   * The metric value is a 64-bit unsigned integer.
   */
  CUPTI_METRIC_VALUE_KIND_UINT64            = 1,
  /**
   * The metric value is a percentage represented by a 64-bit
   * double. For example, 57.5% is represented by the value 57.5.
   */
  CUPTI_METRIC_VALUE_KIND_PERCENT           = 2,
  /**
   * The metric value is a throughput represented by a 64-bit
   * integer. The unit for throughput values is bytes/second.
   */
  CUPTI_METRIC_VALUE_KIND_THROUGHPUT        = 3,
  /**
   * The metric value is a 64-bit signed integer.
   */
  CUPTI_METRIC_VALUE_KIND_INT64             = 4,
  /**
   * The metric value is a utilization level, as represented by
   * CUpti_MetricValueUtilizationLevel.
   */
  CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL = 5,

  CUPTI_METRIC_VALUE_KIND_FORCE_INT  = 0x7fffffff;

/**
 * \brief Enumeration of utilization levels for metrics values of kind
 * CUPTI_METRIC_VALUE_KIND_UTILIZATION_LEVEL. Utilization values can
 * vary from IDLE (0) to MAX (10) but the enumeration only provides
 * specific names for a few values.
 */
/** enum CUpti_MetricValueUtilizationLevel */
public static final int
  CUPTI_METRIC_VALUE_UTILIZATION_IDLE      = 0,
  CUPTI_METRIC_VALUE_UTILIZATION_LOW       = 2,
  CUPTI_METRIC_VALUE_UTILIZATION_MID       = 5,
  CUPTI_METRIC_VALUE_UTILIZATION_HIGH      = 8,
  CUPTI_METRIC_VALUE_UTILIZATION_MAX       = 10,
  CUPTI_METRIC_VALUE_UTILIZATION_FORCE_INT = 0x7fffffff;

/**
 * \brief Metric attributes.
 *
 * Metric attributes describe properties of a metric. These attributes
 * can be read using \ref cuptiMetricGetAttribute.
 */
/** enum CUpti_MetricAttribute */
public static final int
  /**
   * Metric name. Value is a null terminated const c-string.
   */
  CUPTI_METRIC_ATTR_NAME              = 0,
  /**
   * Short description of metric. Value is a null terminated const c-string.
   */
  CUPTI_METRIC_ATTR_SHORT_DESCRIPTION = 1,
  /**
   * Long description of metric. Value is a null terminated const c-string.
   */
  CUPTI_METRIC_ATTR_LONG_DESCRIPTION  = 2,
  /**
   * Category of the metric. Value is of type CUpti_MetricCategory.
   */
  CUPTI_METRIC_ATTR_CATEGORY          = 3,
  /**
   * Value type of the metric. Value is of type CUpti_MetricValueKind.
   */
  CUPTI_METRIC_ATTR_VALUE_KIND          = 4,
  /**
   * Metric evaluation mode. Value is of type CUpti_MetricEvaluationMode.
   */
  CUPTI_METRIC_ATTR_EVALUATION_MODE     = 5,
  CUPTI_METRIC_ATTR_FORCE_INT         = 0x7fffffff;
// Targeting ..\cupti\CUpti_MetricValue.java



/**
 * \brief Device class.
 *
 * Enumeration of device classes for metric property
 * CUPTI_METRIC_PROPERTY_DEVICE_CLASS.
 */
/** enum CUpti_MetricPropertyDeviceClass */
public static final int
  CUPTI_METRIC_PROPERTY_DEVICE_CLASS_TESLA          = 0,
  CUPTI_METRIC_PROPERTY_DEVICE_CLASS_QUADRO         = 1,
  CUPTI_METRIC_PROPERTY_DEVICE_CLASS_GEFORCE        = 2,
  CUPTI_METRIC_PROPERTY_DEVICE_CLASS_TEGRA          = 3;

/**
 * \brief Metric device properties.
 *
 * Metric device properties describe device properties which are needed for a metric.
 * Some of these properties can be collected using cuDeviceGetAttribute.
 */
/** enum CUpti_MetricPropertyID */
public static final int
  /*
   * Number of multiprocessors on a device.  This can be collected
   * using value of \param CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT of
   * cuDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_MULTIPROCESSOR_COUNT = 0,
  /*
   * Maximum number of warps on a multiprocessor. This can be
   * collected using ratio of value of \param
   * CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR and \param
   * CU_DEVICE_ATTRIBUTE_WARP_SIZE of cuDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_WARPS_PER_MULTIPROCESSOR = 1,
  /*
   * GPU Time for kernel in ns. This should be profiled using CUPTI
   * Activity API.
   */
  CUPTI_METRIC_PROPERTY_KERNEL_GPU_TIME = 2,
  /*
   * Clock rate for device in KHz.  This should be collected using
   * value of \param CU_DEVICE_ATTRIBUTE_CLOCK_RATE of
   * cuDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_CLOCK_RATE = 3,
  /*
   * Number of Frame buffer units for device. This should be collected
   * using value of \param CUPTI_DEVICE_ATTRIBUTE_MAX_FRAME_BUFFERS of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_FRAME_BUFFER_COUNT = 4,
  /*
   * Global memory bandwidth in KBytes/sec. This should be collected
   * using value of \param CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH
   * of cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_GLOBAL_MEMORY_BANDWIDTH = 5,
  /*
   * PCIE link rate in Mega bits/sec. This should be collected using
   * value of \param CUPTI_DEVICE_ATTR_PCIE_LINK_RATE of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_PCIE_LINK_RATE = 6,
  /*
   * PCIE link width for device. This should be collected using
   * value of \param CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_PCIE_LINK_WIDTH = 7,
  /*
   * PCIE generation for device. This should be collected using
   * value of \param CUPTI_DEVICE_ATTR_PCIE_GEN of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_PCIE_GEN = 8,
  /*
   * The device class. This should be collected using
   * value of \param CUPTI_DEVICE_ATTR_DEVICE_CLASS of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_DEVICE_CLASS = 9,
  /*
   * Peak single precision floating point operations that
   * can be performed in one cycle by the device.
   * This should be collected using value of
   * \param CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_FLOP_SP_PER_CYCLE = 10,
  /*
   * Peak double precision floating point operations that
   * can be performed in one cycle by the device.
   * This should be collected using value of
   * \param CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_FLOP_DP_PER_CYCLE = 11,
  /*
   * Number of L2 units on a device. This can be collected
   * using value of \param CUPTI_DEVICE_ATTR_MAX_L2_UNITS of
   * cuDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_L2_UNITS = 12,
  /*
   * Whether ECC support is enabled on the device. This can be
   * collected using value of \param CU_DEVICE_ATTRIBUTE_ECC_ENABLED of
   * cuDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_ECC_ENABLED = 13,
  /*
   * Peak half precision floating point operations that
   * can be performed in one cycle by the device.
   * This should be collected using value of
   * \param CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_FLOP_HP_PER_CYCLE = 14,
  /*
   * NVLINK Bandwitdh for device. This should be collected
   * using value of \param CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW of
   * cuptiDeviceGetAttribute.
   */
  CUPTI_METRIC_PROPERTY_GPU_CPU_NVLINK_BANDWIDTH = 15;

/**
 * \brief Get the total number of metrics available on any device.
 *
 * Returns the total number of metrics available on any CUDA-capable
 * devices.
 *
 * @param numMetrics Returns the number of metrics
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numMetrics is NULL
*/
public static native @Cast("CUptiResult") int cuptiGetNumMetrics(@Cast("uint32_t*") IntPointer numMetrics);
public static native @Cast("CUptiResult") int cuptiGetNumMetrics(@Cast("uint32_t*") IntBuffer numMetrics);
public static native @Cast("CUptiResult") int cuptiGetNumMetrics(@Cast("uint32_t*") int[] numMetrics);

/**
 * \brief Get all the metrics available on any device.
 *
 * Returns the metric IDs in \p metricArray for all CUDA-capable
 * devices.  The size of the \p metricArray buffer is given by \p
 * *arraySizeBytes. The size of the \p metricArray buffer must be at
 * least \p numMetrics * sizeof(CUpti_MetricID) or all metric IDs will
 * not be returned. The value returned in \p *arraySizeBytes contains
 * the number of bytes returned in \p metricArray.
 *
 * @param arraySizeBytes The size of \p metricArray in bytes, and
 * returns the number of bytes written to \p metricArray
 * @param metricArray Returns the IDs of the metrics
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p arraySizeBytes or
 * \p metricArray are NULL
*/
public static native @Cast("CUptiResult") int cuptiEnumMetrics(@Cast("size_t*") SizeTPointer arraySizeBytes,
                                      @Cast("CUpti_MetricID*") IntPointer metricArray);
public static native @Cast("CUptiResult") int cuptiEnumMetrics(@Cast("size_t*") SizeTPointer arraySizeBytes,
                                      @Cast("CUpti_MetricID*") int[] metricArray);

/**
 * \brief Get the number of metrics for a device.
 *
 * Returns the number of metrics available for a device.
 *
 * @param device The CUDA device
 * @param numMetrics Returns the number of metrics available for the
 * device
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numMetrics is NULL
 */
public static native @Cast("CUptiResult") int cuptiDeviceGetNumMetrics(@Cast("CUdevice") int device,
                                              @Cast("uint32_t*") IntPointer numMetrics);
public static native @Cast("CUptiResult") int cuptiDeviceGetNumMetrics(@Cast("CUdevice") int device,
                                              @Cast("uint32_t*") IntBuffer numMetrics);
public static native @Cast("CUptiResult") int cuptiDeviceGetNumMetrics(@Cast("CUdevice") int device,
                                              @Cast("uint32_t*") int[] numMetrics);

/**
 * \brief Get the metrics for a device.
 *
 * Returns the metric IDs in \p metricArray for a device.  The size of
 * the \p metricArray buffer is given by \p *arraySizeBytes. The size
 * of the \p metricArray buffer must be at least \p numMetrics *
 * sizeof(CUpti_MetricID) or else all metric IDs will not be
 * returned. The value returned in \p *arraySizeBytes contains the
 * number of bytes returned in \p metricArray.
 *
 * @param device The CUDA device
 * @param arraySizeBytes The size of \p metricArray in bytes, and
 * returns the number of bytes written to \p metricArray
 * @param metricArray Returns the IDs of the metrics for the device
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p arraySizeBytes or
 * \p metricArray are NULL
 */
public static native @Cast("CUptiResult") int cuptiDeviceEnumMetrics(@Cast("CUdevice") int device,
                                            @Cast("size_t*") SizeTPointer arraySizeBytes,
                                            @Cast("CUpti_MetricID*") IntPointer metricArray);
public static native @Cast("CUptiResult") int cuptiDeviceEnumMetrics(@Cast("CUdevice") int device,
                                            @Cast("size_t*") SizeTPointer arraySizeBytes,
                                            @Cast("CUpti_MetricID*") int[] metricArray);

/**
 * \brief Get a metric attribute.
 *
 * Returns a metric attribute in \p *value. The size of the \p
 * value buffer is given by \p *valueSize. The value returned in \p
 * *valueSize contains the number of bytes returned in \p value.
 *
 * If the attribute value is a c-string that is longer than \p
 * *valueSize, then only the first \p *valueSize characters will be
 * returned and there will be no terminating null byte.
 *
 * @param metric ID of the metric
 * @param attrib The metric attribute to read
 * @param valueSize The size of the \p value buffer in bytes, and
 * returns the number of bytes written to \p value
 * @param value Returns the attribute's value
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p valueSize or \p value
 * is NULL, or if \p attrib is not a metric attribute
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT For non-c-string
 * attribute values, indicates that the \p value buffer is too small
 * to hold the attribute value.
 */
public static native @Cast("CUptiResult") int cuptiMetricGetAttribute(@Cast("CUpti_MetricID") int metric,
                                             @Cast("CUpti_MetricAttribute") int attrib,
                                             @Cast("size_t*") SizeTPointer valueSize,
                                             Pointer value);

/**
 * \brief Find an metric by name.
 *
 * Find a metric by name and return the metric ID in \p *metric.
 *
 * @param device The CUDA device
 * @param metricName The name of metric to find
 * @param metric Returns the ID of the found metric or undefined if
 * unable to find the metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_DEVICE
 * \retval CUPTI_ERROR_INVALID_METRIC_NAME if unable to find a metric
 * with name \p metricName. In this case \p *metric is undefined
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p metricName or \p
 * metric are NULL.
 */
public static native @Cast("CUptiResult") int cuptiMetricGetIdFromName(@Cast("CUdevice") int device,
                                              @Cast("const char*") BytePointer metricName,
                                              @Cast("CUpti_MetricID*") IntPointer metric);
public static native @Cast("CUptiResult") int cuptiMetricGetIdFromName(@Cast("CUdevice") int device,
                                              String metricName,
                                              @Cast("CUpti_MetricID*") int[] metric);

/**
 * \brief Get number of events required to calculate a metric.
 *
 * Returns the number of events in \p numEvents that are required to
 * calculate a metric.
 *
 * @param metric ID of the metric
 * @param numEvents Returns the number of events required for the metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numEvents is NULL
 */
public static native @Cast("CUptiResult") int cuptiMetricGetNumEvents(@Cast("CUpti_MetricID") int metric,
                                             @Cast("uint32_t*") IntPointer numEvents);
public static native @Cast("CUptiResult") int cuptiMetricGetNumEvents(@Cast("CUpti_MetricID") int metric,
                                             @Cast("uint32_t*") IntBuffer numEvents);
public static native @Cast("CUptiResult") int cuptiMetricGetNumEvents(@Cast("CUpti_MetricID") int metric,
                                             @Cast("uint32_t*") int[] numEvents);

/**
 * \brief Get the events required to calculating a metric.
 *
 * Gets the event IDs in \p eventIdArray required to calculate a \p
 * metric. The size of the \p eventIdArray buffer is given by \p
 * *eventIdArraySizeBytes and must be at least \p numEvents *
 * sizeof(CUpti_EventID) or all events will not be returned. The value
 * returned in \p *eventIdArraySizeBytes contains the number of bytes
 * returned in \p eventIdArray.
 *
 * @param metric ID of the metric
 * @param eventIdArraySizeBytes The size of \p eventIdArray in bytes,
 * and returns the number of bytes written to \p eventIdArray
 * @param eventIdArray Returns the IDs of the events required to
 * calculate \p metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p eventIdArraySizeBytes or \p
 * eventIdArray are NULL.
 */
public static native @Cast("CUptiResult") int cuptiMetricEnumEvents(@Cast("CUpti_MetricID") int metric,
                                           @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                           @Cast("CUpti_EventID*") IntPointer eventIdArray);
public static native @Cast("CUptiResult") int cuptiMetricEnumEvents(@Cast("CUpti_MetricID") int metric,
                                           @Cast("size_t*") SizeTPointer eventIdArraySizeBytes,
                                           @Cast("CUpti_EventID*") int[] eventIdArray);

/**
 * \brief Get number of properties required to calculate a metric.
 *
 * Returns the number of properties in \p numProp that are required to
 * calculate a metric.
 *
 * @param metric ID of the metric
 * @param numProp Returns the number of properties required for the
 * metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p numProp is NULL
 */
public static native @Cast("CUptiResult") int cuptiMetricGetNumProperties(@Cast("CUpti_MetricID") int metric,
                                                 @Cast("uint32_t*") IntPointer numProp);
public static native @Cast("CUptiResult") int cuptiMetricGetNumProperties(@Cast("CUpti_MetricID") int metric,
                                                 @Cast("uint32_t*") IntBuffer numProp);
public static native @Cast("CUptiResult") int cuptiMetricGetNumProperties(@Cast("CUpti_MetricID") int metric,
                                                 @Cast("uint32_t*") int[] numProp);

/**
 * \brief Get the properties required to calculating a metric.
 *
 * Gets the property IDs in \p propIdArray required to calculate a \p
 * metric. The size of the \p propIdArray buffer is given by \p
 * *propIdArraySizeBytes and must be at least \p numProp *
 * sizeof(CUpti_DeviceAttribute) or all properties will not be
 * returned. The value returned in \p *propIdArraySizeBytes contains
 * the number of bytes returned in \p propIdArray.
 *
 * @param metric ID of the metric
 * @param propIdArraySizeBytes The size of \p propIdArray in bytes,
 * and returns the number of bytes written to \p propIdArray
 * @param propIdArray Returns the IDs of the properties required to
 * calculate \p metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p propIdArraySizeBytes or \p
 * propIdArray are NULL.
 */
public static native @Cast("CUptiResult") int cuptiMetricEnumProperties(@Cast("CUpti_MetricID") int metric,
                                               @Cast("size_t*") SizeTPointer propIdArraySizeBytes,
                                               @Cast("CUpti_MetricPropertyID*") IntPointer propIdArray);
public static native @Cast("CUptiResult") int cuptiMetricEnumProperties(@Cast("CUpti_MetricID") int metric,
                                               @Cast("size_t*") SizeTPointer propIdArraySizeBytes,
                                               @Cast("CUpti_MetricPropertyID*") IntBuffer propIdArray);
public static native @Cast("CUptiResult") int cuptiMetricEnumProperties(@Cast("CUpti_MetricID") int metric,
                                               @Cast("size_t*") SizeTPointer propIdArraySizeBytes,
                                               @Cast("CUpti_MetricPropertyID*") int[] propIdArray);


/**
 * \brief For a metric get the groups of events that must be collected
 * in the same pass.
 *
 * For a metric get the groups of events that must be collected in the
 * same pass to ensure that the metric is calculated correctly. If the
 * events are not collected as specified then the metric value may be
 * inaccurate.
 *
 * The function returns NULL if a metric does not have any required
 * event group. In this case the events needed for the metric can be
 * grouped in any manner for collection.
 *
 * @param context The context for event collection
 * @param metric The metric ID
 * @param eventGroupSets Returns a CUpti_EventGroupSets object that
 * indicates the events that must be collected in the same pass to
 * ensure the metric is calculated correctly.  Returns NULL if no
 * grouping is required for metric
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 */
public static native @Cast("CUptiResult") int cuptiMetricGetRequiredEventGroupSets(CUctx_st context,
                                                          @Cast("CUpti_MetricID") int metric,
                                                          @Cast("CUpti_EventGroupSets**") PointerPointer eventGroupSets);
public static native @Cast("CUptiResult") int cuptiMetricGetRequiredEventGroupSets(CUctx_st context,
                                                          @Cast("CUpti_MetricID") int metric,
                                                          @ByPtrPtr CUpti_EventGroupSets eventGroupSets);

/**
 * \brief For a set of metrics, get the grouping that indicates the
 * number of passes and the event groups necessary to collect the
 * events required for those metrics.
 *
 * For a set of metrics, get the grouping that indicates the number of
 * passes and the event groups necessary to collect the events
 * required for those metrics.
 *
 * @see cuptiEventGroupSetsCreate for details on event group set
 * creation.
 *
 * @param context The context for event collection
 * @param metricIdArraySizeBytes Size of the metricIdArray in bytes
 * @param metricIdArray Array of metric IDs
 * @param eventGroupPasses Returns a CUpti_EventGroupSets object that
 * indicates the number of passes required to collect the events and
 * the events to collect on each pass
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_CONTEXT
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p metricIdArray or
 * \p eventGroupPasses is NULL
 */
public static native @Cast("CUptiResult") int cuptiMetricCreateEventGroupSets(CUctx_st context,
                                                     @Cast("size_t") long metricIdArraySizeBytes,
                                                     @Cast("CUpti_MetricID*") IntPointer metricIdArray,
                                                     @Cast("CUpti_EventGroupSets**") PointerPointer eventGroupPasses);
public static native @Cast("CUptiResult") int cuptiMetricCreateEventGroupSets(CUctx_st context,
                                                     @Cast("size_t") long metricIdArraySizeBytes,
                                                     @Cast("CUpti_MetricID*") IntPointer metricIdArray,
                                                     @ByPtrPtr CUpti_EventGroupSets eventGroupPasses);
public static native @Cast("CUptiResult") int cuptiMetricCreateEventGroupSets(CUctx_st context,
                                                     @Cast("size_t") long metricIdArraySizeBytes,
                                                     @Cast("CUpti_MetricID*") int[] metricIdArray,
                                                     @ByPtrPtr CUpti_EventGroupSets eventGroupPasses);

/**
 * \brief Calculate the value for a metric.
 *
 * Use the events collected for a metric to calculate the metric
 * value. Metric value evaluation depends on the evaluation mode
 * \ref CUpti_MetricEvaluationMode that the metric supports.
 * If a metric has evaluation mode as CUPTI_METRIC_EVALUATION_MODE_PER_INSTANCE,
 * then it assumes that the input event value is for one domain instance.
 * If a metric has evaluation mode as CUPTI_METRIC_EVALUATION_MODE_AGGREGATE,
 * it assumes that input event values are
 * normalized to represent all domain instances on a device. For the
 * most accurate metric collection, the events required for the metric
 * should be collected for all profiled domain instances. For example,
 * to collect all instances of an event, set the
 * CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES attribute on
 * the group containing the event to 1. The normalized value for the
 * event is then: (\p sum_event_values * \p totalInstanceCount) / \p
 * instanceCount, where \p sum_event_values is the summation of the
 * event values across all profiled domain instances, \p
 * totalInstanceCount is obtained from querying
 * CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT and \p instanceCount
 * is obtained from querying CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT (or
 * CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT).
 *
 * @param device The CUDA device that the metric is being calculated for
 * @param metric The metric ID
 * @param eventIdArraySizeBytes The size of \p eventIdArray in bytes
 * @param eventIdArray The event IDs required to calculate \p metric
 * @param eventValueArraySizeBytes The size of \p eventValueArray in bytes
 * @param eventValueArray The normalized event values required to
 * calculate \p metric. The values must be order to match the order of
 * events in \p eventIdArray
 * @param timeDuration The duration over which the events were
 * collected, in ns
 * @param metricValue Returns the value for the metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_OPERATION
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT if the
 * eventIdArray does not contain all the events needed for metric
 * \retval CUPTI_ERROR_INVALID_EVENT_VALUE if any of the
 * event values required for the metric is CUPTI_EVENT_OVERFLOW
 * \retval CUPTI_ERROR_INVALID_METRIC_VALUE if the computed metric value
 * cannot be represented in the metric's value type. For example,
 * if the metric value type is unsigned and the computed metric value is negative
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p metricValue,
 * \p eventIdArray or \p eventValueArray is NULL
 */
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") LongPointer eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") int[] eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") LongBuffer eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") long[] eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") int[] eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") LongPointer eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") LongBuffer eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue(@Cast("CUdevice") int device,
                                         @Cast("CUpti_MetricID") int metric,
                                         @Cast("size_t") long eventIdArraySizeBytes,
                                         @Cast("CUpti_EventID*") int[] eventIdArray,
                                         @Cast("size_t") long eventValueArraySizeBytes,
                                         @Cast("uint64_t*") long[] eventValueArray,
                                         @Cast("uint64_t") long timeDuration,
                                         CUpti_MetricValue metricValue);

/**
 * \brief Calculate the value for a metric.
 *
 * Use the events and properties collected for a metric to calculate
 * the metric value. Metric value evaluation depends on the evaluation
 * mode \ref CUpti_MetricEvaluationMode that the metric supports.  If
 * a metric has evaluation mode as
 * CUPTI_METRIC_EVALUATION_MODE_PER_INSTANCE, then it assumes that the
 * input event value is for one domain instance.  If a metric has
 * evaluation mode as CUPTI_METRIC_EVALUATION_MODE_AGGREGATE, it
 * assumes that input event values are normalized to represent all
 * domain instances on a device. For the most accurate metric
 * collection, the events required for the metric should be collected
 * for all profiled domain instances. For example, to collect all
 * instances of an event, set the
 * CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES attribute on
 * the group containing the event to 1. The normalized value for the
 * event is then: (\p sum_event_values * \p totalInstanceCount) / \p
 * instanceCount, where \p sum_event_values is the summation of the
 * event values across all profiled domain instances, \p
 * totalInstanceCount is obtained from querying
 * CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT and \p instanceCount
 * is obtained from querying CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT (or
 * CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT).
 *
 * @param metric The metric ID
 * @param eventIdArraySizeBytes The size of \p eventIdArray in bytes
 * @param eventIdArray The event IDs required to calculate \p metric
 * @param eventValueArraySizeBytes The size of \p eventValueArray in bytes
 * @param eventValueArray The normalized event values required to
 * calculate \p metric. The values must be order to match the order of
 * events in \p eventIdArray
 * @param propIdArraySizeBytes The size of \p propIdArray in bytes
 * @param propIdArray The metric property IDs required to calculate \p metric
 * @param propValueArraySizeBytes The size of \p propValueArray in bytes
 * @param propValueArray The metric property values required to
 * calculate \p metric. The values must be order to match the order of
 * metric properties in \p propIdArray
 * @param metricValue Returns the value for the metric
 *
 * \retval CUPTI_SUCCESS
 * \retval CUPTI_ERROR_NOT_INITIALIZED
 * \retval CUPTI_ERROR_INVALID_METRIC_ID
 * \retval CUPTI_ERROR_INVALID_OPERATION
 * \retval CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT if the
 * eventIdArray does not contain all the events needed for metric
 * \retval CUPTI_ERROR_INVALID_EVENT_VALUE if any of the
 * event values required for the metric is CUPTI_EVENT_OVERFLOW
 * \retval CUPTI_ERROR_NOT_COMPATIBLE if the computed metric value
 * cannot be represented in the metric's value type. For example,
 * if the metric value type is unsigned and the computed metric value is negative
 * \retval CUPTI_ERROR_INVALID_PARAMETER if \p metricValue,
 * \p eventIdArray or \p eventValueArray is NULL
 */
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") LongPointer eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") IntPointer propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") LongPointer propValueArray,
                                          CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") int[] eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") LongBuffer eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") IntBuffer propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") LongBuffer propValueArray,
                                          CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") long[] eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") int[] propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") long[] propValueArray,
                                          CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") int[] eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") LongPointer eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") IntPointer propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") LongPointer propValueArray,
                                          CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") IntPointer eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") LongBuffer eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") IntBuffer propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") LongBuffer propValueArray,
                                          CUpti_MetricValue metricValue);
public static native @Cast("CUptiResult") int cuptiMetricGetValue2(@Cast("CUpti_MetricID") int metric,
                                          @Cast("size_t") long eventIdArraySizeBytes,
                                          @Cast("CUpti_EventID*") int[] eventIdArray,
                                          @Cast("size_t") long eventValueArraySizeBytes,
                                          @Cast("uint64_t*") long[] eventValueArray,
                                          @Cast("size_t") long propIdArraySizeBytes,
                                          @Cast("CUpti_MetricPropertyID*") int[] propIdArray,
                                          @Cast("size_t") long propValueArraySizeBytes,
                                          @Cast("uint64_t*") long[] propValueArray,
                                          CUpti_MetricValue metricValue);

/** \} */ /* END CUPTI_METRIC_API */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif

// #if defined(__cplusplus)
// #endif

// #endif /*_CUPTI_METRIC_H_*/




// Parsed from cupti_driver_cbid.h


// *************************************************************************
//      Definitions of indices for API functions, unique across entire API
// *************************************************************************

// This file is generated.  Any changes you make will be lost during the next clean build.
// CUDA public interface, for type definitions and cu* function prototypes

// #if !defined(_CUPTI_DRIVER_CBID_H_)
// #define _CUPTI_DRIVER_CBID_H_

/** enum CUpti_driver_api_trace_cbid */
public static final int
    CUPTI_DRIVER_TRACE_CBID_INVALID                                                        = 0,
    CUPTI_DRIVER_TRACE_CBID_cuInit                                                         = 1,
    CUPTI_DRIVER_TRACE_CBID_cuDriverGetVersion                                             = 2,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGet                                                    = 3,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetCount                                               = 4,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetName                                                = 5,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceComputeCapability                                      = 6,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceTotalMem                                               = 7,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetProperties                                          = 8,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetAttribute                                           = 9,
    CUPTI_DRIVER_TRACE_CBID_cuCtxCreate                                                    = 10,
    CUPTI_DRIVER_TRACE_CBID_cuCtxDestroy                                                   = 11,
    CUPTI_DRIVER_TRACE_CBID_cuCtxAttach                                                    = 12,
    CUPTI_DRIVER_TRACE_CBID_cuCtxDetach                                                    = 13,
    CUPTI_DRIVER_TRACE_CBID_cuCtxPushCurrent                                               = 14,
    CUPTI_DRIVER_TRACE_CBID_cuCtxPopCurrent                                                = 15,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetDevice                                                 = 16,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSynchronize                                               = 17,
    CUPTI_DRIVER_TRACE_CBID_cuModuleLoad                                                   = 18,
    CUPTI_DRIVER_TRACE_CBID_cuModuleLoadData                                               = 19,
    CUPTI_DRIVER_TRACE_CBID_cuModuleLoadDataEx                                             = 20,
    CUPTI_DRIVER_TRACE_CBID_cuModuleLoadFatBinary                                          = 21,
    CUPTI_DRIVER_TRACE_CBID_cuModuleUnload                                                 = 22,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetFunction                                            = 23,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetGlobal                                              = 24,
    CUPTI_DRIVER_TRACE_CBID_cu64ModuleGetGlobal                                            = 25,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetTexRef                                              = 26,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetInfo                                                   = 27,
    CUPTI_DRIVER_TRACE_CBID_cu64MemGetInfo                                                 = 28,
    CUPTI_DRIVER_TRACE_CBID_cuMemAlloc                                                     = 29,
    CUPTI_DRIVER_TRACE_CBID_cu64MemAlloc                                                   = 30,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocPitch                                                = 31,
    CUPTI_DRIVER_TRACE_CBID_cu64MemAllocPitch                                              = 32,
    CUPTI_DRIVER_TRACE_CBID_cuMemFree                                                      = 33,
    CUPTI_DRIVER_TRACE_CBID_cu64MemFree                                                    = 34,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetAddressRange                                           = 35,
    CUPTI_DRIVER_TRACE_CBID_cu64MemGetAddressRange                                         = 36,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocHost                                                 = 37,
    CUPTI_DRIVER_TRACE_CBID_cuMemFreeHost                                                  = 38,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostAlloc                                                 = 39,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostGetDevicePointer                                      = 40,
    CUPTI_DRIVER_TRACE_CBID_cu64MemHostGetDevicePointer                                    = 41,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostGetFlags                                              = 42,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD                                                   = 43,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyHtoD                                                 = 44,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH                                                   = 45,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoH                                                 = 46,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD                                                   = 47,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoD                                                 = 48,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA                                                   = 49,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoA                                                 = 50,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD                                                   = 51,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyAtoD                                                 = 52,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA                                                   = 53,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH                                                   = 54,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA                                                   = 55,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D                                                     = 56,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned                                            = 57,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D                                                     = 58,
    CUPTI_DRIVER_TRACE_CBID_cu64Memcpy3D                                                   = 59,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync                                              = 60,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyHtoDAsync                                            = 61,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync                                              = 62,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoHAsync                                            = 63,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync                                              = 64,
    CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoDAsync                                            = 65,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync                                              = 66,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync                                              = 67,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync                                                = 68,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync                                                = 69,
    CUPTI_DRIVER_TRACE_CBID_cu64Memcpy3DAsync                                              = 70,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD8                                                     = 71,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD8                                                   = 72,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD16                                                    = 73,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD16                                                  = 74,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD32                                                    = 75,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD32                                                  = 76,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8                                                   = 77,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D8                                                 = 78,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16                                                  = 79,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D16                                                = 80,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32                                                  = 81,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D32                                                = 82,
    CUPTI_DRIVER_TRACE_CBID_cuFuncSetBlockShape                                            = 83,
    CUPTI_DRIVER_TRACE_CBID_cuFuncSetSharedSize                                            = 84,
    CUPTI_DRIVER_TRACE_CBID_cuFuncGetAttribute                                             = 85,
    CUPTI_DRIVER_TRACE_CBID_cuFuncSetCacheConfig                                           = 86,
    CUPTI_DRIVER_TRACE_CBID_cuArrayCreate                                                  = 87,
    CUPTI_DRIVER_TRACE_CBID_cuArrayGetDescriptor                                           = 88,
    CUPTI_DRIVER_TRACE_CBID_cuArrayDestroy                                                 = 89,
    CUPTI_DRIVER_TRACE_CBID_cuArray3DCreate                                                = 90,
    CUPTI_DRIVER_TRACE_CBID_cuArray3DGetDescriptor                                         = 91,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefCreate                                                 = 92,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefDestroy                                                = 93,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetArray                                               = 94,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress                                             = 95,
    CUPTI_DRIVER_TRACE_CBID_cu64TexRefSetAddress                                           = 96,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D                                           = 97,
    CUPTI_DRIVER_TRACE_CBID_cu64TexRefSetAddress2D                                         = 98,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFormat                                              = 99,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddressMode                                         = 100,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFilterMode                                          = 101,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFlags                                               = 102,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddress                                             = 103,
    CUPTI_DRIVER_TRACE_CBID_cu64TexRefGetAddress                                           = 104,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetArray                                               = 105,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddressMode                                         = 106,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFilterMode                                          = 107,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFormat                                              = 108,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFlags                                               = 109,
    CUPTI_DRIVER_TRACE_CBID_cuParamSetSize                                                 = 110,
    CUPTI_DRIVER_TRACE_CBID_cuParamSeti                                                    = 111,
    CUPTI_DRIVER_TRACE_CBID_cuParamSetf                                                    = 112,
    CUPTI_DRIVER_TRACE_CBID_cuParamSetv                                                    = 113,
    CUPTI_DRIVER_TRACE_CBID_cuParamSetTexRef                                               = 114,
    CUPTI_DRIVER_TRACE_CBID_cuLaunch                                                       = 115,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchGrid                                                   = 116,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchGridAsync                                              = 117,
    CUPTI_DRIVER_TRACE_CBID_cuEventCreate                                                  = 118,
    CUPTI_DRIVER_TRACE_CBID_cuEventRecord                                                  = 119,
    CUPTI_DRIVER_TRACE_CBID_cuEventQuery                                                   = 120,
    CUPTI_DRIVER_TRACE_CBID_cuEventSynchronize                                             = 121,
    CUPTI_DRIVER_TRACE_CBID_cuEventDestroy                                                 = 122,
    CUPTI_DRIVER_TRACE_CBID_cuEventElapsedTime                                             = 123,
    CUPTI_DRIVER_TRACE_CBID_cuStreamCreate                                                 = 124,
    CUPTI_DRIVER_TRACE_CBID_cuStreamQuery                                                  = 125,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSynchronize                                            = 126,
    CUPTI_DRIVER_TRACE_CBID_cuStreamDestroy                                                = 127,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnregisterResource                                   = 128,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsSubResourceGetMappedArray                            = 129,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedPointer                             = 130,
    CUPTI_DRIVER_TRACE_CBID_cu64GraphicsResourceGetMappedPointer                           = 131,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceSetMapFlags                                  = 132,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsMapResources                                         = 133,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnmapResources                                       = 134,
    CUPTI_DRIVER_TRACE_CBID_cuGetExportTable                                               = 135,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSetLimit                                                  = 136,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetLimit                                                  = 137,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDevice                                               = 138,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreate                                               = 139,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D10RegisterResource                                = 140,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10RegisterResource                                        = 141,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10UnregisterResource                                      = 142,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10MapResources                                            = 143,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10UnmapResources                                          = 144,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceSetMapFlags                                     = 145,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedArray                                  = 146,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPointer                                = 147,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedSize                                   = 148,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPitch                                  = 149,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetSurfaceDimensions                            = 150,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDevice                                               = 151,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreate                                               = 152,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D11RegisterResource                                = 153,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDevice                                                = 154,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreate                                                = 155,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D9RegisterResource                                 = 156,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDirect3DDevice                                        = 157,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9RegisterResource                                         = 158,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9UnregisterResource                                       = 159,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9MapResources                                             = 160,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9UnmapResources                                           = 161,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceSetMapFlags                                      = 162,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetSurfaceDimensions                             = 163,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedArray                                   = 164,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPointer                                 = 165,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedSize                                    = 166,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPitch                                   = 167,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9Begin                                                    = 168,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9End                                                      = 169,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9RegisterVertexBuffer                                     = 170,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9MapVertexBuffer                                          = 171,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9UnmapVertexBuffer                                        = 172,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9UnregisterVertexBuffer                                   = 173,
    CUPTI_DRIVER_TRACE_CBID_cuGLCtxCreate                                                  = 174,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsGLRegisterBuffer                                     = 175,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsGLRegisterImage                                      = 176,
    CUPTI_DRIVER_TRACE_CBID_cuWGLGetDevice                                                 = 177,
    CUPTI_DRIVER_TRACE_CBID_cuGLInit                                                       = 178,
    CUPTI_DRIVER_TRACE_CBID_cuGLRegisterBufferObject                                       = 179,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject                                            = 180,
    CUPTI_DRIVER_TRACE_CBID_cuGLUnmapBufferObject                                          = 181,
    CUPTI_DRIVER_TRACE_CBID_cuGLUnregisterBufferObject                                     = 182,
    CUPTI_DRIVER_TRACE_CBID_cuGLSetBufferObjectMapFlags                                    = 183,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync                                       = 184,
    CUPTI_DRIVER_TRACE_CBID_cuGLUnmapBufferObjectAsync                                     = 185,
    CUPTI_DRIVER_TRACE_CBID_cuVDPAUGetDevice                                               = 186,
    CUPTI_DRIVER_TRACE_CBID_cuVDPAUCtxCreate                                               = 187,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsVDPAURegisterVideoSurface                            = 188,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsVDPAURegisterOutputSurface                           = 189,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetSurfRef                                             = 190,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefCreate                                                = 191,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefDestroy                                               = 192,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefSetFormat                                             = 193,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefSetArray                                              = 194,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefGetFormat                                             = 195,
    CUPTI_DRIVER_TRACE_CBID_cuSurfRefGetArray                                              = 196,
    CUPTI_DRIVER_TRACE_CBID_cu64DeviceTotalMem                                             = 197,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedPointer                              = 198,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedSize                                 = 199,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedPitch                                = 200,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetSurfaceDimensions                          = 201,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetSurfaceDimensions                           = 202,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedPointer                               = 203,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedSize                                  = 204,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedPitch                                 = 205,
    CUPTI_DRIVER_TRACE_CBID_cu64D3D9MapVertexBuffer                                        = 206,
    CUPTI_DRIVER_TRACE_CBID_cu64GLMapBufferObject                                          = 207,
    CUPTI_DRIVER_TRACE_CBID_cu64GLMapBufferObjectAsync                                     = 208,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDevices                                              = 209,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreateOnDevice                                       = 210,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDevices                                              = 211,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreateOnDevice                                       = 212,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDevices                                               = 213,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreateOnDevice                                        = 214,
    CUPTI_DRIVER_TRACE_CBID_cu64MemHostAlloc                                               = 215,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD8Async                                                = 216,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD8Async                                              = 217,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD16Async                                               = 218,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD16Async                                             = 219,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD32Async                                               = 220,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD32Async                                             = 221,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8Async                                              = 222,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D8Async                                            = 223,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16Async                                             = 224,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D16Async                                           = 225,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32Async                                             = 226,
    CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D32Async                                           = 227,
    CUPTI_DRIVER_TRACE_CBID_cu64ArrayCreate                                                = 228,
    CUPTI_DRIVER_TRACE_CBID_cu64ArrayGetDescriptor                                         = 229,
    CUPTI_DRIVER_TRACE_CBID_cu64Array3DCreate                                              = 230,
    CUPTI_DRIVER_TRACE_CBID_cu64Array3DGetDescriptor                                       = 231,
    CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2D                                                   = 232,
    CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2DUnaligned                                          = 233,
    CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2DAsync                                              = 234,
    CUPTI_DRIVER_TRACE_CBID_cuCtxCreate_v2                                                 = 235,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreate_v2                                            = 236,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreate_v2                                            = 237,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreate_v2                                             = 238,
    CUPTI_DRIVER_TRACE_CBID_cuGLCtxCreate_v2                                               = 239,
    CUPTI_DRIVER_TRACE_CBID_cuVDPAUCtxCreate_v2                                            = 240,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetGlobal_v2                                           = 241,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetInfo_v2                                                = 242,
    CUPTI_DRIVER_TRACE_CBID_cuMemAlloc_v2                                                  = 243,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocPitch_v2                                             = 244,
    CUPTI_DRIVER_TRACE_CBID_cuMemFree_v2                                                   = 245,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetAddressRange_v2                                        = 246,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostGetDevicePointer_v2                                   = 247,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy_v2                                                    = 248,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD8_v2                                                  = 249,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD16_v2                                                 = 250,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD32_v2                                                 = 251,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8_v2                                                = 252,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16_v2                                               = 253,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32_v2                                               = 254,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress_v2                                          = 255,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D_v2                                        = 256,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddress_v2                                          = 257,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedPointer_v2                          = 258,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceTotalMem_v2                                            = 259,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPointer_v2                             = 260,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedSize_v2                                = 261,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPitch_v2                               = 262,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetSurfaceDimensions_v2                         = 263,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetSurfaceDimensions_v2                          = 264,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPointer_v2                              = 265,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedSize_v2                                 = 266,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPitch_v2                                = 267,
    CUPTI_DRIVER_TRACE_CBID_cuD3D9MapVertexBuffer_v2                                       = 268,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject_v2                                         = 269,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync_v2                                    = 270,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostAlloc_v2                                              = 271,
    CUPTI_DRIVER_TRACE_CBID_cuArrayCreate_v2                                               = 272,
    CUPTI_DRIVER_TRACE_CBID_cuArrayGetDescriptor_v2                                        = 273,
    CUPTI_DRIVER_TRACE_CBID_cuArray3DCreate_v2                                             = 274,
    CUPTI_DRIVER_TRACE_CBID_cuArray3DGetDescriptor_v2                                      = 275,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD_v2                                                = 276,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync_v2                                           = 277,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH_v2                                                = 278,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync_v2                                           = 279,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD_v2                                                = 280,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync_v2                                           = 281,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH_v2                                                = 282,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync_v2                                           = 283,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD_v2                                                = 284,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA_v2                                                = 285,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA_v2                                                = 286,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D_v2                                                  = 287,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned_v2                                         = 288,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync_v2                                             = 289,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D_v2                                                  = 290,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync_v2                                             = 291,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA_v2                                                = 292,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync_v2                                           = 293,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocHost_v2                                              = 294,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitEvent                                              = 295,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetApiVersion                                             = 296,
    CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDirect3DDevice                                       = 297,
    CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDirect3DDevice                                       = 298,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetCacheConfig                                            = 299,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSetCacheConfig                                            = 300,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostRegister                                              = 301,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostUnregister                                            = 302,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSetCurrent                                                = 303,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetCurrent                                                = 304,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy                                                       = 305,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAsync                                                  = 306,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchKernel                                                 = 307,
    CUPTI_DRIVER_TRACE_CBID_cuProfilerStart                                                = 308,
    CUPTI_DRIVER_TRACE_CBID_cuProfilerStop                                                 = 309,
    CUPTI_DRIVER_TRACE_CBID_cuPointerGetAttribute                                          = 310,
    CUPTI_DRIVER_TRACE_CBID_cuProfilerInitialize                                           = 311,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceCanAccessPeer                                          = 312,
    CUPTI_DRIVER_TRACE_CBID_cuCtxEnablePeerAccess                                          = 313,
    CUPTI_DRIVER_TRACE_CBID_cuCtxDisablePeerAccess                                         = 314,
    CUPTI_DRIVER_TRACE_CBID_cuMemPeerRegister                                              = 315,
    CUPTI_DRIVER_TRACE_CBID_cuMemPeerUnregister                                            = 316,
    CUPTI_DRIVER_TRACE_CBID_cuMemPeerGetDevicePointer                                      = 317,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeer                                                   = 318,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeerAsync                                              = 319,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeer                                                 = 320,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeerAsync                                            = 321,
    CUPTI_DRIVER_TRACE_CBID_cuCtxDestroy_v2                                                = 322,
    CUPTI_DRIVER_TRACE_CBID_cuCtxPushCurrent_v2                                            = 323,
    CUPTI_DRIVER_TRACE_CBID_cuCtxPopCurrent_v2                                             = 324,
    CUPTI_DRIVER_TRACE_CBID_cuEventDestroy_v2                                              = 325,
    CUPTI_DRIVER_TRACE_CBID_cuStreamDestroy_v2                                             = 326,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D_v3                                        = 327,
    CUPTI_DRIVER_TRACE_CBID_cuIpcGetMemHandle                                              = 328,
    CUPTI_DRIVER_TRACE_CBID_cuIpcOpenMemHandle                                             = 329,
    CUPTI_DRIVER_TRACE_CBID_cuIpcCloseMemHandle                                            = 330,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetByPCIBusId                                          = 331,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetPCIBusId                                            = 332,
    CUPTI_DRIVER_TRACE_CBID_cuGLGetDevices                                                 = 333,
    CUPTI_DRIVER_TRACE_CBID_cuIpcGetEventHandle                                            = 334,
    CUPTI_DRIVER_TRACE_CBID_cuIpcOpenEventHandle                                           = 335,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSetSharedMemConfig                                        = 336,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetSharedMemConfig                                        = 337,
    CUPTI_DRIVER_TRACE_CBID_cuFuncSetSharedMemConfig                                       = 338,
    CUPTI_DRIVER_TRACE_CBID_cuTexObjectCreate                                              = 339,
    CUPTI_DRIVER_TRACE_CBID_cuTexObjectDestroy                                             = 340,
    CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetResourceDesc                                     = 341,
    CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetTextureDesc                                      = 342,
    CUPTI_DRIVER_TRACE_CBID_cuSurfObjectCreate                                             = 343,
    CUPTI_DRIVER_TRACE_CBID_cuSurfObjectDestroy                                            = 344,
    CUPTI_DRIVER_TRACE_CBID_cuSurfObjectGetResourceDesc                                    = 345,
    CUPTI_DRIVER_TRACE_CBID_cuStreamAddCallback                                            = 346,
    CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayCreate                                         = 347,
    CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetLevel                                       = 348,
    CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayDestroy                                        = 349,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmappedArray                                      = 350,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapFilterMode                                    = 351,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapLevelBias                                     = 352,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapLevelClamp                                    = 353,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMaxAnisotropy                                       = 354,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmappedArray                                      = 355,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapFilterMode                                    = 356,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapLevelBias                                     = 357,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapLevelClamp                                    = 358,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMaxAnisotropy                                       = 359,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedMipmappedArray                      = 360,
    CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetResourceViewDesc                                 = 361,
    CUPTI_DRIVER_TRACE_CBID_cuLinkCreate                                                   = 362,
    CUPTI_DRIVER_TRACE_CBID_cuLinkAddData                                                  = 363,
    CUPTI_DRIVER_TRACE_CBID_cuLinkAddFile                                                  = 364,
    CUPTI_DRIVER_TRACE_CBID_cuLinkComplete                                                 = 365,
    CUPTI_DRIVER_TRACE_CBID_cuLinkDestroy                                                  = 366,
    CUPTI_DRIVER_TRACE_CBID_cuStreamCreateWithPriority                                     = 367,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetPriority                                            = 368,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetFlags                                               = 369,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetStreamPriorityRange                                    = 370,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocManaged                                              = 371,
    CUPTI_DRIVER_TRACE_CBID_cuGetErrorString                                               = 372,
    CUPTI_DRIVER_TRACE_CBID_cuGetErrorName                                                 = 373,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveBlocksPerMultiprocessor                    = 374,
    CUPTI_DRIVER_TRACE_CBID_cuCompilePtx                                                   = 375,
    CUPTI_DRIVER_TRACE_CBID_cuBinaryFree                                                   = 376,
    CUPTI_DRIVER_TRACE_CBID_cuStreamAttachMemAsync                                         = 377,
    CUPTI_DRIVER_TRACE_CBID_cuPointerSetAttribute                                          = 378,
    CUPTI_DRIVER_TRACE_CBID_cuMemHostRegister_v2                                           = 379,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceSetMapFlags_v2                               = 380,
    CUPTI_DRIVER_TRACE_CBID_cuLinkCreate_v2                                                = 381,
    CUPTI_DRIVER_TRACE_CBID_cuLinkAddData_v2                                               = 382,
    CUPTI_DRIVER_TRACE_CBID_cuLinkAddFile_v2                                               = 383,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialBlockSize                               = 384,
    CUPTI_DRIVER_TRACE_CBID_cuGLGetDevices_v2                                              = 385,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRetain                                       = 386,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRelease                                      = 387,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxSetFlags                                     = 388,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxReset                                        = 389,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsEGLRegisterImage                                     = 390,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetFlags                                                  = 391,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxGetState                                     = 392,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerConnect                                     = 393,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerDisconnect                                  = 394,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerAcquireFrame                                = 395,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerReleaseFrame                                = 396,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD_v2_ptds                                           = 397,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH_v2_ptds                                           = 398,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD_v2_ptds                                           = 399,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA_v2_ptds                                           = 400,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD_v2_ptds                                           = 401,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA_v2_ptds                                           = 402,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH_v2_ptds                                           = 403,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA_v2_ptds                                           = 404,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D_v2_ptds                                             = 405,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned_v2_ptds                                    = 406,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D_v2_ptds                                             = 407,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy_ptds                                                  = 408,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeer_ptds                                              = 409,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeer_ptds                                            = 410,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD8_v2_ptds                                             = 411,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD16_v2_ptds                                            = 412,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD32_v2_ptds                                            = 413,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8_v2_ptds                                           = 414,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16_v2_ptds                                          = 415,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32_v2_ptds                                          = 416,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject_v2_ptds                                    = 417,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAsync_ptsz                                             = 418,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync_v2_ptsz                                      = 419,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync_v2_ptsz                                      = 420,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync_v2_ptsz                                      = 421,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync_v2_ptsz                                      = 422,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync_v2_ptsz                                      = 423,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync_v2_ptsz                                        = 424,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync_v2_ptsz                                        = 425,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeerAsync_ptsz                                         = 426,
    CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeerAsync_ptsz                                       = 427,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD8Async_ptsz                                           = 428,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD16Async_ptsz                                          = 429,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD32Async_ptsz                                          = 430,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8Async_ptsz                                         = 431,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16Async_ptsz                                        = 432,
    CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32Async_ptsz                                        = 433,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetPriority_ptsz                                       = 434,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetFlags_ptsz                                          = 435,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitEvent_ptsz                                         = 436,
    CUPTI_DRIVER_TRACE_CBID_cuStreamAddCallback_ptsz                                       = 437,
    CUPTI_DRIVER_TRACE_CBID_cuStreamAttachMemAsync_ptsz                                    = 438,
    CUPTI_DRIVER_TRACE_CBID_cuStreamQuery_ptsz                                             = 439,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSynchronize_ptsz                                       = 440,
    CUPTI_DRIVER_TRACE_CBID_cuEventRecord_ptsz                                             = 441,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchKernel_ptsz                                            = 442,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsMapResources_ptsz                                    = 443,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnmapResources_ptsz                                  = 444,
    CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync_v2_ptsz                               = 445,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerConnect                                     = 446,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerDisconnect                                  = 447,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerPresentFrame                                = 448,
    CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedEglFrame                            = 449,
    CUPTI_DRIVER_TRACE_CBID_cuPointerGetAttributes                                         = 450,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags           = 451,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialBlockSizeWithFlags                      = 452,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerReturnFrame                                 = 453,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetP2PAttribute                                        = 454,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefSetBorderColor                                         = 455,
    CUPTI_DRIVER_TRACE_CBID_cuTexRefGetBorderColor                                         = 456,
    CUPTI_DRIVER_TRACE_CBID_cuMemAdvise                                                    = 457,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32                                            = 458,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_ptsz                                       = 459,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32                                           = 460,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_ptsz                                      = 461,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp                                             = 462,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_ptsz                                        = 463,
    CUPTI_DRIVER_TRACE_CBID_cuNVNbufferGetPointer                                          = 464,
    CUPTI_DRIVER_TRACE_CBID_cuNVNtextureGetArray                                           = 465,
    CUPTI_DRIVER_TRACE_CBID_cuNNSetAllocator                                               = 466,
    CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync                                             = 467,
    CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync_ptsz                                        = 468,
    CUPTI_DRIVER_TRACE_CBID_cuEventCreateFromNVNSync                                       = 469,
    CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerConnectWithFlags                            = 470,
    CUPTI_DRIVER_TRACE_CBID_cuMemRangeGetAttribute                                         = 471,
    CUPTI_DRIVER_TRACE_CBID_cuMemRangeGetAttributes                                        = 472,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64                                            = 473,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_ptsz                                       = 474,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64                                           = 475,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_ptsz                                      = 476,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernel                                      = 477,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernel_ptsz                                 = 478,
    CUPTI_DRIVER_TRACE_CBID_cuEventCreateFromEGLSync                                       = 479,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernelMultiDevice                           = 480,
    CUPTI_DRIVER_TRACE_CBID_cuFuncSetAttribute                                             = 481,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetUuid                                                = 482,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx                                                 = 483,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx_ptsz                                            = 484,
    CUPTI_DRIVER_TRACE_CBID_cuImportExternalMemory                                         = 485,
    CUPTI_DRIVER_TRACE_CBID_cuExternalMemoryGetMappedBuffer                                = 486,
    CUPTI_DRIVER_TRACE_CBID_cuExternalMemoryGetMappedMipmappedArray                        = 487,
    CUPTI_DRIVER_TRACE_CBID_cuDestroyExternalMemory                                        = 488,
    CUPTI_DRIVER_TRACE_CBID_cuImportExternalSemaphore                                      = 489,
    CUPTI_DRIVER_TRACE_CBID_cuSignalExternalSemaphoresAsync                                = 490,
    CUPTI_DRIVER_TRACE_CBID_cuSignalExternalSemaphoresAsync_ptsz                           = 491,
    CUPTI_DRIVER_TRACE_CBID_cuWaitExternalSemaphoresAsync                                  = 492,
    CUPTI_DRIVER_TRACE_CBID_cuWaitExternalSemaphoresAsync_ptsz                             = 493,
    CUPTI_DRIVER_TRACE_CBID_cuDestroyExternalSemaphore                                     = 494,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture                                           = 495,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_ptsz                                      = 496,
    CUPTI_DRIVER_TRACE_CBID_cuStreamEndCapture                                             = 497,
    CUPTI_DRIVER_TRACE_CBID_cuStreamEndCapture_ptsz                                        = 498,
    CUPTI_DRIVER_TRACE_CBID_cuStreamIsCapturing                                            = 499,
    CUPTI_DRIVER_TRACE_CBID_cuStreamIsCapturing_ptsz                                       = 500,
    CUPTI_DRIVER_TRACE_CBID_cuGraphCreate                                                  = 501,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddKernelNode                                           = 502,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetParams                                     = 503,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemcpyNode                                           = 504,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemcpyNodeGetParams                                     = 505,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemsetNode                                           = 506,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemsetNodeGetParams                                     = 507,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemsetNodeSetParams                                     = 508,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetType                                             = 509,
    CUPTI_DRIVER_TRACE_CBID_cuGraphGetRootNodes                                            = 510,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependencies                                     = 511,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependentNodes                                   = 512,
    CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiate                                             = 513,
    CUPTI_DRIVER_TRACE_CBID_cuGraphLaunch                                                  = 514,
    CUPTI_DRIVER_TRACE_CBID_cuGraphLaunch_ptsz                                             = 515,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecDestroy                                             = 516,
    CUPTI_DRIVER_TRACE_CBID_cuGraphDestroy                                                 = 517,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddDependencies                                         = 518,
    CUPTI_DRIVER_TRACE_CBID_cuGraphRemoveDependencies                                      = 519,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemcpyNodeSetParams                                     = 520,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetParams                                     = 521,
    CUPTI_DRIVER_TRACE_CBID_cuGraphDestroyNode                                             = 522,
    CUPTI_DRIVER_TRACE_CBID_cuGraphClone                                                   = 523,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeFindInClone                                         = 524,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddChildGraphNode                                       = 525,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddEmptyNode                                            = 526,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchHostFunc                                               = 527,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchHostFunc_ptsz                                          = 528,
    CUPTI_DRIVER_TRACE_CBID_cuGraphChildGraphNodeGetGraph                                  = 529,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddHostNode                                             = 530,
    CUPTI_DRIVER_TRACE_CBID_cuGraphHostNodeGetParams                                       = 531,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetLuid                                                = 532,
    CUPTI_DRIVER_TRACE_CBID_cuGraphHostNodeSetParams                                       = 533,
    CUPTI_DRIVER_TRACE_CBID_cuGraphGetNodes                                                = 534,
    CUPTI_DRIVER_TRACE_CBID_cuGraphGetEdges                                                = 535,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo                                         = 536,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_ptsz                                    = 537,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecKernelNodeSetParams                                 = 538,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_v2                                        = 539,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_v2_ptsz                                   = 540,
    CUPTI_DRIVER_TRACE_CBID_cuThreadExchangeStreamCaptureMode                              = 541,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetNvSciSyncAttributes                                 = 542,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyAvailableDynamicSMemPerBlock                        = 543,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRelease_v2                                   = 544,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxReset_v2                                     = 545,
    CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxSetFlags_v2                                  = 546,
    CUPTI_DRIVER_TRACE_CBID_cuMemAddressReserve                                            = 547,
    CUPTI_DRIVER_TRACE_CBID_cuMemAddressFree                                               = 548,
    CUPTI_DRIVER_TRACE_CBID_cuMemCreate                                                    = 549,
    CUPTI_DRIVER_TRACE_CBID_cuMemRelease                                                   = 550,
    CUPTI_DRIVER_TRACE_CBID_cuMemMap                                                       = 551,
    CUPTI_DRIVER_TRACE_CBID_cuMemUnmap                                                     = 552,
    CUPTI_DRIVER_TRACE_CBID_cuMemSetAccess                                                 = 553,
    CUPTI_DRIVER_TRACE_CBID_cuMemExportToShareableHandle                                   = 554,
    CUPTI_DRIVER_TRACE_CBID_cuMemImportFromShareableHandle                                 = 555,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetAllocationGranularity                                  = 556,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetAllocationPropertiesFromHandle                         = 557,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetAccess                                                 = 558,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSetFlags                                               = 559,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSetFlags_ptsz                                          = 560,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecUpdate                                              = 561,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecMemcpyNodeSetParams                                 = 562,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecMemsetNodeSetParams                                 = 563,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecHostNodeSetParams                                   = 564,
    CUPTI_DRIVER_TRACE_CBID_cuMemRetainAllocationHandle                                    = 565,
    CUPTI_DRIVER_TRACE_CBID_cuFuncGetModule                                                = 566,
    CUPTI_DRIVER_TRACE_CBID_cuIpcOpenMemHandle_v2                                          = 567,
    CUPTI_DRIVER_TRACE_CBID_cuCtxResetPersistingL2Cache                                    = 568,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeCopyAttributes                                = 569,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetAttribute                                  = 570,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetAttribute                                  = 571,
    CUPTI_DRIVER_TRACE_CBID_cuStreamCopyAttributes                                         = 572,
    CUPTI_DRIVER_TRACE_CBID_cuStreamCopyAttributes_ptsz                                    = 573,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetAttribute                                           = 574,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetAttribute_ptsz                                      = 575,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSetAttribute                                           = 576,
    CUPTI_DRIVER_TRACE_CBID_cuStreamSetAttribute_ptsz                                      = 577,
    CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiate_v2                                          = 578,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetTexture1DLinearMaxWidth                             = 579,
    CUPTI_DRIVER_TRACE_CBID_cuGraphUpload                                                  = 580,
    CUPTI_DRIVER_TRACE_CBID_cuGraphUpload_ptsz                                             = 581,
    CUPTI_DRIVER_TRACE_CBID_cuArrayGetSparseProperties                                     = 582,
    CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetSparseProperties                            = 583,
    CUPTI_DRIVER_TRACE_CBID_cuMemMapArrayAsync                                             = 584,
    CUPTI_DRIVER_TRACE_CBID_cuMemMapArrayAsync_ptsz                                        = 585,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecChildGraphNodeSetParams                             = 586,
    CUPTI_DRIVER_TRACE_CBID_cuEventRecordWithFlags                                         = 587,
    CUPTI_DRIVER_TRACE_CBID_cuEventRecordWithFlags_ptsz                                    = 588,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddEventRecordNode                                      = 589,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddEventWaitNode                                        = 590,
    CUPTI_DRIVER_TRACE_CBID_cuGraphEventRecordNodeGetEvent                                 = 591,
    CUPTI_DRIVER_TRACE_CBID_cuGraphEventWaitNodeGetEvent                                   = 592,
    CUPTI_DRIVER_TRACE_CBID_cuGraphEventRecordNodeSetEvent                                 = 593,
    CUPTI_DRIVER_TRACE_CBID_cuGraphEventWaitNodeSetEvent                                   = 594,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecEventRecordNodeSetEvent                             = 595,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecEventWaitNodeSetEvent                               = 596,
    CUPTI_DRIVER_TRACE_CBID_cuArrayGetPlane                                                = 597,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocAsync                                                = 598,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocAsync_ptsz                                           = 599,
    CUPTI_DRIVER_TRACE_CBID_cuMemFreeAsync                                                 = 600,
    CUPTI_DRIVER_TRACE_CBID_cuMemFreeAsync_ptsz                                            = 601,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolTrimTo                                                = 602,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolSetAttribute                                          = 603,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolGetAttribute                                          = 604,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolSetAccess                                             = 605,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetDefaultMemPool                                      = 606,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolCreate                                                = 607,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolDestroy                                               = 608,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceSetMemPool                                             = 609,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetMemPool                                             = 610,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocFromPoolAsync                                        = 611,
    CUPTI_DRIVER_TRACE_CBID_cuMemAllocFromPoolAsync_ptsz                                   = 612,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolExportToShareableHandle                               = 613,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolImportFromShareableHandle                             = 614,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolExportPointer                                         = 615,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolImportPointer                                         = 616,
    CUPTI_DRIVER_TRACE_CBID_cuMemPoolGetAccess                                             = 617,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddExternalSemaphoresSignalNode                         = 618,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresSignalNodeGetParams                   = 619,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresSignalNodeSetParams                   = 620,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddExternalSemaphoresWaitNode                           = 621,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresWaitNodeGetParams                     = 622,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresWaitNodeSetParams                     = 623,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecExternalSemaphoresSignalNodeSetParams               = 624,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecExternalSemaphoresWaitNodeSetParams                 = 625,
    CUPTI_DRIVER_TRACE_CBID_cuGetProcAddress                                               = 626,
    CUPTI_DRIVER_TRACE_CBID_cuFlushGPUDirectRDMAWrites                                     = 627,
    CUPTI_DRIVER_TRACE_CBID_cuGraphDebugDotPrint                                           = 628,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v2                                      = 629,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v2_ptsz                                 = 630,
    CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies                              = 631,
    CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies_ptsz                         = 632,
    CUPTI_DRIVER_TRACE_CBID_cuUserObjectCreate                                             = 633,
    CUPTI_DRIVER_TRACE_CBID_cuUserObjectRetain                                             = 634,
    CUPTI_DRIVER_TRACE_CBID_cuUserObjectRelease                                            = 635,
    CUPTI_DRIVER_TRACE_CBID_cuGraphRetainUserObject                                        = 636,
    CUPTI_DRIVER_TRACE_CBID_cuGraphReleaseUserObject                                       = 637,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemAllocNode                                         = 638,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemFreeNode                                          = 639,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGraphMemTrim                                           = 640,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetGraphMemAttribute                                   = 641,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceSetGraphMemAttribute                                   = 642,
    CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithFlags                                    = 643,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetExecAffinitySupport                                 = 644,
    CUPTI_DRIVER_TRACE_CBID_cuCtxCreate_v3                                                 = 645,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetExecAffinity                                           = 646,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetUuid_v2                                             = 647,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemAllocNodeGetParams                                   = 648,
    CUPTI_DRIVER_TRACE_CBID_cuGraphMemFreeNodeGetParams                                    = 649,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeSetEnabled                                          = 650,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetEnabled                                          = 651,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchKernelEx                                               = 652,
    CUPTI_DRIVER_TRACE_CBID_cuLaunchKernelEx_ptsz                                          = 653,
    CUPTI_DRIVER_TRACE_CBID_cuArrayGetMemoryRequirements                                   = 654,
    CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetMemoryRequirements                          = 655,
    CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithParams                                   = 656,
    CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithParams_ptsz                              = 657,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecGetFlags                                            = 658,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_v2                                         = 659,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_v2_ptsz                                    = 660,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_v2                                         = 661,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_v2_ptsz                                    = 662,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_v2                                        = 663,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_v2_ptsz                                   = 664,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_v2                                        = 665,
    CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_v2_ptsz                                   = 666,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_v2                                          = 667,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_v2_ptsz                                     = 668,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddBatchMemOpNode                                       = 669,
    CUPTI_DRIVER_TRACE_CBID_cuGraphBatchMemOpNodeGetParams                                 = 670,
    CUPTI_DRIVER_TRACE_CBID_cuGraphBatchMemOpNodeSetParams                                 = 671,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecBatchMemOpNodeSetParams                             = 672,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetLoadingMode                                         = 673,
    CUPTI_DRIVER_TRACE_CBID_cuMemGetHandleForAddressRange                                  = 674,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialClusterSize                             = 675,
    CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveClusters                                   = 676,
    CUPTI_DRIVER_TRACE_CBID_cuGetProcAddress_v2                                            = 677,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryLoadData                                              = 678,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryLoadFromFile                                          = 679,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryUnload                                                = 680,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetKernel                                             = 681,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetModule                                             = 682,
    CUPTI_DRIVER_TRACE_CBID_cuKernelGetFunction                                            = 683,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetGlobal                                             = 684,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetManaged                                            = 685,
    CUPTI_DRIVER_TRACE_CBID_cuKernelGetAttribute                                           = 686,
    CUPTI_DRIVER_TRACE_CBID_cuKernelSetAttribute                                           = 687,
    CUPTI_DRIVER_TRACE_CBID_cuKernelSetCacheConfig                                         = 688,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddKernelNode_v2                                        = 689,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetParams_v2                                  = 690,
    CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetParams_v2                                  = 691,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecKernelNodeSetParams_v2                              = 692,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetId                                                  = 693,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetId_ptsz                                             = 694,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetId                                                     = 695,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecUpdate_v2                                           = 696,
    CUPTI_DRIVER_TRACE_CBID_cuTensorMapEncodeTiled                                         = 697,
    CUPTI_DRIVER_TRACE_CBID_cuTensorMapEncodeIm2col                                        = 698,
    CUPTI_DRIVER_TRACE_CBID_cuTensorMapReplaceAddress                                      = 699,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetUnifiedFunction                                    = 700,
    CUPTI_DRIVER_TRACE_CBID_cuCoredumpGetAttribute                                         = 701,
    CUPTI_DRIVER_TRACE_CBID_cuCoredumpGetAttributeGlobal                                   = 702,
    CUPTI_DRIVER_TRACE_CBID_cuCoredumpSetAttribute                                         = 703,
    CUPTI_DRIVER_TRACE_CBID_cuCoredumpSetAttributeGlobal                                   = 704,
    CUPTI_DRIVER_TRACE_CBID_cuCtxSetFlags                                                  = 705,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastCreate                                              = 706,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastAddDevice                                           = 707,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastBindMem                                             = 708,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastBindAddr                                            = 709,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastUnbind                                              = 710,
    CUPTI_DRIVER_TRACE_CBID_cuMulticastGetGranularity                                      = 711,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddNode                                                 = 712,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeSetParams                                           = 713,
    CUPTI_DRIVER_TRACE_CBID_cuGraphExecNodeSetParams                                       = 714,
    CUPTI_DRIVER_TRACE_CBID_cuMemAdvise_v2                                                 = 715,
    CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync_v2                                          = 716,
    CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync_v2_ptsz                                     = 717,
    CUPTI_DRIVER_TRACE_CBID_cuFuncGetName                                                  = 718,
    CUPTI_DRIVER_TRACE_CBID_cuKernelGetName                                                = 719,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCaptureToGraph                                    = 720,
    CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCaptureToGraph_ptsz                               = 721,
    CUPTI_DRIVER_TRACE_CBID_cuGraphConditionalHandleCreate                                 = 722,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddNode_v2                                              = 723,
    CUPTI_DRIVER_TRACE_CBID_cuGraphGetEdges_v2                                             = 724,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependencies_v2                                  = 725,
    CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependentNodes_v2                                = 726,
    CUPTI_DRIVER_TRACE_CBID_cuGraphAddDependencies_v2                                      = 727,
    CUPTI_DRIVER_TRACE_CBID_cuGraphRemoveDependencies_v2                                   = 728,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v3                                      = 729,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v3_ptsz                                 = 730,
    CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies_v2                           = 731,
    CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies_v2_ptsz                      = 732,
    CUPTI_DRIVER_TRACE_CBID_cuFuncGetParamInfo                                             = 733,
    CUPTI_DRIVER_TRACE_CBID_cuKernelGetParamInfo                                           = 734,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceRegisterAsyncNotification                              = 735,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceUnregisterAsyncNotification                            = 736,
    CUPTI_DRIVER_TRACE_CBID_cuModuleGetFunctionCount                                       = 737,
    CUPTI_DRIVER_TRACE_CBID_cuModuleEnumerateFunctions                                     = 738,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryGetKernelCount                                        = 739,
    CUPTI_DRIVER_TRACE_CBID_cuLibraryEnumerateKernels                                      = 740,
    CUPTI_DRIVER_TRACE_CBID_cuFuncIsLoaded                                                 = 741,
    CUPTI_DRIVER_TRACE_CBID_cuFuncLoad                                                     = 742,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxCreate                                               = 743,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxDestroy                                              = 744,
    CUPTI_DRIVER_TRACE_CBID_cuDeviceGetDevResource                                         = 745,
    CUPTI_DRIVER_TRACE_CBID_cuCtxGetDevResource                                            = 746,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxGetDevResource                                       = 747,
    CUPTI_DRIVER_TRACE_CBID_cuDevResourceGenerateDesc                                      = 748,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxRecordEvent                                          = 749,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxWaitEvent                                            = 750,
    CUPTI_DRIVER_TRACE_CBID_cuDevSmResourceSplitByCount                                    = 751,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetGreenCtx                                            = 752,
    CUPTI_DRIVER_TRACE_CBID_cuCtxFromGreenCtx                                              = 753,
    CUPTI_DRIVER_TRACE_CBID_cuKernelGetLibrary                                             = 754,
    CUPTI_DRIVER_TRACE_CBID_cuCtxRecordEvent                                               = 755,
    CUPTI_DRIVER_TRACE_CBID_cuCtxWaitEvent                                                 = 756,
    CUPTI_DRIVER_TRACE_CBID_cuCtxCreate_v4                                                 = 757,
    CUPTI_DRIVER_TRACE_CBID_cuGreenCtxStreamCreate                                         = 758,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx_v2                                              = 759,
    CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx_v2_ptsz                                         = 760,
    CUPTI_DRIVER_TRACE_CBID_cuMemBatchDecompressAsync                                      = 761,
    CUPTI_DRIVER_TRACE_CBID_cuMemBatchDecompressAsync_ptsz                                 = 762,
    CUPTI_DRIVER_TRACE_CBID_SIZE                                                           = 763,
    CUPTI_DRIVER_TRACE_CBID_FORCE_INT                                                      = 0x7fffffff;

// #endif


// Parsed from cupti_runtime_cbid.h


// *************************************************************************
//      Definitions of indices for API functions, unique across entire API
// *************************************************************************

// This file is generated.  Any changes you make will be lost during the next clean build.
// CUDA public interface, for type definitions and cu* function prototypes

// #if !defined(_CUPTI_RUNTIME_CBID_H)
// #define _CUPTI_RUNTIME_CBID_H

/** enum CUpti_runtime_api_trace_cbid */
public static final int
    CUPTI_RUNTIME_TRACE_CBID_INVALID                                                       = 0,
    CUPTI_RUNTIME_TRACE_CBID_cudaDriverGetVersion_v3020                                    = 1,
    CUPTI_RUNTIME_TRACE_CBID_cudaRuntimeGetVersion_v3020                                   = 2,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceCount_v3020                                      = 3,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceProperties_v3020                                 = 4,
    CUPTI_RUNTIME_TRACE_CBID_cudaChooseDevice_v3020                                        = 5,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetChannelDesc_v3020                                      = 6,
    CUPTI_RUNTIME_TRACE_CBID_cudaCreateChannelDesc_v3020                                   = 7,
    CUPTI_RUNTIME_TRACE_CBID_cudaConfigureCall_v3020                                       = 8,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetupArgument_v3020                                       = 9,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetLastError_v3020                                        = 10,
    CUPTI_RUNTIME_TRACE_CBID_cudaPeekAtLastError_v3020                                     = 11,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetErrorString_v3020                                      = 12,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunch_v3020                                              = 13,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetCacheConfig_v3020                                  = 14,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncGetAttributes_v3020                                   = 15,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetDevice_v3020                                           = 16,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDevice_v3020                                           = 17,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetValidDevices_v3020                                     = 18,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetDeviceFlags_v3020                                      = 19,
    CUPTI_RUNTIME_TRACE_CBID_cudaMalloc_v3020                                              = 20,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocPitch_v3020                                         = 21,
    CUPTI_RUNTIME_TRACE_CBID_cudaFree_v3020                                                = 22,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocArray_v3020                                         = 23,
    CUPTI_RUNTIME_TRACE_CBID_cudaFreeArray_v3020                                           = 24,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocHost_v3020                                          = 25,
    CUPTI_RUNTIME_TRACE_CBID_cudaFreeHost_v3020                                            = 26,
    CUPTI_RUNTIME_TRACE_CBID_cudaHostAlloc_v3020                                           = 27,
    CUPTI_RUNTIME_TRACE_CBID_cudaHostGetDevicePointer_v3020                                = 28,
    CUPTI_RUNTIME_TRACE_CBID_cudaHostGetFlags_v3020                                        = 29,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemGetInfo_v3020                                          = 30,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy_v3020                                              = 31,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2D_v3020                                            = 32,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArray_v3020                                       = 33,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArray_v3020                                     = 34,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArray_v3020                                     = 35,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArray_v3020                                   = 36,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyArrayToArray_v3020                                  = 37,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DArrayToArray_v3020                                = 38,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbol_v3020                                      = 39,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbol_v3020                                    = 40,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyAsync_v3020                                         = 41,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArrayAsync_v3020                                  = 42,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArrayAsync_v3020                                = 43,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DAsync_v3020                                       = 44,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArrayAsync_v3020                                = 45,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArrayAsync_v3020                              = 46,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbolAsync_v3020                                 = 47,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbolAsync_v3020                               = 48,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset_v3020                                              = 49,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset2D_v3020                                            = 50,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemsetAsync_v3020                                         = 51,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset2DAsync_v3020                                       = 52,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetSymbolAddress_v3020                                    = 53,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetSymbolSize_v3020                                       = 54,
    CUPTI_RUNTIME_TRACE_CBID_cudaBindTexture_v3020                                         = 55,
    CUPTI_RUNTIME_TRACE_CBID_cudaBindTexture2D_v3020                                       = 56,
    CUPTI_RUNTIME_TRACE_CBID_cudaBindTextureToArray_v3020                                  = 57,
    CUPTI_RUNTIME_TRACE_CBID_cudaUnbindTexture_v3020                                       = 58,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureAlignmentOffset_v3020                           = 59,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureReference_v3020                                 = 60,
    CUPTI_RUNTIME_TRACE_CBID_cudaBindSurfaceToArray_v3020                                  = 61,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetSurfaceReference_v3020                                 = 62,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLSetGLDevice_v3020                                       = 63,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLRegisterBufferObject_v3020                              = 64,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLMapBufferObject_v3020                                   = 65,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLUnmapBufferObject_v3020                                 = 66,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLUnregisterBufferObject_v3020                            = 67,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLSetBufferObjectMapFlags_v3020                           = 68,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLMapBufferObjectAsync_v3020                              = 69,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLUnmapBufferObjectAsync_v3020                            = 70,
    CUPTI_RUNTIME_TRACE_CBID_cudaWGLGetDevice_v3020                                        = 71,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsGLRegisterImage_v3020                             = 72,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsGLRegisterBuffer_v3020                            = 73,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsUnregisterResource_v3020                          = 74,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceSetMapFlags_v3020                         = 75,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsMapResources_v3020                                = 76,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsUnmapResources_v3020                              = 77,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedPointer_v3020                    = 78,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsSubResourceGetMappedArray_v3020                   = 79,
    CUPTI_RUNTIME_TRACE_CBID_cudaVDPAUGetDevice_v3020                                      = 80,
    CUPTI_RUNTIME_TRACE_CBID_cudaVDPAUSetVDPAUDevice_v3020                                 = 81,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsVDPAURegisterVideoSurface_v3020                   = 82,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsVDPAURegisterOutputSurface_v3020                  = 83,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDevice_v3020                                      = 84,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDevices_v3020                                     = 85,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D11SetDirect3DDevice_v3020                              = 86,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D11RegisterResource_v3020                       = 87,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDevice_v3020                                      = 88,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDevices_v3020                                     = 89,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10SetDirect3DDevice_v3020                              = 90,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D10RegisterResource_v3020                       = 91,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10RegisterResource_v3020                               = 92,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10UnregisterResource_v3020                             = 93,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10MapResources_v3020                                   = 94,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10UnmapResources_v3020                                 = 95,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceSetMapFlags_v3020                            = 96,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetSurfaceDimensions_v3020                   = 97,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedArray_v3020                         = 98,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedPointer_v3020                       = 99,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedSize_v3020                          = 100,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedPitch_v3020                         = 101,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDevice_v3020                                       = 102,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDevices_v3020                                      = 103,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9SetDirect3DDevice_v3020                               = 104,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDirect3DDevice_v3020                               = 105,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D9RegisterResource_v3020                        = 106,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9RegisterResource_v3020                                = 107,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnregisterResource_v3020                              = 108,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9MapResources_v3020                                    = 109,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnmapResources_v3020                                  = 110,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceSetMapFlags_v3020                             = 111,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetSurfaceDimensions_v3020                    = 112,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedArray_v3020                          = 113,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedPointer_v3020                        = 114,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedSize_v3020                           = 115,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedPitch_v3020                          = 116,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9Begin_v3020                                           = 117,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9End_v3020                                             = 118,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9RegisterVertexBuffer_v3020                            = 119,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnregisterVertexBuffer_v3020                          = 120,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9MapVertexBuffer_v3020                                 = 121,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnmapVertexBuffer_v3020                               = 122,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadExit_v3020                                          = 123,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetDoubleForDevice_v3020                                  = 124,
    CUPTI_RUNTIME_TRACE_CBID_cudaSetDoubleForHost_v3020                                    = 125,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadSynchronize_v3020                                   = 126,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadGetLimit_v3020                                      = 127,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadSetLimit_v3020                                      = 128,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreate_v3020                                        = 129,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamDestroy_v3020                                       = 130,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSynchronize_v3020                                   = 131,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamQuery_v3020                                         = 132,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventCreate_v3020                                         = 133,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventCreateWithFlags_v3020                                = 134,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventRecord_v3020                                         = 135,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventDestroy_v3020                                        = 136,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventSynchronize_v3020                                    = 137,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventQuery_v3020                                          = 138,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventElapsedTime_v3020                                    = 139,
    CUPTI_RUNTIME_TRACE_CBID_cudaMalloc3D_v3020                                            = 140,
    CUPTI_RUNTIME_TRACE_CBID_cudaMalloc3DArray_v3020                                       = 141,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset3D_v3020                                            = 142,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset3DAsync_v3020                                       = 143,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3D_v3020                                            = 144,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DAsync_v3020                                       = 145,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadSetCacheConfig_v3020                                = 146,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamWaitEvent_v3020                                     = 147,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDirect3DDevice_v3020                              = 148,
    CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDirect3DDevice_v3020                              = 149,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadGetCacheConfig_v3020                                = 150,
    CUPTI_RUNTIME_TRACE_CBID_cudaPointerGetAttributes_v4000                                = 151,
    CUPTI_RUNTIME_TRACE_CBID_cudaHostRegister_v4000                                        = 152,
    CUPTI_RUNTIME_TRACE_CBID_cudaHostUnregister_v4000                                      = 153,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceCanAccessPeer_v4000                                 = 154,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceEnablePeerAccess_v4000                              = 155,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceDisablePeerAccess_v4000                             = 156,
    CUPTI_RUNTIME_TRACE_CBID_cudaPeerRegister_v4000                                        = 157,
    CUPTI_RUNTIME_TRACE_CBID_cudaPeerUnregister_v4000                                      = 158,
    CUPTI_RUNTIME_TRACE_CBID_cudaPeerGetDevicePointer_v4000                                = 159,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyPeer_v4000                                          = 160,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyPeerAsync_v4000                                     = 161,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeer_v4000                                        = 162,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeerAsync_v4000                                   = 163,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceReset_v3020                                         = 164,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSynchronize_v3020                                   = 165,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetLimit_v3020                                      = 166,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetLimit_v3020                                      = 167,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetCacheConfig_v3020                                = 168,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetCacheConfig_v3020                                = 169,
    CUPTI_RUNTIME_TRACE_CBID_cudaProfilerInitialize_v4000                                  = 170,
    CUPTI_RUNTIME_TRACE_CBID_cudaProfilerStart_v4000                                       = 171,
    CUPTI_RUNTIME_TRACE_CBID_cudaProfilerStop_v4000                                        = 172,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetByPCIBusId_v4010                                 = 173,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetPCIBusId_v4010                                   = 174,
    CUPTI_RUNTIME_TRACE_CBID_cudaGLGetDevices_v4010                                        = 175,
    CUPTI_RUNTIME_TRACE_CBID_cudaIpcGetEventHandle_v4010                                   = 176,
    CUPTI_RUNTIME_TRACE_CBID_cudaIpcOpenEventHandle_v4010                                  = 177,
    CUPTI_RUNTIME_TRACE_CBID_cudaIpcGetMemHandle_v4010                                     = 178,
    CUPTI_RUNTIME_TRACE_CBID_cudaIpcOpenMemHandle_v4010                                    = 179,
    CUPTI_RUNTIME_TRACE_CBID_cudaIpcCloseMemHandle_v4010                                   = 180,
    CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetInfo_v4010                                        = 181,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetSharedMemConfig_v4020                              = 182,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetSharedMemConfig_v4020                            = 183,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetSharedMemConfig_v4020                            = 184,
    CUPTI_RUNTIME_TRACE_CBID_cudaCreateTextureObject_v5000                                 = 185,
    CUPTI_RUNTIME_TRACE_CBID_cudaDestroyTextureObject_v5000                                = 186,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectResourceDesc_v5000                        = 187,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectTextureDesc_v5000                         = 188,
    CUPTI_RUNTIME_TRACE_CBID_cudaCreateSurfaceObject_v5000                                 = 189,
    CUPTI_RUNTIME_TRACE_CBID_cudaDestroySurfaceObject_v5000                                = 190,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetSurfaceObjectResourceDesc_v5000                        = 191,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocMipmappedArray_v5000                                = 192,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetMipmappedArrayLevel_v5000                              = 193,
    CUPTI_RUNTIME_TRACE_CBID_cudaFreeMipmappedArray_v5000                                  = 194,
    CUPTI_RUNTIME_TRACE_CBID_cudaBindTextureToMipmappedArray_v5000                         = 195,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedMipmappedArray_v5000             = 196,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamAddCallback_v5000                                   = 197,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreateWithFlags_v5000                               = 198,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectResourceViewDesc_v5000                    = 199,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetAttribute_v5000                                  = 200,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamDestroy_v5050                                       = 201,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreateWithPriority_v5050                            = 202,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetPriority_v5050                                   = 203,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetFlags_v5050                                      = 204,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetStreamPriorityRange_v5050                        = 205,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocManaged_v6000                                       = 206,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessor_v6000           = 207,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamAttachMemAsync_v6000                                = 208,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetErrorName_v6050                                        = 209,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessor_v6050           = 210,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernel_v7000                                        = 211,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceFlags_v7000                                      = 212,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunch_ptsz_v7000                                         = 213,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernel_ptsz_v7000                                   = 214,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy_ptds_v7000                                         = 215,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2D_ptds_v7000                                       = 216,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArray_ptds_v7000                                  = 217,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArray_ptds_v7000                                = 218,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArray_ptds_v7000                                = 219,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArray_ptds_v7000                              = 220,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyArrayToArray_ptds_v7000                             = 221,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DArrayToArray_ptds_v7000                           = 222,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbol_ptds_v7000                                 = 223,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbol_ptds_v7000                               = 224,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyAsync_ptsz_v7000                                    = 225,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArrayAsync_ptsz_v7000                             = 226,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArrayAsync_ptsz_v7000                           = 227,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DAsync_ptsz_v7000                                  = 228,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArrayAsync_ptsz_v7000                           = 229,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArrayAsync_ptsz_v7000                         = 230,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbolAsync_ptsz_v7000                            = 231,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbolAsync_ptsz_v7000                          = 232,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset_ptds_v7000                                         = 233,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset2D_ptds_v7000                                       = 234,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemsetAsync_ptsz_v7000                                    = 235,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset2DAsync_ptsz_v7000                                  = 236,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetPriority_ptsz_v7000                              = 237,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetFlags_ptsz_v7000                                 = 238,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSynchronize_ptsz_v7000                              = 239,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamQuery_ptsz_v7000                                    = 240,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamAttachMemAsync_ptsz_v7000                           = 241,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventRecord_ptsz_v7000                                    = 242,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset3D_ptds_v7000                                       = 243,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemset3DAsync_ptsz_v7000                                  = 244,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3D_ptds_v7000                                       = 245,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DAsync_ptsz_v7000                                  = 246,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamWaitEvent_ptsz_v7000                                = 247,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamAddCallback_ptsz_v7000                              = 248,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeer_ptds_v7000                                   = 249,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeerAsync_ptsz_v7000                              = 250,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags_v7000  = 251,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_v8000                                    = 252,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_ptsz_v8000                               = 253,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemAdvise_v8000                                           = 254,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetP2PAttribute_v8000                               = 255,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsEGLRegisterImage_v7000                            = 256,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerConnect_v7000                            = 257,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerDisconnect_v7000                         = 258,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerAcquireFrame_v7000                       = 259,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerReleaseFrame_v7000                       = 260,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerConnect_v7000                            = 261,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerDisconnect_v7000                         = 262,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerPresentFrame_v7000                       = 263,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerReturnFrame_v7000                        = 264,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedEglFrame_v7000                   = 265,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemRangeGetAttribute_v8000                                = 266,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemRangeGetAttributes_v8000                               = 267,
    CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerConnectWithFlags_v7000                   = 268,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernel_v9000                             = 269,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernel_ptsz_v9000                        = 270,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventCreateFromEGLSync_v9000                              = 271,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernelMultiDevice_v9000                  = 272,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetAttribute_v9000                                    = 273,
    CUPTI_RUNTIME_TRACE_CBID_cudaImportExternalMemory_v10000                               = 274,
    CUPTI_RUNTIME_TRACE_CBID_cudaExternalMemoryGetMappedBuffer_v10000                      = 275,
    CUPTI_RUNTIME_TRACE_CBID_cudaExternalMemoryGetMappedMipmappedArray_v10000              = 276,
    CUPTI_RUNTIME_TRACE_CBID_cudaDestroyExternalMemory_v10000                              = 277,
    CUPTI_RUNTIME_TRACE_CBID_cudaImportExternalSemaphore_v10000                            = 278,
    CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v10000                      = 279,
    CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_ptsz_v10000                 = 280,
    CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v10000                        = 281,
    CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_ptsz_v10000                   = 282,
    CUPTI_RUNTIME_TRACE_CBID_cudaDestroyExternalSemaphore_v10000                           = 283,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchHostFunc_v10000                                     = 284,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchHostFunc_ptsz_v10000                                = 285,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphCreate_v10000                                        = 286,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeGetParams_v10000                           = 287,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeSetParams_v10000                           = 288,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddKernelNode_v10000                                 = 289,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNode_v10000                                 = 290,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeGetParams_v10000                           = 291,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParams_v10000                           = 292,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemsetNode_v10000                                 = 293,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemsetNodeGetParams_v10000                           = 294,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemsetNodeSetParams_v10000                           = 295,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddHostNode_v10000                                   = 296,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphHostNodeGetParams_v10000                             = 297,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddChildGraphNode_v10000                             = 298,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphChildGraphNodeGetGraph_v10000                        = 299,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEmptyNode_v10000                                  = 300,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphClone_v10000                                         = 301,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeFindInClone_v10000                               = 302,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetType_v10000                                   = 303,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetRootNodes_v10000                                  = 304,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependencies_v10000                           = 305,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependentNodes_v10000                         = 306,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddDependencies_v10000                               = 307,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphRemoveDependencies_v10000                            = 308,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphDestroyNode_v10000                                   = 309,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiate_v10000                                   = 310,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphLaunch_v10000                                        = 311,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphLaunch_ptsz_v10000                                   = 312,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecDestroy_v10000                                   = 313,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphDestroy_v10000                                       = 314,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCapture_v10000                                 = 315,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCapture_ptsz_v10000                            = 316,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamIsCapturing_v10000                                  = 317,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamIsCapturing_ptsz_v10000                             = 318,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamEndCapture_v10000                                   = 319,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamEndCapture_ptsz_v10000                              = 320,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphHostNodeSetParams_v10000                             = 321,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetNodes_v10000                                      = 322,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetEdges_v10000                                      = 323,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v10010                               = 324,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_ptsz_v10010                          = 325,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecKernelNodeSetParams_v10010                       = 326,
    CUPTI_RUNTIME_TRACE_CBID_cudaThreadExchangeStreamCaptureMode_v10010                    = 327,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetNvSciSyncAttributes_v10020                       = 328,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyAvailableDynamicSMemPerBlock_v10200              = 329,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetFlags_v10200                                     = 330,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetFlags_ptsz_v10200                                = 331,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParams_v10020                       = 332,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemsetNodeSetParams_v10020                       = 333,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecHostNodeSetParams_v10020                         = 334,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecUpdate_v10020                                    = 335,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetFuncBySymbol_v11000                                    = 336,
    CUPTI_RUNTIME_TRACE_CBID_cudaCtxResetPersistingL2Cache_v11000                          = 337,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeCopyAttributes_v11000                      = 338,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeGetAttribute_v11000                        = 339,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeSetAttribute_v11000                        = 340,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamCopyAttributes_v11000                               = 341,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamCopyAttributes_ptsz_v11000                          = 342,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetAttribute_v11000                                 = 343,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetAttribute_ptsz_v11000                            = 344,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetAttribute_v11000                                 = 345,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetAttribute_ptsz_v11000                            = 346,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetTexture1DLinearMaxWidth_v11010                   = 347,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphUpload_v10000                                        = 348,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphUpload_ptsz_v10000                                   = 349,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNodeToSymbol_v11010                         = 350,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNodeFromSymbol_v11010                       = 351,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNode1D_v11010                               = 352,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParamsToSymbol_v11010                   = 353,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParamsFromSymbol_v11010                 = 354,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParams1D_v11010                         = 355,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParamsToSymbol_v11010               = 356,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParamsFromSymbol_v11010             = 357,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParams1D_v11010                     = 358,
    CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetSparseProperties_v11010                           = 359,
    CUPTI_RUNTIME_TRACE_CBID_cudaMipmappedArrayGetSparseProperties_v11010                  = 360,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecChildGraphNodeSetParams_v11010                   = 361,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEventRecordNode_v11010                            = 362,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventRecordNodeGetEvent_v11010                       = 363,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventRecordNodeSetEvent_v11010                       = 364,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEventWaitNode_v11010                              = 365,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventWaitNodeGetEvent_v11010                         = 366,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventWaitNodeSetEvent_v11010                         = 367,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecEventRecordNodeSetEvent_v11010                   = 368,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecEventWaitNodeSetEvent_v11010                     = 369,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventRecordWithFlags_v11010                               = 370,
    CUPTI_RUNTIME_TRACE_CBID_cudaEventRecordWithFlags_ptsz_v11010                          = 371,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetDefaultMemPool_v11020                            = 372,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocAsync_v11020                                        = 373,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocAsync_ptsz_v11020                                   = 374,
    CUPTI_RUNTIME_TRACE_CBID_cudaFreeAsync_v11020                                          = 375,
    CUPTI_RUNTIME_TRACE_CBID_cudaFreeAsync_ptsz_v11020                                     = 376,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolTrimTo_v11020                                      = 377,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolSetAttribute_v11020                                = 378,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolGetAttribute_v11020                                = 379,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolSetAccess_v11020                                   = 380,
    CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetPlane_v11020                                      = 381,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolGetAccess_v11020                                   = 382,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolCreate_v11020                                      = 383,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolDestroy_v11020                                     = 384,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetMemPool_v11020                                   = 385,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetMemPool_v11020                                   = 386,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolExportToShareableHandle_v11020                     = 387,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolImportFromShareableHandle_v11020                   = 388,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolExportPointer_v11020                               = 389,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolImportPointer_v11020                               = 390,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocFromPoolAsync_v11020                                = 391,
    CUPTI_RUNTIME_TRACE_CBID_cudaMallocFromPoolAsync_ptsz_v11020                           = 392,
    CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v2_v11020                   = 393,
    CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v2_ptsz_v11020              = 394,
    CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v2_v11020                     = 395,
    CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v2_ptsz_v11020                = 396,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddExternalSemaphoresSignalNode_v11020               = 397,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresSignalNodeGetParams_v11020         = 398,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresSignalNodeSetParams_v11020         = 399,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddExternalSemaphoresWaitNode_v11020                 = 400,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresWaitNodeGetParams_v11020           = 401,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresWaitNodeSetParams_v11020           = 402,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecExternalSemaphoresSignalNodeSetParams_v11020     = 403,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecExternalSemaphoresWaitNodeSetParams_v11020       = 404,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceFlushGPUDirectRDMAWrites_v11030                     = 405,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPoint_v11030                                = 406,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPoint_ptsz_v11030                           = 407,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphDebugDotPrint_v11030                                 = 408,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v2_v11030                            = 409,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v2_ptsz_v11030                       = 410,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_v11030                    = 411,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_ptsz_v11030               = 412,
    CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectCreate_v11030                                   = 413,
    CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectRetain_v11030                                   = 414,
    CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectRelease_v11030                                  = 415,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphRetainUserObject_v11030                              = 416,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphReleaseUserObject_v11030                             = 417,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithFlags_v11040                          = 418,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemAllocNode_v11040                               = 419,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemAllocNodeGetParams_v11040                         = 420,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemFreeNode_v11040                                = 421,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemFreeNodeGetParams_v11040                          = 422,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGraphMemTrim_v11040                                 = 423,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetGraphMemAttribute_v11040                         = 424,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetGraphMemAttribute_v11040                         = 425,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeSetEnabled_v11060                                = 426,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetEnabled_v11060                                = 427,
    CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetMemoryRequirements_v11060                         = 428,
    CUPTI_RUNTIME_TRACE_CBID_cudaMipmappedArrayGetMemoryRequirements_v11060                = 429,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernelExC_v11060                                    = 430,
    CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernelExC_ptsz_v11060                               = 431,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxPotentialClusterSize_v11070                   = 432,
    CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveClusters_v11070                         = 433,
    CUPTI_RUNTIME_TRACE_CBID_cudaCreateTextureObject_v2_v11080                             = 434,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectTextureDesc_v2_v11080                     = 435,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithParams_v12000                         = 436,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithParams_ptsz_v12000                    = 437,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecGetFlags_v12000                                  = 438,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetKernel_v12000                                          = 439,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceProperties_v2_v12000                             = 440,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetId_v12000                                        = 441,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetId_ptsz_v12000                                   = 442,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiate_v12000                                   = 443,
    CUPTI_RUNTIME_TRACE_CBID_cudaInitDevice_v12000                                         = 444,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddNode_v12020                                       = 445,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeSetParams_v12020                                 = 446,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecNodeSetParams_v12020                             = 447,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemAdvise_v2_v12020                                       = 448,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_v2_v12020                                = 449,
    CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_v2_ptsz_v12020                           = 450,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncGetName_v12030                                        = 451,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCaptureToGraph_v12030                          = 452,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCaptureToGraph_ptsz_v12030                     = 453,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphConditionalHandleCreate_v12030                       = 454,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetEdges_v2_v12030                                   = 455,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependencies_v2_v12030                        = 456,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependentNodes_v2_v12030                      = 457,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddDependencies_v2_v12030                            = 458,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphRemoveDependencies_v2_v12030                         = 459,
    CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddNode_v2_v12030                                    = 460,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v3_v12030                            = 461,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v3_ptsz_v12030                       = 462,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_v2_v12030                 = 463,
    CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_v2_ptsz_v12030            = 464,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceRegisterAsyncNotification_v12040                    = 465,
    CUPTI_RUNTIME_TRACE_CBID_cudaDeviceUnregisterAsyncNotification_v12040                  = 466,
    CUPTI_RUNTIME_TRACE_CBID_cudaFuncGetParamInfo_v12040                                   = 467,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPointByVersion_v12050                       = 468,
    CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPointByVersion_ptsz_v12050                  = 469,
    CUPTI_RUNTIME_TRACE_CBID_cuda470_v12060                                                = 470,
    CUPTI_RUNTIME_TRACE_CBID_cuda471_v12060                                                = 471,
    CUPTI_RUNTIME_TRACE_CBID_cuda472_v12060                                                = 472,
    CUPTI_RUNTIME_TRACE_CBID_cuda473_v12060                                                = 473,
    CUPTI_RUNTIME_TRACE_CBID_cuda474_v12060                                                = 474,
    CUPTI_RUNTIME_TRACE_CBID_cuda475_v12060                                                = 475,
    CUPTI_RUNTIME_TRACE_CBID_cuda476_v12060                                                = 476,
    CUPTI_RUNTIME_TRACE_CBID_cuda477_v12060                                                = 477,
    CUPTI_RUNTIME_TRACE_CBID_cuda478_v12060                                                = 478,
    CUPTI_RUNTIME_TRACE_CBID_cuda479_v12060                                                = 479,
    CUPTI_RUNTIME_TRACE_CBID_SIZE                                                          = 480,
    CUPTI_RUNTIME_TRACE_CBID_FORCE_INT                                                     = 0x7fffffff;

// #endif


// Parsed from cupti_nvtx_cbid.h

/*
 * Copyright 2013-2017 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility push(default)
// #endif

/** enum CUpti_nvtx_api_trace_cbid */
public static final int
  CUPTI_CBID_NVTX_INVALID                               = 0,
  CUPTI_CBID_NVTX_nvtxMarkA                             = 1,
  CUPTI_CBID_NVTX_nvtxMarkW                             = 2,
  CUPTI_CBID_NVTX_nvtxMarkEx                            = 3,
  CUPTI_CBID_NVTX_nvtxRangeStartA                       = 4,
  CUPTI_CBID_NVTX_nvtxRangeStartW                       = 5,
  CUPTI_CBID_NVTX_nvtxRangeStartEx                      = 6,
  CUPTI_CBID_NVTX_nvtxRangeEnd                          = 7,
  CUPTI_CBID_NVTX_nvtxRangePushA                        = 8,
  CUPTI_CBID_NVTX_nvtxRangePushW                        = 9,
  CUPTI_CBID_NVTX_nvtxRangePushEx                       = 10,
  CUPTI_CBID_NVTX_nvtxRangePop                          = 11,
  CUPTI_CBID_NVTX_nvtxNameCategoryA                     = 12,
  CUPTI_CBID_NVTX_nvtxNameCategoryW                     = 13,
  CUPTI_CBID_NVTX_nvtxNameOsThreadA                     = 14,
  CUPTI_CBID_NVTX_nvtxNameOsThreadW                     = 15,
  CUPTI_CBID_NVTX_nvtxNameCuDeviceA                     = 16,
  CUPTI_CBID_NVTX_nvtxNameCuDeviceW                     = 17,
  CUPTI_CBID_NVTX_nvtxNameCuContextA                    = 18,
  CUPTI_CBID_NVTX_nvtxNameCuContextW                    = 19,
  CUPTI_CBID_NVTX_nvtxNameCuStreamA                     = 20,
  CUPTI_CBID_NVTX_nvtxNameCuStreamW                     = 21,
  CUPTI_CBID_NVTX_nvtxNameCuEventA                      = 22,
  CUPTI_CBID_NVTX_nvtxNameCuEventW                      = 23,
  CUPTI_CBID_NVTX_nvtxNameCudaDeviceA                   = 24,
  CUPTI_CBID_NVTX_nvtxNameCudaDeviceW                   = 25,
  CUPTI_CBID_NVTX_nvtxNameCudaStreamA                   = 26,
  CUPTI_CBID_NVTX_nvtxNameCudaStreamW                   = 27,
  CUPTI_CBID_NVTX_nvtxNameCudaEventA                    = 28,
  CUPTI_CBID_NVTX_nvtxNameCudaEventW                    = 29,
  CUPTI_CBID_NVTX_nvtxDomainMarkEx                      = 30,
  CUPTI_CBID_NVTX_nvtxDomainRangeStartEx                = 31,
  CUPTI_CBID_NVTX_nvtxDomainRangeEnd                    = 32,
  CUPTI_CBID_NVTX_nvtxDomainRangePushEx                 = 33,
  CUPTI_CBID_NVTX_nvtxDomainRangePop                    = 34,
  CUPTI_CBID_NVTX_nvtxDomainResourceCreate              = 35,
  CUPTI_CBID_NVTX_nvtxDomainResourceDestroy             = 36,
  CUPTI_CBID_NVTX_nvtxDomainNameCategoryA               = 37,
  CUPTI_CBID_NVTX_nvtxDomainNameCategoryW               = 38,
  CUPTI_CBID_NVTX_nvtxDomainRegisterStringA             = 39,
  CUPTI_CBID_NVTX_nvtxDomainRegisterStringW             = 40,
  CUPTI_CBID_NVTX_nvtxDomainCreateA                     = 41,
  CUPTI_CBID_NVTX_nvtxDomainCreateW                     = 42,
  CUPTI_CBID_NVTX_nvtxDomainDestroy                     = 43,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserCreate              = 44,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserDestroy             = 45,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserAcquireStart        = 46,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserAcquireFailed       = 47,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserAcquireSuccess      = 48,
  CUPTI_CBID_NVTX_nvtxDomainSyncUserReleasing           = 49,
  CUPTI_CBID_NVTX_SIZE = 50,
  CUPTI_CBID_NVTX_FORCE_INT                             = 0x7fffffff;

// #if defined(__GNUC__) && defined(CUPTI_LIB)
//     #pragma GCC visibility pop
// #endif    


}
