// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.nvcomp.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class nvcomp extends org.bytedeco.cuda.presets.nvcomp {
    static { Loader.load(); }

// Parsed from <nvcomp/shared_types.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once

// #include <stddef.h>

/** enum nvcompStatus_t */
public static final int
  nvcompSuccess = 0,
  nvcompErrorInvalidValue = 10,
  nvcompErrorNotSupported = 11,
  nvcompErrorCannotDecompress = 12,
  nvcompErrorBadChecksum = 13,
  nvcompErrorCannotVerifyChecksums = 14,
  nvcompErrorOutputBufferTooSmall = 15,
  nvcompErrorWrongHeaderLength = 16,
  nvcompErrorAlignment = 17,
  nvcompErrorChunkSizeTooLarge = 18,
  nvcompErrorCudaError = 1000,
  nvcompErrorInternal = 10000;
// Targeting ..\nvcomp\nvcompAlignmentRequirements_t.java




// Parsed from <nvcomp.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once

// #include "nvcomp/shared_types.h"
// #include "nvcomp/version.h"
// #include "nvcomp_export.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * CONSTANTS ******************************************************************
 *****************************************************************************/

/* Supported datatypes */
/** enum nvcompType_t */
public static final int
  NVCOMP_TYPE_CHAR = 0,      // 1B
  NVCOMP_TYPE_UCHAR = 1,     // 1B
  NVCOMP_TYPE_SHORT = 2,     // 2B
  NVCOMP_TYPE_USHORT = 3,    // 2B
  NVCOMP_TYPE_INT = 4,       // 4B
  NVCOMP_TYPE_UINT = 5,      // 4B
  NVCOMP_TYPE_LONGLONG = 6,  // 8B
  NVCOMP_TYPE_ULONGLONG = 7, // 8B
  NVCOMP_TYPE_UINT8 = 8,     // 1B
  NVCOMP_TYPE_FLOAT16 = 9,   // 2B
  NVCOMP_TYPE_BITS = 0xff;    // 1b
// Targeting ..\nvcomp\nvcompProperties_t.java




/******************************************************************************
 * FUNCTION PROTOTYPES ********************************************************
 *****************************************************************************/

/**
 * \brief Provides nvCOMP library properties.
 *
 * @param properties [out] Set nvCOMP properties in nvcompProperties_t handle.
 *
 * @return nvcompErrorInvalidValue is properties is nullptr, nvcompSuccess otherwise
 */
public static native @Cast("nvcompStatus_t") int nvcompGetProperties(nvcompProperties_t properties);

/**
 * \brief Computes the required temporary workspace required to perform
 * decompression.
 *
 * @param metadata_ptr The metadata.
 * @param temp_bytes The size of the required temporary workspace in bytes
 * (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 *
 * @deprecated This interface is deprecated and will be removed in future releases, 
 * please switch to the compression schemes specific interfaces in nvcomp/cascaded.h,
 * nvcomp/lz4.h, nvcomp/snappy, nvcomp/bitcomp.h, nvcomp/gdeflate.h, nvcomp/zstd.h,
 * nvcomp/deflate.h and nvcomp/ans.h.
 */


/**
 * \brief Computes the size of the uncompressed data in bytes.
 *
 * @param metadata_ptr The metadata.
 * @param output_bytes The size of the uncompressed data (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 *
 * @deprecated This interface is deprecated and will be removed in future releases, 
 * please switch to the compression schemes specific interfaces in nvcomp/cascaded.h,
 * nvcomp/lz4.h, nvcomp/snappy, nvcomp/bitcomp.h, nvcomp/gdeflate.h, nvcomp/zstd.h,
 * nvcomp/deflate.h and nvcomp/ans.h.
 */


/**
 * \brief Get the type of the compressed data.
 *
 * @param metadata_ptr The metadata.
 * @param type The data type (output).
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 *
 * @deprecated This interface is deprecated and will be removed in future releases, 
 * please switch to the compression schemes specific interfaces in nvcomp/cascaded.h,
 * nvcomp/lz4.h, nvcomp/snappy, nvcomp/bitcomp.h, nvcomp/gdeflate.h, nvcomp/zstd.h,
 * nvcomp/deflate.h and nvcomp/ans.h.
 */


/**
 * \brief Perform the asynchronous decompression.
 *
 * @param in_ptr The compressed data on the device to decompress.
 * @param in_bytes The size of the compressed data.
 * @param temp_ptr The temporary workspace on the device.
 * @param temp_bytes The size of the temporary workspace.
 * @param metadata_ptr The metadata.
 * @param out_ptr The output location on the device.
 * @param out_bytes The size of the output location.
 * @param stream The cuda stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 *
 * @deprecated This interface is deprecated and will be removed in future releases, 
 * please switch to the compression schemes specific interfaces in nvcomp/cascaded.h,
 * nvcomp/lz4.h, nvcomp/snappy, nvcomp/bitcomp.h, nvcomp/gdeflate.h, nvcomp/zstd.h,
 * nvcomp/deflate.h and nvcomp/ans.h.
 */


// #ifdef __cplusplus
// #endif


// Parsed from <nvcomp/nvcompManager.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2020-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include "nvcomp.h"

// #include <memory>
// #include <vector>
// #include <functional>
// #include <stdint.h>
// #include <cstdio>

/******************************************************************************
 * CLASSES ********************************************************************
 *****************************************************************************/

/**
 * Internal memory pool used for compression / decompression configs
 */
// Targeting ..\nvcomp\CompressionConfig.java


// Targeting ..\nvcomp\DecompressionConfig.java



/**
 * \brief Defines how buffer will be compressed in nvcomp Manager
 */
/** enum class nvcomp::BitstreamKind */
public static final int
  /** Each input buffer is chunked according to manager setting and compressed in parallel.
   *  Allows computation of checksums.
   *  Adds custom header with nvCOMP metadata at the beginning of the compressed data. */
  NVCOMP_NATIVE = 0,
  /** Compresses input data as is, just using underlying compression algorithm.
   *  Does not add header with nvCOMP metadata. */
  RAW = 1,
  /** Similar to RAW, but adds custom header with just uncompressed size at the beginning of the compressed data. */
  WITH_UNCOMPRESSED_SIZE = 2;

/** enum nvcomp::ChecksumPolicy */
public static final int
  /** During compression, do not compute checksums.
   *  During decompression, do not verify checksums. */
  NoComputeNoVerify = 0,

  /** During compression, compute checksums.
   *  During decompression, do not attempt to verify checksums. */
  ComputeAndNoVerify = 1,

  /** During compression, do not compute checksums.
   *  During decompression, verify checksums if they were included. */
  NoComputeAndVerifyIfPresent = 2,

  /** During compression, compute checksums.
   *  During decompression, verify checksums if they were included. */
  ComputeAndVerifyIfPresent = 3,

  /** During compression, compute checksums.
   *  During decompression, verify checksums.
   *  A runtime error will be thrown upon configure_decompression if
   *  checksums were not included in the compressed buffer. */
  ComputeAndVerify = 4;
// Targeting ..\nvcomp\nvcompManagerBase.java


// Targeting ..\nvcomp\PimplManager.java



 // namespace nvcomp


// Parsed from <nvcomp/nvcompManagerFactory.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once

// #include "nvcompManager.hpp"
// #include "ans.hpp"
// #include "gdeflate.hpp"
// #include "lz4.hpp"
// #include "snappy.hpp"
// #include "bitcomp.hpp"
// #include "cascaded.hpp"
// #include "zstd.hpp"
// #include "deflate.hpp"
// #include "gzip.hpp"

// #include <cassert>
// #include <stdint.h>

/**
 * \brief Construct a ManagerBase from a buffer
 *
 * This synchronizes the stream
 */
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") BytePointer comp_buffer, CUstream_st stream/*=0*/,
    @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") BytePointer comp_buffer);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") ByteBuffer comp_buffer, CUstream_st stream/*=0*/,
    @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") ByteBuffer comp_buffer);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") byte[] comp_buffer, CUstream_st stream/*=0*/,
    @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") byte[] comp_buffer);

/**
 * \brief Construct a ManagerBase from a buffer
 *
 * @deprecated
 * This signature is deprecated, in favour of the one that does not accept a
 * device_id, and instead gets the device from the stream.
 */
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") BytePointer comp_buffer, CUstream_st stream,
    int device_id, @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") ByteBuffer comp_buffer, CUstream_st stream,
    int device_id, @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);
@Namespace("nvcomp") public static native @SharedPtr nvcompManagerBase create_manager(
    @Cast("const uint8_t*") byte[] comp_buffer, CUstream_st stream,
    int device_id, @Cast("nvcomp::ChecksumPolicy") int checksum_policy/*=nvcomp::NoComputeNoVerify*/);

 // namespace nvcomp


// Parsed from <nvcomp/ans.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_ANS_H
// #define NVCOMP_ANS_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched compression/decompression interface for ANS
 *****************************************************************************/
/** enum nvcompANSType_t */
public static final int
  nvcomp_rANS = 0;

/** enum nvcompANSDataType_t */
public static final int
    uint8 = 0,
    float16 = 1;
// Targeting ..\nvcomp\nvcompBatchedANSOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedANSOpts_t nvcompBatchedANSDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompANSCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompANSRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetRequiredAlignments(
    @ByVal nvcompBatchedANSOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] Compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] Compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedANSCompressAsync() for each chunk.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] Compression options.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedANSCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace, could be NULL in case
 * temporary memory is not needed.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedANSCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedANSCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedANSCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] Compression options.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedANSOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedANSDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in ANS.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedANSDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * If there is an error when retrieving the size of a chunk, the
 * uncompressed size of that chunk will be set to 0. This argument needs to
 * be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * This function is used to decompress compressed buffers produced by
 * {@code nvcompBatchedANSCompressAsync}.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedANSDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space, could be NULL in case temporary space is not needed.
 * Must be aligned to the value in {@code nvcompBatchedANSDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedANSDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedANSDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/ans.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/ans.h"
// Targeting ..\nvcomp\ANSFormatSpecHeader.java


// Targeting ..\nvcomp\ANSManager.java



 // namespace nvcomp


// Parsed from <nvcomp/bitcomp.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_BITCOMP_H
// #define NVCOMP_BITCOMP_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedBitcompOpts_t.java



/** Legacy alias for \ref nvcompBatchedBitcompOpts_t. */

@MemberGetter public static native @Const @ByRef nvcompBatchedBitcompOpts_t nvcompBatchedBitcompDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompBitcompCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompBitcompRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetRequiredAlignments(
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * NOTE: Bitcomp currently doesn't use any temp memory.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param format_opts [in] Compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * NOTE: Bitcomp currently doesn't use any temp memory.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk 
 * in the batch. This parameter is currently unused. Set it to either
 * the actual value or zero.
 * @param format_opts [in] Compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedBitcompCompressAsync() for each chunk.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] Compression options.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedBitcompCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Each chunk size must be a multiple of the size of the data type specified by
 * format_opts.data_type.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. 
 * Set it to either the actual value or zero.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedBitcompCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedBitcompCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] Compression options. They must be valid.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedBitcompOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedBitcompDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * NOTE: Bitcomp currently doesn't use any temp memory.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * NOTE: Bitcomp currently doesn't use any temp memory.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression. Unused in Bitcomp.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedBitcompDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] This argument is not used.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * If there is an error when retrieving the size of a chunk, the
 * uncompressed size of that chunk will be set to 0. This argument needs to
 * be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * This function is used to decompress compressed buffers produced by
 * {@code nvcompBatchedBitcompCompressAsync}. It can also decompress buffers
 * compressed with the standalone Bitcomp library.
 * 
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * \note The function is not completely asynchronous, as it needs to look
 * at the compressed data in order to create the proper bitcomp handle.
 * The stream is synchronized, the data is examined, then the asynchronous
 * decompression is launched.
 * 
 * \note An asynchronous, faster version of batched Bitcomp asynchrnous decompression
 * is available, and can be launched via the HLIF manager.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedBitcompDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] This argument is not used.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedBitcompDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedBitcompDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/bitcomp.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2020-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include "nvcompManager.hpp"
// #include "nvcomp/bitcomp.h"
// Targeting ..\nvcomp\BitcompFormatSpecHeader.java


// Targeting ..\nvcomp\BitcompManager.java



 // namespace nvcomp


// Parsed from <nvcomp/cascaded.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_CASCADED_H
// #define NVCOMP_CASCADED_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedCascadedOpts_t.java



// Default options for batched compression
@MemberGetter public static native @Const @ByRef nvcompBatchedCascadedOpts_t nvcompBatchedCascadedDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompCascadedCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompCascadedRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetRequiredAlignments(
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * \note Batched Cascaded compression does not require temp space, so
 * this will set *temp_bytes=0, unless an error is found with the format_opts.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param format_opts [in] The Cascaded compression options and datatype to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * \note Batched Cascaded compression does not require temp space, so
 * this will set *temp_bytes=0, unless an error is found with the format_opts.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param format_opts [in] The Cascaded compression options and datatype to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedCascadedCompressAsync() for each chunk.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The Cascaded compression options to use.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note The current implementation does not support uncompressed size larger
 * than 4,294,967,295 bytes (max uint32_t).
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedCascadedCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Each chunk size must be a multiple of the size of the data type specified by
 * format_opts.type, else this may crash or produce invalid output.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedCascadedCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedCascadedCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The cascaded format options. The format must be valid.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedCascadedOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedCascadedDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in Cascaded.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedCascadedDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * If there is an error when retrieving the size of a chunk, the
 * uncompressed size of that chunk will be set to 0. This argument needs to
 * be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * This function is used to decompress compressed buffers produced by
 * {@code nvcompBatchedCascadedCompressAsync}.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedCascadedDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] This argument is not used.
 * @param temp_bytes [in] This argument is not used.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedCascadedDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCascadedDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);
    
// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/CRC32.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_CRC32_H
// #define NVCOMP_CRC32_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched compute interface for CRC32
 *****************************************************************************/

/**
 * \brief Perform CRC32 checksum calculation asynchronously. All pointers must point to GPU
 * accessible locations.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * @param num_chunks [in] The number of chunks to compute checksums of.
 * @param device_CRC [out] 32_ptr Array with size \p num_chunks on the GPU
 * to be filled with the CRC32 checksum of each chunk.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    @Cast("uint32_t*") IntPointer device_CRC32_ptr,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    @Cast("uint32_t*") IntPointer device_CRC32_ptr,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    @Cast("uint32_t*") IntBuffer device_CRC32_ptr,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedCRC32Async(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    @Cast("uint32_t*") int[] device_CRC32_ptr,
    CUstream_st stream);


// #ifdef __cplusplus
// #endif
// #endif // NVCOMP_CRC32_H

// Parsed from <nvcomp/deflate.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_DEFLATE_H
// #define NVCOMP_DEFLATE_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedDeflateOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedDeflateOpts_t nvcompBatchedDeflateDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompDeflateCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompDeflateRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetRequiredAlignments(
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The Deflate compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The Deflate compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedDeflateCompressAsync() for each chunk.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The Deflate compression options to use.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedDeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Chunk sizes must not exceed 65536 bytes. For best performance, a chunk size
 * of 65536 bytes is recommended.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedDeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedDeflateCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedDeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The Deflate compression options to use.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedDeflateOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedDeflateDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in Deflate.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * This is needed when we do not know the expected output size.
 *
 * \note If the stream is corrupt, the calculated sizes will be invalid.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedDeflateDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * \note In the case where a chunk of compressed data is not a valid Deflate
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedDeflateDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated, but can be nullptr if desired,
 * in which case the actual sizes are not reported.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space.
 * Must be aligned to the value in {@code nvcompBatchedDeflateDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedDeflateDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedDeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_DEFLATE_H


// Parsed from <nvcomp/deflate.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2020-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include "nvcompManager.hpp"
// #include "nvcomp/deflate.h"
// Targeting ..\nvcomp\DeflateFormatSpecHeader.java


// Targeting ..\nvcomp\DeflateManager.java



 // namespace nvcomp


// Parsed from <nvcomp/gdeflate.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_GDEFLATE_H
// #define NVCOMP_GDEFLATE_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedGdeflateOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedGdeflateOpts_t nvcompBatchedGdeflateDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompGdeflateCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompGdeflateRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetRequiredAlignments(
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The GDeflate compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The GDeflate compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedGdeflateCompressAsync() for each chunk.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The GDeflate compression options to use.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedGdeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Chunk sizes must not exceed 65536 bytes. For best performance, a chunk size
 * of 65536 bytes is recommended.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedGdeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedGdeflateCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedGdeflateCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The GDeflate compression options to use.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedGdeflateOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedGdeflateDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in GDeflate.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * This is needed when we do not know the expected output size.
 *
 * \note If the stream is corrupt, the calculated sizes will be invalid.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedGdeflateDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * \note In the case where a chunk of compressed data is not a valid GDeflate
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedGdeflateDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated, but can be nullptr if desired,
 * in which case the actual sizes are not reported.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space.
 * Must be aligned to the value in {@code nvcompBatchedGdeflateDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedGdeflateDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGdeflateDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_GDEFLATE_H


// Parsed from <nvcomp/gdeflate.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include <memory>

// #include "nvcompManager.hpp"
// #include "gdeflate.h"
// Targeting ..\nvcomp\GdeflateFormatSpecHeader.java


// Targeting ..\nvcomp\GdeflateManager.java



 // namespace nvcomp



// Parsed from <nvcomp/gzip.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_GZIP_H
// #define NVCOMP_GZIP_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// #endif

/******************************************************************************
 * Batched decompression interface for gzip
 *****************************************************************************/

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedGzipDecompressRequiredAlignments();
// Targeting ..\nvcomp\nvcompBatchedGzipOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedGzipOpts_t nvcompBatchedGzipDefaultOpts();

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The Gzip compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The Gzip compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedGzipCompressAsync() for each chunk.
 *
 * Chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The Gzip compression options to use.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */


/**
 * \brief Perform batched asynchronous compression.
 *
 * The individual chunk size must not exceed
 * 65536 bytes. For best performance, a chunk size of 65536 bytes is
 * recommended. The output buffers must be 8-byte aligned.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedGzipCompressGetMaxOutputChunkSize}.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks,
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The Gzip compression options to use.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */


/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in gzip.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * This is needed when we do not know the expected output size.
 *
 * \note If the stream is corrupt, the calculated sizes will be invalid.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedGzipDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * \note In the case where a chunk of compressed data is not a valid Deflate
 * stream, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedGzipDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated, but can be nullptr if desired,
 * in which case the actual sizes are not reported.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space.
 * Must be aligned to the value in {@code nvcompBatchedGzipDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedGzipDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedGzipDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif // NVCOMP_GZIP_H


// Parsed from <nvcomp/lz4.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_LZ4_H
// #define NVCOMP_LZ4_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedLZ4Opts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedLZ4Opts_t nvcompBatchedLZ4DefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompLZ4CompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompLZ4RequiredAlignment();

/******************************************************************************
 * Batched compression/decompression interface
 *****************************************************************************/

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetRequiredAlignments(
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * Chunk size must not exceed 16777216 bytes.
 * For best performance, a chunk size of 65536 bytes is recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The LZ4 compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * Chunk size must not exceed 16777216 bytes.
 * For best performance, a chunk size of 65536 bytes is recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The LZ4 compression options to use.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedLZ4CompressAsync() for each chunk.
 *
 * Chunk size must not exceed 16777216 bytes.
 * For best performance, a chunk size of 65536 bytes is recommended.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The LZ4 compression options to use.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedLZ4CompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Each chunk size must be a multiple of the size of the data type specified by
 * format_opts.data_type.
 * Chunk sizes must not exceed 16777216 bytes. For best performance, a chunk size
 * of 65536 bytes is recommended.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedLZ4CompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedLZ4CompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedLZ4CompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The LZ4 compression options to use.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4CompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedLZ4Opts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedLZ4DecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in LZ4.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * This is needed when we do not know the expected output size.
 *
 * \note If the stream is corrupt, the calculated sizes will be invalid.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedLZ4DecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * This argument needs to be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4GetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4GetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * \note In the case where a chunk of compressed data is not a valid LZ4
 * block, 0 will be written for the size of the invalid chunk and
 * nvcompStatusCannotDecompress will be flagged for that chunk.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedLZ4DecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated, but can be nullptr if desired,
 * in which case the actual sizes are not reported.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space.
 * Must be aligned to the value in {@code nvcompBatchedLZ4DecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedLZ4DecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedLZ4DecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/lz4.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/lz4.h"
// Targeting ..\nvcomp\LZ4FormatSpecHeader.java


// Targeting ..\nvcomp\LZ4Manager.java



 // namespace nvcomp


// Parsed from <nvcomp/snappy.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2017-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_SNAPPY_H
// #define NVCOMP_SNAPPY_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedSnappyOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedSnappyOpts_t nvcompBatchedSnappyDefaultOpts();

@MemberGetter public static native @Cast("const size_t") long nvcompSnappyCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompSnappyRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetRequiredAlignments(
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param format_opts [in] Snappy compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch. This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param format_opts [in] Snappy compression options.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedSnappyCompressAsync() for each chunk.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] Snappy compression options.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedSnappyCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * This parameter is currently unused. Set it to either the actual value 
 * or zero.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace, could be NULL in case
 * temporary memory is not needed.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedSnappyCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedSnappyCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedSnappyCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] Snappy compression options.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedSnappyOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedSnappyDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed. 
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 * Unused in Snappy.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedSnappyDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * If there is an error when retrieving the size of a chunk, the
 * uncompressed size of that chunk will be set to 0. This argument needs to
 * be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedSnappyDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * This argument needs to be preallocated, but can be nullptr if desired,
 * in which case the actual sizes are not reported.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space, could be NULL in case temporary space is not needed.
 * Must be aligned to the value in {@code nvcompBatchedSnappyDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedSnappyDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * Can be nullptr if desired, in which case error status is not reported.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedSnappyDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/snappy.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once

// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/snappy.h"
// Targeting ..\nvcomp\SnappyFormatSpecHeader.java


// Targeting ..\nvcomp\SnappyManager.java



 // namespace nvcomp


// Parsed from <nvcomp/zstd.h>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #ifndef NVCOMP_Zstd_H
// #define NVCOMP_Zstd_H

// #include "nvcomp.h"

// #include <cuda_runtime.h>
// #include <stdint.h>

// #ifdef __cplusplus
// Targeting ..\nvcomp\nvcompBatchedZstdOpts_t.java



@MemberGetter public static native @Const @ByRef nvcompBatchedZstdOpts_t nvcompBatchedZstdDefaultOpts();

// To go higher than 1 << 31 - 1, would require 64-bit math in a number of places
@MemberGetter public static native @Cast("const size_t") long nvcompZstdCompressionMaxAllowedChunkSize();

/**
 * The most restrictive of minimum alignment requirements for void-type CUDA memory buffers
 * used for input, output, or temporary memory, passed to compression or decompression functions.
 * In all cases, typed memory buffers must still be aligned to their type's size, e.g., 4 bytes for {@code int}.
 */
@MemberGetter public static native @Cast("const size_t") long nvcompZstdRequiredAlignment();

/**
 * \brief Get the minimum buffer alignment requirements for compression.
 *
 * @param format_opts [in] Compression options.
 * @param alignment_requirements [out] The minimum buffer alignment requirements
 * for compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetRequiredAlignments(
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    nvcompAlignmentRequirements_t alignment_requirements);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression.
 *
 * Chunk size must not exceed 16 MB.
 * For best performance, a chunk size of 64 KB is recommended.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The ZSTD compression options to use -- currently empty
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetTempSize(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for compression
 * with extra total bytes argument.
 *
 * Chunk size must not exceed 16 MB.
 * For best performance, a chunk size of 64 KB is recommended.
 *
 * This extended API is useful for cases where chunk sizes aren't uniform in the batch
 * I.e. in the non-extended API, if all but 1 chunk is 64 KB, but 1 chunk is
 * 16 MB, the temporary space computed is based on 16 MB * num_chunks.
 *
 * @param num_chunks [in] The number of chunks of memory in the batch.
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk in the
 * batch.
 * @param format_opts [in] The ZSTD compression options to use. Currently empty.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily
 * required during compression.
 * @param max_total_uncompressed_bytes [in] Upper bound on the total uncompressed
 * size of all chunks
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetTempSizeEx(
    @Cast("size_t") long num_chunks,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    @Cast("size_t*") SizeTPointer temp_bytes,
    @Cast("const size_t") long max_total_uncompressed_bytes);

/**
 * \brief Get the maximum size that a chunk of size at most max_uncompressed_chunk_bytes
 * could compress to. That is, the minimum amount of output memory required to be given
 * nvcompBatchedZstdCompressAsync() for each chunk.
 *
 * Chunk size must not exceed 16 MB.
 * For best performance, a chunk size of 64 KB is recommended.
 *
 * @param max_uncompressed_chunk_bytes [in] The maximum size of a chunk before compression.
 * @param format_opts [in] The Zstd compression options to use. Currently empty.
 * @param max_compressed_chunk_bytes [out] The maximum possible compressed size of the chunk.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressGetMaxOutputChunkSize(
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    @Cast("size_t*") SizeTPointer max_compressed_chunk_bytes);

/**
 * \brief Perform batched asynchronous compression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_uncompressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * to the uncompressed data chunks. Both the pointers and the uncompressed data
 * should reside in device-accessible memory.
 * Each chunk must be aligned to the value in the {@code input} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedZstdCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_uncompressed_chunk_bytes [in] Array with size \p num_chunks of
 * sizes of the uncompressed chunks in bytes.
 * The sizes should reside in device-accessible memory.
 * Chunk sizes must not exceed 16 MB. For best performance, a chunk size of
 * 64 KB is recommended.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest uncompressed chunk.
 * @param num_chunks [in] Number of chunks of data to compress.
 * @param device_temp_ptr [in] The temporary GPU workspace, could be NULL in case
 * temporary memory is not needed.
 * Must be aligned to the value in the {@code temp} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedZstdCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param temp_bytes [in] The size of the temporary GPU memory pointed to by
 * {@code device_temp_ptr}.
 * @param device_compressed_chunk_ptrs [out] Array with size \p num_chunks of pointers
 * to the output compressed buffers. Both the pointers and the compressed
 * buffers should reside in device-accessible memory. Each compressed buffer
 * should be preallocated with the size given by
 * {@code nvcompBatchedZstdCompressGetMaxOutputChunkSize}.
 * Each compressed buffer must be aligned to the value in the {@code output} member of the
 * \ref nvcompAlignmentRequirements_t object output by
 * {@code nvcompBatchedZstdCompressGetRequiredAlignments} when called with the same
 * \p format_opts.
 * @param device_compressed_chunk_bytes [out] Array with size \p num_chunks, 
 * to be filled with the compressed sizes of each chunk.
 * The buffer should be preallocated in device-accessible memory.
 * @param format_opts [in] The Zstd compression options to use. Currently empty.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressAsync(
    @Cast("const void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdCompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("size_t*") SizeTPointer device_compressed_chunk_bytes,
    @ByVal nvcompBatchedZstdOpts_t format_opts,
    CUstream_st stream);

/**
 * Minimum buffer alignment requirements for decompression.
 */
@MemberGetter public static native @Const @ByRef nvcompAlignmentRequirements_t nvcompBatchedZstdDecompressRequiredAlignments();

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressGetTempSize(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes, @Cast("size_t*") SizeTPointer temp_bytes);

/**
 * \brief Get the amount of temporary memory required on the GPU for decompression
 * with extra total bytes argument.
 *
 * @param num_chunks [in] Number of chunks of data to be decompressed.
 * @param max_uncompressed_chunk_bytes [in] The size of the largest chunk in bytes
 * when uncompressed.
 * @param temp_bytes [out] The amount of GPU memory that will be temporarily required
 * during decompression.
 * @param max_total_uncompressed_bytes [in]  The total decompressed size of all the chunks. 
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressGetTempSizeEx(
    @Cast("size_t") long num_chunks, @Cast("size_t") long max_uncompressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer temp_bytes, @Cast("size_t") long max_total_uncompressed_bytes);

/**
 * \brief Asynchronously compute the number of bytes of uncompressed data for
 * each compressed chunk.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of
 * pointers in device-accessible memory to compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedZstdDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes
 * of the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks
 * to be filled with the sizes, in bytes, of each uncompressed data chunk.
 * If there is an error when retrieving the size of a chunk, the
 * uncompressed size of that chunk will be set to 0. This argument needs to
 * be preallocated in device-accessible memory.
 * @param num_chunks [in] Number of data chunks to compute sizes of.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successful, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdGetDecompressSizeAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdGetDecompressSizeAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    CUstream_st stream);

/**
 * \brief Perform batched asynchronous decompression.
 *
 * \note Violating any of the conditions listed in the parameter descriptions
 * below may result in undefined behaviour.
 *
 * @param device_compressed_chunk_ptrs [in] Array with size \p num_chunks of pointers
 * in device-accessible memory to device-accessible compressed buffers.
 * Each buffer must be aligned to the value in
 * {@code nvcompBatchedZstdDecompressRequiredAlignments.input}.
 * @param device_compressed_chunk_bytes [in] Array with size \p num_chunks of sizes of
 * the compressed buffers in bytes. The sizes should reside in device-accessible memory.
 * @param device_uncompressed_buffer_bytes [in] Array with size \p num_chunks of sizes,
 * in bytes, of the output buffers to be filled with uncompressed data for each chunk.
 * The sizes should reside in device-accessible memory. If a
 * size is not large enough to hold all decompressed data, the decompressor
 * will set the status in \p device_statuses corresponding to the
 * overflow chunk to {@code nvcompErrorCannotDecompress}.
 * @param device_uncompressed_chunk_bytes [out] Array with size \p num_chunks to
 * be filled with the actual number of bytes decompressed for every chunk.
 * @param num_chunks [in] Number of chunks of data to decompress.
 * @param device_temp_ptr [in] The temporary GPU space, could be NULL in case temporary space is not needed.
 * Must be aligned to the value in {@code nvcompBatchedZstdDecompressRequiredAlignments.temp}.
 * @param temp_bytes [in] The size of the temporary GPU space.
 * @param device_uncompressed_chunk_ptrs [out] Array with size \p num_chunks of
 * pointers in device-accessible memory to decompressed data. Each uncompressed
 * buffer needs to be preallocated in device-accessible memory, have the size
 * specified by the corresponding entry in \p device_uncompressed_buffer_bytes,
 * and be aligned to the value in
 * {@code nvcompBatchedZstdDecompressRequiredAlignments.output}.
 * @param device_statuses [out] Array with size \p num_chunks of statuses in
 * device-accessible memory. This argument needs to be preallocated. For each
 * chunk, if the decompression is successful, the status will be set to
 * {@code nvcompSuccess}. If the decompression is not successful, for example due to
 * the corrupted input or out-of-bound errors, the status will be set to
 * {@code nvcompErrorCannotDecompress}.
 * @param stream [in] The CUDA stream to operate on.
 *
 * @return nvcompSuccess if successfully launched, and an error code otherwise.
 */
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") PointerPointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") PointerPointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntPointer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") IntBuffer device_statuses,
    CUstream_st stream);
public static native @Cast("nvcompStatus_t") int nvcompBatchedZstdDecompressAsync(
    @Cast("const void*const*") @ByPtrPtr Pointer device_compressed_chunk_ptrs,
    @Cast("const size_t*") SizeTPointer device_compressed_chunk_bytes,
    @Cast("const size_t*") SizeTPointer device_uncompressed_buffer_bytes,
    @Cast("size_t*") SizeTPointer device_uncompressed_chunk_bytes,
    @Cast("size_t") long num_chunks,
    Pointer device_temp_ptr,
    @Cast("size_t") long temp_bytes,
    @Cast("void*const*") @ByPtrPtr Pointer device_uncompressed_chunk_ptrs,
    @Cast("nvcompStatus_t*") int[] device_statuses,
    CUstream_st stream);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <nvcomp/zstd.hpp>

/*
 * SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES.
 * All rights reserved. SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
*/

// #pragma once
// #include <memory>

// #include "nvcompManager.hpp"
// #include "nvcomp/zstd.h"
// Targeting ..\nvcomp\ZstdFormatSpecHeader.java


// Targeting ..\nvcomp\ZstdManager.java



 // namespace nvcomp



}
