// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;


/**
 * Structure to store a vGPU software scheduler log
 */
@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlVgpuSchedulerLog_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlVgpuSchedulerLog_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlVgpuSchedulerLog_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlVgpuSchedulerLog_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlVgpuSchedulerLog_t position(long position) {
        return (nvmlVgpuSchedulerLog_t)super.position(position);
    }
    @Override public nvmlVgpuSchedulerLog_t getPointer(long i) {
        return new nvmlVgpuSchedulerLog_t((Pointer)this).offsetAddress(i);
    }

    /** Engine whose software runlist log entries are fetched */
    public native @Cast("unsigned int") int engineId(); public native nvmlVgpuSchedulerLog_t engineId(int setter);
    /** Scheduler policy */
    public native @Cast("unsigned int") int schedulerPolicy(); public native nvmlVgpuSchedulerLog_t schedulerPolicy(int setter);
    /** Adaptive Round Robin scheduler mode. One of the NVML_VGPU_SCHEDULER_ARR_*. */
    public native @Cast("unsigned int") int arrMode(); public native nvmlVgpuSchedulerLog_t arrMode(int setter);
    public native @ByRef nvmlVgpuSchedulerParams_t schedulerParams(); public native nvmlVgpuSchedulerLog_t schedulerParams(nvmlVgpuSchedulerParams_t setter);
    /** Count of log entries fetched */
    public native @Cast("unsigned int") int entriesCount(); public native nvmlVgpuSchedulerLog_t entriesCount(int setter);
    public native @ByRef nvmlVgpuSchedulerLogEntry_t logEntries(int i); public native nvmlVgpuSchedulerLog_t logEntries(int i, nvmlVgpuSchedulerLogEntry_t setter);
    @MemberGetter public native nvmlVgpuSchedulerLogEntry_t logEntries();
}
