// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * CUDA checkpoint optional lock arguments
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUcheckpointLockArgs extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUcheckpointLockArgs() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUcheckpointLockArgs(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUcheckpointLockArgs(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUcheckpointLockArgs position(long position) {
        return (CUcheckpointLockArgs)super.position(position);
    }
    @Override public CUcheckpointLockArgs getPointer(long i) {
        return new CUcheckpointLockArgs((Pointer)this).offsetAddress(i);
    }

    /** Timeout in milliseconds to attempt to lock the process, 0 indicates no timeout */
    public native @Cast("unsigned int") int timeoutMs(); public native CUcheckpointLockArgs timeoutMs(int setter);
    /** Reserved for future use, must be zero */
    public native @Cast("unsigned int") int reserved0(); public native CUcheckpointLockArgs reserved0(int setter);
    /** Reserved for future use, must be zeroed */
    public native @Cast("cuuint64_t") long reserved1(int i); public native CUcheckpointLockArgs reserved1(int i, long setter);
    @MemberGetter public native @Cast("cuuint64_t*") LongPointer reserved1();
}
