// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * \brief Structure describing the parameters that compose a single
 *        decompression operation.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUmemDecompressParams extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUmemDecompressParams() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUmemDecompressParams(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUmemDecompressParams(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUmemDecompressParams position(long position) {
        return (CUmemDecompressParams)super.position(position);
    }
    @Override public CUmemDecompressParams getPointer(long i) {
        return new CUmemDecompressParams((Pointer)this).offsetAddress(i);
    }

    /** The number of bytes to be read and decompressed from
     *  ::CUmemDecompressParams_st.src. */
    public native @Cast("size_t") long srcNumBytes(); public native CUmemDecompressParams srcNumBytes(long setter);
    /** The number of bytes that the decompression operation will be expected to
     *  write to ::CUmemDecompressParams_st.dst. This value is optional; if
     *  present, it may be used by the CUDA driver as a heuristic for scheduling
     *  the individual decompression operations. */
    public native @Cast("size_t") long dstNumBytes(); public native CUmemDecompressParams dstNumBytes(long setter);
    /** After the decompression operation has completed, the actual number of
     * bytes written to ::CUmemDecompressParams.dst will be recorded as a 32-bit
     * unsigned integer in the memory at this address. */
    public native @Cast("cuuint32_t*") IntPointer dstActBytes(); public native CUmemDecompressParams dstActBytes(IntPointer setter);
    /** Pointer to a buffer of at least ::CUmemDecompressParams_st.srcNumBytes
      * compressed bytes. */
    public native @Const Pointer src(); public native CUmemDecompressParams src(Pointer setter);
    /** Pointer to a buffer where the decompressed data will be written. The
      * number of bytes written to this location will be recorded in the memory
      * pointed to by ::CUmemDecompressParams_st.dstActBytes */
    public native Pointer dst(); public native CUmemDecompressParams dst(Pointer setter);
    /** The decompression algorithm to use. */
    public native @Cast("CUmemDecompressAlgorithm") int algo(); public native CUmemDecompressParams algo(int setter);
    /*  These bytes are unused and must be zeroed. This ensures compatibility if
     *  additional fields are added in the future. */
    public native @Cast("unsigned char") byte padding(int i); public native CUmemDecompressParams padding(int i, byte setter);
    @MemberGetter public native @Cast("unsigned char*") BytePointer padding();
}
