// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * CUDA array and CUDA mipmapped array memory requirements
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaArrayMemoryRequirements extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaArrayMemoryRequirements() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaArrayMemoryRequirements(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaArrayMemoryRequirements(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaArrayMemoryRequirements position(long position) {
        return (cudaArrayMemoryRequirements)super.position(position);
    }
    @Override public cudaArrayMemoryRequirements getPointer(long i) {
        return new cudaArrayMemoryRequirements((Pointer)this).offsetAddress(i);
    }

    /** Total size of the array. */
    public native @Cast("size_t") long size(); public native cudaArrayMemoryRequirements size(long setter);
    /** Alignment necessary for mapping the array. */
    public native @Cast("size_t") long alignment(); public native cudaArrayMemoryRequirements alignment(long setter);
    public native @Cast("unsigned int") int reserved(int i); public native cudaArrayMemoryRequirements reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
}
