// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Child graph node parameters
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaChildGraphNodeParams extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaChildGraphNodeParams() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaChildGraphNodeParams(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaChildGraphNodeParams(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaChildGraphNodeParams position(long position) {
        return (cudaChildGraphNodeParams)super.position(position);
    }
    @Override public cudaChildGraphNodeParams getPointer(long i) {
        return new cudaChildGraphNodeParams((Pointer)this).offsetAddress(i);
    }

    /** The child graph to clone into the node for node creation, or
                            *   a handle to the graph owned by the node for node query.
                            *   The graph must not contain conditional nodes. Graphs
                            *   containing memory allocation or memory free nodes must
                            *   set the ownership to be moved to the parent.
                            */
    public native CUgraph_st graph(); public native cudaChildGraphNodeParams graph(CUgraph_st setter);
    /** The ownership relationship of the child graph node. */
    public native @Cast("cudaGraphChildGraphNodeOwnership") int ownership(); public native cudaChildGraphNodeParams ownership(int setter);
}
