// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Memory allocation node parameters
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaMemAllocNodeParams extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaMemAllocNodeParams() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaMemAllocNodeParams(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaMemAllocNodeParams(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaMemAllocNodeParams position(long position) {
        return (cudaMemAllocNodeParams)super.position(position);
    }
    @Override public cudaMemAllocNodeParams getPointer(long i) {
        return new cudaMemAllocNodeParams((Pointer)this).offsetAddress(i);
    }

    /**
    * in: location where the allocation should reside (specified in ::location).
    * ::handleTypes must be ::cudaMemHandleTypeNone. IPC is not supported.
    */
    /** in: array of memory access descriptors. Used to describe peer GPU access */
    public native @ByRef cudaMemPoolProps poolProps(); public native cudaMemAllocNodeParams poolProps(cudaMemPoolProps setter);
    /** in: number of memory access descriptors.  Must not exceed the number of GPUs. */
    public native @Const cudaMemAccessDesc accessDescs(); public native cudaMemAllocNodeParams accessDescs(cudaMemAccessDesc setter);
    /** in: Number of {@code accessDescs}s */
    public native @Cast("size_t") long accessDescCount(); public native cudaMemAllocNodeParams accessDescCount(long setter);
    /** in: size in bytes of the requested allocation */
    public native @Cast("size_t") long bytesize(); public native cudaMemAllocNodeParams bytesize(long setter);
    /** out: address of the allocation returned by CUDA */
    public native Pointer dptr(); public native cudaMemAllocNodeParams dptr(Pointer setter);
}
