// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Memory allocation node parameters
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaMemAllocNodeParamsV2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaMemAllocNodeParamsV2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaMemAllocNodeParamsV2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaMemAllocNodeParamsV2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaMemAllocNodeParamsV2 position(long position) {
        return (cudaMemAllocNodeParamsV2)super.position(position);
    }
    @Override public cudaMemAllocNodeParamsV2 getPointer(long i) {
        return new cudaMemAllocNodeParamsV2((Pointer)this).offsetAddress(i);
    }

    /**
    * in: location where the allocation should reside (specified in ::location).
    * ::handleTypes must be ::cudaMemHandleTypeNone. IPC is not supported.
    */
    /** in: array of memory access descriptors. Used to describe peer GPU access */
    public native @ByRef cudaMemPoolProps poolProps(); public native cudaMemAllocNodeParamsV2 poolProps(cudaMemPoolProps setter);
    /** in: number of memory access descriptors.  Must not exceed the number of GPUs. */
    public native @Const cudaMemAccessDesc accessDescs(); public native cudaMemAllocNodeParamsV2 accessDescs(cudaMemAccessDesc setter);
    /** in: Number of {@code accessDescs}s */
    public native @Cast("size_t") long accessDescCount(); public native cudaMemAllocNodeParamsV2 accessDescCount(long setter);
    /** in: size in bytes of the requested allocation */
    public native @Cast("size_t") long bytesize(); public native cudaMemAllocNodeParamsV2 bytesize(long setter);
    /** out: address of the allocation returned by CUDA */
    public native Pointer dptr(); public native cudaMemAllocNodeParamsV2 dptr(Pointer setter);
}
