// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Attributes specific to copies within a batch. For more details on usage see ::cudaMemcpyBatchAsync.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class cudaMemcpyAttributes extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public cudaMemcpyAttributes() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public cudaMemcpyAttributes(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public cudaMemcpyAttributes(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public cudaMemcpyAttributes position(long position) {
        return (cudaMemcpyAttributes)super.position(position);
    }
    @Override public cudaMemcpyAttributes getPointer(long i) {
        return new cudaMemcpyAttributes((Pointer)this).offsetAddress(i);
    }

    /** Source access ordering to be observed for copies with this attribute. */
    public native @Cast("cudaMemcpySrcAccessOrder") int srcAccessOrder(); public native cudaMemcpyAttributes srcAccessOrder(int setter);
    /** Hint location for the source operand. Ignored when the pointers are not managed memory or memory allocated outside CUDA. */
    public native @ByRef cudaMemLocation srcLocHint(); public native cudaMemcpyAttributes srcLocHint(cudaMemLocation setter);
    /** Hint location for the destination operand. Ignored when the pointers are not managed memory or memory allocated outside CUDA. */
    public native @ByRef cudaMemLocation dstLocHint(); public native cudaMemcpyAttributes dstLocHint(cudaMemLocation setter);
    /** Additional flags for copies with this attribute. See ::cudaMemcpyFlags. */
    public native @Cast("unsigned int") int flags(); public native cudaMemcpyAttributes flags(int setter);
}
