// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a driver or runtime API invocation.
 *
 * This activity record represents an invocation of a driver or
 * runtime API (CUPTI_ACTIVITY_KIND_DRIVER and
 * CUPTI_ACTIVITY_KIND_RUNTIME).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityAPI extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityAPI() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityAPI(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityAPI(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityAPI position(long position) {
        return (CUpti_ActivityAPI)super.position(position);
    }
    @Override public CUpti_ActivityAPI getPointer(long i) {
        return new CUpti_ActivityAPI((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_DRIVER,
   * CUPTI_ACTIVITY_KIND_RUNTIME, or CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityAPI kind(int setter);

  /**
   * The ID of the driver or runtime function.
   */
  public native @Cast("CUpti_CallbackId") int cbid(); public native CUpti_ActivityAPI cbid(int setter);

  /**
   * The start timestamp for the function, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the function.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityAPI start(long setter);

  /**
   * The end timestamp for the function, in ns. A value of 0 for both
   * the start and end timestamps indicates that timestamp information
   * could not be collected for the function.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityAPI end(long setter);

  /**
   * The ID of the process where the driver or runtime CUDA function
   * is executing.
   */
  public native @Cast("uint32_t") int processId(); public native CUpti_ActivityAPI processId(int setter);

  /**
   * The ID of the thread where the driver or runtime CUDA function is
   * executing.
   */
  public native @Cast("uint32_t") int threadId(); public native CUpti_ActivityAPI threadId(int setter);

  /**
   * The correlation ID of the driver or runtime CUDA function. Each
   * function invocation is assigned a unique correlation ID that is
   * identical to the correlation ID in the memcpy, memset, or kernel
   * activity record that is associated with this function.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityAPI correlationId(int setter);

  /**
   * The return value for the function. For a CUDA driver function
   * with will be a CUresult value, and for a CUDA runtime function
   * this will be a cudaError_t value.
   */
  public native @Cast("uint32_t") int returnValue(); public native CUpti_ActivityAPI returnValue(int setter);
}
