// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief Device auto boost state structure
 *
 * This structure defines auto boost state for a device.
 * See function \ref cuptiGetAutoBoostState
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityAutoBoostState extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityAutoBoostState() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityAutoBoostState(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityAutoBoostState(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityAutoBoostState position(long position) {
        return (CUpti_ActivityAutoBoostState)super.position(position);
    }
    @Override public CUpti_ActivityAutoBoostState getPointer(long i) {
        return new CUpti_ActivityAutoBoostState((Pointer)this).offsetAddress(i);
    }

  /**
   * Returned auto boost state. 1 is returned in case auto boost is enabled, 0
   * otherwise
   */
  public native @Cast("uint32_t") int enabled(); public native CUpti_ActivityAutoBoostState enabled(int setter);

  /**
   * Id of process that has set the current boost state. The value will be
   * CUPTI_AUTO_BOOST_INVALID_CLIENT_PID if the user does not have the
   * permission to query process ids or there is an error in querying the
   * process id.
   */
  public native @Cast("uint32_t") int pid(); public native CUpti_ActivityAutoBoostState pid(int setter);

}
