// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for source level result
 * branch.
 *
 * This activity record the locations of the branches in the
 * source (CUPTI_ACTIVITY_KIND_BRANCH).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityBranch2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityBranch2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityBranch2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityBranch2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityBranch2 position(long position) {
        return (CUpti_ActivityBranch2)super.position(position);
    }
    @Override public CUpti_ActivityBranch2 getPointer(long i) {
        return new CUpti_ActivityBranch2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_BRANCH.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityBranch2 kind(int setter);

  /**
   * The ID for source locator.
   */
  public native @Cast("uint32_t") int sourceLocatorId(); public native CUpti_ActivityBranch2 sourceLocatorId(int setter);

  /**
   * The correlation ID of the kernel to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityBranch2 correlationId(int setter);

  /**
  * Correlation ID with global/device function name
  */
  public native @Cast("uint32_t") int functionId(); public native CUpti_ActivityBranch2 functionId(int setter);

  /**
   * The pc offset for the branch.
   */
  public native @Cast("uint32_t") int pcOffset(); public native CUpti_ActivityBranch2 pcOffset(int setter);

  /**
   * Number of times this branch diverged
   */
  public native @Cast("uint32_t") int diverged(); public native CUpti_ActivityBranch2 diverged(int setter);

  /**
   * This increments each time when this instruction is executed by number
   * of threads that executed this instruction
   */
  public native @Cast("uint64_t") long threadsExecuted(); public native CUpti_ActivityBranch2 threadsExecuted(long setter);

  /**
   * The number of times this instruction was executed per warp. It will be incremented
   * regardless of predicate or condition code.
   */
  public native @Cast("uint32_t") int executed(); public native CUpti_ActivityBranch2 executed(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityBranch2 pad(int setter);
}
