// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for CUDA event.
 *
 * This activity is used to track recorded events.
 * (CUPTI_ACTIVITY_KIND_CUDA_EVENT).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityCudaEvent2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityCudaEvent2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityCudaEvent2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityCudaEvent2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityCudaEvent2 position(long position) {
        return (CUpti_ActivityCudaEvent2)super.position(position);
    }
    @Override public CUpti_ActivityCudaEvent2 getPointer(long i) {
        return new CUpti_ActivityCudaEvent2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_CUDA_EVENT.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityCudaEvent2 kind(int setter);

  /**
   * The correlation ID of the API to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityCudaEvent2 correlationId(int setter);

  /**
   * The ID of the context where the event was recorded.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityCudaEvent2 contextId(int setter);

  /**
   * The compute stream where the event was recorded.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityCudaEvent2 streamId(int setter);

  /**
   * A unique event ID to identify the event record.
   */
  public native @Cast("uint32_t") int eventId(); public native CUpti_ActivityCudaEvent2 eventId(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityCudaEvent2 pad(int setter);

  /**
   * The ID of the device where the event was recorded.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityCudaEvent2 deviceId(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad2(); public native CUpti_ActivityCudaEvent2 pad2(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native Pointer reserved0(); public native CUpti_ActivityCudaEvent2 reserved0(Pointer setter);

  /**
   * The device-side timestamp on CUDA event record.
   * Timestamp is in nanoseconds.
   */
  public native @Cast("uint64_t") long deviceTimestamp(); public native CUpti_ActivityCudaEvent2 deviceTimestamp(long setter);
  /**
   * A unique ID to associate event synchronization records
   * with the latest CUDA Event record. Similar field is added
   * in CUpti_ActivitySynchronization2 to associate CUDA Event
   * record to the synchronization record.
   *
   * The same CUDA event can be used multiple times, so the
   * event id will not be unique to correlate the synchronization
   * record with the latest CUDA Event record.
   * This field will be unique and can be used to do the required
   * correlation.
   */
  public native @Cast("uint64_t") long cudaEventSyncId(); public native CUpti_ActivityCudaEvent2 cudaEventSyncId(long setter);
}
