// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a device. (CUDA 11.6 onwards)
 *
 * This activity record represents information about a GPU device
 * (CUPTI_ACTIVITY_KIND_DEVICE).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityDevice5 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityDevice5() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityDevice5(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityDevice5(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityDevice5 position(long position) {
        return (CUpti_ActivityDevice5)super.position(position);
    }
    @Override public CUpti_ActivityDevice5 getPointer(long i) {
        return new CUpti_ActivityDevice5((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_DEVICE.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityDevice5 kind(int setter);

  /**
   * The flags associated with the device. @see CUpti_ActivityFlag
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityDevice5 flags(int setter);

  /**
   * The global memory bandwidth available on the device, in
   * kBytes/sec.
   */
  public native @Cast("uint64_t") long globalMemoryBandwidth(); public native CUpti_ActivityDevice5 globalMemoryBandwidth(long setter);

  /**
   * The amount of global memory on the device, in bytes.
   */
  public native @Cast("uint64_t") long globalMemorySize(); public native CUpti_ActivityDevice5 globalMemorySize(long setter);

  /**
   * The amount of constant memory on the device, in bytes.
   */
  public native @Cast("uint32_t") int constantMemorySize(); public native CUpti_ActivityDevice5 constantMemorySize(int setter);

  /**
   * The size of the L2 cache on the device, in bytes.
   */
  public native @Cast("uint32_t") int l2CacheSize(); public native CUpti_ActivityDevice5 l2CacheSize(int setter);

  /**
   * The number of threads per warp on the device.
   */
  public native @Cast("uint32_t") int numThreadsPerWarp(); public native CUpti_ActivityDevice5 numThreadsPerWarp(int setter);

  /**
   * The core clock rate of the device, in kHz.
   */
  public native @Cast("uint32_t") int coreClockRate(); public native CUpti_ActivityDevice5 coreClockRate(int setter);

  /**
   * Number of memory copy engines on the device.
   */
  public native @Cast("uint32_t") int numMemcpyEngines(); public native CUpti_ActivityDevice5 numMemcpyEngines(int setter);

  /**
   * Number of multiprocessors on the device.
   */
  public native @Cast("uint32_t") int numMultiprocessors(); public native CUpti_ActivityDevice5 numMultiprocessors(int setter);

  /**
   * The maximum "instructions per cycle" possible on each device
   * multiprocessor.
   */
  public native @Cast("uint32_t") int maxIPC(); public native CUpti_ActivityDevice5 maxIPC(int setter);

  /**
   * Maximum number of warps that can be present on a multiprocessor
   * at any given time.
   */
  public native @Cast("uint32_t") int maxWarpsPerMultiprocessor(); public native CUpti_ActivityDevice5 maxWarpsPerMultiprocessor(int setter);

  /**
   * Maximum number of blocks that can be present on a multiprocessor
   * at any given time.
   */
  public native @Cast("uint32_t") int maxBlocksPerMultiprocessor(); public native CUpti_ActivityDevice5 maxBlocksPerMultiprocessor(int setter);

  /**
   * Maximum amount of shared memory available per multiprocessor, in bytes.
   */
  public native @Cast("uint32_t") int maxSharedMemoryPerMultiprocessor(); public native CUpti_ActivityDevice5 maxSharedMemoryPerMultiprocessor(int setter);

  /**
   * Maximum number of 32-bit registers available per multiprocessor.
   */
  public native @Cast("uint32_t") int maxRegistersPerMultiprocessor(); public native CUpti_ActivityDevice5 maxRegistersPerMultiprocessor(int setter);

  /**
   * Maximum number of registers that can be allocated to a block.
   */
  public native @Cast("uint32_t") int maxRegistersPerBlock(); public native CUpti_ActivityDevice5 maxRegistersPerBlock(int setter);

  /**
   * Maximum amount of shared memory that can be assigned to a block,
   * in bytes.
   */
  public native @Cast("uint32_t") int maxSharedMemoryPerBlock(); public native CUpti_ActivityDevice5 maxSharedMemoryPerBlock(int setter);

  /**
   * Maximum number of threads allowed in a block.
   */
  public native @Cast("uint32_t") int maxThreadsPerBlock(); public native CUpti_ActivityDevice5 maxThreadsPerBlock(int setter);

  /**
   * Maximum allowed X dimension for a block.
   */
  public native @Cast("uint32_t") int maxBlockDimX(); public native CUpti_ActivityDevice5 maxBlockDimX(int setter);

  /**
   * Maximum allowed Y dimension for a block.
   */
  public native @Cast("uint32_t") int maxBlockDimY(); public native CUpti_ActivityDevice5 maxBlockDimY(int setter);

  /**
   * Maximum allowed Z dimension for a block.
   */
  public native @Cast("uint32_t") int maxBlockDimZ(); public native CUpti_ActivityDevice5 maxBlockDimZ(int setter);

  /**
   * Maximum allowed X dimension for a grid.
   */
  public native @Cast("uint32_t") int maxGridDimX(); public native CUpti_ActivityDevice5 maxGridDimX(int setter);

  /**
   * Maximum allowed Y dimension for a grid.
   */
  public native @Cast("uint32_t") int maxGridDimY(); public native CUpti_ActivityDevice5 maxGridDimY(int setter);

  /**
   * Maximum allowed Z dimension for a grid.
   */
  public native @Cast("uint32_t") int maxGridDimZ(); public native CUpti_ActivityDevice5 maxGridDimZ(int setter);

  /**
   * Compute capability for the device, major number.
   */
  public native @Cast("uint32_t") int computeCapabilityMajor(); public native CUpti_ActivityDevice5 computeCapabilityMajor(int setter);

  /**
   * Compute capability for the device, minor number.
   */
  public native @Cast("uint32_t") int computeCapabilityMinor(); public native CUpti_ActivityDevice5 computeCapabilityMinor(int setter);

  /**
   * The device ID.
   */
  public native @Cast("uint32_t") int id(); public native CUpti_ActivityDevice5 id(int setter);

  /**
   * ECC enabled flag for device
   */
  public native @Cast("uint32_t") int eccEnabled(); public native CUpti_ActivityDevice5 eccEnabled(int setter);

  /**
   * The device UUID. This value is the globally unique immutable
   * alphanumeric identifier of the device.
   */
  public native @ByRef CUuuid uuid(); public native CUpti_ActivityDevice5 uuid(CUuuid setter);

// #ifndef CUPTILP64
// #endif

  /**
   * The device name. This name is shared across all activity records
   * representing instances of the device, and so should not be
   * modified.
   */
  public native @Cast("const char*") BytePointer name(); public native CUpti_ActivityDevice5 name(BytePointer setter);

  /**
   * Flag to indicate whether the device is visible to CUDA. Users can
   * set the device visibility using CUDA_VISIBLE_DEVICES environment
   */
  public native @Cast("uint8_t") byte isCudaVisible(); public native CUpti_ActivityDevice5 isCudaVisible(byte setter);

  /**
   * MIG enabled flag for device
   */
  public native @Cast("uint8_t") byte isMigEnabled(); public native CUpti_ActivityDevice5 isMigEnabled(byte setter);

  public native @Cast("uint8_t") byte reserved(int i); public native CUpti_ActivityDevice5 reserved(int i, byte setter);
  @MemberGetter public native @Cast("uint8_t*") BytePointer reserved();

  /**
   * GPU Instance id for MIG enabled devices.
   * If mig mode is disabled value is set to UINT32_MAX
   */
  public native @Cast("uint32_t") int gpuInstanceId(); public native CUpti_ActivityDevice5 gpuInstanceId(int setter);

  /**
   * Compute Instance id for MIG enabled devices.
   * If mig mode is disabled value is set to UINT32_MAX
   */
  public native @Cast("uint32_t") int computeInstanceId(); public native CUpti_ActivityDevice5 computeInstanceId(int setter);

  /**
   * The MIG UUID. This value is the globally unique immutable
   * alphanumeric identifier of the device.
   */
  public native @ByRef CUuuid migUuid(); public native CUpti_ActivityDevice5 migUuid(CUuuid setter);

  /**
   * Numa (Non-uniform memory access) information for device
   * GPU is a NUMA node or not
  */
  public native @Cast("uint32_t") int isNumaNode(); public native CUpti_ActivityDevice5 isNumaNode(int setter);

  /**
   * Numa (Non-uniform memory access) information for device
   * NUMA node ID of the GPU memory
   * if GPU is not a NUMA node, it returns invalidNumaId
  */
  public native @Cast("uint32_t") int numaId(); public native CUpti_ActivityDevice5 numaId(int setter);
}
