// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for CUPTI environmental data.
 *
 * This activity record provides CUPTI environmental data, include
 * power, clocks, and thermals.  This information is sampled at
 * various rates and returned in this activity record.  The consumer
 * of the record needs to check the environmentKind field to figure
 * out what kind of environmental record this is.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityEnvironment extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityEnvironment() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityEnvironment(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityEnvironment(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityEnvironment position(long position) {
        return (CUpti_ActivityEnvironment)super.position(position);
    }
    @Override public CUpti_ActivityEnvironment getPointer(long i) {
        return new CUpti_ActivityEnvironment((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_ENVIRONMENT.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityEnvironment kind(int setter);

  /**
   * The ID of the device
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityEnvironment deviceId(int setter);

  /**
   * The timestamp when this sample was retrieved, in ns. A value of 0
   * indicates that timestamp information could not be collected for
   * the marker.
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityEnvironment timestamp(long setter);

  /**
   * The kind of data reported in this record.
   */
  public native @Cast("CUpti_ActivityEnvironmentKind") int environmentKind(); public native CUpti_ActivityEnvironment environmentKind(int setter);

    /**
     * Data returned for CUPTI_ACTIVITY_ENVIRONMENT_SPEED environment
     * kind.
     */
      /**
       * The SM frequency in MHz
       */
      @Name("data.speed.smClock") public native @Cast("uint32_t") int data_speed_smClock(); public native CUpti_ActivityEnvironment data_speed_smClock(int setter);

      /**
       * The memory frequency in MHz
       */
      @Name("data.speed.memoryClock") public native @Cast("uint32_t") int data_speed_memoryClock(); public native CUpti_ActivityEnvironment data_speed_memoryClock(int setter);

      /**
       * The PCIe link generation.
       */
      @Name("data.speed.pcieLinkGen") public native @Cast("uint32_t") int data_speed_pcieLinkGen(); public native CUpti_ActivityEnvironment data_speed_pcieLinkGen(int setter);

      /**
       * The PCIe link width.
       */
      @Name("data.speed.pcieLinkWidth") public native @Cast("uint32_t") int data_speed_pcieLinkWidth(); public native CUpti_ActivityEnvironment data_speed_pcieLinkWidth(int setter);

      /**
       * The clocks throttle reasons.
       */
      @Name("data.speed.clocksThrottleReasons") public native @Cast("CUpti_EnvironmentClocksThrottleReason") int data_speed_clocksThrottleReasons(); public native CUpti_ActivityEnvironment data_speed_clocksThrottleReasons(int setter);

    /**
     * Data returned for CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE
     * environment kind.
     */
      /**
       * The GPU temperature in degrees C.
       */
      @Name("data.temperature.gpuTemperature") public native @Cast("uint32_t") int data_temperature_gpuTemperature(); public native CUpti_ActivityEnvironment data_temperature_gpuTemperature(int setter);

    /**
     * Data returned for CUPTI_ACTIVITY_ENVIRONMENT_POWER environment kind.
     * The power in milliwatts consumed by GPU and associated circuitry.
     * The power in milliwatts that will trigger power management algorithm.
     */

      @Name("data.power.power") public native @Cast("uint32_t") int data_power_power(); public native CUpti_ActivityEnvironment data_power_power(int setter);
      @Name("data.power.powerLimit") public native @Cast("uint32_t") int data_power_powerLimit(); public native CUpti_ActivityEnvironment data_power_powerLimit(int setter);

    /**
     * Data returned for CUPTI_ACTIVITY_ENVIRONMENT_COOLING
     * environment kind.
     */
      /**
       * The fan speed as percentage of maximum.
       */
      @Name("data.cooling.fanSpeed") public native @Cast("uint32_t") int data_cooling_fanSpeed(); public native CUpti_ActivityEnvironment data_cooling_fanSpeed(int setter);
}
