// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for source-level sass/source
 * line-by-line correlation.
 *
 * This activity records source level sass/source correlation
 * information.
 * (CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityInstructionCorrelation extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityInstructionCorrelation() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityInstructionCorrelation(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityInstructionCorrelation(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityInstructionCorrelation position(long position) {
        return (CUpti_ActivityInstructionCorrelation)super.position(position);
    }
    @Override public CUpti_ActivityInstructionCorrelation getPointer(long i) {
        return new CUpti_ActivityInstructionCorrelation((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityInstructionCorrelation kind(int setter);

  /**
   * The properties of this instruction.
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityInstructionCorrelation flags(int setter);

  /**
   * The ID for source locator.
   */
  public native @Cast("uint32_t") int sourceLocatorId(); public native CUpti_ActivityInstructionCorrelation sourceLocatorId(int setter);

 /**
  * Correlation ID with global/device function name
  */
  public native @Cast("uint32_t") int functionId(); public native CUpti_ActivityInstructionCorrelation functionId(int setter);

  /**
   * The pc offset for the instruction.
   */
  public native @Cast("uint32_t") int pcOffset(); public native CUpti_ActivityInstructionCorrelation pcOffset(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityInstructionCorrelation pad(int setter);
}
