// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for source-level instruction execution.
 *
 * This activity records result for source level instruction execution.
 * (CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityInstructionExecution extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityInstructionExecution() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityInstructionExecution(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityInstructionExecution(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityInstructionExecution position(long position) {
        return (CUpti_ActivityInstructionExecution)super.position(position);
    }
    @Override public CUpti_ActivityInstructionExecution getPointer(long i) {
        return new CUpti_ActivityInstructionExecution((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityInstructionExecution kind(int setter);

  /**
   * The properties of this instruction execution.
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityInstructionExecution flags(int setter);

  /**
   * The ID for source locator.
   */
  public native @Cast("uint32_t") int sourceLocatorId(); public native CUpti_ActivityInstructionExecution sourceLocatorId(int setter);

  /**
   * The correlation ID of the kernel to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityInstructionExecution correlationId(int setter);

  /**
  * Correlation ID with global/device function name
  */
  public native @Cast("uint32_t") int functionId(); public native CUpti_ActivityInstructionExecution functionId(int setter);

  /**
   * The pc offset for the instruction.
   */
  public native @Cast("uint32_t") int pcOffset(); public native CUpti_ActivityInstructionExecution pcOffset(int setter);

  /**
   * This increments each time when this instruction is executed by number
   * of threads that executed this instruction, regardless of predicate or condition code.
   */
  public native @Cast("uint64_t") long threadsExecuted(); public native CUpti_ActivityInstructionExecution threadsExecuted(long setter);

  /**
   * This increments each time when this instruction is executed by number
   * of threads that executed this instruction with predicate and condition code evaluating to true.
   */
  public native @Cast("uint64_t") long notPredOffThreadsExecuted(); public native CUpti_ActivityInstructionExecution notPredOffThreadsExecuted(long setter);

  /**
   * The number of times this instruction was executed per warp. It will be incremented
   * regardless of predicate or condition code.
   */
  public native @Cast("uint32_t") int executed(); public native CUpti_ActivityInstructionExecution executed(int setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityInstructionExecution pad(int setter);
}
