// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record providing a marker which is an
 * instantaneous point in time.
 *
 * The marker is specified with a descriptive name and unique id
 * (CUPTI_ACTIVITY_KIND_MARKER).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMarker2 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMarker2() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMarker2(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMarker2(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMarker2 position(long position) {
        return (CUpti_ActivityMarker2)super.position(position);
    }
    @Override public CUpti_ActivityMarker2 getPointer(long i) {
        return new CUpti_ActivityMarker2((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MARKER.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMarker2 kind(int setter);

  /**
   * The flags associated with the marker. @see CUpti_ActivityFlag
   */
  public native @Cast("CUpti_ActivityFlag") int flags(); public native CUpti_ActivityMarker2 flags(int setter);

  /**
   * The timestamp for the marker, in ns. A value of 0 indicates that
   * timestamp information could not be collected for the marker.
   */
  public native @Cast("uint64_t") long timestamp(); public native CUpti_ActivityMarker2 timestamp(long setter);

  /**
   * The marker ID.
   */
  public native @Cast("uint32_t") int id(); public native CUpti_ActivityMarker2 id(int setter);

  /**
   * The kind of activity object associated with this marker.
   */
  public native @Cast("CUpti_ActivityObjectKind") int objectKind(); public native CUpti_ActivityMarker2 objectKind(int setter);

  /**
   * The identifier for the activity object associated with this
   * marker. 'objectKind' indicates which ID is valid for this record.
   */
  public native @ByRef CUpti_ActivityObjectKindId objectId(); public native CUpti_ActivityMarker2 objectId(CUpti_ActivityObjectKindId setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint32_t") int pad(); public native CUpti_ActivityMarker2 pad(int setter);


  /**
   * The marker name for an instantaneous or start marker. This will
   * be NULL for an end marker.
   */
  public native @Cast("const char*") BytePointer name(); public native CUpti_ActivityMarker2 name(BytePointer setter);

  /**
   * The name of the domain to which this marker belongs to.
   * This will be NULL for default domain.
   */
  public native @Cast("const char*") BytePointer domain(); public native CUpti_ActivityMarker2 domain(BytePointer setter);

}
