// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for trace of decompression operations.
 *
 * This activity record represents execution for a batch of decompression operatios.
 * The activity kind is CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMemDecompress extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMemDecompress() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMemDecompress(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMemDecompress(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMemDecompress position(long position) {
        return (CUpti_ActivityMemDecompress)super.position(position);
    }
    @Override public CUpti_ActivityMemDecompress getPointer(long i) {
        return new CUpti_ActivityMemDecompress((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMemDecompress kind(int setter);

  /**
   * The ID of the device.
   */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityMemDecompress deviceId(int setter);

  /**
   * The ID of the context.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityMemDecompress contextId(int setter);

  /**
   * The ID of the stream.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityMemDecompress streamId(int setter);

  /**
   * The ID of the HW channel on which the memory copy is occurring.
   */
  public native @Cast("uint32_t") int channelID(); public native CUpti_ActivityMemDecompress channelID(int setter);

  /**
   * The type of the channel
   */
  public native @Cast("CUpti_ChannelType") int channelType(); public native CUpti_ActivityMemDecompress channelType(int setter);

  /**
   * The correlation ID of the decompression operations. Each operation is
   * assigned a unique correlation ID that is identical to the
   * correlation ID in the driver API activity record that launched
   * the operation.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMemDecompress correlationId(int setter);

  /**
   * The number of operations in the batch.
   */
  public native @Cast("uint32_t") int numberOfOperations(); public native CUpti_ActivityMemDecompress numberOfOperations(int setter);

  /**
   * The number of bytes to be read and decompressed in the
   * batch operation.
   */
  public native @Cast("uint64_t") long sourceBytes(); public native CUpti_ActivityMemDecompress sourceBytes(long setter);

  /**
   * This field is reserved for internal use
   */
  public native Pointer reserved0(); public native CUpti_ActivityMemDecompress reserved0(Pointer setter);

  /**
   * The start timestamp.
   * A value of CUPTI_TIMESTAMP_UNKNOWN indicates that
   * the start time is unknown.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityMemDecompress start(long setter);

  /**
   * The end timestamp.
   * A value of CUPTI_TIMESTAMP_UNKNOWN indicates that
   * the start time is unknown.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityMemDecompress end(long setter);
}
