// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for peer-to-peer memory copies.
 *
 * This activity record represents a peer-to-peer memory copy
 * (CUPTI_ACTIVITY_KIND_MEMCPY2).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMemcpyPtoP4 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMemcpyPtoP4() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMemcpyPtoP4(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMemcpyPtoP4(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMemcpyPtoP4 position(long position) {
        return (CUpti_ActivityMemcpyPtoP4)super.position(position);
    }
    @Override public CUpti_ActivityMemcpyPtoP4 getPointer(long i) {
        return new CUpti_ActivityMemcpyPtoP4((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_MEMCPY2.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMemcpyPtoP4 kind(int setter);

  /**
   * The kind of the memory copy, stored as a byte to reduce record
   * size.  @see CUpti_ActivityMemcpyKind
   */
  public native @Cast("uint8_t") byte copyKind(); public native CUpti_ActivityMemcpyPtoP4 copyKind(byte setter);

  /**
   * The source memory kind read by the memory copy, stored as a byte
   * to reduce record size.  @see CUpti_ActivityMemoryKind
   */
  public native @Cast("uint8_t") byte srcKind(); public native CUpti_ActivityMemcpyPtoP4 srcKind(byte setter);

  /**
   * The destination memory kind read by the memory copy, stored as a
   * byte to reduce record size.  @see CUpti_ActivityMemoryKind
   */
  public native @Cast("uint8_t") byte dstKind(); public native CUpti_ActivityMemcpyPtoP4 dstKind(byte setter);

  /**
   * The flags associated with the memory copy. @see
   * CUpti_ActivityFlag
   */
  public native @Cast("uint8_t") byte flags(); public native CUpti_ActivityMemcpyPtoP4 flags(byte setter);

  /**
   * The number of bytes transferred by the memory copy.
   */
  public native @Cast("uint64_t") long bytes(); public native CUpti_ActivityMemcpyPtoP4 bytes(long setter);

  /**
   * The start timestamp for the memory copy, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the memory copy.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityMemcpyPtoP4 start(long setter);

  /**
   * The end timestamp for the memory copy, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the memory copy.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityMemcpyPtoP4 end(long setter);

  /**
  * The ID of the device where the memory copy is occurring.
  */
  public native @Cast("uint32_t") int deviceId(); public native CUpti_ActivityMemcpyPtoP4 deviceId(int setter);

  /**
   * The ID of the context where the memory copy is occurring.
   */
  public native @Cast("uint32_t") int contextId(); public native CUpti_ActivityMemcpyPtoP4 contextId(int setter);

  /**
   * The ID of the stream where the memory copy is occurring.
   */
  public native @Cast("uint32_t") int streamId(); public native CUpti_ActivityMemcpyPtoP4 streamId(int setter);

  /**
   * The ID of the device where memory is being copied from.
   */
  public native @Cast("uint32_t") int srcDeviceId(); public native CUpti_ActivityMemcpyPtoP4 srcDeviceId(int setter);

  /**
   * The ID of the context owning the memory being copied from.
   */
  public native @Cast("uint32_t") int srcContextId(); public native CUpti_ActivityMemcpyPtoP4 srcContextId(int setter);

  /**
   * The ID of the device where memory is being copied to.
   */
  public native @Cast("uint32_t") int dstDeviceId(); public native CUpti_ActivityMemcpyPtoP4 dstDeviceId(int setter);

  /**
   * The ID of the context owning the memory being copied to.
   */
  public native @Cast("uint32_t") int dstContextId(); public native CUpti_ActivityMemcpyPtoP4 dstContextId(int setter);

  /**
   * The correlation ID of the memory copy. Each memory copy is
   * assigned a unique correlation ID that is identical to the
   * correlation ID in the driver and runtime API activity record that
   * launched the memory copy.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMemcpyPtoP4 correlationId(int setter);

// #ifndef CUPTILP64
// #endif

  /**
   * Undefined. Reserved for internal use.
   */
  public native Pointer reserved0(); public native CUpti_ActivityMemcpyPtoP4 reserved0(Pointer setter);

  /**
   * The unique ID of the graph node that executed the memcpy through graph launch.
   * This field will be 0 if memcpy is not done using graph launch.
   */
  public native @Cast("uint64_t") long graphNodeId(); public native CUpti_ActivityMemcpyPtoP4 graphNodeId(long setter);

  /**
   * The unique ID of the graph that executed this memcpy through graph launch.
   * This field will be 0 if the memcpy is not done through graph launch.
   */
  public native @Cast("uint32_t") int graphId(); public native CUpti_ActivityMemcpyPtoP4 graphId(int setter);

  /**
   * The ID of the HW channel on which the memory copy is occurring.
   */
  public native @Cast("uint32_t") int channelID(); public native CUpti_ActivityMemcpyPtoP4 channelID(int setter);

  /**
   * The type of the channel
   */
  public native @Cast("CUpti_ChannelType") int channelType(); public native CUpti_ActivityMemcpyPtoP4 channelType(int setter);
}
