// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for a CUPTI metric with instance
 * information.
 *
 * This activity record represents a CUPTI metric value
 * for a specific metric domain instance
 * (CUPTI_ACTIVITY_KIND_METRIC_INSTANCE).  This activity record kind
 * is not produced by the activity API but is included for
 * completeness and ease-of-use. Profile frameworks built on top of
 * CUPTI that collect metric data may choose to use this type to store
 * the collected metric data. This activity record should be used when
 * metric domain instance information needs to be associated with the
 * metric.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityMetricInstance extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityMetricInstance() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityMetricInstance(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityMetricInstance(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityMetricInstance position(long position) {
        return (CUpti_ActivityMetricInstance)super.position(position);
    }
    @Override public CUpti_ActivityMetricInstance getPointer(long i) {
        return new CUpti_ActivityMetricInstance((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be
   * CUPTI_ACTIVITY_KIND_METRIC_INSTANCE.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityMetricInstance kind(int setter);

  /**
   * The metric ID.
   */
  public native @Cast("CUpti_MetricID") int id(); public native CUpti_ActivityMetricInstance id(int setter);

  /**
   * The metric value.
   */
  public native @ByRef CUpti_MetricValue value(); public native CUpti_ActivityMetricInstance value(CUpti_MetricValue setter);

  /**
   * The metric domain instance.
   */
  public native @Cast("uint32_t") int instance(); public native CUpti_ActivityMetricInstance instance(int setter);

  /**
   * The correlation ID of the metric. Use of this ID is user-defined,
   * but typically this ID value will equal the correlation ID of the
   * kernel for which the metric was gathered.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityMetricInstance correlationId(int setter);

  /**
   * The properties of this metric. @see CUpti_ActivityFlag
   */
  public native @Cast("uint8_t") byte flags(); public native CUpti_ActivityMetricInstance flags(byte setter);

  /**
   * Undefined. Reserved for internal use.
   */
  public native @Cast("uint8_t") byte pad(int i); public native CUpti_ActivityMetricInstance pad(int i, byte setter);
  @MemberGetter public native @Cast("uint8_t*") BytePointer pad();
}
