// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
* \brief NVLink information.
*
* This structure gives capabilities of each logical NVLink connection between two devices,
* gpu<->gpu or gpu<->CPU which can be used to understand the topology.
*/

@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityNvLink4 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityNvLink4() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityNvLink4(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityNvLink4(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityNvLink4 position(long position) {
        return (CUpti_ActivityNvLink4)super.position(position);
    }
    @Override public CUpti_ActivityNvLink4 getPointer(long i) {
        return new CUpti_ActivityNvLink4((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_NVLINK.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityNvLink4 kind(int setter);

  /**
   * NvLink version.
   */
  public native @Cast("uint32_t") int nvlinkVersion(); public native CUpti_ActivityNvLink4 nvlinkVersion(int setter);

  /**
   * Type of device 0 \ref CUpti_DevType
   */
  public native @Cast("CUpti_DevType") int typeDev0(); public native CUpti_ActivityNvLink4 typeDev0(int setter);

  /**
   * Type of device 1 \ref CUpti_DevType
   */
  public native @Cast("CUpti_DevType") int typeDev1(); public native CUpti_ActivityNvLink4 typeDev1(int setter);

  /**
  * If typeDev0 is CUPTI_DEV_TYPE_GPU, UUID for device 0. \ref CUpti_ActivityDevice5.
  * If typeDev0 is CUPTI_DEV_TYPE_NPU, struct npu for NPU.
  */
    @Name("idDev0.uuidDev") public native @ByRef CUuuid idDev0_uuidDev(); public native CUpti_ActivityNvLink4 idDev0_uuidDev(CUuuid setter);
      /**
       * Index of the NPU. First index will always be zero.
       */
      @Name("idDev0.npu.index") public native @Cast("uint32_t") int idDev0_npu_index(); public native CUpti_ActivityNvLink4 idDev0_npu_index(int setter);

      /**
       * Domain ID of NPU. On Linux, this can be queried using lspci.
       */
      @Name("idDev0.npu.domainId") public native @Cast("uint32_t") int idDev0_npu_domainId(); public native CUpti_ActivityNvLink4 idDev0_npu_domainId(int setter);

  /**
  * If typeDev1 is CUPTI_DEV_TYPE_GPU, UUID for device 1. \ref CUpti_ActivityDevice5.
  * If typeDev1 is CUPTI_DEV_TYPE_NPU, struct npu for NPU.
  */
    @Name("idDev1.uuidDev") public native @ByRef CUuuid idDev1_uuidDev(); public native CUpti_ActivityNvLink4 idDev1_uuidDev(CUuuid setter);

      /**
       * Index of the NPU. First index will always be zero.
       */
      @Name("idDev1.npu.index") public native @Cast("uint32_t") int idDev1_npu_index(); public native CUpti_ActivityNvLink4 idDev1_npu_index(int setter);

      /**
       * Domain ID of NPU. On Linux, this can be queried using lspci.
       */
      @Name("idDev1.npu.domainId") public native @Cast("uint32_t") int idDev1_npu_domainId(); public native CUpti_ActivityNvLink4 idDev1_npu_domainId(int setter);

  /**
   * Flag gives capabilities of the link @see CUpti_LinkFlag
   */
  public native @Cast("uint32_t") int flag(); public native CUpti_ActivityNvLink4 flag(int setter);

  /**
   * Number of physical NVLinks present between two devices.
   */
  public native @Cast("uint32_t") int physicalNvLinkCount(); public native CUpti_ActivityNvLink4 physicalNvLinkCount(int setter);

  /**
   * Port numbers for maximum 32 NVLinks connected to device 0.
   * If typeDev0 is CUPTI_DEV_TYPE_NPU, ignore this field.
   * In case of invalid/unknown port number, this field will be set
   * to value CUPTI_NVLINK_INVALID_PORT.
   * This will be used to correlate the metric values to individual
   * physical link and attribute traffic to the logical NVLink in
   * the topology.
   */
  public native byte portDev0(int i); public native CUpti_ActivityNvLink4 portDev0(int i, byte setter);
  @MemberGetter public native BytePointer portDev0();

  /**
   * Port numbers for maximum 32 NVLinks connected to device 1.
   * If typeDev1 is CUPTI_DEV_TYPE_NPU, ignore this field.
   * In case of invalid/unknown port number, this field will be set
   * to value CUPTI_NVLINK_INVALID_PORT.
   * This will be used to correlate the metric values to individual
   * physical link and attribute traffic to the logical NVLink in
   * the topology.
   */
  public native byte portDev1(int i); public native CUpti_ActivityNvLink4 portDev1(int i, byte setter);
  @MemberGetter public native BytePointer portDev1();

  /**
   * Bandwidth of NVLink in kbytes/sec
   */
  public native @Cast("uint64_t") long bandwidth(); public native CUpti_ActivityNvLink4 bandwidth(long setter);

  /**
   * NVSwitch is connected as an intermediate node.
   */
  public native @Cast("uint8_t") byte nvswitchConnected(); public native CUpti_ActivityNvLink4 nvswitchConnected(byte setter);

  /**
   * Undefined. reserved for internal use
   */
  public native @Cast("uint8_t") byte pad(int i); public native CUpti_ActivityNvLink4 pad(int i, byte setter);
  @MemberGetter public native @Cast("uint8_t*") BytePointer pad();
}
