// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for CUPTI and driver overheads.
 *
 * This activity record provides CUPTI and driver overhead information
 * (CUPTI_ACTIVITY_KIND_OVERHEAD).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityOverhead3 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityOverhead3() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityOverhead3(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityOverhead3(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityOverhead3 position(long position) {
        return (CUpti_ActivityOverhead3)super.position(position);
    }
    @Override public CUpti_ActivityOverhead3 getPointer(long i) {
        return new CUpti_ActivityOverhead3((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_OVERHEAD.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityOverhead3 kind(int setter);

  /**
   * The kind of overhead, CUPTI, DRIVER, COMPILER etc.
   */
  public native @Cast("CUpti_ActivityOverheadKind") int overheadKind(); public native CUpti_ActivityOverhead3 overheadKind(int setter);

  /**
   * The kind of activity object that the overhead is associated with.
   */
  public native @Cast("CUpti_ActivityObjectKind") int objectKind(); public native CUpti_ActivityOverhead3 objectKind(int setter);

  /**
   * The identifier for the activity object. 'objectKind' indicates
   * which ID is valid for this record.
   */
  public native @ByRef CUpti_ActivityObjectKindId objectId(); public native CUpti_ActivityOverhead3 objectId(CUpti_ActivityObjectKindId setter);

  /**
   * The start timestamp for the overhead, in ns. A value of 0 for
   * both the start and end timestamps indicates that timestamp
   * information could not be collected for the overhead.
   */
  public native @Cast("uint64_t") long start(); public native CUpti_ActivityOverhead3 start(long setter);

  /**
   * The end timestamp for the overhead, in ns. A value of 0 for both
   * the start and end timestamps indicates that timestamp information
   * could not be collected for the overhead.
   */
  public native @Cast("uint64_t") long end(); public native CUpti_ActivityOverhead3 end(long setter);

  /**
   * The correlation ID of the overhead operation to which
   * records belong to. This ID is identical to the
   * correlation ID in the driver or runtime API activity record that
   * launched the overhead operation.
   * In some cases, it can be zero, such as for CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH records.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityOverhead3 correlationId(int setter);

  /**
   * Reserved for internal use.
   */
  public native @Cast("uint32_t") int reserved0(); public native CUpti_ActivityOverhead3 reserved0(int setter);

  /**
   * Pointer to the struct with additional details about the overhead.
   * Refer CUpti_ActivityOverheadKind enum and the corresponding structure to typecast and access additional overhead data.
   * Client is responsible for freeing this memory using the free function when done.
   */
  public native Pointer overheadData(); public native CUpti_ActivityOverhead3 overheadData(Pointer setter);

}
