// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief The activity record for record status for PC sampling.
 *
 * This activity records information obtained by sampling PC
 * (CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO).
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityPCSamplingRecordInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityPCSamplingRecordInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityPCSamplingRecordInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityPCSamplingRecordInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityPCSamplingRecordInfo position(long position) {
        return (CUpti_ActivityPCSamplingRecordInfo)super.position(position);
    }
    @Override public CUpti_ActivityPCSamplingRecordInfo getPointer(long i) {
        return new CUpti_ActivityPCSamplingRecordInfo((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityPCSamplingRecordInfo kind(int setter);

  /**
   * The correlation ID of the kernel to which this result is associated.
   */
  public native @Cast("uint32_t") int correlationId(); public native CUpti_ActivityPCSamplingRecordInfo correlationId(int setter);

  /**
   * Number of times the PC was sampled for this kernel instance including all
   * dropped samples.
   */
  public native @Cast("uint64_t") long totalSamples(); public native CUpti_ActivityPCSamplingRecordInfo totalSamples(long setter);

  /**
   * Number of samples that were dropped by hardware due to backpressure/overflow.
   */
  public native @Cast("uint64_t") long droppedSamples(); public native CUpti_ActivityPCSamplingRecordInfo droppedSamples(long setter);
  /**
   * Sampling period in terms of number of cycles .
   */
  public native @Cast("uint64_t") long samplingPeriodInCycles(); public native CUpti_ActivityPCSamplingRecordInfo samplingPeriodInCycles(long setter);
}
