// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cupti;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.cupti.*;


/**
 * \brief PCI devices information required to construct topology
 *
 * This structure gives capabilities of GPU and PCI bridge connected to the PCIE bus
 * which can be used to understand the topology.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cupti.class)
public class CUpti_ActivityPcie extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUpti_ActivityPcie() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUpti_ActivityPcie(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUpti_ActivityPcie(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUpti_ActivityPcie position(long position) {
        return (CUpti_ActivityPcie)super.position(position);
    }
    @Override public CUpti_ActivityPcie getPointer(long i) {
        return new CUpti_ActivityPcie((Pointer)this).offsetAddress(i);
    }

  /**
   * The activity record kind, must be CUPTI_ACTIVITY_KIND_PCIE.
   */
  public native @Cast("CUpti_ActivityKind") int kind(); public native CUpti_ActivityPcie kind(int setter);

  /**
   * Type of device in topology, \ref CUpti_PcieDeviceType. If type is
   * CUPTI_PCIE_DEVICE_TYPE_GPU use devId for id and gpuAttr and if type is
   * CUPTI_PCIE_DEVICE_TYPE_BRIDGE use bridgeId for id and bridgeAttr.
   */
  public native @Cast("CUpti_PcieDeviceType") int type(); public native CUpti_ActivityPcie type(int setter);

  /**
   * A unique identifier for GPU or Bridge in Topology
   */
    /**
     * GPU device ID
     */
    @Name("id.devId") public native @Cast("CUdevice") int id_devId(); public native CUpti_ActivityPcie id_devId(int setter);

    /**
     * A unique identifier for Bridge in the Topology
     */
    @Name("id.bridgeId") public native @Cast("uint32_t") int id_bridgeId(); public native CUpti_ActivityPcie id_bridgeId(int setter);

  /**
   * Domain for the GPU or Bridge, required to identify which PCIE bus it belongs to in
   * multiple NUMA systems.
   */
  public native @Cast("uint32_t") int domain(); public native CUpti_ActivityPcie domain(int setter);

  /**
   * PCIE Generation of GPU or Bridge.
   */
  public native @Cast("uint16_t") short pcieGeneration(); public native CUpti_ActivityPcie pcieGeneration(short setter);

  /**
   * Link rate of the GPU or bridge in gigatransfers per second (GT/s)
   */
  public native @Cast("uint16_t") short linkRate(); public native CUpti_ActivityPcie linkRate(short setter);

  /**
   * Link width of the GPU or bridge
   */
  public native @Cast("uint16_t") short linkWidth(); public native CUpti_ActivityPcie linkWidth(short setter);

  /**
   * Upstream bus ID for the GPU or PCI bridge. Required to identify which bus it is
   * connected to in the topology.
   */
  public native @Cast("uint16_t") short upstreamBus(); public native CUpti_ActivityPcie upstreamBus(short setter);

  /**
   * Attributes for more information about GPU (gpuAttr) or PCI Bridge (bridgeAttr)
   */
      /**
       * UUID for the device. \ref CUpti_ActivityDevice5.
       */
      @Name("attr.gpuAttr.uuidDev") public native @ByRef CUuuid attr_gpuAttr_uuidDev(); public native CUpti_ActivityPcie attr_gpuAttr_uuidDev(CUuuid setter);

      /**
       * CUdevice with which this device has P2P capability.
       * This can also be obtained by querying cuDeviceCanAccessPeer or
       * cudaDeviceCanAccessPeer APIs
       */
      @Name("attr.gpuAttr.peerDev") public native @Cast("CUdevice") int attr_gpuAttr_peerDev(int i); public native CUpti_ActivityPcie attr_gpuAttr_peerDev(int i, int setter);
      @Name("attr.gpuAttr.peerDev") @MemberGetter public native @Cast("CUdevice*") IntPointer attr_gpuAttr_peerDev();

      /**
       * The downstream bus number, used to search downstream devices/bridges connected
       * to this bridge.
       */
      @Name("attr.bridgeAttr.secondaryBus") public native @Cast("uint16_t") short attr_bridgeAttr_secondaryBus(); public native CUpti_ActivityPcie attr_bridgeAttr_secondaryBus(short setter);

      /**
       * Device ID of the bridge
       */
      @Name("attr.bridgeAttr.deviceId") public native @Cast("uint16_t") short attr_bridgeAttr_deviceId(); public native CUpti_ActivityPcie attr_bridgeAttr_deviceId(short setter);

      /**
       * Vendor ID of the bridge
       */
      @Name("attr.bridgeAttr.vendorId") public native @Cast("uint16_t") short attr_bridgeAttr_vendorId(); public native CUpti_ActivityPcie attr_bridgeAttr_vendorId(short setter);

      /**
       * Padding for alignment
       */
      @Name("attr.bridgeAttr.pad0") public native @Cast("uint16_t") short attr_bridgeAttr_pad0(); public native CUpti_ActivityPcie attr_bridgeAttr_pad0(short setter);
}
